#!/bin/sh
# Copyright © 2018 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
#
# This script prepares the current Linux environment for ToolsCenter.
export PATH=$PATH:/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/usr/X11R6/bin:/bin:/usr/games:/usr/lib/mit/bin:/usr/lib/mit/sbin
export HOME=~

dmesg --console-level 4

dos2unix /toolscenter/*.sh >/dev/null 2>&1
cp -f /toolscenter/*.sh /tmp/ >/dev/null 2>&1
cp -f /toolscenter/menu/updatecli_start.sh /tmp/updatecli_start.sh >/dev/null 2>&1
cp -f /toolscenter/menu/updatecli_start_salie.sh /tmp/updatecli_start_salie.sh >/dev/null 2>&1
cp -fra /toolscenter/menu /tmp/ >/dev/null 2>&1
cp -fra /toolscenter/dsa /tmp/ >/dev/null 2>&1
cp -fra /toolscenter/uxspi /tmp/ >/dev/null 2>&1

#--------------------this is just for same as original script. but i think it is unuseful.
dos2unix /toolscenter/*.sh >/dev/null 2>&1
dos2unix /toolscenter/menu/*.sh >/dev/null 2>&1

chmod +x /toolscenter/*.sh >/dev/null 2>&1
chmod +x /toolscenter/menu/*.sh >/dev/null 2>&1
#-----------------------
dos2unix /tmp/*.sh >/dev/null 2>&1
dos2unix /tmp/menu/*.sh >/dev/null 2>&1

chmod +x /tmp/*.sh >/dev/null 2>&1
chmod +x /tmp/menu/*.sh >/dev/null 2>&1

cp -f /toolscenter/bomc.config /tmp/bomc.config >/dev/null 2>&1
dos2unix /tmp/bomc.config >/dev/null 2>&1

export EXTTOOL_EXIST=0
exttoolpath="/toolscenter/BoMC_3rdPartyTool"
[ -d "$exttoolpath" ] && cp -fr $exttoolpath /tmp/ 1>/dev/null 2>&1 && export EXTTOOL_EXIST=1 && chmod +x /tmp/BoMC_3rdPartyTool/*

cd /tmp/
chmod -R +x * /dev/null 2>/dev/null

#disable Crtl+z and Ctrl+c
trap "" 2 20

BOMC_MENU=/tmp/menu/show_menu.sh
BOMC_LOG_FILE=/tmp/bomc.log

BOMC_REMOTE_CHECK=/tmp/menu/check_remote.sh

#Export environment for UXSPI UXSP's/latest
if cat /tmp/bomc.config | grep "IBM_SYSTEM_COPY_TO_RAMDISK=YES" >/dev/null 2>&1; then
  export COPY_TO_RAMDISK=1
fi

# Export the UXSPI_TIMEOUT environment to uxspi
TIMEOUT=60
if cat /tmp/bomc.config | grep IBM_SYSTEM_TIMEOUT >/dev/null 2>&1; then
  TIMEOUT=$(cat /tmp/bomc.config | grep IBM_SYSTEM_TIMEOUT | sed 's/IBM_SYSTEM_TIMEOUT=//')
fi
export UXSPI_TIMEOUT=${TIMEOUT}

#Export environment for UXSPI UXSP's/latest
if cat /tmp/bomc.config | grep "IBM_SYSTEM_LATEST=YES" >/dev/null 2>&1; then
  export UXSPI_LATEST=1
fi

#Export environment for UXSPI UXSP's/latest
if cat /tmp/bomc.config | grep "IBM_SYSTEM_UPDATE_HBACNA=YES" >/dev/null 2>&1; then
  export UXSPI_NEW=1
fi

# SEP environment variable
export SEP_REPOSITORY_PATH=/toolscenter
export SEP_INSTALL_PATH=/tmp

# UXSPI environment variable
export UXLITE_CLEAN_INVFILE=1
export UXSPI_CLEAN_INVFILE=1
export UXSPI_REDUCE_COPY=1
export UXSPI_BOOTABLE=/toolscenter
#export UXSPI_BINARY_PATH=`find /toolscenter/update -name 'Onecli' | sort | tail -n 1`

if [ -f /etc/mcp.manifest ]; then
  export UPDATE_CLI_BIN=/tmp/updatecli_start.sh
  export BOOT_OS_ENV_TYPE=MCP
  echo "This is MCP, will auto call the script for MCP..."
else
  export UPDATE_CLI_BIN=/tmp/updatecli_start_salie.sh
  export BOOT_OS_ENV_TYPE=SaLIE
  if [ -f /etc/elie_version ]; then
    echo "This is ELIE, will auto call the script for ELIE..."
  else
    echo "This is SALIE, will auto call the script for SALIE..."
  fi
fi

${UPDATE_CLI_BIN}

echo "Pre-copy payloads if it is selected..."
if [ ${COPY_TO_RAMDISK} -eq 1 ]; then
    mkdir -p /run/initramfs/live
    mount /dev/sr0 /run/initramfs/live 1>/dev/null 2>&1
    cp -nv /run/initramfs/live/* /toolscenter/
    cp -nrv /run/initramfs/live/payloads /toolscenter/
    umount /run/initramfs/live 1>/dev/null 2>&1
    rm -rf /toolscenter/lnvgy_utl_lxce_bomc-*.xml 1>/dev/null 2>&1
fi

export UXSPI_GUI_CMD=/tmp/lxce_ux/start_lxce_ux.sh
# Invoke UXSPI directly in blue system
# -----[brondan 2019/7/17]
if [ "${BOOT_OS_ENV_TYPE}" = "SaLIE" ]; then
  #sed -i -e 's/^UXSPI_PATH=.*/UXSPI_PATH=\/tmp\/lxce_ux\/command\/uxspi\/lnvgy_utl_uxspi_10.7_anyos_x86-64.bin/g' /tmp/lxce_ux/command/onecli/global.config
  sed -i -e 's/^ENCRYPTED_CREDENTIALS_FILE_PATH=.*/ENCRYPTED_CREDENTIALS_FILE_PATH=\/toolscenter\/encrypt.json/g' /tmp/lxce_ux/command/onecli/global.config
  export UXSPI_BINARY_PATH=/tmp/lxce_ux/command/onecli/OneCli
  export UXSPI_TUI_CMD_WORKING_DIR=/tmp/lxce_ux/command/onecli/
  export UXSPI_TUI_CMD="${UXSPI_BINARY_PATH} update flash --type=fw --dir=${UXSPI_BOOTABLE} --scope=latest --output=/var/log/Lenovo_Support"
elif [ "${BOOT_OS_ENV_TYPE}" = "MCP" ]; then
  export UXSPI_BINARY_PATH=/tmp/lxce_ux/command/uxspi/lnvgy_utl_uxspi_10.7_anyos_x86-64.bin
  export UXSPI_TUI_CMD_WORKING_DIR=/tmp/lxce_ux/command/uxspi/
  export UXSPI_TUI_CMD="${UXSPI_BINARY_PATH} update -u -F -l ${UXSPI_BOOTABLE} -L"
fi

${BOMC_REMOTE_CHECK} /toolscenter
if [ $? -eq 0 ]; then
  echo "Remote mounting via remote IMM/network" >>${BOMC_LOG_FILE}
else
  echo "NOT mounted via remote IMM/network" >>${BOMC_LOG_FILE}
  export UXSPI_REDUCE_COPY=1
fi
# DSA environment variable
export DSA_PATH=/tmp/embed:/tmp/embed/qlogic:/usr/X11R6/lib64:/usr/X11R6/lib
export DSA_GUI_CMD="xterm -geometry 170x61 +sb -e /tmp/dsa/start.sh --gui"
export DSA_CMD_CMD="xterm -geometry 170x61 +sb -e /tmp/dsa/start.sh --cmd"
#export DSA_TUI_CMD="/toolscenter/dsa/start.sh --cmd"

# Export environment for exit script command
if cat /tmp/bomc.config | grep "IBM_SYSTEM_MEDIA_EJECT=NO" >/dev/null 2>&1; then
  if [ "x$BOOT_OS_ENV_TYPE" == "xMCP" ]; then
    export BOMC_EXIT_CMD="/tmp/tcexit_noeject.sh"
  else
    if [ -f /etc/elie_version ]; then
      export BOMC_EXIT_CMD="/tmp/elie_tcexit_noeject.sh"
    else
      export BOMC_EXIT_CMD="/tmp/salie_tcexit_noeject.sh"
    fi
  fi
else
  if [ "x$BOOT_OS_ENV_TYPE" == "xMCP" ]; then
    export BOMC_EXIT_CMD="/tmp/tcexit.sh"
  else
    if [ -f /etc/elie_version ]; then
      export BOMC_EXIT_CMD="/tmp/elie_tcexit.sh"
    else
      export BOMC_EXIT_CMD="/tmp/salie_tcexit.sh"
    fi
  fi
fi

# Export environment for UXSPI autorun command
if cat /tmp/bomc.config | grep "IBM_SYSTEM_AUTORUN=update" >/dev/null 2>&1; then
  export UXSPI_AUTORUN=1
fi

# VLAN configuration
VLAN_ID=$(cat /tmp/bomc.config | grep "IBM_SYSTEM_VLANID" | sed 's/IBM_SYSTEM_VLANID=//')
VLAN_IP=$(cat /tmp/bomc.config | grep "IBM_SYSTEM_VLANIP" | sed 's/IBM_SYSTEM_VLANIP=//')
echo "Start to config VLAN with arguments "$VLAN_ID" and "$VLAN_IP >>${BOMC_LOG_FILE}
if [ -n "$VLAN_ID" ] && [ -n "$VLAN_IP" ] && [ "$VLAN_IP" != "NULL" ] && [ "$VLANID" != "NULL" ]; then
  ifc_all_list=$(ifconfig -a | egrep '^((ath)|(eth)|(tr)|(wifi)|(wlan))[0-9]' | sed -e 's/ .*//')
  has_ip_ifcs=""
  for ifc in $ifc_all_list; do
    ifc_ip=""
    ifc_ip=$(ifconfig $ifc | grep "inet addr")
    if [ -n "$ifc_ip" ]; then
      has_ip_ifcs=$has_ip_ifcs" "$ifc
    fi
  done

  modprobe 8021q >/dev/null 2>&1
  echo "The network interface to configurate includes "$has_ip_ifcs >>${BOMC_LOG_FILE}
  for inet in $has_ip_ifcs; do
    echo "Command: vconfig add "$inet" "$VLAN_ID >>${BOMC_LOG_FILE}
    vconfig add $inet $VLAN_ID >>${BOMC_LOG_FILE} 2>&1
    echo "Command: ifconfig "$inet"."$VLAN_ID" up" >>${BOMC_LOG_FILE}
    ifconfig $inet.$VLAN_ID up >>${BOMC_LOG_FILE} 2>&1
    echo "Command: ip addr add "$VLAN_IP" dev "$inet"."$VLAN_ID >>${BOMC_LOG_FILE}
    ip addr add $VLAN_IP dev $inet.$VLAN_ID >>${BOMC_LOG_FILE} 2>&1
  done
fi

# Export the unattended mode environment variable
UNATTD_FULLSTR=$(cat /tmp/bomc.config | grep "^IBM_SYSTEM_UNATTENDED=" | sed 's/IBM_SYSTEM_UNATTENDED=//')
if echo ${UNATTD_FULLSTR} | grep '[tftp://|ftp://|sftp:://|nfs://|smb://|usb:/]' >/dev/null 2>&1; then
  echo "Unattended mode specified by user" >>${BOMC_LOG_FILE}
  export BOMC_UNATTENDED_MODE=1
fi

os_version() {
  _version=$(cat /etc/os-release | grep "VERSION_ID=" | cut -d "=" -f2)
  _version=${_version%%\"}
  _version=${_version##\"}
  echo $_version
}

if [ -e /etc/elie_version ]; then
  echo "running in elie"
else
  OS_VERSION=$(os_version)
  if [ "x$OS_VERSION" == "x8" ]; then
    ln -s /usr/lib64/libcrypto.so.1.1.1g /usr/lib64/libcrypto.so.4 2>/dev/null
    ln -s /usr/lib64/libssl.so.1.1.1g /usr/lib64/libssl.so.4 2>/dev/null
    ln -s /usr/lib64/libcrypto.so.1.1.1g /lib64/libcrypto.so.4 2>/dev/null
    ln -s /usr/lib64/libssl.so.1.1.1g /lib64/libssl.so.4 2>/dev/null
  fi
fi

if [ $# -eq 0 ]; then
  echo "Running in non SOL mode" >>${BOMC_LOG_FILE}
  export DSA_TUI_CMD="/tmp/dsa/start.sh --cmd"
  if [ "${BOMC_UNATTENDED_MODE}" = "1" ]; then
    echo "Calling show_menu.sh unattended" >>${BOMC_LOG_FILE}
    ${BOMC_MENU} unattended
  else
    echo "Calling show_menu.sh attended" >>${BOMC_LOG_FILE}
    ${BOMC_MENU} attended
  fi
else
  if [ "$1" = "serial" ]; then
    echo "Running in SOL mode - Console" >>${BOMC_LOG_FILE}
    export BOMC_SOL_MODE=1
    export DSA_TUI_CMD="/tmp/dsa/start.sh serial --cmd"
    if [ "${BOMC_UNATTENDED_MODE}" = "1" ]; then
      echo "Calling show_menu.sh unattended" >>${BOMC_LOG_FILE}
      ${BOMC_MENU} unattended
    else
      echo "Calling show_menu.sh attended" >>${BOMC_LOG_FILE}
      ${BOMC_MENU} attended
    fi
  elif [ "$1" = "serial-on" ]; then
    while [ 1 ]; do
      clear
      echo "Lenovo XClarity Essentials started on SOL console......type \"reboot\" to reboot the system"
      read INPUT
      if [ "${INPUT}" = "reboot" ]; then
        echo "Rebooting the system ..."
        ${BOMC_EXIT_CMD} reboot
        exit
      elif [ "${INPUT}" = "r2d2" ]; then
        sh
      fi
    done
  fi
fi

# Exit ToolsCenter
echo "Using Exit Script: ${BOMC_EXIT_CMD}...."
sleep 3

if [ "${BOMC_UNATTENDED_MODE}" = "1" ]; then
  if cat /tmp/bomc.config | grep "IBM_SYSTEM_NOSHUTDOWN=YES" >/dev/null 2>&1; then
    clear
    read -n 1 -p "Press any key to shutdown..."
  fi
  if cat /tmp/bomc.config | grep "IBM_SYSTEM_REBOOT_OS=YES" >/dev/null 2>&1; then
    echo "Rebooting the system ..."
    ${BOMC_EXIT_CMD} reboot
  else
    echo "Shut down the system ..."
    ${BOMC_EXIT_CMD} shutdown
  fi
elif cat /tmp/bomc.config | grep "IBM_SYSTEM_PXE_FILE=NULL" >/dev/null 2>&1; then
  echo "Rebooting the system ..."
  ${BOMC_EXIT_CMD} reboot
else
  # Shut down the system when it's PXE image
  echo "Shut down the system ..."
  ${BOMC_EXIT_CMD} shutdown
fi
exit 0
