#!/bin/sh
# Copyright © 2018 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.

#Check paramters
BOMC_LOG_FILE=/tmp/bomc.log

if [ ${#} -ne 1 ]; then
  echo "Sytax error" >> ${BOMC_LOG_FILE}
  echo "Example: $0 <directory_path>" >> ${BOMC_LOG_FILE}
  echo "directory_path=/toolscenter" >> ${BOMC_LOG_FILE}
  echo "This script checks if directory_path is mounted remotely on iMM" >> ${BOMC_LOG_FILE}
  exit 1
fi

#Check if it's mounting via network - NFS / Samba
cat /proc/mounts | grep ${UXSPI_BOOTABLE} | grep -E '(nfs|smb|samba|cifs)'
if [ $? -eq 0 ]; then
  echo "Mounting from network share" >> ${BOMC_LOG_FILE}
  exit 0 
fi

#Check what devices are the updates located
target_path=${1}
device=`cat /proc/mounts | grep /toolscenter | grep /dev | cut -d / -f 3`
device=`echo ${device} | tr -s " "`

#For XB048012, truncate partition number for remote usbkey thru amm
#e.g: truncate "sdcx" to "sdc"
if [ ! -d "/sys/block/${device}/" ]; then
  echo "/sys/block/${device} not found" >> ${BOMC_LOG_FILE}
  device=${device:0:3}
  echo "change device to ${device}" >> ${BOMC_LOG_FILE}
fi

cat /sys/block/${device}/device/vendor 2>/dev/null | grep -q IMM
if [ $? -eq 0 ]; then
  echo "/sys/block/${device}/device/vendor contains IMM" >> ${BOMC_LOG_FILE}
  echo "Device is iMM" >> ${BOMC_LOG_FILE}
  echo "This method might be unreleable, lets continue and check for IDs" >> ${BOMC_LOG_FILE} 
  #exit 0 
fi
  

pushd /sys/block/${device} >/dev/null 2>&1
rawdata=`ls -l device 2>/dev/null`
path1=`echo $rawdata| cut -d " "  -f 11`
usbpath=$path1/../../../../

cat ${usbpath}/idVendor 2>/dev/null| grep -q 04b3
if [ $? -eq 0 ]; then
  echo "cat ${usbpath}/idVendor | grep -q 04b3 return true" >> ${BOMC_LOG_FILE}
  echo "IBM Device" >> ${BOMC_LOG_FILE}
else
  echo "Path $1 is NOT mounted on remote IMM" >> ${BOMC_LOG_FILE}
  popd >/dev/null 2>&1
  exit 2 
fi 

cat ${usbpath}/idProduct 2>/dev/null| grep -q 4012 
if [ $? -eq 0 ]; then
  echo "cat ${usbpath}/idProduct | grep -q 4012 return true" >> ${BOMC_LOG_FILE}
  echo "IMM Remote Disk" >> ${BOMC_LOG_FILE}
else
  cat ${usbpath}/idProduct 2>/dev/null| grep -q 4003  
  if [ $? -eq 0 ]; then
    echo "cat ${usbpath}/idProduct | grep -q 4003 return true" >> ${BOMC_LOG_FILE}
    echo "AMM Remote Disk" >> ${BOMC_LOG_FILE}
  else
    popd 2>/dev/null
    echo "Path $1 is NOT mounted on remote IMM" >> ${BOMC_LOG_FILE}
    exit 2
  fi
fi

popd >/dev/null 2>&1
echo "Path $1 is mounted on remote IMM" >> ${BOMC_LOG_FILE}
exit 0
