#!/bin/sh
dmesg --console-off

if [ "$1" = "eject" ]; then
    progname=$(basename $0)
    devnamae=$(grep ^BOOT_DEVICE_NAME /bin/tcmount.sh | busybox cut -f2 -d"=")
    if [ "$devnamae" = "" ] || [ "$progname" = "tcexit_noeject.sh" ]; then
        echo "Ejecting Boot device does not apply in this case"
        devnamae=""
    else
        # Try to umount boot media
        cmd1="umount -l $devnamae"
        echo $cmd1
        $cmd1

        # Try to eject boot media
        cmd2="eject $devnamae"
        echo $cmd2
        $cmd2
        sleep 2
    fi
else
    if [ -e /toolscenter/start.sh ]; then
        cmd="umount /toolscenter"
        echo $cmd
        $cmd
        sleep 2
    fi

    ln -s /usr/lib/systemd/system/eject.service /usr/lib/systemd/system/halt.target.wants/
    ln -s /usr/lib/systemd/system/eject.service /usr/lib/systemd/system/poweroff.target.wants/
    ln -s /usr/lib/systemd/system/eject.service /usr/lib/systemd/system/reboot.target.wants/

    echo "setup complete"

    if [ "$1" = "shutdown" ]; then
        shutdown -h now
    elif [ "$1" = "reboot" ]; then
        reboot
    else
        exit 1
    fi
fi
