// Copyright © 2017 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
const { app, BrowserWindow, dialog} = require('electron');
const path = require('path');
const url = require('url');
const ipcMain = require('electron').ipcMain;
const Menu = require('electron').Menu;
const os = require('os');
const fs = require('fs');
const utils = require(__dirname + '/js_main/utils');

var win;
var close_flg = true; 

global.sharedObject = {
    showExitPrompt: true,
    exitConfirmMessage: "",
    messageBoxTitle: "",
};

// app.allowRendererProcessReuse = true;
utils.RegisterUtilsFunctions(ipcMain);
function init(){
    createWindow();   
}

function createWindow (){
    if(!process.argv.join(" ").endsWith("debug")){
        Menu.setApplicationMenu(null);
    }
    var icon_path = os.type().match(/windows/i)?'/images/l-favicon.ico':'/images/l-favicon.png';
    win = new BrowserWindow({
        width: 1020, 
        height: 780,
        resizable: true,
        frame: true,
        icon: __dirname + icon_path,
        show: false,
        minWidth: 800,
        minHeight: 600,
        webPreferences: {
            spellcheck: false,
            preload: `${__dirname}/preload.js`,
        }
    });
    utils.bomc_log(1, "create windows");

    win.loadURL(url.format({
        pathname: path.join(__dirname, 'index.html'),
        protocol: 'file',
        slashes: true
    }));
    if(process.argv.join(" ").endsWith("debug")){
        win.webContents.openDevTools();
    }
    win.on('close', function(e) {
        if(close_flg) {
            close_flg = false;
            var button = dialog.showMessageBoxSync(win, {
                title: "BoMC",
                message: "Are you sure to exit?",
                buttons: ["Yes", "No"]
            });
            if(button != 0) {
                e.preventDefault();
            }
            else {
                var confirmFile = os.type().match(/windows/i)?process.env["SystemDrive"]+"\\Lenovo_Support\\BoMC\\confirm_continue.xml":"/var/log/Lenovo_Support/BoMC/confirm_continue.xml";
                fs.writeFileSync(confirmFile, "STOP");
            }
            close_flg = true;
        } else {
            e.preventDefault();
        } 
    });
    win.on('closed', () => {
        win = null;
    });
    win.on('ready-to-show', () => {
        win.show();
    });
    const enforceInheritance = (topWebContents) => {
        const handle = (webContents) => {
            webContents.setWindowOpenHandler((details) => {
                return {
                    action: 'allow',
                    overrideBrowserWindowOptions: {
                        webPreferences: topWebContents.getLastWebPreferences()
                    }
                };
            });
        }
        handle(topWebContents);
    }
    enforceInheritance(win.webContents);

    ipcMain.on('reload', function (_) {
        win.reload();
    });
}
app.on('ready', init);
app.on('window-all-closed', () => {
    if(process.platform !== 'darwin'){
        app.quit();
    }
});
app.on('activate', () => {
    if(win === null){
        init();
    }
});

ipcMain.on('alertMsg', function(event, msg) {
    if(close_flg) {
        close_flg = false;
        event.returnValue = dialog.showMessageBoxSync(win, {
            title: "BoMC",
            message: msg,
            buttons: ["Ok"]
        });
        close_flg = true;
    }
});

ipcMain.on('confirmMsg', function(event, msg) {
    if(close_flg) {
        close_flg = false;
        event.returnValue = dialog.showMessageBoxSync(win, {
            title: "BoMC",
            message: msg,
            buttons: ["No", "Yes"]
        });
        close_flg = true;
    }
});

ipcMain.on('showOpenDialog', function(event, _defaultPath) {
    if(close_flg) {
        close_flg = false;
        event.returnValue = dialog.showOpenDialogSync(win, {
            defaultPath: _defaultPath,
            properties: ['openDirectory']
        });
        close_flg = true;
    }
});

ipcMain.on('showOpenDialogFile', function(event, _defaultPath, _filterType) {
    if(close_flg) {
        close_flg = false;
        event.returnValue = dialog.showOpenDialogSync(win, { 
            defaultPath: _defaultPath,
            properties: ['openFile'],
            filters: _filterType
        });
        close_flg = true;
    }
});

ipcMain.on('showSaveDialogFile', function(event, _defaultPath, _filterType) {
    if(close_flg) {
        close_flg = false;
        event.returnValue = dialog.showSaveDialogSync(win, { 
            defaultPath: _defaultPath,
            properties: ['openFile'],
            filters: _filterType
        });
        close_flg = true;
    }
});

ipcMain.on('quitMsg', function (event, msg) {
    froce_close = true;
    app.quit();
});

ipcMain.on('setMessageBoxTitle', function (_, title) {
    global.sharedObject.messageBoxTitle = title;
});

ipcMain.on('setExitConfirmFlag', function (_, flag) {
    global.sharedObject.showExitPrompt = flag;
});

ipcMain.on('setExitConfirmMessage', function (_, msg) {
    global.sharedObject.exitConfirmMessage = msg;
});







