// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
var SupportedSystems = function () {
	var SUPPORTLIST_OPERATION_RESULT;
	// if user selects a system in storage table, selectedTable is "storage"
	// if user selects a system in Lenovo Platform or IBM Platform table, selectedTable is "platform"
	function checkNewItem(newFamily, newMT) {
		var mtExisted = false;
		for (let i = 0; i < lenovoTable.data.length; i++) {
			let item = lenovoTable.data[i];
			if (item.mt.toLowerCase() === newMT.toLowerCase()) {
				mtExisted = true;
				break;
			}
		}
		return mtExisted;
	}

	/**
	  * A valid machine type should be a 4-digit text
	  */

	function isMTValid(mt, type) {
		var valid = true;
		mt = $.trim(mt);
		let regExp = /^[a-zA-Z\d]{4}$/gi;
		if (!mt.match(regExp)) {
			valid = false;
		}

		return valid;
	}

	/**
	  * Avoid HTML injection
	  */
	function isFamilyValid(family) {
		var valid = true;
		family = $.trim(family);
		let regExp = /^[a-zA-Z\d/ ]*$/gi;
		if (!family.match(regExp)) {
			valid = false;
		}
		return valid;
	}



	function checkSelectedSystems() {
		top.selectedOSMachineType = [];
		top.mtArray = [];
		for (let item of storageTable.data) {
			if (item.selected) {
				top.mtArray.push(item.mt);
			}
		}
		for (let item of lenovoTable.data) {
			if (item.selected) {
				top.mtArray.push(item.mt);
			}
		}
		if (top.mtArray.length == 0) {
			alert("You have not selected any system! ");
			return false;
		} else {
			for (var i = 0; i < top.mtArray.length; i++) {
				var type = top.returnMtCategory(top.mtArray[i]);
				if (type != "" && type != undefined && type != null) {
					if (top.selectedOSMachineType.indexOf(type) == -1) {
						top.selectedOSMachineType.push(type);
					}
				}
			}
			if (top.selectedOSMachineType.indexOf("storage") != -1) {
				top.program = "UPDATE";
				top.autorun = "NULL";
			}
			return true;
		}
	}

	function loadSystemsList() {
		try {
			var machineListFile = top.findFile(null, top.SYSTEM_SUPPORT_LIST);
			top.gl_salie_machine_list = JSON.parse(readTextFile(SALIE_SUPPORT_LIST));
			if (top.gl_salie_machine_list == null) throw new Error();
			top.getXML(machineListFile, populateSysList, "sysListID");
		} catch (error) {
			if (top.OSTYPE == "windows") {
				var salie_support_list_temp = top.workingdir + "\\SALIE_SYSTEM_SUPPORT_LIST_13.3.0.json";
				top.gl_salie_machine_list = JSON.parse(readTextFile(salie_support_list_temp));

				var supportListFile_temp = top.workingdir + "\\SYSTEM_SUPPORT_LIST_13.3.0.xml";
				var machineListFile = top.findFile(null, supportListFile_temp);
				top.getXML(machineListFile, populateSysList, "sysListID");
			} else {
				var salie_support_list_temp = top.workingdir + "/SALIE_SYSTEM_SUPPORT_LIST_13.3.0.json";
				top.gl_salie_machine_list = JSON.parse(readTextFile(salie_support_list_temp));

				var supportListFile_temp = top.workingdir + "/SYSTEM_SUPPORT_LIST_13.3.0.xml";
				var machineListFile = top.findFile(null, supportListFile_temp);
				top.getXML(machineListFile, populateSysList, "sysListID");
			}
		}
		create_table_body_storage();
	}

	function init() {
		SUPPORTLIST_OPERATION_RESULT = top.gl_ibm_support + top.getOSCommand("SUPPORTLIST_OPERATION_RESULT");
		loadSystemsList();
		isInited = true;
	}
	var salieTableBodyStr = "";

	function create_table_body_storage() {
		var storage_system = ['D1212/D1224', 'D3284', 'D4390'];
		var storage_mt = ['4587', '6413', '7DAH'];
		let back = storageTable.data;
		storageTable.data = [];
		for (let i = 0; i < storage_system.length; i++) {
			let bkItem = undefined;
			for(let j = 0; j < back.length; j++){
				let item = back[j];
				if(item.mt === storage_mt[i]){
					bkItem = item;
					break;
				}
			}
			if(bkItem != undefined){
				storageTable.data.push({
					productFamily: storage_system[i],
					mt: storage_mt[i],
					visible: bkItem.visible,
					selected: bkItem.selected
				});
			} else {
				storageTable.data.push({
					productFamily: storage_system[i],
					mt: storage_mt[i],
					visible: true,
					selected: false					
				});
			}
		}
	}

	function createTableBody(allSystems) {
		var sysCount = allSystems.length;
		let back = lenovoTable.data;
		lenovoTable.data = [];
		for (i = 0; i < sysCount; i++) {
			var xname = allSystems.item(i).firstChild.firstChild.nodeValue.toLowerCase();
			if (xname == "legacy option" || xname == "storage") {
				continue;
			}
			let mt = allSystems.item(i).childNodes[1].firstChild.nodeValue;
			let family = allSystems.item(i).childNodes[0].firstChild.nodeValue;
			if(!checkMTisSalie(mt)){
				continue;
			}
			let bkItem = undefined;
			for(let j = 0; j < back.length; j++){
				let item = back[j];
				if(item.mt === mt){
					bkItem = item;
					break;
				}
			}
			if(bkItem != undefined){
				lenovoTable.data.push({
					mt: bkItem.mt,
					mtDisplay: bkItem.mtDisplay,
					productFamily: family,
					productFamilyDisplay: family,
					visible: bkItem.visible,
					selected: bkItem.selected
				});
			} else {
				lenovoTable.data.push({
					mt: mt,
					mtDisplay: mt,
					productFamily: family,
					productFamilyDisplay: family,
					visible: true,
					selected: false
				});
			}
		}
	}

	function checkMTisSalie(mt){
		if(top.gl_salie_machine_list && top.gl_salie_machine_list.indexOf(mt)>-1)
			return true;
		else
			return false;
	}

	// Array of systems not allowed for selection
	// Element: id of checkbox for each system
	var forbidSystemList;
	// Dom object for contents of system support list
	function populateSysList(dom) {
		var root = dom.documentElement;
		var allSystems = root.getElementsByTagName("system");
		createTableBody(allSystems);
	}

	function updateSupportedSystems() {
		init_vue();
		initSalieListFile();
		top.printLog("INFO", "initSalieListFile done.");

		// refresh salie_support_list
		initAllList();
		top.printLog("INFO", "initAllList done.");

		initLenovoSystemxList();
		top.printLog("INFO", "initLenovoSystemxList done.");

		initPurleyList();
		top.printLog("INFO", "initPurleyList done.");

		initStorageList();
		top.printLog("INFO", "initStorageList done.");

		init();
		top.printLog("INFO", "init done.");
	}
	/**
	  * Perform necessary updates when suppport list operation is finished
	  */
	function postUpdate(dom) {
		if (dom != null) {
			var root = dom.documentElement;
			var result = root.getElementsByTagName("result");
			var resultStr = result.item(0).childNodes[0].nodeValue;
			var dispMsg;
			if (resultStr == "SUCCESS") {
				//top.showGlobalStatus("Request succeeded", null, top.STATUS.SUCCESS);
				// init();
				updateSupportedSystems();
				top.getVMWareSupportList(); //update vmware update support list
				dispMsg = "Request succeeded";
			} else {
				if (resultStr == "NOCHANGE") {
					//top.showGlobalStatus("No change found, request succeeded");
					dispMsg = "No change found, request succeeded";
				} else if (resultStr == "FAIL") {
					//top.showGlobalStatus("Request failed", null, top.STATUS.FAIL);
					dispMsg = "Request failed";
				} else {
					// dummy
					dispMsg = "Unknown error occured...";
				}
				errorInfo.info = dispMsg;
			}
		}
	}
	/**
	  * Check the result of operation on system support list
	  */
	function checkOperationResult() {
		var file = top.findFile(null, SUPPORTLIST_OPERATION_RESULT);
		if (file == null) {
			errorInfo.info = "Update list fail.";
		} else {
			top.getXML(file, postUpdate, "sysListOPResultID");
		}
	}

	function maskRunProgram(cmd, msg) {
		top.deleteFile(SUPPORTLIST_OPERATION_RESULT);
		errorInfo.reset();
		if (top.proxyAdd && top.proxyPort) {
			if (top.proxyAdd != "NULL") {
				if (top.proxyType == "https" ||
					top.proxyType == "socks4" ||
					top.proxyType == "socks4a" ||
					top.proxyType == "socks5" ||
					top.proxyType == "socks5h") {
					cmd.push("--proxy-address=" + top.proxyType + "://" + top.proxyAdd);
				} else {
					cmd.push("--proxy-address=" + top.proxyAdd);
				}
			}
			if (top.proxyPort != "NULL") {
				cmd.push("--proxy-port=" + top.proxyPort);
			}
			if (top.proxyUid != "NULL") {
				cmd.push("--proxy-user=" + top.proxyUid);
			}
			if (top.proxyPwd != "NULL") {
				cmd.push("--proxy-password=" + top.proxyPwd);
			}
		}
		dialog.waiting.text = msg;
		dialog.waiting.show = true;
		top.secureRunProgram(null, cmd, top.BACKGROUND, top.HIDDEN, undefined, function(success, error, stdout, stderr){
			dialog.waiting.show = false;
			dialog.waiting.code = error;
			dialog.waiting.stdout = stdout;
			dialog.waiting.stderr = stderr;
			checkOperationResult();
		});
	}

    /**
	 * Update Target System page with latest system support list acquired from server
	 */
	function updateList() {
		var cmd = new Array();
		cmd.push(top.pathJoin(top.workingdir, top.mainAppName));
		cmd.push("--update-supportlist");
		cmd.push("--xml");
		setPreviewParams(cmd);
		var msg = "Updating system support list now, please wait...";
		maskRunProgram(cmd, msg);
	}

	/**
	 * Update Target System page with the list bundled in BoMC
	 */
	function rollbackList() {
		var cmd = new Array();
		cmd.push(top.pathJoin(top.workingdir, top.mainAppName));
		cmd.push("--rollback-supportlist");
		cmd.push("--xml");
		setPreviewParams(cmd);
		var msg = "Rolling back system support list now, please wait...";
		maskRunProgram(cmd, msg);
	}
	function onRowSelectedChanged() {
		let allChecked = true;
		let allUnCheckted = true;
		for (let item of this.data) {
			if (item.selected) {
				allUnCheckted = false;
			} else {
				allChecked = false;
			}
		}
		if (allChecked) {
			this.checkAll = true;
			this.checkAllIndeterminate = true;
			setTimeout(() => { this.checkAllIndeterminate = false; }, 1);
		} else if (allUnCheckted) {
			this.checkAll = false;
			this.checkAllIndeterminate = true;
			setTimeout(() => { this.checkAllIndeterminate = false; }, 1);
		} else {
			this.checkAllIndeterminate = false;
			setTimeout(() => { this.checkAllIndeterminate = true; }, 1);
		}
		this.checkSelectCount();
	}

	function onCheckAllChanged() {
		for (let item of this.data) {
			if (item.visible) {
				item.selected = this.checkAll;
			}
		}
		this.onRowSelectedChanged();
	}

	function tr(msg) {
		return msg;
	}

	let dialog = Vue.reactive({
		warning: {
			show: false,
			text: tr("Batch management is limited to 10 devices. Adjust your selection accordingly."),
			onOk: function () {
				this.show = false;
			}
		},
		addDialog: {
			productFamily: "",
			mt: "",
			show: false,
			error: false,
			onCancel: function () {
				this.show = false;
			},
			onOk: function () {

			}
		},
		waiting: {
			show: false,
			text: "",
			stdout: "",
			stderr: "",
			code: 0,
			onAbort: function(){
				var args = new Array();
				args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
				args.push("--kill");
				args.push(top.mainAppName);
				args.push("--file");
				args.push(top.bomc_gui);
				secureRunProgram(null, args, BACKGROUND, HIDDEN);
			}
		}
	});

	function onRemoveSelected() {
		let func = () => {
			for (let i = 0; i < this.data.length;) {
				if (this.data[i].selected) {
					this.data.splice(i, 1);
					continue;
				}
				i++;
			}
			this.onRowSelectedChanged();
			dialog.warning.show = false;
		}
		if (this.selectedCount == 0) {
			return;
		}
		dialog.warning.text = "All selected systems will be removed from the list. Do you wish to proceed?";
		dialog.warning.onOk = func;
		dialog.warning.show = true;
	}

	function onAdd() {
		let func = () => {
			if (!isMTValid(dialog.addDialog.mt, "")) {
				dialog.addDialog.error = true;
				dialog.addDialog.errorInfo = "Invalid machine-type(s) specified";
				return;
			}
			if (checkNewItem(dialog.addDialog.productFamily, dialog.addDialog.mt)) {
				dialog.addDialog.error = true;
				dialog.addDialog.errorInfo = "The machine-type(s) has existed";
				return;
			}
			if (dialog.addDialog.productFamily === "") {
				dialog.addDialog.error = true;
				dialog.addDialog.errorInfo = "Product family cannot be empty.";
				return;
			}
			if (!isFamilyValid(dialog.addDialog.productFamily)) {
				dialog.addDialog.error = true;
				dialog.addDialog.errorInfo = "Product family can only contain digit numbers, letters, spaces or forward slashes.";
				return;
			}
			dialog.addDialog.show = false;
			this.data.push({
				selected: false,
				productFamily: dialog.addDialog.productFamily,
				mt: dialog.addDialog.mt,
				productFamilyDisplay: dialog.addDialog.productFamily,
				mtDisplay: dialog.addDialog.mt
			});
			this.filterChanged(this.filterString);
			setTimeout(() => {
				let div = document.getElementById("div-lenovo-table");
				div.scrollTop = div.scrollHeight;
			}, 5);
		};
		dialog.addDialog.onOk = func;
		dialog.addDialog.show = true;
	}

	function onSortByFamily(val) {
		if (val === "asc") {
			this.mtSortType = undefined;
			this.data.sort((x, y) => {
				if (x.productFamily > y.productFamily) {
					return 1;
				}
				if (x.productFamily < y.productFamily) {
					return -1;
				}
				return 0;
			});
		} else if (val === "dsc") {
			this.mtSortType = undefined;
			this.data.sort((y, x) => {
				if (x.productFamily > y.productFamily) {
					return 1;
				}
				if (x.productFamily < y.productFamily) {
					return -1;
				}
				return 0;
			});
		}
	}

	function onSortByMt(val) {
		if (val === "asc") {
			this.sortType = undefined;
			this.data.sort((x, y) => {
				if (x.mt > y.mt) {
					return 1;
				}
				if (x.mt < y.mt) {
					return -1;
				}
				return 0;
			});
		} else if (val === "dsc") {
			this.sortType = undefined;
			this.data.sort((y, x) => {
				if (x.mt > y.mt) {
					return 1;
				}
				if (x.mt < y.mt) {
					return -1;
				}
				return 0;
			});
		}
	}

	let storageTable = Vue.reactive({
		filterString: "",
		checkAllIndeterminate: false,
		checkAll: false,
		sortType: undefined,
		mtSortType: undefined,
		disabled: false,
		selectedCount: 0,
		data: [],
		onCheckAllChanged: onCheckAllChanged,
		onRowSelectedChanged: onRowSelectedChanged,
		checkSelectCount: function () {
			this.selectedCount = 0;
			for (let item of this.data) {
				if (item.selected) {
					this.selectedCount++;
				}
			}
		},
		total: function () {
			return this.data.length;
		},
		sortByFamily: onSortByFamily,
		sortByMt: onSortByMt,
		filterChanged: onFilterChanged
	});

	let lenovoTable = Vue.reactive({
		filterString: "",
		checkAll: false,
		checkAllIndeterminate: false,
		sortType: undefined,
		mtSortType: undefined,
		disabled: false,
		selectedCount: 0,
		data: [],
		onCheckAllChanged: onCheckAllChanged,
		onRowSelectedChanged: onRowSelectedChanged,
		checkSelectCount: function () {
			this.selectedCount = 0;
			for (let item of this.data) {
				if (item.selected) {
					this.selectedCount++;
				}
			}
		},
		total: function () {
			return this.data.length;
		},
		add: onAdd,
		removeSelected: onRemoveSelected,
		sortByFamily: onSortByFamily,
		sortByMt: onSortByMt,
		filterChanged: onFilterChanged
	});

	let selectedTable = Vue.ref("");

	let errorInfo = Vue.reactive({
		info: "",
		reset: function(){
			this.info = "";
		}
	})

	function onSelectedTableChanged() {
		console.log("changeStep");
		if (selectedTable.value == 'platform') {
			if (top.gl_steps_current.indexOf(MediaPurpose) == -1) {
				if (top.gl_steps_current.indexOf(SupportedSystems) != -1) {
					top.gl_steps_current.splice(top.gl_steps_current.indexOf(SupportedSystems) + 1, 0, MediaPurpose);
				}
			}
			if (top.gl_steps_current.indexOf(UnattendedConfiguration) == -1) {
				if (top.gl_steps_current.indexOf(SaveConfiguration) != -1) {
					top.gl_steps_current.splice(top.gl_steps_current.indexOf(SaveConfiguration), 0, UnattendedConfiguration);
				}
			}
		} else if (selectedTable.value == 'storage') {
			if (top.gl_steps_current.indexOf(MediaPurpose) != -1) {
				top.gl_steps_current.splice(top.gl_steps_current.indexOf(MediaPurpose), 1);
			}
			if (top.gl_steps_current.indexOf(UnattendedConfiguration) != -1) {
				top.gl_steps_current.splice(top.gl_steps_current.indexOf(UnattendedConfiguration), 1);
			}
		}
		top.configSteps(top.gl_steps_current);
	}

	function onFilterChanged(value) {
		let key = value.toLowerCase();
		let regex = new RegExp(key, "ig");
		for (let item of this.data) {
			if (item.productFamily.toLowerCase().includes(key)) {
				let tempVal = item.productFamily.match(regex);
                item.productFamilyDisplay = item.productFamily.replace(regex, "<b style='font-style:italic'>" + tempVal[0] + "</b>");
				item.mtDisplay = item.mt;
				item.visible = true;
			} else if (item.mt.toLowerCase().includes(key)) {
				item.productFamilyDisplay = item.productFamily;
				item.mtDisplay = item.mt.replace(key, `<b style="font-style:italic">${value}</b>`)
				item.visible = true;
			} else {
				item.productFamilyDisplay = item.productFamily;
				item.mtDisplay = item.mt;
				item.visible = false;
			}
			this.onRowSelectedChanged();
		}
	}

	function init_vue() {
		if (this.vueApp) {
			return;
		}
		this.vueApp = Vue.createApp({
			data() {
				return {
					storageTable: storageTable,
					lenovoTable: lenovoTable,
					dialog: dialog,
					selectedTable: selectedTable,
					errorInfo:errorInfo
				};
			},
			methods: {
				tr: tr,
				updateList: updateList,
				rollbackList: rollbackList
			},
			watch: {
				"lenovoTable.filterString": (val) => { lenovoTable.filterChanged(val); },
				"lenovoTable.sortType": (val) => { lenovoTable.sortByFamily(val); },
				"lenovoTable.mtSortType": (val) => { lenovoTable.sortByMt(val); },
				"storageTable.filterString": (val) => { storageTable.filterChanged(val); },
				"storageTable.sortType": (val) => { storageTable.sortByFamily(val); },
				"storageTable.mtSortType": (val) => { storageTable.sortByMt(val); },
				"selectedTable": (val) => { onSelectedTableChanged(val); },
				"storageTable.selectedCount": function (val) {
					lenovoTable.disabled = val > 0;
					selectedTable.value = val > 0 ? "storage" : selectedTable.value;
				},
				"lenovoTable.selectedCount": function (val) {
					storageTable.disabled = val > 0;
					selectedTable.value = val > 0 ? "platform" : selectedTable.value;
				}
			},
			directives: {
				focus: {
					mounted(el) {
						el.focus();
					}
				}
			}
		});
		this.vueApp.mount("#vue_supported_systems");
	}

	function onRemove() {
		this.vueApp = undefined;
	}


	return {
		name: "SupportedSystems",
		init: updateSupportedSystems,
		needReInit: false,
		nextAction: checkSelectedSystems,
		title: "Targeted Systems",
		content: loadContent("menu_SupportedSystems.html"),
	}
}();