// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
var ObtainLatestVersion = function()
{
	var obtainLatestVersion_result;
	var count = 0;
	var timer_update;
	var appBaseDir, appName;
	var downloadLocation;
	var errCode = 0;
	var errMsg = "";
	// tag for whether main app is still running
	var mainAppFinished = false;
	// record obtain folder that user selected
	var obtainFolderSelectedByUser = "";

	// callback function after main App is finished, set tag to false;
	function mainAppIsStopped()
	{
		mainAppFinished = true;
	}

	function cleanup()
	{
		if (!mainAppFinished) 
		{
			killApp_bomc(top.mainAppName);
			if(top.OSTYPE == "windows")
			{
				if(event.clientY < 0 || event.altKey)
				{
				killApp_bomc("mshta.exe");
				}
			}   
		}
	}

	function obtainLatestVersion_init() 
	{
		//disable "next" button
	  	top.togglePrevious(false); 
	  	//disable "next" button
		top.toggleNext(false); 
		obtainLatestVersion_result = top.gl_ibm_support + getOSCommand("obtainLatestVersion_result");
		if (top.OSTYPE == "windows") 
		{
			// var systemDriv = command("systemDriv")[0];
			appBaseDir = (top.portabledir == undefined || top.portabledir == "") ? top.gl_systemDrive
					+ "\\tmp\\updateDir"
					: top.portabledir + ('\\' == top.portabledir.charAt(top.portabledir.length-1)?"":"\\") + "updateDir";
		} else {
			appBaseDir = (top.portabledir == undefined || top.portabledir == "") ? "/tmp/updateDir"
					: top.portabledir + "/updateDir";
		}
		appName = top.mainAppName;
		clearMessage();
		StartOverallProcess();
	}

	function StartOverallProcess() {
		showChkForLatestVer_step_1();
		checkUpdate();
	}

	function checkUpdate() 
	{
		var args = new Array();
		// windows case:
		if (top.OSTYPE == "windows") 
		{
			args.push("..\\proxyupdate.bat");
			args.push(top.workingdir + "\\" + top.mainAppName);

		} 
		// linux case:
		else 
		{
			args.push("../proxyupdate.sh");
			args.push(top.mainAppName);
		}

		if (top.useAdditionalCaCertFile) {
            if (top.additionalCaCertFile != "" && top.additionalCaCertFile != null) {
                args.push("--cacert");
                args.push(top.additionalCaCertFile); 
            }
        }

		if (top.url_custom) {
			if (top.url_insecure) {
				args.push("--insecure");
			} else if (top.url_specify_cert) {
				if (top.urlCustomCaCertFile != "" && top.urlCustomCaCertFile != null) {
					args.push("--cacert");
					args.push(top.urlCustomCaCertFile);
				}
			}
		}

		
		if (top.proxyAdd && top.proxyPort) 
		{
			//args.push("--enable-proxy=yes");
			// fix defect 198284 - [2020/3/18 brondan]
			if (top.proxyAdd != "") {
				if (top.proxyType == "https" ||
					top.proxyType == "socks4" ||
					top.proxyType == "socks4a" ||
					top.proxyType == "socks5" ||
					top.proxyType == "socks5h") {
					args.push("--proxy-address=" + top.proxyType + "://" + top.proxyAdd);
				} else {
					args.push("--proxy-address=" + top.proxyAdd);
				}
			}
			if (top.proxyPort!= "") {
				args.push("--proxy-port=" + top.proxyPort);
			}
			if (top.proxyUid != "") {
				args.push("--proxy-user=" + top.proxyUid);
			}
			if (top.proxyPwd != "") {
				args.push("--proxy-password=" + top.proxyPwd);
			}

			if (top.proxy_insecure) {
				args.push("--proxy-insecure");
			} else {
				if (top.proxy_specify_cert) {
					if (top.proxyCaCertFile != "" && top.proxyCaCertFile != null) {
						args.push("--proxy-cacert");
						args.push(top.proxyCaCertFile); 
					}
				}
			}
		}
		
		args.push("--check-update");
		args.push("--report");

		setPreviewParams(args);

		mainAppFinished = false;
		secureRunProgram(null, args, BACKGROUND, HIDDEN, null, mainAppIsStopped);
		setTimeout(showChkForLatestVer_step_2, 1000);
		//timer_update = setInterval(showChkForLatestVer_step_2, 3000);
	}

	function showChkForLatestVer_step_1() 
	{
		// document.all("statusImg").innerHTML = "<img src=\"images/progressing.gif\" style=\"float:left;\" alt=\"Progressing\">";
		$("#obtainStatusImg").html("<img src=\"images/progressing.gif\" style=\"float:left;\" alt=\"Progressing\">");
		DisplayInnerText("obtainInfoText", "Checking for the latest version. . .");
	}

	//update the status when checking if a latest version is available on web site   
	function showChkForLatestVer_step_2() 
	{
		var statusImg = "<img src=\"images/statusInformation.png\" style=\"float:left;\" alt=\"Information\">";
		var infoTextLine = "";
		var downLoadBtn = "";
		var downloadDir = "";
		var retCode = 0;
		retCode = parseVersionCheckResult();
		$("#obtainDownloadButton").html("");
		//document.all("downloadbtn").innerHTML = "";
		if (retCode == 2) 
		{
			//no newer version available
			//clearInterval(timer_update);
			if (!mainAppFinished) {
				var args = new Array();
				args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
				args.push("--kill");
				args.push(top.mainAppName);
				args.push("--file");
				args.push(top.bomc_gui);
				secureRunProgram(null, args, BACKGROUND, HIDDEN, null, mainAppIsStopped);
			}
			clearMessage();
			$("#obtainStatusImg").html(statusImg);
			// document.all("statusImg").innerHTML = statusImg;
			DisplayInnerText("obtainInfoText", "No newer version is available. You are running the latest tool.");
			//enable "next" button
			top.togglePrevious(true); 
			//enable "next" button
			top.toggleNext(true); 
		} 
		else if (retCode == 1) 
		{
			//new version available on web site
			//clearInterval(timer_update);
			if (!mainAppFinished) {
				var args = new Array();
				args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
				args.push("--kill");
				args.push(top.mainAppName);
				args.push("--file");
				args.push(top.bomc_gui);
				secureRunProgram(null, args, BACKGROUND, HIDDEN, null, mainAppIsStopped);
			}
			//document.all("statusImg").innerHTML = "<img src=\"images/statusSuccess.gif\" style=\"float:left;\" alt=\"Success\">";
			//DisplayInnerText("InfoText", "Download complete. Find the new version in " +  appBaseDir);
			clearMessage();
			infoTextLine = "A new version of the this tool is available on Lenovo support web site.";
		    downloadDir = "Download to:&nbsp;&nbsp; <input type=\"text\" style=\"width:60%;\" id=\"target_dir\">&nbsp;&nbsp;<button class=\"DialogButton\" onClick = \"ObtainLatestVersion.SetDownloadDir()\">Browse</button>";
		    downLoadBtn = "<button class=\"DialogButton\" onClick = \"ObtainLatestVersion.startDownload()\">Download Now</button>";

		    $("#obtainStatusImg").html(statusImg)
		    $("#obtainSetDownloadPathbtn").html(downloadDir);
		    $("#obtainDownloadButton").html(downLoadBtn);
		    // document.all("statusImg").innerHTML = statusImg;
		    // document.all("setDownloadPathbtn").innerHTML = downloadDir;
		    // document.all("downloadbtn").innerHTML = downLoadBtn;
		    DisplayInnerText("obtainInfoText", infoTextLine);
		    
		    downloadLocation = appBaseDir;
		    if (obtainFolderSelectedByUser != null && obtainFolderSelectedByUser != "")
		    {
		    	$("#target_dir").attr("value", obtainFolderSelectedByUser);
		    }
		    else
		    {
		    	$("#target_dir").attr("value", downloadLocation);
		    }
		    // document.all("target_dir").value = downloadLocation;
	    	// enable "next" button
			top.togglePrevious(true); 
			// enable "next" button
			top.toggleNext(true); 
		} 
		else if (retCode == -1)
		{
		   //download error
		   //clearInterval(timer_update);
			if (!mainAppFinished) {
				var args = new Array();
				args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
				args.push("--kill");
				args.push(top.mainAppName);
				args.push("--file");
				args.push(top.bomc_gui);
				secureRunProgram(null, args, FOREGROUND, HIDDEN, null, mainAppIsStopped);
			}
			$("#obtainStatusImg").html("<img src=\"images/statusCritical_obj16.gif\" style=\"float:left;\" alt=\"Information\">");
			// document.all("statusImg").innerHTML = "<img src=\"images/statusCritical_obj16.gif\" style=\"float:left;\" alt=\"Information\">";
			DisplayInnerText("obtainInfoText", "There is an error when checking Lenovo support web site for the latest version, please check the log file for more details.");
			// enable "next" button
			top.togglePrevious(true); 
			// enable "next" button
			top.toggleNext(true); 
	  	}
	  	else
		{

			setTimeout(showChkForLatestVer_step_2,1000);
		}
	}

	function SetDownloadDir()
	{
		setWorkingDirectroy("target_dir", false);
	}

	function startDownload()
	{
	    var isLocValid = false;
	    downloadLocation = $("#target_dir").val();
	    // downloadLocation = document.all("target_dir").value;
	    isLocValid = validateDownloadLocation();
	    if(!isLocValid){
	    	return;
	    }
	    showChkForLatestVer_step_3();
	    top.togglePrevious(false); 	// disable "next" button
		top.toggleNext(false); 		// disable "next" button
	    getUpdate();
	}

	function getUpdate() {
		var args = new Array();
		if (top.OSTYPE == "windows") {
			args.push("..\\proxyupdate.bat");
			args.push(top.workingdir + "\\" + top.mainAppName);

		} else //linux ...
		{
			args.push("../proxyupdate.sh");
			args.push(top.mainAppName);
		}

        if (top.useAdditionalCaCertFile) {
            if (top.additionalCaCertFile != "" && top.additionalCaCertFile != null) {
                args.push("--cacert");
                args.push(top.additionalCaCertFile); 
            }
        }

		if (top.url_custom) {
			if (top.url_insecure) {
				args.push("--insecure");
			} else if (top.url_specify_cert) {
				if (top.urlCustomCaCertFile != "" && top.urlCustomCaCertFile != null) {
					args.push("--cacert");
					args.push(top.urlCustomCaCertFile);
				}
			}
		}

		if (top.proxyAdd && top.proxyPort) {
			//args.push("--enable-proxy=yes");
			// fix defect 198284 - [2020/3/18 brondan]
			if (top.proxyAdd != "") {
				if (top.proxyType == "https" ||
					top.proxyType == "socks4" ||
					top.proxyType == "socks4a" ||
					top.proxyType == "socks5" ||
					top.proxyType == "socks5h") {
					args.push("--proxy-address=" + top.proxyType + "://" + top.proxyAdd);
				} else {
					args.push("--proxy-address=" + top.proxyAdd);
				}
			}
			if (top.proxyPort!= "") {
				args.push("--proxy-port=" + top.proxyPort);
			}
			if (top.proxyUid != "") {
				args.push("--proxy-user=" + top.proxyUid);
			}
			if (top.proxyPwd != "") {
				args.push("--proxy-password=" + top.proxyPwd);
			}

			if (top.proxy_insecure) {
				args.push("--proxy-insecure");
			} else {
				if (top.proxy_specify_cert) {
					if (top.proxyCaCertFile != "" && top.proxyCaCertFile != null) {
						args.push("--proxy-cacert");
						args.push(top.proxyCaCertFile); 
					}
				}
			}
		}
		
		args.push("--check-update");
		args.push("--local=" + downloadLocation);
		setPreviewParams(args);

		mainAppFinished = false;
		secureRunProgram(null, args, BACKGROUND, HIDDEN, null, mainAppIsStopped);
		setTimeout(showChkForLatestVer_step_4,1000);
		//timer_update = setInterval(showChkForLatestVer_step_4, 3000);
	}

	function showChkForLatestVer_step_3()
	{
	    clearMessage();
	    // document.all("statusImg").innerHTML = "<img src=\"images/progress_anim2.gif\" style=\"float:left;\">";
	    // document.all("downloadbtn").innerHTML = "";
	    $("#obtainStatusImg").html("<img src=\"images/progress_anim2.gif\" style=\"float:left;\">");
	    $("#obtainDownloadButton").html("");
	    DisplayInnerText("obtainInfoText", "Acquiring latest version. . .");
	}

	function showChkForLatestVer_step_4()
	{
	    var retCode = 0;
	    retCode = parseDownloadResult();
	    // document.all("downloadbtn").innerHTML = "";
	    $("#obtainDownloadButton").html("");
	    if(retCode  == -1)
	    {
	        // clearInterval(timer_update);
	        // document.all("statusImg").innerHTML = "<img src=\"images/StatusCritical.gif\" style=\"float:left;\">";
	        $("#obtainStatusImg").html("<img src=\"images/StatusCritical.gif\" style=\"float:left;\">");
	        DisplayInnerText("obtainInfoText", "Download Failed! Please refer to the log file for more details.");
	        top.togglePrevious(true);
	        top.toggleNext(true);
	    }
	    else if(retCode == 1)
	    {
	        //clearInterval(timer_update);
	        // document.all("statusImg").innerHTML = "<img src=\"images/statusSuccess.png\" style=\"float:left;\">";
	        $("#obtainStatusImg").html("<img src=\"images/statusSuccess.png\" style=\"float:left;\">");
	        var fileLines = engineTop.secureReadTextFile(obtainLatestVersion_result);
	        var bAlreadyDownloaded = false;
			for ( var i = 0; i < fileLines.length; i++) 
	        {
				var aLine = trim(fileLines[i]);
				if (aLine.indexOf("Already downloaded") != -1) 
	          	{
					//download successfully
					bAlreadyDownloaded = true;
					break;
				}
			}
		  	if (bAlreadyDownloaded)
		  	{
				DisplayInnerText("obtainInfoText", "Acquiring latest version. . . Already downloaded");
	        }
	        else
	        {
	            DisplayInnerText("obtainInfoText", "Acquiring latest version. . . Done");
	        }
	        DisplayInnerText("obtainNewUXLiteInfoText", "Latest version of this tool is available at: " + downloadLocation);
		 	alert("Warning:Some legacy systems might be supported by older versions only, please have a check before switching to the latest version.");
	        top.togglePrevious(true);
	        top.toggleNext(true);
	    }
	    else
	    {
		setTimeout(showChkForLatestVer_step_4, 1000);
	    }
	}

	//return value:
	//  0 - still checking
	// -1 - error occured when checking
	//  1 - a new version available
	//  2 - no new version available
	function parseVersionCheckResult() 
	{
		if (cliErrorDetected()) 
		{
			//Error occurred
			if (!mainAppFinished) 
			{
				var args = new Array();
				args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
				args.push("--kill");
				args.push(top.mainAppName);
				args.push("--file");
				args.push(top.bomc_gui);
				secureRunProgram(null, args, BACKGROUND, HIDDEN, null, mainAppIsStopped);
			}
			if (errCode == 30)
			{
			  // new version available on web site
			  return 1;
		    }
		    else if (errCode == 31)
		    {
		      // user is running the latest version of tool
		      return 2;
		    }
		    else
		    {
		      //Error occurred when checking the latest version of the tool
		      return -1;
		    }
		} 
		else 
		{
			if (!mainAppFinished) {
				//still checking
				return 0;
			} 
			else 
			{
				//run for one more loop
				return 0;
			}
		}
	}

	//return value:
	// -1 - error occured when downloading
	//  1 - download successfully
	//  0 - still running
	function parseDownloadResult() {
		if (cliErrorDetected()) 
		{
			//Error occurred
			if (!mainAppFinished) {
				var args = new Array();
				args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
				args.push("--kill");
				args.push(top.mainAppName);
				args.push("--file");
				args.push(top.bomc_gui);
				secureRunProgram(null, args, FOREGROUND, HIDDEN, null, mainAppIsStopped);
			}
			return -1;
		}
		else 
		{
			if (!mainAppFinished) 
			{
				//still downloading
				return 0;
			} 
			else 
			{
		  		if (cliErrorDetected())
				{
				return -1;
				}
	      		else
	      		{
		        //cli finish running successfully
		        return 1;
	      		}
			}
		}
	}

	function DisplayInnerText(pTagName, textVal) {
		if (top.OSTYPE == "windows") {
			document.getElementById(pTagName).innerText = textVal;
		} else {
			document.getElementById(pTagName).innerHTML = textVal;
		}
	}

	function isRunning(appName) 
	{
		var args = new Array();
		args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
		args.push("--isrunning");
		args.push(appName);
		args.push("--file");
		args.push(top.bomc_gui);
		if (secureRunProgram(null, args, FOREGROUND, HIDDEN)) 
		{
			return false;
		}

		var propertiesInfo = new Array();
		if (!engineTop.secureFileExists(top.basicInfo)) 
		{
			alert("Can't get basic info!");
		}
		engineTop.secureRead1PropertyFile(top.basicInfo, propertiesInfo, false);

		if (propertiesInfo["IBM_SYSTEM_RUNNING"] == appName) 
		{
			return true;
		}
		return false;
	}

	function cliErrorDetected() 
	{
		var cliErrorMsgFile;
		cliErrorMsgFile = top.readTextFile(top.cliErrorMsg);
		if (cliErrorMsgFile && mainAppFinished) 
		{
			var errDom;
			errDom = ezJsLib.XmlDom.parse(cliErrorMsgFile);
			errMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", errDom.documentElement);
			errCode = ezJsLib.XmlDom.getValueByTagFromNode("CODE", errDom.documentElement);
			if (errCode != 0 && errCode != 20)
			{
				return true;
			}
			else
			{
				return false;
			}
		}
	}

	function trim(strtmp) 
	{
		return strtmp.replace(/(^\s*)|(\s*$)|(\r*$)|(\t*$)/g, "");
	}

	function clearMessage()
	{
		/*
	    document.all("statusImg").innerHTML = "";
	    document.all("downloadbtn").innerHTML = "";  
	    document.all("setDownloadPathbtn").innerHTML = ""; 
	    */
	    $("#obtainStatusImg").html("");
	    $("#obtainDownloadButton").html("");
	    $("#obtainSetDownloadPathbtn").html("");
	    DisplayInnerText("obtainInfoText", "");
	    DisplayInnerText("obtainNewUXLiteInfoText", "");
	}

	function validateDownloadLocation()
	{
	    if(top.trim(downloadLocation) == ""){
	        alert("Please specify the download location!");
	        return false;
	    }
		var ret = validatePath(downloadLocation);
		if(ret != "success")
		{
			if(ret == "Unavailable path!") {
				createDirectory(downloadLocation);
			}
			ret = validatePath(downloadLocation);
			if(ret != "success")
			{
				alert(ret);
				return false;
			}
		}
	    return true;
	}

	return{
		name: "ObtainLatestVersion",
        init: obtainLatestVersion_init, 
        SetDownloadDir: SetDownloadDir,
        startDownload: startDownload,
        nextAction: function() { return true; },
        title: "Obtain Latest Version",
        content: loadContent("menu_ObtainLatestVersion.html"),
	}
}();