// preload with contextIsolation enabled
const { contextBridge, ipcRenderer } = require('electron')

contextBridge.exposeInMainWorld('xpress', {
    alertMsg: (msg) => ipcRenderer.sendSync('alertMsg', msg),
    showOpenDialog: (msg) => ipcRenderer.sendSync('showOpenDialog', msg),
    showOpenDialogFile: (_defaultPath, _filterType) => ipcRenderer.sendSync('showOpenDialogFile', _defaultPath, _filterType),
    confirmMsg: (msg) => ipcRenderer.sendSync('confirmMsg', msg),
    quitMsg: (msg) => ipcRenderer.sendSync('quitMsg', msg),
    setMessageBoxTitle: (title) => ipcRenderer.send('setMessageBoxTitle', title),
    setExitConfirmFlag: (flag) => ipcRenderer.send('setExitConfirmFlag', flag),
    setExitConfirmMessage: (msg) => ipcRenderer.send('setExitConfirmMessage', msg),
    runProgram: (args, workingDirectory, callback, msgs) => {
        const callbackName = "runProgram" + Date.now().toString();
        ipcRenderer.once(
            callbackName,
            (_, ...args) => {
                callback(...args)
            }
        )
        console.log(JSON.stringify(args));
        ipcRenderer.send('runProgram', args, workingDirectory, callbackName, msgs)
    },
    rewrite_compare_result: (elected_list, forceid_list, callback, compare_rewrite_xml, compare_xml) => {
        const callbackName = "rewrite_compare_result" + Date.now().toString();
        ipcRenderer.once(
            callbackName,
            (_, ...args) => {
                callback(...args)
            }
        )
        ipcRenderer.send('rewrite_compare_result', elected_list, forceid_list, callbackName, compare_rewrite_xml, compare_xml)
    },
    utils: (funcName, ...args) => ipcRenderer.sendSync(funcName, ...args),
    reload: () => ipcRenderer.send('reload'),
    maximize: () => ipcRenderer.send('maximize'),
    close: () => ipcRenderer.send('close')
})
