// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
const fs = require('fs');
const path = require('path');
const process = require('process');
const os = require('os');
const readline = require('node:readline');
const {clipboard, dialog} = require('electron');

//const gl_base_path = "F:\\code\\gitlab\\LXCE\\updategui\\US\\windows\\imagefull\\updatexpress";
const gl_base_path = path.dirname(process.execPath);
const gl_support_dir = path.join(gl_base_path, "Lenovo_Support") + path.sep
const gl_app_base_path = path.join(__dirname, '..');
const lanCfgFile = path.join(__dirname, '../../../languages.json');

var gl_languages_cfg = JSON.parse(fs.readFileSync(lanCfgFile).toString());
const gl_build_cfg = JSON.parse(fs.readFileSync(path.join(__dirname, '../../../build.json')).toString());
var gl_onecli_process = null;
var mainWindow = null;

//const gl_basePath = process.execPath;
const logStream = function initLog() {
    if (!fs.existsSync(gl_support_dir)) {
        fs.mkdirSync(gl_support_dir)
    }
    var date = new Date();
    var month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
    var strDate = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
    var strHour = date.getHours() < 10 ? "0" + date.getHours() : date.getHours();
    var strMinute = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes();
    var strSecond = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();
    var curDate = "" + date.getFullYear() + month + strDate + strHour + strMinute + strSecond;
    var logPath = path.join(gl_support_dir, "updateXpress" + curDate + ".log");
    const lf = fs.createWriteStream(logPath, { flags: 'a' });
    lf.write(logPath + "\n");
    return lf;
}();


function setMainWindow(win){
    mainWindow = win;
}


function confirm(msg){
    var button = dialog.showMessageBoxSync(mainWindow, {
        type: 'warning',
        title: global.sharedObject.messageBoxTitle,
        message: msg,
        buttons: ["Yes", "No"],
        defaultId: 2
    });
    if (button === 0) {
        return true;
    }
    return false;
}


fsUtils = {
    createDirectory: function (dirpath) {
        if (!fs.existsSync(dirpath)) {
            try {
                if (!fs.mkdirSync(dirpath, { recursive: true })) {
                    return false;
                }
            } catch (e) {
                _ux_log("WARN", "Failed to create dir: " + dirpath)
                return false;
            }
        }
        return true;
    },
    fileExists: function (filepath) {
        return fs.existsSync(filepath);
    },
    directoryExists: function (directory) {
        return fs.existsSync(directory);
    },
    deleteFile: function (file) {
        if (fs.existsSync(file)) {
            fs.unlinkSync(file);
        }
        return true;
    },
    del_dir: function (dir_path) {
        if (directoryExists(dir_path)) {
            fs.rmdirSync(dir_path);
        }
    },
    // read an external file
    // fileName: string - full native file name or URL
    // returns: string - contents of file if readable, null otherwise
    readTextFile: function (fileName, charset) {
        if (!path.isAbsolute(fileName)) {
            fileName = path.join(gl_support_dir, fileName)
        }
        if (fileName == null || !fs.existsSync(fileName))
            return null;
        if (!charset)
            charset = "utf8"
        if (charset == "null")
            charset = null
        return fs.readFileSync(fileName, charset);
    },
    // write a text file
    // fileName: string - full native file name
    // text:  string - content of text file
    // append: boolean - true = append text to end of file,  false = overwrite existing file
    // returns: true if file was written successfully, false otherwise
    writeTextFile: function (fileName, fileContent, append) {
        if (!path.isAbsolute(fileName)) {
            fileName = path.join(gl_support_dir, fileName)
        }
        if (!fileContent) {
            console.error("No fileContent.");
            return false;
        }
        if (append && fs.existsSync(fileName)) {
            fs.appendFileSync(fileName, fileContent);
        } else {
            fs.writeFileSync(fileName, fileContent);
        }
        return true;
    },
    join: function (...args) {
        return path.join(...args);
    },
    rename: function (oldPath, newPath) {
        return fs.renameSync(oldPath, newPath)
    },
    dirname: function (filepath) {
        return path.dirname(filepath);
    },
    basename: function (filepath) {
        return path.basename(filepath);
    },
    basePath: () => {
        return gl_base_path;
    },
    appBasePath: () => {
        return gl_app_base_path;
    },
    loadFile: function (filePath) {
        if (!path.isAbsolute(filePath)) {
            filePath = path.join(__dirname, filePath)
        }
        return fs.readFileSync(filePath).toString();
    },
    loadSetting: function (settingName) {
        const settingFile = path.join(__dirname, "../settings", settingName);
        if (!fs.existsSync(settingFile)) {
            return {}
        }
        return JSON.parse(fs.readFileSync(settingFile).toString());
    }
};

commonUtils = {
    getEnv: function (name) {
        return process.env[name];
    },
    parsePropertiesFile: function (filename) {
        var prop = require("../js/libs/String.prototype.codePointAt-0.2.0/index.js");
        return prop.read(filename);
    },
    buildCfg: () => {
        return gl_build_cfg;
    },
    languagesCfg: () => {
        return gl_languages_cfg
    },
    updateLanguagesCfg: (cfg) => {
        fs.writeFileSync(lanCfgFile, Buffer.from(JSON.stringify(cfg)));
        gl_languages_cfg = cfg;
    },
    logPathCfg: () => {
        return gl_logPath_cfg
    },
    getGenericOSType: () => {
        var osName = os.type().toLowerCase();
        if (osName.indexOf("windows") >= 0) {
            return "windows";
        }
        return "unix";
    },
    getOS: () => {
        return os.type() + " " + os.release();
    },
    printLog: function (level, caller, msg) {
        const getNowFormatDate = function () {
            var date = new Date();
            var seperator1 = "-";
            var seperator2 = ":";
            var month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
            var strDate = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
            var strHour = date.getHours() < 10 ? "0" + date.getHours() : date.getHours();
            var strMinute = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes();
            var strSecond = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();

            var currentdate = date.getFullYear() + seperator1 + month + seperator1 + strDate
                + " " + strHour + seperator2 + strMinute + seperator2 + strSecond;
            return currentdate;
        };
        logStream.write(getNowFormatDate() + " [" + level + "]" + caller + msg + "\n");
    },
    openExternal: function (link) {
        require('electron').shell.openExternal(link);
    },
    getSupportDir: function () {
        return gl_support_dir;
    },
    killOneCli: function () {
        if (gl_onecli_process !== null) {
            gl_onecli_process.kill();
            gl_onecli_process = null
        }
    },
    copyToClipBoard: function(data){
        clipboard.writeText(data);
    }
}

function runProgram(event, args, workingDirectory, callback, msgs) {
    process.env["LD_PRELOAD"] = "";
    var cmd = args[0];
    args.shift();
    if (workingDirectory == null) {
        workingDirectory = path.dirname(cmd);
    }
    var options = { cwd: workingDirectory, maxBuffer: 2048000000 };
    var execFile = require('child_process').execFile;
    JSON.stringify()
    var subProcess = execFile(cmd, args, options, function (error, stdout, stderr) {
        if (error) {
            if (callback) {
                event.sender.send(callback, false, error, stdout, stderr);
            }
            return error.code;
        }
        if (callback) {
            event.sender.send(callback, true, error, stdout, stderr);
        }
        return 0;
    });
    if (path.basename(cmd).toLowerCase().startsWith('onecli')) {
        gl_onecli_process = subProcess
    }
    subProcess.stdout.on('data', (data) => {
        var data_string = data.toString();
        _ux_log("debug", data_string);
        event.sender.send("logConsole", data_string);
        console.log(data_string);
        if (msgs && msgs.length != 0) {
            msgs.forEach(msg => {
                if (data_string.indexOf(msg) != -1) {
                    if (confirm(msg)) {
                        subProcess.stdin.write("yes\n");
                    } else {
                        subProcess.stdin.write("no\n");
                    }
                }
            });
        }
    });
    subProcess.stderr.on('data', (data) => {
        var data_string = data.toString();
        _ux_log("debut", data_string);
        console.error(data_string);
        if (msgs && msgs.length != 0) {
            msgs.forEach(msg => {
                if (data_string.indexOf(msg) != -1) {
                    if (confirm(msg)) {
                        subProcess.stdin.write("yes\n");
                    } else {
                        subProcess.stdin.write("no\n");
                    }
                }
            });
        }
    });
}

function rewrite_compare_result(event, selected_list, forceid_list, callback, compare_rewrite_xml, compare_xml) {
    fsUtils.deleteFile(compare_rewrite_xml);
    var tag_sel = 0;
    var tag_force = 0;
    var rested_selected_list = selected_list.concat();
    var instream = fs.createReadStream(compare_xml);
    var outstream = new (require('stream'))();
    var rl = readline.createInterface(instream, outstream);
    rl.on('line', function (line) {
        if (line.indexOf('UPDATEID') != -1) {
            if (rested_selected_list) {
                for (var i = 0; i < rested_selected_list.length; i++) {
                    if (line.indexOf(rested_selected_list[i]) != -1) {
                        rested_selected_list.splice(i, 1);
                        tag_sel = 1;
                        break;
                    }
                    tag_sel = 0;
                }
            }
            if (forceid_list) {
                for (var i = 0; i < forceid_list.length; i++) {
                    if (line.indexOf(forceid_list[i]) != -1) {
                        tag_force = 1;
                        break;
                    }
                    tag_force = 0;
                }
            }
        }
        if (line.indexOf('<SELECTED>') != -1) {
            if (line.indexOf('0') != -1) {
                line = line.replace('0', tag_sel);
            } else if (line.indexOf('1') != -1) {
                line = line.replace('1', tag_sel);
            }
        }
        if (line.indexOf('<CSELECTED>') != -1) {
            if (line.indexOf('0') != -1) {
                line = line.replace('0', tag_sel);
            } else if (line.indexOf('1') != -1) {
                line = line.replace('1', tag_sel);
            }
        }
        if (line.indexOf('FORCEID') != -1) {
            if (line.indexOf('0') != -1) {
                line = line.replace('0', tag_force);
            } else if (line.indexOf('1') != -1) {
                line = line.replace('1', tag_force);
            }
        }
        if (line.indexOf('</PACKAGE>') != -1) {
            tag_sel = 0;
            tag_force = 0;
        }
        if (line.indexOf('</PACKAGES>') != -1) {
            // It is time to append missing package such as BMU
            var appended_lines = "";
            for (var i = 0; i < rested_selected_list.length; i++) {
                appended_lines += "<PACKAGE>\n";
                appended_lines += "<NAME/>\n";
                appended_lines += "<UPDATEID>" + rested_selected_list[i] + "</UPDATEID>\n";
                appended_lines += "<SELECTED>1</SELECTED>\n";
                appended_lines += "<FORCEID>0</FORCEID>\n";
                appended_lines += "<PACKAGEXML/>\n";
                appended_lines += "<INVENTORYJSON/>\n";
                appended_lines += "<SIGNATUREJSON/>\n";
                appended_lines += "<PAYLOADFILE/>\n";
                appended_lines += "</PACKAGE>\n";
            }
            line = appended_lines + line;
        }
        line = line + '\n';
        fsUtils.writeTextFile(compare_rewrite_xml, line, true);
    });
    rl.on('close', function (_) {
        if (callback) {
            event.sender.send(callback);
        }
    });
}

module.exports.RegisterUtilsFunctions = function (ipcMain) {
    for (var m in fsUtils) {
        if (fsUtils.hasOwnProperty(m) && typeof fsUtils[m] == "function") {
            const funcName = m;
            ipcMain.on(m, (event, ...args) => {
                event.returnValue = fsUtils[funcName](...args);
            });
        }
    }
    for (var m in commonUtils) {
        if (commonUtils.hasOwnProperty(m) && typeof commonUtils[m] == "function") {
            const funcName = m;
            ipcMain.on(m, function (event, ...args) {
                event.returnValue = commonUtils[funcName](...args);
            });
        }
    }
    ipcMain.on("runProgram", function (event, args, workingDirectory, callback, msgs) {
        runProgram(event, args, workingDirectory, callback, msgs);
    });
    ipcMain.on("rewrite_compare_result", function (event, elected_list, forceid_list, callback, compare_rewrite_xml, compare_xml) {
        rewrite_compare_result(event, elected_list, forceid_list, callback, compare_rewrite_xml, compare_xml);
    });
}

function _ux_log(level, msg) {
    function getCallerFileNameAndLine() {
        function getException() {
            try {
                throw Error('');
            } catch (err) {
                return err;
            }
        }
        const err = getException();
        const stack = err.stack;
        const stackArr = stack.split('\n');
        let callerLogIndex = 0;
        for (let i = 0; i < stackArr.length; i++) {
            if (stackArr[i].indexOf("_ux_log") > 0 && i + 1 < stackArr.length) {
                callerLogIndex = i + 1;
                break;
            }
        }
        if (callerLogIndex !== 0) {
            const callerStackLine = stackArr[callerLogIndex];
            const lastDash = callerStackLine.lastIndexOf("/");
            const lastBackslash = callerStackLine.lastIndexOf("\\");
            return `[${callerStackLine.substring((lastDash > lastBackslash ? lastDash : lastBackslash) + 1, callerStackLine.lastIndexOf(':'))}]`;
        } else {
            return '[-]';
        }
    }
    return commonUtils.printLog(level, getCallerFileNameAndLine(), msg)
}

module.exports.ux_log = _ux_log;
module.exports.setMainWindow = setMainWindow;