// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Update_Task = function(){
	let isInitArray = false;
	let availTasks = [];
	let taskLists = [];
	let htmlTaskLists = [];
	let checkboxidTaskLists = [];
	let cmdStatus = "init";

	let isSecurityLicenseFound = true;

	function initConstArray() {
		// Those indexs are defined in global.js, they must always be same with global.js
		// Use this array to confirm process steps
		taskLists = [
			/*gl_createRepo*/[],
			/*gl_enableSecurity*/[Security_Pack, Task_Complete],
			/*gl_sedBackup*/[Sed_Backup, Task_Complete],
			/*gl_isUpdate*/[OOB_Setting, Update_Location, Update_Type, Update_Comparison, Update_Execution, Task_Complete],
			/*gl_configRaid*/[Raid_Config, Task_Complete],
			/*gl_activate*/[TShield_Setting, Task_Complete],
			/*gl_syncEdgeStatus*/[TShield_Setting, Task_Complete],
			/*gl_stagedTask*/[Staged_Task, Task_Complete],
			/*gl_sedRestoreAK*/[Sed_Restore, Task_Complete]
		];
		// Use this array to re-sort tasks' html content ruled by config file
		htmlTaskLists = [
			/*gl_createRepo*/"",
			/*gl_enableSecurity*/document.getElementById("updateTasks0").innerHTML,
			/*gl_sedBackup*/document.getElementById("updateTasks1").innerHTML,
			/*gl_isUpdate*/document.getElementById("updateTasks2").innerHTML,
			/*gl_configRaid*/document.getElementById("updateTasks3").innerHTML,
			/*gl_activate*/document.getElementById("updateTasks4").innerHTML,
			/*gl_syncEdgeStatus*/document.getElementById("updateTasks5").innerHTML,
			/*gl_stagedTask*/document.getElementById("updateTasks6").innerHTML,
			/*gl_sedRestoreAK*/document.getElementById("updateTasks7").innerHTML
		];
		// Use this array to get checkbox id, then could do anything with it
		checkboxidTaskLists = [
			/*gl_createRepo*/"",
			/*gl_enableSecurity*/"updateTasksEnableSecurity",
			/*gl_sedBackup*/"updateTasksBackupSEDKey",
			/*gl_isUpdate*/"updateTasksUpdateOnly",
			/*gl_configRaid*/"updateTasksRaidConfig",
			/*gl_activate*/"updateTasksActivate",
			/*gl_syncEdgeStatus*/"updateSyncEdgeStatus",
			/*gl_stagedTask*/"manageStagedTasks",
			/*gl_sedRestoreAK*/"updateRestoreSEDTasks"
		]
		/**
		 * e.g. tasks = [gl_configRaid, gl_enableSecurity]
		 * ### Do something to display ###
		 * tasks.forEach(function(val, key) {
		 *     document.getElementById("updateTasks" + key).innerHTML = htmlTaskLists[val];
		 *     document.getElementById("updateTasks" + key).style.display = "block";
		 * });
		 * ### After user click 'Next' ###
		 * tasks.forEach(function(val, key) {
		 *     if (document.getElementById(checkboxidTaskLists[val]).checked){
		 *         gl_steps_current = gl_steps_current.concat(taskLists[val]);
		 *         top.gl_task.push(val);
		 *     }
		 * });
		 * configSteps(gl_steps_current);
		 */
	}

	function updateNavItems(toggledTaskName)
	{
		if (toggledTaskName) {
			printLog("INFO","toggle checkbox " + toggledTaskName + ".");
		}

		if(document.getElementById("updateTasksUpdateOnly").checked){
			document.getElementById("manageStagedTasks").disabled = true;
			$("#manageStagedTasks").parent().addClass("DisabledText");
		}else if(document.getElementById("manageStagedTasks").checked){
			document.getElementById("updateTasksUpdateOnly").disabled = true;
			$("#updateTasksUpdateOnly").parent().addClass("DisabledText");
		}else{
			document.getElementById("manageStagedTasks").disabled = false;
			document.getElementById("updateTasksUpdateOnly").disabled = false;
			$("#manageStagedTasks").parent().removeClass("DisabledText");
			$("#updateTasksUpdateOnly").parent().removeClass("DisabledText");
		}

		if (top.bCheckForLatest) {
            top.gl_steps_current = [Welcome, Proxy_Setting, Obtain_Latest_Version, Target_Server, Update_Task];
        } else {
            top.gl_steps_current = [Welcome, Target_Server, Update_Task];
        }
		top.gl_task = [];
		top.onecliCommandStrings = [];
		top.logFiles = [];

		availTasks.forEach(function(val, key) {
			if (document.getElementById(checkboxidTaskLists[val]).checked){
				top.gl_steps_current = top.gl_steps_current.concat(taskLists[val]);
				top.gl_task.push(val);
				top.onecliCommandStrings.push("");
				top.logFiles.push("");
			}
		});


		if (!top.bCheckForLatest) {
			if (top.gl_task.indexOf(top.gl_activate) != -1 || top.gl_task.indexOf(top.gl_syncEdgeStatus) != -1) {
				// These cases must need Proxy_Setting
				top.gl_steps_current.splice(top.gl_steps_current.indexOf(Update_Task) + 1, 0, Proxy_Setting);
			}
		}
		if (!isSecurityLicenseFound) {
			if (top.gl_steps_current.indexOf(Security_Pack) != -1) {
				top.gl_steps_current.splice(top.gl_steps_current.indexOf(Security_Pack), 0, Validate_License, Acquire_License);
			}
		}

		top.gl_steps_current.push(Finish);
		configSteps(top.gl_steps_current);
		printLog("DEBUG","function updateNavItems end.");
	}

	function edgeGetInfoCmd() {
		let edgeserverStatusPath = top.getSupportFile("edgeserverStatus");
		if (top.fileExists(edgeserverStatusPath)) {
			top.deleteFile(edgeserverStatusPath);
		}
		let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("getsecurityinfo");
		args.push("--bmc");
		args.push(SplitFullConnInfo());
		args.push("--never-check-trust");
		args.push(...add_output_log5());
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
		runProgram(args, null, () => {
			cmdStatus = "inited";
			ut_init();
		});
	}

	function edgeGetInfo() {
		let edgeserverStatusPath = top.getSupportFile("edgeserverStatus");
		let ret = "Default";
		if (top.fileExists(edgeserverStatusPath)) {
			try {
				let xccInfo = JSON.parse(top.readTextFile(edgeserverStatusPath));
				let xccMode = xccInfo["Mode"]; // enabled/disabled/unsupported
				let xccStatus = xccInfo["Status"]; // inactive/active (only presented when mode = enabled)
				if (xccMode.toLowerCase() == "enabled") {
					if (xccStatus.toLowerCase() != "active") {
						ret = "ThinkEdge_Locked";
					} else {
						ret = "ThinkEdge_Actived";
					}
				} else if (xccMode.toLowerCase() == "disabled") {
					ret = "ThinkEdge_Upgradeable";
				}
				top.gl_Machine_Params.ActivationCode = xccInfo["Active Code"];
				top.gl_Machine_Params.ChallengeText = xccInfo["Challenge Text"];
				top.gl_Machine_Params.SN = xccInfo["Serial Number"];
				top.gl_Machine_Params.MotionDetectionEnable = xccInfo["Motion Detection Enable"];
				top.gl_Machine_Params.ChassisIntrusionDetectionEnable = xccInfo["Chassis Intrusion Detection Enable"];
			} catch (e) {
				printLog("ERROR","Failed to read edgeserverStatus json.");
				ret = "Default";
			}
		}
		return ret;
	}

	function ut_obtainAvaOperations() {
		printLog("INFO","Begin to obtain available operations.");
		let connectMode = (top.gl_OOB_Params.Enabled ? "OOB": "Inband");
		let mtype = "";
		if ("OOB" == connectMode) {
			// All tasks about thinkshield only could work in OOB mode
			mtype = edgeGetInfo();
		}
		 else {
			mtype = "Default";
		}
		let opsList = top.loadSetting("operation_defines.json");
		return opsList[connectMode][mtype].concat();
	}

	function ut_init()
	{
		printLog("INFO","Task page init.");
		top.togglePrevious(false);
		top.toggleNext(false);
		Staged_Task.setSkipRepoter(false);

		if (!isInitArray) {
			initConstArray();
			isInitArray = true;
		}
		if (cmdStatus == "init") {
			top.showUnstoppableWaitMsg();
			if (top.gl_OOB_Params.Enabled) {
				edgeGetInfoCmd();
			} else {
				cmdStatus = "inited";
				ut_init();
			}
		} else if (cmdStatus == "inited") {
			availTasks = ut_obtainAvaOperations();
			// Display available operations by pre-defined order, hide unavailable operations
			availTasks.forEach(function(val, key) {
				document.getElementById("updateTasks" + key).innerHTML = htmlTaskLists[val];
				document.getElementById("updateTasks" + key).style.display = "block";
			});
			// htmlTaskLists.length - 1 because task createRepo does not exsit in this page
			for (let i = availTasks.length; i < htmlTaskLists.length - 1; ++i) {
				document.getElementById("updateTasks" + i).style.display = "none";
			}
			// if only 1 task, choose it by default
			if (availTasks.length == 1) {
				document.getElementById("updateTasks0").getElementsByTagName("input")[0].checked=true;
			}
			updateNavItems();
			cmdStatus = "init";
			top.togglePrevious(true);
			top.toggleNext(true);
			top.hideUnstoppableWaitMsg();
		}
		printLog("DEBUG","function ut_init end.");
	}

	function ut_collect(){
		printLog("INFO","Next was clicked.");
		if (0 == top.gl_task.length) {
			alert($.i18n.prop("UpdateTask.needSelected"));
			return false;
		}
		top.gl_curTaskIndex = 0;
		if(top.gl_Inband_Params.Enabled){
			top.gl_mt_list = new Array();
	  		top.gl_os_list = new Array();
			top.gl_mt_list.push(top.gl_current_mt);
	  		top.gl_os_list.push(top.gl_current_os);
		} else {
			top.gl_mt_list = new Array();
	  		top.gl_os_list = new Array();
	  	}
	  	return true;
	}

	function showHelpPage(task) {
		printLog("INFO","Show help info of '" + task + "' was clicked.");
		let mywidth = 600;
		let myheight = 400;
		let myleft = (screen.width - mywidth) / 2;
		let mytop = (screen.height - myheight) / 2;
		let pageOpts = 'width=' + mywidth + ', height=' + myheight;
		pageOpts += ', top=' + mytop + ', left=' + myleft;
		pageOpts += ', directories=no';
		pageOpts += ', location=no';
		pageOpts += ', menubar=yes';
		pageOpts += ', resizable=yes';
		pageOpts += ', scrollbars=yes';
		pageOpts += ', status=no';
		pageOpts += ', toolbar=no';
		pageOpts += ', close=yes';
		pageOpts += ', show=true';
		pageOpts += ', title=Lenovo XClarity Essentials UpdateXpress';
		let helpContent = "";
		if ("EnableSecurity" == task) {
			helpContent = "<HTML><BODY style='white-space:normal;'>" + $.i18n.prop("UpdateTask.HelpInfo.EnableSecurity") + "<\/BODY><\/HTML>";
		} else if ("Activate" == task) {
			helpContent = "<HTML><BODY style='white-space:normal;'>" + $.i18n.prop("UpdateTask.HelpInfo.Activate") + "<\/BODY><\/HTML>";
		} else if ("SyncEdgeStatus" == task) {
			helpContent = "<HTML><BODY style='white-space:normal;'>" + $.i18n.prop("UpdateTask.HelpInfo.SyncEdgeStatus") + "<\/BODY><\/HTML>";
		}
		top.writeTextFile(top.getSupportFile("helpHtml"), helpContent);

		let helpWindow = window.open("file://" + top.getSupportFile("helpHtml"), "", pageOpts);
		if (window.focus) helpWindow.focus();
	}

	return {
		index: 0,
		name: "Update_Task",
        init: ut_init,
        needReInit: true,
		updateNavItems: updateNavItems,
		showHelpPage: showHelpPage,
		previousAction: function() {return true;},
        nextAction: ut_collect,
		importId: '#import_update_task',
        selectorId: '.update_task',
        title: "Navi.UpdateTask"
	}
}();