// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Target_Directory = function() {

	function target_directory_init() {
		printLog("INFO","Target Directory page init.");
		document.getElementById("target_dir").focus();
		document.getElementById("target_dir").value = top.gl_workingDir;
		//document.getElementById("target_directory_folder_browser").value = top.gl_workingDir;
	}

	function dir_collect() {
		printLog("INFO","Next was clicked.");
		var dir = document.getElementById("target_dir").value;
		var ret = validatePath(dir);
		if(ret != "success")
		{
			if(ret == "Common.UnavailablePath") {
				if(confirm($.i18n.prop("TargetDirectory.DirectoryNotExist"))) {
					createDirectory(dir);
					if(!directoryExists(dir)) {
						alert($.i18n.prop("Common.CreatePathFailure"));
						return false;
					}
				} else {
					return false;
				}
			} else {
				alert($.i18n.prop(ret));
				return false;
			}
		}
		top.gl_workingDir = dir;
		writeConfigFile();

		return true;
	}

	function openWorkingDir() {
		printLog("INFO","button 'Browse...' was clicked.");
	    setWorkingDir("target_dir", true);
	}

	return {
		index: 0,
		name: "Target_Directory",
        init: target_directory_init,
        openWorkingDir: openWorkingDir,
        nextAction: dir_collect,
		importId: '#import_target_directory',
        selectorId: '.target_directory',
        title: "Navi.TargetDirectory"
	}
}();