// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Sed_Restore = function () {

    let restoreParams = {
        backupFilePath: "", 
        password: ""
    };

    let commandStage = "init";
    let method = "UsingBackUpFile";
    const methods = ["UsingBackUpFile", "UsingPassphrase", "UsingAutomaticBackup"];
    // Total retry times if failed
    let DEFAULT_RETRY_TIMES = 2;
    let maxRetryTimes = 0;
    let currentRetriedTimes = 0;
    // Current command's info
    let currentFunc;

    function sed_restore_init() {
        top.toggleNext(false);
        setRecoverMethod("BackupFile");
        return true;
    }

    function hideAll() {
        $("#RecoverResult").hide();
        showTipsInfo("");
    }

    function setRecoverMethod(value) {
        top.gl_proxyType = value.toLowerCase();
        printLog("INFO","set Recover method as using " + value);
        switch (value)
        {
            case "BackupFile":
                $("#UsingBackupFile").show();
                $("#UsingPassword").hide();
                $("#UsingAutomaticBackup").hide();
                method = methods[0];
                break;
            case "Passphrase":
                $("#UsingBackupFile").hide();
                $("#UsingPassword").show();
                $("#UsingAutomaticBackup").hide();
                method = methods[1];
                break;
            case "AutomaticBackUp":
                // TODO: to implement
                $("#UsingBackupFile").hide();
                $("#UsingPassword").hide();
                $("#UsingAutomaticBackup").show();
                method = methods[2];
                break;
            default:
                break;
        }
        hideAll();
    }

    function openBackupFileDir() {
        printLog("INFO","button 'Browse...' was clicked.");
        openFileDirectory("BackupFilePath", getBackupFileDir, 
		[{ name: 'File Type', extensions: ['bak', 'txt'] }]);
    }

    function getBackupFileDir(path){
        var cert=path;
        if(cert!=null && cert!=""){
            $("#BackupFilePath").val(cert);
            top.gl_proxy_cert = cert;
        }
    }

    function checkParamIsNull(params) {
        let isNull = false;
		$(params).each(function(i, n){
			let value=$("#" + n).val();
			if(!value || value == ""){
                setTimeout(() => {
                    $("#"+n).focus();
                });
                isNull = true;
                return false;
			}
		});
        if (isNull) {
            showTipsInfo($.i18n.prop("SedRestore.ParamsNeeded"));
        } else {
            showTipsInfo("");
        }
		return isNull;
	}

    function checkIfValid(params, regExp, local, focus) {
        let res = $("#"+params[0]).val().match(regExp) || $("#"+params[0]).val() == "";
        if (!res) {
            if (focus) {
                setTimeout(() => {
                    $("#"+params[0]).focus();    
                });
            }
            showTipsInfo($.i18n.prop(local));
        } else {
            showTipsInfo("");
        }
        return res;
    }

    function checkFileExists(path){
        let res =  fileExists(path);
        if (!res) {
            setTimeout(() => {
                $("#BackupFilePath").focus();   
            });
            showTipsInfo($.i18n.prop("SedRestore.FileNotExists"));
        } else {
            showTipsInfo("");
        }
        return res;
    }

    function validatePassword(params) {
        do{
            let regExp = ".{9,}";
            let local = "SedRestore.PasswordNotValid";
            if(!checkIfValid(params, regExp, local, false)) {
                $("#RecoverResult").hide();
                break;
            }
        } while (false)
    }

    function validatePassphrase(params) {
        do{
            let regExp = "^(?!.*(.)\\1\\1)(?![a-zA-Z]+$)(?![A-Z0-9]+$)(?![A-Z\\W_]+$)(?![a-z0-9]+$)(?![a-z\\W_]+$)(?![0-9\\W_]+$)(?![a-zA-Z\\W_]+$)[a-zA-Z0-9\\W_]{10,32}$";
            let local = "SedRestore.PassphraseNotValid";
            if(!checkIfValid(params, regExp, local, false)) {
                $("#RecoverResult").hide();
                break;
            }
        } while (false)
    }

    function showTipsInfo(str){
		if (str == ""){
			$("#RestoreTips").hide();
			return;
		}
		$("#RestoreTips").show();
		$("#RestoreTipsInfo").html(str);
	}

    function enableAll() {
        $("#BackupFilePath").prop("disabled", false);
        $("#BackupFilePassword").prop("disabled", false);
        $(".StartRestoreBtn").prop("disabled", false);
        $("#BackupFileBrowserBtn").prop("disabled", false);
        $("#RecoverMethods").prop("disabled", false);
        $("#Passphrase").prop("disabled", false);
        $("#ComfirmedPassphrase").prop("disabled", false);
    }

    function disableAll() {
        $("#BackupFilePath").prop("disabled", true);
        $("#BackupFilePassword").prop("disabled", true);
        $(".StartRestoreBtn").prop("disabled", true);
        $("#BackupFileBrowserBtn").prop("disabled", true);
        $("#RecoverMethods").prop("disabled", true);
        $("#Passphrase").prop("disabled", true);
        $("#ComfirmedPassphrase").prop("disabled", true);
    }

    function getCommonResult() {
        let resultFile = top.readTextFile(top.getSupportFile("commonResult"));
        var resultDom, resultMsg;
        if (resultFile != null) {
            resultDom = ezJsLib.XmlDom.parse(resultFile);
            resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
            setLogFile(ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom));
            return resultMsg;
        } else {
            return top.getComErrMsg();
        }
    }

    function runCmdRecoverUsingBackupFile() {
        ++currentRetriedTimes;
        deleteFile(top.getSupportFile("commonResult"));
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("config");
		args.push("restore");
        args.push("Security.SED_AK");
        args.push("--file");
        args.push(restoreParams.backupFilePath);
        args.push("--passphrase");
        args.push(restoreParams.password);
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--redfish");
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
        commandStage = "done";
        runProgram(args, null, rescoverSEDAK);
    }

    function runCmdRecoverUsingPassphrase() {
        ++currentRetriedTimes;
        deleteFile(top.getSupportFile("commonResult"));
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("config");
		args.push("restore");
        args.push("Security.SED_AK");
        args.push("--passphrase");
        args.push(restoreParams.password);
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--redfish");
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
        commandStage = "done";
        runProgram(args, null, rescoverSEDAK);
    }

    function setRunning() {
        $("#RecoverResult").show();
        let nodes = $("#RecoverResult").children();
        nodes[0].src = "images/progress_anim2_small.gif";
        nodes[1].style.display = "inline";
        nodes[1].innerHTML = $.i18n.prop("SedRestore.RecoverRunning");
        nodes[2].style.display = "none";
    }

    function setFailed() {
        $("#RecoverResult").show();
        let nodes = $("#RecoverResult").children();
        nodes[0].src = "images/statusCritical_obj16.gif";
        nodes[1].style.display = "inline";
        nodes[1].innerHTML = $.i18n.prop("SedRestore.RestoreFailed");
        nodes[2].style.display = "block";
        nodes[2].innerHTML = $.i18n.prop("SedRestore.ErrorMessage", getCommonResult());
    }

    function setSuccessed() {
        $("#RecoverResult").show();
        let nodes = $("#RecoverResult").children();
        nodes[0].src = "images/statusSuccess_obj16.gif";
        nodes[1].style.display = "inline";
        nodes[1].innerHTML = $.i18n.prop("SedRestore.SuccessInfo");
        nodes[2].style.display = "none";
    }

    function taskAllComplete(success) {
        top.togglePrevious(true);
        enableAll();
        commandStage = "init";
        if (success == true) {
            top.toggleNext(true);
            getCommonResult(); // only for set log file in the end
        }
    }

    function taskSucceed() {
        setSuccessed();
        taskAllComplete(true);
    }

    function taskFailed() {
        setFailed();
        taskAllComplete(false);
    }

    function taskRetry() {
        if (currentRetriedTimes < maxRetryTimes) {
            currentFunc();
        } else {
            taskFailed();
        }
    }

    function taskRun(cmdFunc, retryTimes) {
        currentFunc = cmdFunc;
        currentRetriedTimes = 0;
        if (retryTimes != undefined) {
            maxRetryTimes = retryTimes;
        } else {
            maxRetryTimes = DEFAULT_RETRY_TIMES;
        }
        currentFunc();
    }

    function rescoverSEDAK(isSeccessful) {
        if (!isSeccessful) {
            return taskRetry();
        }
        if ("init" == commandStage) {
            if (methods[0] == method) {
                taskRun(runCmdRecoverUsingBackupFile, 0);
            } else if (methods[1] == method){
                taskRun(runCmdRecoverUsingPassphrase, 0);
            }
            setRunning();
        } else if ("done" == commandStage) {
            taskSucceed();
        }
    }

    function startRestoreSEDAK() {
        printLog("INFO","Start Restore was clicked.");
        top.toggleNext(false);
        top.togglePrevious(false);
        hideAll();
        disableAll();

        let res = true;
        let regExp;
        let local;
        do {
            if (methods[0] == method) {
                if (checkParamIsNull(["BackupFilePath", "BackupFilePassword"])) {
                    res = false;
                    break;
                }
                if (!checkFileExists($("#BackupFilePath").val())) {
                    res = false;
                    break;
                }
                regExp = ".{9,}";
                local = "SedRestore.PasswordNotValid";
                if(!checkIfValid(["BackupFilePassword"], regExp, local, true)) {
                    res = false;
                    break;
                }
            } else if (methods[1] == method) {
                if (checkParamIsNull(["Passphrase"])) {
                    res = false;
                    break;
                }
                regExp = "^(?!.*(.)\\1\\1)(?![a-zA-Z]+$)(?![A-Z0-9]+$)(?![A-Z\\W_]+$)(?![a-z0-9]+$)(?![a-z\\W_]+$)(?![0-9\\W_]+$)(?![a-zA-Z\\W_]+$)[a-zA-Z0-9\\W_]{10,32}$";
                local = "SedRestore.PassphraseNotValid";
                if(!checkIfValid(["Passphrase"], regExp, local, true)) {
                    res = false;
                    break;
                }
            }
        } while (false);
        
        if (!res) {
            top.toggleNext(false);
            top.togglePrevious(true);
            enableAll();
            return false;
        }

        if (methods[0] == method) {
            restoreParams.backupFilePath = $("#BackupFilePath").val();
		    restoreParams.password  = $("#BackupFilePassword").val();
        } else if (methods[1] == method) {
            restoreParams.password  = $("#Passphrase").val();
        }

        rescoverSEDAK(true);
    }

    return {
        index: 0,
        name: "Sed_restore",
        init: sed_restore_init,
        setRecoverMethod: setRecoverMethod,
        openBackupFileDir: openBackupFileDir,
        startRestoreSEDAK: startRestoreSEDAK,
        validatePassword: validatePassword,
        validatePassphrase: validatePassphrase,
        nextAction: function() {
            return true;
        },
        previousAction: function() {
            return true;
        },
        importId: '#import_sed_restore',
        selectorId: '.sed_restore',
        title: "Navi.SedRestore",
    }
}();