// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Obtain_Latest_Version = function() {
  var downloadLocation;
  var updateAction;
  var newVersionId;
  var updateListResultFile = "";
  var defaultSystemListPath = "";

  function clearMessage() {
    $(".statusImg").html("");
    document.getElementById("downloadbtn").innerHTML = "";
    DisplayInnerText("InfoText", "");
    DisplayInnerText("NewUXLiteInfoText", "");
  }

  function DisplayInnerText(pTagName, textVal) {
    document.getElementById(pTagName).innerText = textVal;
  }

  function obtainLatestVersionInit() {
    printLog("INFO","Obtain Latest Version init or button 'Check for the latest version' was clicked.");
    updateListResultFile = top.pathJoin(top.getSupportDir(), top.BUILD_FIX_ID+".xml");
    defaultSystemListPath = top.getSystemFile("mtList");
    clearMessage();
    newVersionId = "";
    top.togglePrevious(false);
    top.toggleNext(false);
    top.isOneCliRunning(obtainLatestVersionInitCallback);
    printLog("DEBUG","function obtainLatestVersionInit end.");
  }

  function obtainLatestVersionInitCallback(isRunning) {
    if(!isRunning) {
      var args = new Array();
      deleteFile(top.getSupportFile("acquireResult"));
      deleteFile(top.getSupportFile("commonResult"));
      args.push(top.getSystemFile("oneCli"));
      args.push("update");
      args.push("acquire");
      args.push("--xml");
      args.push("--scope");
      args.push("latest");
      args.push("--includeid");
      args.push(top.BUILD_FIX_ID);
      args.push("--metaonly");
      args.push("--dir");
      args.push(top.getSupportDir());
      args.push(...add_output_log5());
      //set proxy if there is
      args.push(...add_proxy_para());

      statusCheckingLatestVersion();
      runProgram(args, null, checkingLatestVersionCallback);
    } else {
      statusOneCliIsRunning();
    }
  }

  function statusOneCliIsRunning() {
    clearMessage();
    DisplayInnerText("InfoText", $.i18n.prop("ObtainLatestVersion.OneCliRun"));
    if (updateAction == "check") {
      var buttonContent = "<button class='DialogButton' onClick='Obtain_Latest_Version.obtainLatestVersionInit()'>" + $.i18n.prop("ObtainLatestVersion.CheckVersion") + "</button>";
    } else if (updateAction == "update") {
      var buttonContent = "<button class='DialogButton' onClick='Obtain_Latest_Version.startUpdateSystemListXML()'>" + $.i18n.prop("ObtainLatestVersion.UpdateNow") + "</button>";
    } else if (updateAction == "download") {
      var buttonContent = "<button class='DialogButton' onClick='Obtain_Latest_Version.downloadUpdateGui()'>" + $.i18n.prop("ObtainLatestVersion.DownloadNow") + "</button>";
    }
    document.getElementById("downloadbtn").innerHTML = buttonContent;
  }

  function statusCheckingLatestVersion() {
    clearMessage();
    $(".statusImg").html( "<img src=\"images/progress_anim2.gif\" style=\"float:left;\">");
    DisplayInnerText("InfoText", $.i18n.prop("ObtainLatestVersion.CheckVersion"));
    top.togglePrevious(false);
    top.toggleNext(false);
  }

  function checkingLatestVersionCallback(success) {
    top.togglePrevious(true);
    top.toggleNext(true);
    if (!success) {
      statusCheckingLatestVersionFail();
    } else {
      var commonResultContent = top.readTextFile(top.getSupportFile("commonResult"));
      if (commonResultContent != null && commonResultContent != "") {
        var commonResultDom = ezJsLib.XmlDom.parse(commonResultContent);
        var errorNode = ezJsLib.XmlDom.getValueByTag("ERROR", commonResultDom);
        var msgNode = ezJsLib.XmlDom.getValueByTag("MESSAGE", commonResultDom);
        if (errorNode == "No" && (msgNode.indexOf("Succeed") != -1 || msgNode.indexOf("Success") != -1)) {
          var acquireResultContent = top.readTextFile(top.getSupportFile("acquireResult"));
          if (acquireResultContent != null && acquireResultContent != "") {
            var acquireResultDom = ezJsLib.XmlDom.parse(acquireResultContent);
            var updateId = ezJsLib.XmlDom.getValueByTag("UPDATEID", acquireResultDom);
            // if updateId equals to top.BUILD_FIX_ID, it indicates that it is the latest version, no need to update.
            // in this case, user can choose to update the latest system support list
            // if updateId does not equal to top.BUILD_FIX_ID, it indicates that there is newer version, need to update.
            if (updateId == top.BUILD_FIX_ID) {
              updateAction = "update";
              statusUpdateSystemList();
            } else {
              updateAction = "download";
              newVersionId = updateId;
              statusNeedDownload();
            }
          } else {
            statusCheckingLatestVersionFail();
          }
        } else {
          statusCheckingLatestVersionFail();
        }
      } else {
        statusCheckingLatestVersionFail();
      }
    }
  }

  function openWorkingDir()
  {
    setWorkingDir("obtainTargetDir", true);
  }

  function getDownloadSection() {
    return $.i18n.prop("ObtainLatestVersion.DownloadTo") + "<div><input type=\"text\" class=\"StandardTextBox\" style=\"width:40%;float:left;margin-right:5px\" id=\"obtainTargetDir\">" + "<button id=\"obtainBrowseBtn\" class=\"DialogButton\" onclick=\"Obtain_Latest_Version.openWorkingDir()\">" + $.i18n.prop('ObtainLatestVersion.BrowseBtn') + "</button></div>" + "<br><button class='DialogButton' onClick='Obtain_Latest_Version.startDownload()'>" + $.i18n.prop("ObtainLatestVersion.DownloadNow") + "</button>";
  }

  function statusNeedDownload() {
    clearMessage();
    DisplayInnerText("InfoText", $.i18n.prop("ObtainLatestVersion.NewVersionAvailable"));
    var buttonContent = getDownloadSection();
    document.getElementById("downloadbtn").innerHTML = buttonContent;
    top.togglePrevious(true);
    top.toggleNext(true);
  }

  function statusUpdateSystemList() {
    clearMessage();
    DisplayInnerText("InfoText", $.i18n.prop("ObtainLatestVersion.NoNewVersion"));
    var buttonContent = "<button class='DialogButton' onClick='Obtain_Latest_Version.startUpdateSystemListXML()'>" + $.i18n.prop("ObtainLatestVersion.UpdateNow") + "</button>";
    document.getElementById("downloadbtn").innerHTML = buttonContent;
    top.togglePrevious(true);
    top.toggleNext(true);
  }

  function statusCheckingLatestVersionFail() {
    clearMessage();
    DisplayInnerText("InfoText", $.i18n.prop("ObtainLatestVersion.ErrorCheck"));
    var buttonContent = "<button class='DialogButton' onClick='Obtain_Latest_Version.obtainLatestVersionInit()'>" + $.i18n.prop("ObtainLatestVersion.CheckVersion") + "</button>";
    document.getElementById("downloadbtn").innerHTML = buttonContent;
    top.togglePrevious(true);
    top.toggleNext(true);
  }

  function startUpdateSystemListXML() {
    printLog("INFO","button 'Update Now' was clicked.");
    top.togglePrevious(false);
    top.toggleNext(false);
    top.isOneCliRunning(startUpdateListCallback);
    printLog("DEBUG","function startUpdateSystemListXML end.");
  }

  function startUpdateListCallback(isRunning) {
    if(!isRunning) {
      var args = new Array();
      args.push(top.getSystemFile("oneCli"));
      args.push("update");
      args.push("acquire");
      args.push("--xml");
      args.push("--scope");
      args.push("individual");
      args.push("--metaonly");
      args.push("--dir");
      args.push(top.getSupportDir());
      args.push(...add_output_log5());

      args.push(...add_proxy_para());

      args.push("--includeid");
      args.push(top.BUILD_FIX_ID);
      args.push("--nosupersede");

      // delete the previous result file
      deleteFile(updateListResultFile);

      runProgram(args, null, updateListCallback);
      statusUpdatingList();
    }
  }

  function statusUpdatingList() {
    top.togglePrevious(false);
    top.toggleNext(false);
    clearMessage();
    $(".statusImg").html( "<img src=\"images/progress_anim2.gif\" style=\"float:left;\">");
    DisplayInnerText("InfoText", "Updating the system list...");
  }

  function statusUpdateFailed() {
    top.togglePrevious(true);
    top.toggleNext(true);
    clearMessage();
    DisplayInnerText("InfoText", $.i18n.prop("ObtainLatestVersion.ErrorObtain"));
    var buttonContent = "<button class='DialogButton' onClick='Obtain_Latest_Version.startUpdateSystemListXML()'>" + $.i18n.prop("ObtainLatestVersion.UpdateNow") + "</button>";
    document.getElementById("downloadbtn").innerHTML = buttonContent;
  }

  function updateListCallback(success) {
    if (!success) {
      statusUpdateFailed();
    } else {
      var resultFile = top.readTextFile(updateListResultFile);
      var resultDom = ezJsLib.XmlDom.parse(resultFile);
      var resultProperty = ezJsLib.XmlDom.getValueByTagFromNode("PROPERTY.ARRAY", resultDom.documentElement);
      var resultStr = resultProperty.toString();
      resultStr = resultStr.trim();
      var resultArray = resultStr.split("\n");
      for (var i = 0; i < resultArray.length; i++) {
        resultArray[i] = resultArray[i].trim();
        resultArray[i] = resultArray[i].replace("-[", ",");
        resultArray[i] = resultArray[i].replace("]-", "");
      }
      deleteFile(defaultSystemListPath);
      deleteFile(top.getSupportFile("configList"));
      writeSystemsListFile(resultArray);
      statusUpdateListSuccess();
    }
  }

  function statusUpdateListSuccess() {
    clearMessage();
    $(".statusImg").html("<img src=\"images/statusSuccess.png\" style=\"float:left;\">");
    // DisplayInnerText("InfoText", "Updating supported system list finished. ");
    DisplayInnerText("InfoText", $.i18n.prop("ObtainLatestVersion.UpdateFinish"));
    top.togglePrevious(true);
    top.toggleNext(true);
  }

  function writeSystemsListFile(resultArray) {
    var root = '<?xml version="1.0" ?>\n';
    root += "<root>\n";
    for (var i = 0; i < resultArray.length; i++) {
      var commaIndex = resultArray[i].indexOf(",");
      var xName = resultArray[i].substr(0, commaIndex);
      var machineType = resultArray[i].substr(commaIndex + 1);
      root += "<system><xname>" + xName + "</xname><machineType>" + machineType + "</machineType><selected>0</selected><noUXSP>0</noUXSP></system>\n"
    }
    root += "</root>\n";
    top.writeTextFile(defaultSystemListPath, root);
  }

  function validateDownloadLocation() {
    if (downloadLocation == null || downloadLocation == undefined || downloadLocation.trim() == "") {
      alert($.i18n.prop("ObtainLatestVersion.SpecifyLocation"));
      return false;
    }
    var ret = validatePath(downloadLocation);
    if(ret != "success") {
      if (ret == "Common.InvalidPath") {
        alert($.i18n.prop("ObtainLatestVersion.IsInvalidPath",downloadLocation));
      } else {
        alert($.i18n.prop(ret));
      }
      return false;
    }
    return true;
  }

  function startDownload() {
    var isLocValid = false;
    downloadLocation = $("#obtainTargetDir").val();
    isLocValid = validateDownloadLocation();
    if (!isLocValid) {
      return;
    }
    top.togglePrevious(false);
    top.toggleNext(false);
    isOneCliRunning(startDownloadCallback);
  }

  function startDownloadCallback(isRunning) {
    if(!isRunning) {
      var args = new Array();
      deleteFile(top.getSupportFile("acquireResult"));
      deleteFile(top.getSupportFile("commonResult"));
      args.push(top.getSystemFile("oneCli"));
      args.push("update");
      args.push("acquire");
      args.push("--xml");
      args.push("--scope");
      args.push("individual");
      args.push("--includeid");
      args.push(newVersionId);
      args.push("--dir");
      args.push(downloadLocation);
      args.push(...add_output_log5());
      //set proxy if there is
      args.push(...add_proxy_para());

      statusDownloading();
      runProgram(args, null, downloadCallback);
    }
  }

  function statusDownloading() {
    clearMessage();
    $(".statusImg").html("<img src=\"images/progress_anim2.gif\" style=\"float:left;\">");
    // DisplayInnerText("InfoText", "Downloading latest version...");
    DisplayInnerText("InfoText", $.i18n.prop("ObtainLatestVersion.DownloadLatest"));
    top.togglePrevious(false);
    top.toggleNext(false);
  }

  function downloadCallback(success) {
    if (!success) {
      statusDownloadFail();
    } else {
      var commonResultContent = top.readTextFile(top.getSupportFile("commonResult"));
      if (commonResultContent != null && commonResultContent != "") {
        var commonResultDom = ezJsLib.XmlDom.parse(commonResultContent);
        var errorNode = ezJsLib.XmlDom.getValueByTag("ERROR", commonResultDom);
        var msgNode = ezJsLib.XmlDom.getValueByTag("MESSAGE", commonResultDom);
        if (errorNode == "No" && (msgNode.indexOf("Succeed") != -1 || msgNode.indexOf("Success") != -1)) {
          statusDownloadSuccess();
        } else {
          statusDownloadFail();
        }
      } else {
        statusDownloadFail();
      }
    }
  }

  function changeTargetDir() {
    downloadLocation = $("#obtainTargetDir").val();
  }

  function statusDownloadFail() {
    clearMessage();
    DisplayInnerText("InfoText", $.i18n.prop("ObtainLatestVersion.DownloadFail"));
    var buttonContent = getDownloadSection();
    document.getElementById("downloadbtn").innerHTML = buttonContent;
    top.togglePrevious(true);
    top.toggleNext(true);
  }

  function statusDownloadSuccess() {
    clearMessage();
    $(".statusImg").html("<img src=\"images/statusSuccess.png\" style=\"float:left;\">");
    DisplayInnerText("InfoText", $.i18n.prop("ObtainLatestVersion.DownloadComplete"));
    DisplayInnerText("NewUXLiteInfoText", $.i18n.prop("ObtainLatestVersion.NewDownloadTo") + " " + downloadLocation);
    alert($.i18n.prop("ObtainLatestVersion.LegacyWarn"));
    top.togglePrevious(true);
    top.toggleNext(true);
  }

  return {
    name: "Obtain_Latest_Version",
    index: 0,
    init: obtainLatestVersionInit,
    obtainLatestVersionInit: obtainLatestVersionInit,
    startDownload: startDownload,
    startUpdateSystemListXML: startUpdateSystemListXML,
    changeTargetDir: changeTargetDir,
    openWorkingDir: openWorkingDir,
    // nextAction: checkUpdate_collect,
    nextAction: function() { printLog("INFO","Next was clicked."); return true; },
    importId: '#import_obtain_latest_version',
    selectorId: '.obtain_latest_version',
    title: "Navi.ObtainLatestVersion"
  }
}();
