// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
OOB_Setting = function(){
	var userCanceled = false;
	// var statusImg = "<img src=\"images/statusInformation.png\" border=\"0\" style=\"vertical-align:middle;\">";
	var certRemoteTempFile = '';
	var certRemoteSaveFile = '';
	var certRemoteTempContent;
	var certRemoteSaveContent;
	var certNewRemote = false;
	var scan_status = "";

	var tagCheckDefault = false;

	function checkDefault() {
		tagCheckDefault = document.getElementById("acceptCertDefault").checked;
		printLog("INFO","check box 'Accept remote server's key fingerprint by default.' " + (tagCheckDefault?"checked.":"unchecked."));
	}

	function oob_init(){
		printLog("INFO","Setting page init.");
		tagCheckDefault = document.getElementById("acceptCertDefault").checked;
		scan_status = "init";
		certNewRemote = false;
		certRemoteTempFile = top.pathJoin(top.getSupportDir(), "Remote_Cert.txt");

		/**
		 * About remote server
		 * OOB case:
		 * line 		  None  	SFTP	FTP		HTTPS	HTTP
		 * 1	CFC		   Y		 N		 Y		  Y		 N
		 * 2	Grantly	   N		 Y		 N		  N		 N
		 * 3	Amd		   Y		 N		 N		  N		 N
		 * 4	Others	   Y		 Y		 N		  Y		 Y
		 *  *************************************************
		 * inband case:
		 * 				  None  	SFTP	FTP		HTTPS	HTTP
		 * 5	CFC		   Y		 N		 Y		  Y		 N
		 * 6	Others	   Y		 N		 N		  N		 N
		 */
		$('#SepRemoteProtocolOpt option[value="SFTP"]').hide();
		$('#SepRemoteProtocolOpt option[value="HTTP"]').hide();
		$('#SepRemoteProtocolOpt option[value="FTP"]').hide();
		$('#SepRemoteProtocolOpt option[value="HTTPS"]').hide();
		if (top.isCFC()) {
			// line 1, 5
			$("#enableExternalRemoteDiv").show();
			$('#MustEnableExternalRemote').hide();
			$('#SepRemoteProtocolOpt option[value="FTP"]').show();
			$('#SepRemoteProtocolOpt option[value="HTTPS"]').show();
			if ($('#SepRemoteProtocolOpt').prop("value")=="SFTP" || $('#SepRemoteProtocolOpt').prop("value")=="HTTP") {
				$('#SepRemoteProtocolOpt option[value="HTTPS"]').prop("selected", true);
			}
			toggleEnableExternalRemote();
		} else if ((top.gl_OOB_Params.Enabled && top.isAmd()) || (top.gl_Inband_Params.Enabled && !top.isCFC())) {
			// line 3, 6
			$("#enableExternalRemoteDiv").hide();
			$('#MustEnableExternalRemote').hide();
			$("#SepRemoteProtocolOpt").hide();
			$("#OOBRemote").hide();
			top.gl_Remote_Params.Use_Sep_Remote = false;
		} else if (top.gl_OOB_Params.Enabled && top.isGrantly()) {
			// line 2
			$("#enableExternalRemoteDiv").hide();
			$('#MustEnableExternalRemote').show();
			$("#SepRemoteProtocolOpt").show();
			$("#OOBRemote").show();
			$('#SepRemoteProtocolOpt option[value="SFTP"]').show();
			$('#SepRemoteProtocolOpt option[value="SFTP"]').prop("selected", true);
			checkRemoteProtocolOpt();
			top.gl_Remote_Params.Use_Sep_Remote = true;
		} else {
			// line 4
			$("#enableExternalRemoteDiv").show();
			$('#MustEnableExternalRemote').hide();
			$('#SepRemoteProtocolOpt option[value="SFTP"]').show();
			$('#SepRemoteProtocolOpt option[value="HTTP"]').show();
			$('#SepRemoteProtocolOpt option[value="HTTPS"]').show();
			if ($('#SepRemoteProtocolOpt').prop("value")=="FTP") {
				$('#SepRemoteProtocolOpt option[value="SFTP"]').prop("selected", true);
			}
			toggleEnableExternalRemote();
		}

		top.gl_showNoAdapters = false;

    	initRemoteParams();
		if (top.gl_uxlite_bootable) {
			if (top.is_autorun() || top.is_unattend()) {
				setTimeout(() => {
					gl_wizard.steps("next");
				}, 1000);
			}
		}

		printLog("DEBUG","function oob_init end.");
	}

	function initRemoteParams(){
		top.gl_Remote_Params.Remote_Address = "";
		top.gl_Remote_Params.Remote_Port = "";
		top.gl_Remote_Params.Remote_UserName = "";
		top.gl_Remote_Params.Remote_Password = "";
		top.gl_Remote_Params.Remote_Location = "";
	}

	function writeRemoteParams(){
		top.gl_Remote_Params.Remote_Address = $("#remoteHostName").val();
		top.gl_Remote_Params.Remote_Port = $("#remotePort").val();
		top.gl_Remote_Params.Remote_UserName = $("#remoteUserName").val();
		top.gl_Remote_Params.Remote_Password = $("#remotePassword").val();
		top.gl_Remote_Params.Remote_Location = $("#remoteLocation").val();
	}

	function getRemoteCert() {
		if (userCanceled) {
			top.togglePrevious(true);
			top.toggleNext(true);
			return "waiting";
		}
		var args = new Array();
    	args.push(top.getSystemFile("oneCli"));
    	args.push("misc");
    	args.push("gettrust");
    	args.push("--host");
    	args.push(top.gl_Remote_Params.Remote_Address);
    	args.push("--port");
    	if (top.gl_Remote_Params.Remote_Port == "" || top.gl_Remote_Params.Remote_Port == undefined || top.gl_Remote_Params.Remote_Port == null) {
			if (top.gl_Remote_Params.Use_Sep_SFTP) {
				args.push("22");
			} else if (top.gl_Remote_Params.Use_Sep_HTTPS) {
				args.push("443");
			} else if (top.gl_Remote_Params.Use_Sep_FTP) {
				args.push("22");
			} else if (top.gl_Remote_Params.Use_Sep_HTTP) {
				args.push("80");
			}
    	} else {
    		args.push(top.gl_Remote_Params.Remote_Port);
    	}
    	args.push("--type");
    	if (top.gl_Remote_Params.Use_Sep_SFTP) {
			args.push("sftp");
		} else if (top.gl_Remote_Params.Use_Sep_HTTPS) {
			args.push("https");
		} else if (top.gl_Remote_Params.Use_Sep_FTP) {
			args.push("ftp");
		} else if (top.gl_Remote_Params.Use_Sep_HTTP) {
			args.push("http");
		}
    	args.push("--result");
    	certRemoteSaveFile = "Remote_" + top.gl_Remote_Params.Remote_Address + ".txt";
    	certRemoteSaveFile = top.pathJoin(top.getSupportDir(), certRemoteSaveFile);
    	top.deleteFile(certRemoteTempFile);
		args.push(certRemoteTempFile);
		args.push(...add_output_log5());
    	printLog("INFO","run commend:" + getRunProgramCommend(args));
    	runProgram(args, null, getRemoteCertCB);
    	return "waiting";
	}

	function getRemoteCertCB(success) {
		if (userCanceled) {
			top.togglePrevious(true);
			top.toggleNext(true);
			return "waiting";
		}
		if (!success || !top.fileExists(certRemoteTempFile)) {
			scan_status = "ssh_fail";
			goNextStep();
		} else {
			scan_status = "ssh_success";
			goNextStep();
		}
	}

	function checkRemoteInputOnly() {
		var remoteHostName = $("#remoteHostName").val();
		var remotePort = $("#remotePort").val();
		var remoteUser = $("#remoteUserName").val();
		var remotePass = $("#remotePassword").val();
		var remoteLocation = $("#remoteLocation").val();
		if (!remoteHostName || !remoteLocation) {
			showTipsInfo($.i18n.prop("OOBSetting.TipsInfo3"), "showRemoteTips");
			return false;
		}
		// username/password is unnecessary for https/ftp/http
		if (top.gl_Remote_Params.Use_Sep_SFTP) {	
			if (!remoteUser || !remotePass) {
				showTipsInfo($.i18n.prop("OOBSetting.TipsInfo3"), "showRemoteTips");
				return false;
			} 
		}
		if(!checkHostName(remoteHostName)){
			showTipsInfo($.i18n.prop("OOBSetting.TipsInfo6"), "showRemoteTips");
			return false;
		} 
		if(remotePort && (isNaN(remotePort) || remotePort<1 || remotePort>65535) ){
			showTipsInfo($.i18n.prop("OOBSetting.TipsInfo4"), "showRemoteTips");
			return false;
		}
		return true;
	}

	function isNeedGetCert() {
		if (!tagCheckDefault) {
			if (top.gl_Remote_Params.Use_Sep_Remote && (top.gl_Remote_Params.Use_Sep_HTTPS || top.gl_Remote_Params.Use_Sep_SFTP)) {
				return true;
			}
		}
		return false;
	}

	function startGetCert() {
		printLog("INFO","Next was clicked.");
		if(top.gl_Remote_Params.Use_Sep_Remote) {
			if (scan_status == "init") {
				showTipsInfo("");
				userCanceled = false;
				if (!checkRemoteInputOnly()) return false;
				writeRemoteParams();
				if (isNeedGetCert()) {
					top.showRemoteCertWaitMsg();
					return getRemoteCert();
				}
				scan_status = "done";
				return postProcess();
			} else if (scan_status == "ssh_fail") {
				top.hideRemoteCertWaitMsg();
				scan_status = "init";
				if (!userCanceled) {
					showTipsInfo($.i18n.prop("OOBSetting.GetTrust.Remote.Failed"), "showRemoteTips");
					return false;
				} else {
					top.togglePrevious(true);
					top.toggleNext(true);
					return "waiting";
				}
			} else if (scan_status == "ssh_success") {
				top.hideRemoteCertWaitMsg();
				try {
					certRemoteTempContent = top.readTextFile(certRemoteTempFile);
				} catch (e) {
					showTipsInfo($.i18n.prop("OOBSetting.GetTrust.Remote.Failed"), "showRemoteTips");
					return false;
				}
				try {
					certRemoteSaveContent = top.readTextFile(certRemoteSaveFile);
				} catch (e) {
					certRemoteSaveContent = null;
				}

				certNewRemote = false;

				if (certRemoteTempContent == '') certNewRemote = false;
				if (certRemoteTempContent != '' && certRemoteTempContent != certRemoteSaveContent) certNewRemote = true;

				if (!certNewRemote) {
					return postProcess();
				} else {
					document.getElementById("remoteCertDialog").style.height = "295px";
				}
				if (certNewRemote) {
					$("#remoteCertSection").show();
					$("#remoteCertArea").html(certRemoteTempContent);
				}
		
				if (!userCanceled) {
					showCertContentMsg();
					return "waiting";
				} else {
					scan_status = "init";
					return "waiting";
				}
			} else if (scan_status == "cert_no_accept") {
				top.togglePrevious(true);
				top.toggleNext(true);
				scan_status = "init";
				return "waiting";
			} else if (scan_status == "done") {
				if (certNewRemote) {
					if (top.fileExists(certRemoteSaveFile)) {
						top.deleteFile(certRemoteSaveFile);
					}
					top.writeTextFile(certRemoteSaveFile, certRemoteTempContent);
				}
				return postProcess();
			}
		}
		return postProcess();
	}

	function toggleEnableExternalRemote() {
		if ($("#enableExternalRemoteCheckbox").prop("checked")) {
			printLog("INFO","check box 'Use a seperate remote server checked.");
			$("#OOBRemote").show();
			$("#SepRemoteProtocolOpt").show();
			top.gl_Remote_Params.Use_Sep_Remote = true;
			checkRemoteProtocolOpt();
		} else {
			printLog("INFO","check box 'Use a seperate remote server unchecked.");
			$("#OOBRemote").hide();
			$("#SepRemoteProtocolOpt").hide();
			top.gl_Remote_Params.Use_Sep_Remote = false;
		}
		$("#showRemoteTips").hide();//fix coverity issue 63437
	}

	function toggleEnableBackup() {
		if ($("#enableBackupCheckbox").prop("checked")) {
			printLog("INFO","check box 'Only update the backup image of the BMC(and UEFI where applicable)' checked.");
			top.gl_optionBackup = true;
		} else {
			printLog("INFO","check box 'Only update the backup image of the BMC(and UEFI where applicable)' unchecked.");
			top.gl_optionBackup = false;
		}
	}

	// function showNoAdapters() {
	// 	if ($("#showNoAdaptersCheckbox").prop("checked")) {
	// 		printLog("INFO","check box 'Show updates with no adapters detected' checked.");
	// 		top.gl_showNoAdapters = true;
	// 	} else {
	// 		printLog("INFO","check box 'Show updates with no adapters detected' unchecked.");
	// 		top.gl_showNoAdapters = false;
	// 	}
	// }

	function showCertContentMsg() {
		$("#remoteCertConfirmDiv").show();
	}

	function hideCertContentMsg() {
		$("#remoteCertConfirmDiv").hide();
	}

	function acceptCert() {
		hideCertContentMsg();
		cleanCertContent();
		scan_status = "done";
		goNextStep();
	}

	function noAcceptCert() {
		hideCertContentMsg();
		cleanCertContent();
		scan_status = "cert_no_accept";
		goNextStep();
	}

	function cleanCertContent() {
		$("#remoteCertSection").hide();
		$("#remoteCertArea").html("");
	}

	function postProcess(){
		userCanceled = false;
		scan_status = "init";
		return true;
	}

	function checkHostName(hostName) {
		var expHostName = /((^\s*((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))\s*$)|(^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$))|(^\s*((?=.{1,255}$)(?=.*[A-Za-z].*)[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?)*)\s*$)/;
		var flag = expHostName.test(hostName);
		if (flag) return true;
		else return false;
	}

	function showTipsInfo(str, id){
		if (str == ""){
			$("#showRemoteTips").hide();
			return;
		}
		$("#"+id).show();
		$("#"+id+"Info").html(str);
	}

	function toggleEnableUpdateSelection() {
        if ($("#enableUpdate").prop("checked")) {
			printLog("INFO","check box 'Enable updating to a back-level firmware' checked.");
            top.gl_force = true;
        } else {
			printLog("INFO","check box 'Enable updating to a back-level firmware' unchecked.");
            top.gl_force = false;
        }
    }

    function userCancelGetCert(value) {
    	scan_status = "init";
    	userCanceled = true;
    } 

	function checkRemoteProtocolOpt() {
		if ($('#SepRemoteProtocolOpt').prop("value")=="SFTP") {
			// argumrnts
			top.gl_Remote_Params.Use_Sep_SFTP = true;
			top.gl_Remote_Params.Use_Sep_HTTPS = false;
			top.gl_Remote_Params.Use_Sep_FTP = false;
			top.gl_Remote_Params.Use_Sep_HTTP = false;
			// text
			$("#certDefaultSection").show();
			$("#acceptCertLabel").html($.i18n.prop("OOBSetting.ConfirmTrust.Option.SFTP"));
			$("#RemoteTitle").html($.i18n.prop("OOBSetting.SFTP.Title"));
			$("#RemoteSubtitle").html($.i18n.prop("OOBSetting.SFTP.SubTitle"));
			$("#RemotePortHint").html($.i18n.prop("OOBSetting.SFTP.Port.Hint"));
			$("#RemotePayloadHint").html($.i18n.prop("OOBSetting.SFTP.Payload.Hint"));
			$("#RemoteIpInputTitle").html($.i18n.prop("OOBSetting.SFTP.Host"));
			$("#NecessaryFlagUser").show();
			$("#NecessaryFlagPassword").show();
		} else if ($('#SepRemoteProtocolOpt').prop("value")=="HTTPS") {
			top.gl_Remote_Params.Use_Sep_SFTP = false;
			top.gl_Remote_Params.Use_Sep_HTTPS = true;
			top.gl_Remote_Params.Use_Sep_FTP = false;
			top.gl_Remote_Params.Use_Sep_HTTP = false;
			$("#certDefaultSection").show();
			$("#acceptCertLabel").html($.i18n.prop("OOBSetting.ConfirmTrust.Option.HTTPS"));
			$("#RemoteTitle").html($.i18n.prop("OOBSetting.HTTPS.Title"));
			$("#RemoteSubtitle").html($.i18n.prop("OOBSetting.HTTPS.SubTitle"));
			$("#RemotePortHint").html($.i18n.prop("OOBSetting.HTTPS.Port.Hint"));
			$("#RemotePayloadHint").html($.i18n.prop("OOBSetting.HTTPS.Payload.Hint"));
			$("#RemoteIpInputTitle").html($.i18n.prop("OOBSetting.SFTP.HostOnly"));
			$("#NecessaryFlagUser").hide();
			$("#NecessaryFlagPassword").hide();
		} else if ($('#SepRemoteProtocolOpt').prop("value")=="FTP") {
			top.gl_Remote_Params.Use_Sep_SFTP = false;
			top.gl_Remote_Params.Use_Sep_HTTPS = false;
			top.gl_Remote_Params.Use_Sep_FTP = true;
			top.gl_Remote_Params.Use_Sep_HTTP = false;
			$("#certDefaultSection").hide();
			$("#RemoteTitle").html($.i18n.prop("OOBSetting.FTP.Title"));
			$("#RemoteSubtitle").html($.i18n.prop("OOBSetting.FTP.SubTitle"));
			$("#RemotePortHint").html($.i18n.prop("OOBSetting.FTP.Port.Hint"));
			$("#RemotePayloadHint").html($.i18n.prop("OOBSetting.FTP.Payload.Hint"));
			$("#RemoteIpInputTitle").html($.i18n.prop("OOBSetting.SFTP.Host"));
			$("#NecessaryFlagUser").hide();
			$("#NecessaryFlagPassword").hide();
		} else if ($('#SepRemoteProtocolOpt').prop("value")=="HTTP") {
			top.gl_Remote_Params.Use_Sep_SFTP = false;
			top.gl_Remote_Params.Use_Sep_HTTPS = false;
			top.gl_Remote_Params.Use_Sep_FTP = false;
			top.gl_Remote_Params.Use_Sep_HTTP = true;
			$("#certDefaultSection").hide();
			$("#RemoteTitle").html($.i18n.prop("OOBSetting.HTTP.Title"));
			$("#RemoteSubtitle").html($.i18n.prop("OOBSetting.HTTP.SubTitle"));
			$("#RemotePortHint").html($.i18n.prop("OOBSetting.HTTP.Port.Hint"));
			$("#RemotePayloadHint").html($.i18n.prop("OOBSetting.HTTP.Payload.Hint"));
			$("#RemoteIpInputTitle").html($.i18n.prop("OOBSetting.SFTP.Host"));
			$("#NecessaryFlagUser").hide();
			$("#NecessaryFlagPassword").hide();
		}
	}
	
	return {
		index: 0,
		name: "OOB_Setting",
        init: oob_init, 
        nextAction: startGetCert,
        previousAction: function(){
			printLog("INFO","Previous was clicked.");
        	showTipsInfo("");
        	return true;
        },
        toggleEnableUpdateSelection: toggleEnableUpdateSelection,
		toggleEnableExternalRemote: toggleEnableExternalRemote,
		checkRemoteProtocolOpt: checkRemoteProtocolOpt,
		toggleEnableBackup: toggleEnableBackup,
        userCancelGetCert: userCancelGetCert,
        acceptCert: acceptCert,
        noAcceptCert: noAcceptCert,
        checkDefault: checkDefault,
        needReInit: true,
		importId: '#import_oob_setting',
        selectorId: '.oob_setting',
        title: "Navi.OOBSetting"
	}
}();
