
function createDirectory(dirpath) {
    return window.xpress.utils('createDirectory', dirpath);
}

function fileExists(dirpath) {
    return window.xpress.utils('fileExists', dirpath)
}

function directoryExists(directory) {
    return window.xpress.utils('directoryExists', directory)
}

function deleteFile(file) {
    return window.xpress.utils('deleteFile', file)
}

function del_dir(file) {
    return window.xpress.utils('del_dir', file)
}

function readTextFile(fileName, charset) {
    return window.xpress.utils('readTextFile', fileName, charset)
}

function writeTextFile(fileName, fileContent, append) {
    return window.xpress.utils('writeTextFile', fileName, fileContent, append)
}

function validatePath(path) {
    if (path == null || path == undefined || path.trim() == "")
        return "Common.InputDir";
    //support non-English,
    var regExp = null;
    var regExpNet = null;
    if (top.OSTYPE == "windows") //for windows
    {
        //regExp = /^[a-zA-Z]\:(\\[a-zA-Z0-9_ -.]+)*\\{0,1}$/gi;
        regExp = /^[a-zA-Z]\:(\\.+)*\\{0,1}$/gi;
        regExpNet = /^\\\\((2[0-4]\d|25[0-5]|[01]?\d\d?)\.){3}(2[0-4]\d|25[0-5]|[01]?\d\d?)(\\.+)*\\{0,1}$/gi;
    } else //for linux
    //regExp = /^\/|(\/[a-zA-Z0-9_ -.]+)+\/{0,1}$/gi;
        regExp = /^\/|(\/.+)+\/{0,1}$/gi;
    if (!path.match(regExp) && !path.match(regExpNet))
        return "Common.InvalidPath";
    else if (!directoryExists(path))
        return "Common.UnavailablePath";
    else
        return "success"
}

function printLog(level, msg) {
    function getCallerFileNameAndLine() {
        function getException() {
            try {
                throw Error('');
            } catch (err) {
                return err;
            }
        }
        const err = getException();
        const stack = err.stack;
        const stackArr = stack.split('\n');
        let callerLogIndex = 0;
        for (let i = 0; i < stackArr.length; i++) {
            if (stackArr[i].indexOf("at printLog") > 0 && i + 1 < stackArr.length) {
                callerLogIndex = i + 1;
                break;
            }
        }
        if (callerLogIndex !== 0) {
            const callerStackLine = stackArr[callerLogIndex];
            return `[${callerStackLine.substring(callerStackLine.lastIndexOf("/") + 1, callerStackLine.lastIndexOf(':'))}]`;
        } else {
            return '[-]';
        }
    }
    return window.xpress.utils('printLog', level, getCallerFileNameAndLine(), msg)
}

function passwordCode(password)
{
    var a = "";
    for(var i = 0; i < password.length; ++i)
    {
        a+="*";
    }
    return a;
}

function getRunProgramCommend(args)
{
    var argsCommend = "";
    var isPassword = false;
    var isUrl = false;
    for(var i = 0; i < args.length ; ++i)
    {
        argsCommend += " ";
        if(isPassword)
        {
            argsCommend += passwordCode(args[i]);
        }
        else if(isUrl && args[i].indexOf("@"))
        {
            var startPos = args[i].indexOf(":");
            var stopPos = args[i].lastIndexOf("@");
            var url = startPos>stopPos?args[i]:args[i].substring(0,startPos+1) + passwordCode(args[i].substring(startPos+1,stopPos)) + args[i].substring(stopPos);
            argsCommend += url;
        }
        else
        {
            argsCommend += args[i];
        }
        isPassword = ("--bmc-password" == args[i] || "--password" == args[i] || "--ts-password" == args[i] || "--newpwd" == args[i] || "--passphrase" == args[i]);
        isUrl = ("--imm" == args[i] || "--bmc" == args[i] || "--sftp" == args[i] || "--proxy" == args[i] || "--https" == args[i] || "--ftp" == args[i] || "--http" == args[i]);
    }
    return argsCommend;
}

function pathJoin(...args) {
    return window.xpress.utils('join', ...args)
}

function rename(oldPath, newPath) {
    return window.xpress.utils('rename', oldPath, newPath)
}

function dirname(filepath) {
    return window.xpress.utils('dirname', filepath)
}

function basename(filepath) {
    return window.xpress.utils('basename', filepath)
}

function loadFile(filepath) {
    return window.xpress.utils('loadFile', filepath)
}

function loadSetting(settingName) {
    return window.xpress.utils('loadSetting', settingName)
}