#!/bin/bash
# Copyright © 2018 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
export UXLITE_BOOTABLE=/toolscenter
export UXSPI_BOOTABLE=/toolscenter
export UXSPI_REDUCE_COPY=1

ROOT_PATH="/toolscenter"
#ROOT_PATH="/mnt/hgfs/myshare/20081014/lib/linuxboot"
CONFIG_FILE=${ROOT_PATH}/bomc100.config
MTLIST_FILE_LINUX64=${ROOT_PATH}/menu/systemslistx86.xml
MTLIST_FILE_LINUXPPC64=${ROOT_PATH}/menu/systemslistppc.xml
MTLIST_FILE=""
BOOT_ENV=""
UXSPI_FOLDER=${ROOT_PATH}/uxspi
DSA_FOLDER=${ROOT_PATH}/dsa
UXSPI_BIN=${ROOT_PATH}/uxspi/uxspi300.sles10_ppc64
DSA_BIN=${ROOT_PATH}/dsa/ibm_utl_dsa_220cp_anyos_ppc64.sh

FUN_NUM=0
FUNCTIONS=""
#FUN_NUM=4
VERSION="1.0"
LABELSTR=""

MACHINEARRAY=""
MACHINELISTHEADER="This bootable media is created for the following machines:"
MACHINELISTSTR=""

WELCOME="Welcome to Lenovo XClarity Essentials "${VERSION}
DESCRIPTION="Lenovo XClarity Essentials is collection server management stand alone tools to help Deploy, Configure, Update and Diagnose your machines. This wizard will help you manage your system more efficiently." 

FUNCTIONSTR=""
FUNCTIONMAPPING=""

AUTORUNSTR=""
AUTORUNID=""

DES_DEPLOYMENT="Deployment tools help you become productive faster by minimizing the time it takes to get your systems up and running.\n"

DES_CONFIGURATION="Configuration tools allow remote scripted configuration of System x Servers and Bladecenters.\n"

DES_UPDATES="Keep your systems up-to-date and running optimally with tools that make it easy to appy the latest system software updates.\n"

DES_DIAGNOSTICS="Intelligent tools that enable rapid, remote diagnosis and resolution help minimize the costs associated with system downtime.\n"

SELECT_INFO="Do you want to start it now? Y(yes)/N(no)/Q(quit)"

USAGE_HANDLE_RESULT="Usage: handle_result result current_item"
USAGE_CALL_FUN="Usage: call_fun current_item"
USAGE_PARSE_SELECT="Usage: parse_select current_item"


function print_welcome()
{
	echo -e ${WELCOME}"\n"
	echo -e ${DESCRIPTION}"\n"
}
function initial_label()
{
	if [ -f ${CONFIG_FILE} ]
	then
		#`dos2unix ${CONFIG_FILE}` 
		LABELSTR=`cat ${CONFIG_FILE} | grep IBM_SYSTEM_MEDIALABEL | sed 's/IBM_SYSTEM_MEDIALABEL=//'`
		LABELSTR="Discriptive name:\n   "${LABELSTR}"\n"	
	fi
}
function print_label()
{
	echo -e ${LABELSTR}	
}
#function print_machinelist()
#{
#	echo -e ${MACHINELISTSTR}
#}

function print_machinelist()
{
	if [ -f ${CONFIG_FILE} ]
	then
	  BOOT_ENV=`cat ${CONFIG_FILE} | grep IBM_SYSTEM_BOOT_ENV | sed 's/IBM_SYSTEM_BOOT_ENV=//'`
	  case ${BOOT_ENV} in
	  linux)
	       MTLIST_FILE=${MTLIST_FILE_LINUX64};;
	  linuxppc)
	       MTLIST_FILE=${MTLIST_FILE_LINUXPPC64};;
	  esac
		MACHINEARRAY=`cat ${CONFIG_FILE} | grep IBM_SYSTEM_MACHINETYPE | sed 's/IBM_SYSTEM_MACHINETYPE=//' | sed 's/,/ /g'`
		parse_machinelist
	fi
}
function parse_machinelist()
{
	echo -e ${MACHINELISTHEADER}
	if echo ${MACHINEARRAY} | grep -E '(all|ALL)'> /dev/null 2>&1 
	then
	 echo "   All Power and Cell/B.E. processor-based systems supported."
	else
	 for list in ${MACHINEARRAY}
	 do
	 	 if cat ${MTLIST_FILE} | grep $list > /dev/null 2>&1 
		  then
			 cat ${MTLIST_FILE} | grep $list | sed 's/<system><xname>/   /' | sed 's/\(.*\)<\/xname>.*/\1/' | sed "s/$/ - machine type $list/"|awk '{print $0}'
		  else
			 echo "   Unkown family - machine type $list"
		  fi
	 done
	fi
}

function initial_function()
{
	if [ -f ${CONFIG_FILE} ]
	then
	   FUNCTIONS=`cat ${CONFIG_FILE} | grep IBM_SYSTEM_FUNCTION | sed 's/IBM_SYSTEM_FUNCTION=//'`
	fi
	FUNCTIONSTR="\nLenovo XClarity Essentials have following function:\n"
	FUNCTIONEND="\nEnter the item number to "
	#adding deployment
	#adding configuration
	#adding updates
	#if [ -d ${UXSPI_FOLDER} ] 
	if echo ${FUNCTIONS} | grep uxspi> /dev/null 2>&1 
	then
		FUN_NUM=`expr $FUN_NUM + 1`
		FUNCTIONSTR=${FUNCTIONSTR}"   <"${FUN_NUM}"> Updates\n"
		FUNCTIONEND=${FUNCTIONEND}"Updates|"
		FUNCTIONMAPPING=${FUNCTIONMAPPING}" "${FUN_NUM}"->3"	
	fi
	#adding diagnostics
	#if [ -d ${DSA_FOLDER} ]
	if echo ${FUNCTIONS} | grep dsa> /dev/null 2>&1 
	then
		FUN_NUM=`expr $FUN_NUM + 1`
		FUNCTIONSTR=${FUNCTIONSTR}"   <"${FUN_NUM}"> Diagnostics\n"
		FUNCTIONEND=${FUNCTIONEND}"Diagnostics"
		FUNCTIONMAPPING=${FUNCTIONMAPPING}" "${FUN_NUM}"->4"	
	fi
	
	FUNCTIONEND=${FUNCTIONEND}" ('q' to quit):\n"
	FUNCTIONSTR=${FUNCTIONSTR}${FUNCTIONEND}

	 
}
function print_function()
{
	echo -e ${FUNCTIONSTR}
}

initial_autorun()
{
	
	if [ -f ${CONFIG_FILE} ]
	then
		AUTORUNSTR=`cat ${CONFIG_FILE} | grep IBM_SYSTEM_AUTORUN | sed 's/IBM_SYSTEM_AUTORUN=//'`
		#echo ${AUTORUNSTR}
	fi
	case ${AUTORUNSTR} in
	uxspi)
		AUTORUNID=3;
		AUTORUNSTR="Updates";;
	dsa)
		AUTORUNID=4;
		AUTORUNSTR="Diagnostics";;
		
	esac
	#echo ${AUTORUNID}	
}

function print_menu()
{
	clear
	print_welcome
	print_label
	print_machinelist
	print_function
}

function print_detail()
{
	if [ $# -ne 1 ]
	then
		echo ${USAGE_PRINT_DETAIL}
		return 
	fi

	case "$1" in
	1)
		echo -e ${DES_DEPLOYMENT};;
	2)
		echo -e ${DES_CONFIGURATION};;
	3)
		echo -e ${DES_UPDATES};;
	4)
		echo -e ${DES_DIAGNOSTICS};;
	*)
		echo "Unknow input"
		return 1;;
	esac

	echo -e ${SELECT_INFO}
}

function parse_select()
{
	if [ $# -ne 1 ]
	then
		echo  ${USAGE_PARSE_SELECT}
	fi

	while true
	do
		read SELECT
	
		case "${SELECT}" in
		Y)
			return 0;;
		y)
			return 0;;
		N)
			return 1;;
		n)
			return 1;;
		Q)
			return 2;;
		q)
			return 2;;
		*)
			clear
			print_detail $1;;
			#echo -e "\b";;
		esac
	done
}

function call_fun()
{
	if [ $# -ne 1 ]
	then
		echo ${USAGE_CALL_FUN}
		return 
	fi

	clear
	case "$1" in
	1)
		;;
	2)
		;;	
	3)
		${UXSPI_BIN} update --tui --firmware -l ${ROOT_PATH};;
	4)
		${DSA_BIN} --cmd;;
	*)
		echo unknown command...;;	
	esac
}

function handle_result()
{
	if [ $# -ne 2 ]
	then
		echo ${USAGE_HANDLE_RESULT}
		return 
	fi

	if [ $1 -eq 0 ] 
	then
		call_fun $2
		print_menu
	else
		print_menu
	fi
}

function parse_input()
{
	#stty -echo
	read INPUT
	#stty echo

	if [ "${INPUT}" = "q" ] || [ "${INPUT}" = "Q" ]
	then
		echo "Goodbye!"
		exit 0
	elif [ ${INPUT} -le ${FUN_NUM} ] && [ ${INPUT} -gt 0 ]
	then
		clear
		for map in ${FUNCTIONMAPPING}
		do
			if echo ${map} | grep "${INPUT}->" > /dev/null 2>&1
			then
				INPUT=`echo $map|grep "${INPUT}->"|sed "s/${INPUT}->//"`
			fi	
		done
		print_detail ${INPUT}
		parse_select ${INPUT}
		handle_result $? ${INPUT}
	else 
		print_menu
	fi
}
	
function do_work()
{
	while true
	do
		parse_input
	done
}

#initial the label, machine type and function from the config and support list file
initial_label
#initial_machinelist
initial_function
initial_autorun

#auto run
if [ ${AUTORUNID} -gt 0 ]
then
	echo "Starting IBM ${AUTORUNSTR}...."
	sleep 5
 	clear
	call_fun ${AUTORUNID}
fi

#print the label,machine type list and function
print_menu

#do the job
do_work

