#!/bin/sh  
# Copyright © 2018 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
#
# This script prepares menu(both GUI and TUI) for unattended mode ToolsCenter 

# disable Crtl+z and Ctrl+c
trap "" 2 20

# path and directory
ROOT_PATH=/toolscenter
TMP_PATH=/tmp
CONFIG_FILE=${TMP_PATH}/bomc.config
LOG_PATH=/var/log/Lenovo_Support
NEW_LOG_PATH=$TMP_PATH/lxce_ux/Lenovo_Support
LOG_PKG_FILE=""
ERROR_FILE=/tmp/error.log
LOG_FILE=/tmp/bomc.log
MOUNT_DIR=""
Command_File=/tmp/server.ftp		
	
# commands
UXSPI_TUI_CMD_UNATTD_WORKING_DIR=${UXSPI_TUI_CMD_WORKING_DIR}
UXSPI_TUI_CMD_UNATTD=${UXSPI_TUI_CMD}  
TFTP_CMD="busybox tftp"
#FTP_CMD="pftp"
FTP_CMD="ftp -i -n"
MOUNT_NFS_CMD="mount -t nfs -o nolock "
MOUNT_SMB_CMD="mount -t cifs"
MOUNT_USB_CMD="mount"
UMOUNT="umount"


# variables definition
# the unattended mode type
#	0	-	invalid
#	1 	-	tftp
#	2 	-	ftp
#	3	-	nfs
#	4	-	smb
#	5	-	usb
# 6 - sftp
UNATTD_MODE_TYPE=0
UNATTENDED_SERURITY_METHOD=0

UNATTD_FULLSTR=""
UNATTD_PAUSE_ON_ERROR=20
SERVER_STR=""
DIR_STR=""
SN_STR=""
MT_STR=""
STAMP_STR=""

# usage string for functions
USAGE_UNATTD_MENU="Usage: unattended_menu.sh cli|gui"
USAGE_UPLOAD_USB="Usage: upload_2_usb dir"
USAGE_UPLOAD_OTHER="Usage: upload_2_xxx server dir"


function wait_4_uxspi()
{
  while  ps -a | grep uxspi > /dev/null 2>&1 
  do
	   # uxspi tool is still running
	   sleep 5
  done
}

function show_error()
{
	echo -e "\nFailed to upload log package to the location specified."

	echo -e "\nFailed to upload log package to the location specified" >> ${LOG_FILE}
	# get the value of pause on error from config file
	UNATTD_PAUSE_ON_ERROR=`cat ${CONFIG_FILE} | grep IBM_SYSTEM_PAUSE_ON_ERROR | sed 's/IBM_SYSTEM_PAUSE_ON_ERROR=//'`
	
	while [ ${UNATTD_PAUSE_ON_ERROR} -gt 0 ]
	do
		UNATTD_PAUSE_ON_ERROR=`expr $UNATTD_PAUSE_ON_ERROR - 1`
		clear
		INPUT=""
		echo -e "Warning! Error occurred when uploading the log package\n"
		echo -e "Error Details:\n"
		cat ${ERROR_FILE}
		echo -e "\n\n"
		echo "System will pause for ${UNATTD_PAUSE_ON_ERROR} seconds, and then move on to the shutdown process"
		read -t 1 INPUT
		if [ "${INPUT}" = "r2d2" ]
		then
		  sh
		fi
	done
}

function upload_2_usb()
{
 	echo -e "\nUploading log package to USB drive..." >> ${LOG_FILE}
	if [ $# -gt 1 ]
	then
		echo ${USAGE_UPLOAD_USB}
		return 
	fi
	
	if [ $# -eq 0 ]
	then
		tmp=""
	else
	  #remove the '/' if the directory is end with the '/'
	  tmp=`echo $1 | sed 's/\/$//'`
	fi
	echo "Upload log package to directory:"$1 >> ${LOG_FILE}

	cp -r ${TMP_PATH}/${LOG_PKG_FILE} ${ROOT_PATH}/${tmp}
}

function upload_2_tftp()
{
	echo -e "\nUploading log package to TFTP server..." >> ${LOG_FILE}

	if [ $# -ne 2 ]
	then
		echo ${USAGE_UPLOAD_OTHER}
		return
	fi
	#remove the '/' if the directory is end with the '/'
	tmp=`echo $2 | sed 's/\/$//'`
	echo "Upload log package to sever:"$1", directory:"$2 >> ${LOG_FILE}
	
	#uploading the package
	echo ${TFTP_CMD} -p -r ${tmp}/${LOG_PKG_FILE} -l ${TMP_PATH}/${LOG_PKG_FILE} $1 >> ${LOG_FILE}

	if ${TFTP_CMD} -p -r ${tmp}/${LOG_PKG_FILE} -l ${TMP_PATH}/${LOG_PKG_FILE} $1 >> ${LOG_FILE} 2>${ERROR_FILE}
	then
		echo "Uploaded log package to TFTP server successfully" >> ${LOG_FILE}	
	else
		echo "Failed to upload package to TFTP server" >> ${LOG_FILE}
		show_error
		return
	fi
	
}

function upload_2_ftp()
{
echo -e "\nUploading log package to FTP server..." >> ${LOG_FILE}

if [ $# -ne 2 ]
then
	echo ${USAGE_UPLOAD_OTHER}
	return
fi
#remove the '/' if the directory is end with the '/'
tmp=`echo $2 | sed 's/\/$//'`
echo "Upload log package to sever:"$1", directory:"$2 >> ${LOG_FILE}

echo "Upload log package to sever:"$1", directory:"$2

FTP_port=""
FTP_Server_IN=$1

echo $FTP_Server_IN

#add [] to ipv6 address if it doesn't include it
	squareBracket=`echo $FTP_Server_IN | grep '\['`
	if [ "$squareBracket" = "" ]
	then   
		isIpv6=`echo $FTP_Server_IN | grep '\:[A-Za-z0-9]\{0,3\}\:'`
		if [ "$isIpv6" != "" ]
		then
			#server=[$1]:21
			#server=[$1]
			server=$FTP_Server_IN
			FTP_port=21
		else
			hasPort=`echo $FTP_Server_IN | grep '\:'`
			if [ "$hasPort" != "" ]
			then
				#server=$1
				server=`echo ${FTP_Server_IN%:*}`
				FTP_port=`echo ${FTP_Server_IN##*:}`				
			else
				#server=$1:21
				server=$FTP_Server_IN
				FTP_port=21
			fi
		fi
	else
		hasPort=`echo $FTP_Server_IN | grep '\]\:'`
		if [ "$hasPort" != "" ]
		then
			#server=$1
			server=`echo ${FTP_Server_IN%:*}`
			FTP_port=`echo ${FTP_Server_IN##*:}`			
		else
			#server=$1:21
			server=$FTP_Server_IN
			FTP_port=21
		fi
			fi

#Command_File="$server.ftp"				
				
	#echo ${FTP_CMD} -u ftp://anonymous:anonymous@$server${tmp}/${LOG_PKG_FILE}   ${TMP_PATH}/${LOG_PKG_FILE} >>${LOG_FILE}
	#${FTP_CMD} -u ftp://anonymous:anonymous@$server${tmp}/${LOG_PKG_FILE}   ${TMP_PATH}/${LOG_PKG_FILE} >>${ERROR_FILE} 2>${ERROR_FILE}

cat > $Command_File <<EOF
		open $server $FTP_port
		user anonymous anonymous
		binary
		send ${TMP_PATH}/${LOG_PKG_FILE} ${tmp}/${LOG_PKG_FILE}
		bye
EOF
	
#${FTP_CMD}<${Command_File}

#echo open $server   >>${Command_File}
#echo user anonymous anonymous   >>${Command_File}
#echo send ${TMP_PATH}/${LOG_PKG_FILE} ${tmp}/${LOG_PKG_FILE}  >>${Command_File}
#echo bye   >>${Command_File}

echo ${FTP_CMD}<${Command_File} >>${LOG_FILE}
${FTP_CMD}<${Command_File}  >>${ERROR_FILE} 2>${ERROR_FILE}
if [ -s ${ERROR_FILE}  ]
then
	echo "Failed to upload package to FTP server" >> ${ERROR_FILE}
	show_error
	return
	echo "Upload log package to FTP server successfully" >> ${LOG_FILE}
else
	echo "Upload log package to FTP server successfully" >> ${LOG_FILE}
fi
		
}
function upload_2_nfs()
{
	echo -e "\nUploading log package to NFS server..." >> ${LOG_FILE}
	if [ $# -ne 2 ]
	then
		echo ${USAGE_UPLOAD_OTHER}
		return
	fi
	
	#remove the '/' if the directory is end with the '/'
	tmp=`echo $2 | sed 's/\/$//'`
	echo "Upload log package to sever:"$1", directory:"$2 >> ${LOG_FILE}
 
	MOUNT_DIR=${TMP_PATH}/nfs
	mkdir -p ${MOUNT_DIR}

	# mounting the NFS share
	echo ${MOUNT_NFS_CMD} $1:$2 ${MOUNT_DIR} >> ${LOG_FILE}
	if ${MOUNT_NFS_CMD} $1:$2 ${MOUNT_DIR} >> ${LOG_FILE} 2>${ERROR_FILE}
	then
		echo "Mount NFS share successfully" >> ${LOG_FILE}
	
	else
		echo "Failed to mount NFS share" >> ${ERRO_FILE}
		show_error
		return
	fi	
	
	# copy the log package
	echo cp ${TMP_PATH}/${LOG_PKG_FILE} ${MOUNT_DIR} >> ${LOG_FILE}
	if cp -r ${TMP_PATH}/${LOG_PKG_FILE} ${MOUNT_DIR} >> ${LOG_FILE} 2>${ERROR_FILE}
	then
		echo "Upload the log package to NFS server successfully" >> ${LOG_FILE}
	else
		echo "Failed to upload the log package to NFS server" >> ${EROOR_FILE}
		show_error
		return
	fi
	umount ${MOUNT_DIR}

}
function upload_2_smb()
{
	echo -e "\nUploading log package to Samba server"

	if [ $# -ne 2 ]
	then
		echo ${USAGE_UPLOAD_OTHER}
		return

	fi
	
	#remove the '/' if the directory is end with the '/'
	tmp=`echo $2 | sed 's/\/$//'`
	echo "Upload log package to sever:"$1", directory:"$2 >> ${LOG_FILE}
	
	MOUNT_DIR=${TMP_PATH}/smb
	mkdir -p ${MOUNT_DIR}

	# mounting the samba share
	echo ${MOUNT_SMB_CMD} //$1$2 ${MOUNT_DIR} -o user=anonymous,password=anonymous,vers=1.0,vers=2.0,vers=2.1,vers=3.0 >> ${LOG_FILE}
	
	if ${MOUNT_SMB_CMD} //$1$2 ${MOUNT_DIR} -o user=anonymous,password=anonymous,vers=1.0 >> ${LOG_FILE} 2>${ERROR_FILE} || 
	${MOUNT_SMB_CMD} //$1$2 ${MOUNT_DIR} -o user=anonymous,password=anonymous,vers=2.0 >> ${LOG_FILE} 2>${ERROR_FILE} || 
	${MOUNT_SMB_CMD} //$1$2 ${MOUNT_DIR} -o user=anonymous,password=anonymous,vers=2.1 >> ${LOG_FILE} 2>${ERROR_FILE} ||
	${MOUNT_SMB_CMD} //$1$2 ${MOUNT_DIR} -o user=anonymous,password=anonymous,vers=3.0 >> ${LOG_FILE} 2>${ERROR_FILE}
	then
		echo "Mount SMB share successfully" >> ${LOG_FILE}
	else
		echo "Failed to mount the SMB share" >> ${ERROR_FILE}
		show_error
		return
	fi

	# upload the log package
	echo cp ${TMP_PATH}/${LOG_PKG_FILE} ${MOUNT_DIR} >> ${LOG_FILE}
	if cp -r ${TMP_PATH}/${LOG_PKG_FILE} ${MOUNT_DIR} >> ${LOG_FILE} 2>${ERROR_FILE}
	then
		echo "Upload log package to SMB share successfully" >> ${LOG_FILE}
	else
		echo "Failed to upload log package to SMB share" >> ${ERROR_FILE}
		show_error
		return
	fi	
	umount ${MOUNT_DIR}	

}
function update_unattd_mode()
{
	
	
  if cat ${CONFIG_FILE} | grep IBM_SYSTEM_PASSWORD_ENCRYPT=YES 1>/dev/null 2>&1
  then
    UNATTENDED_SERURITY_METHOD=1
		echo -e "Use onecli to upload log..." >> ${LOG_FILE}
  else
		UNATTD_FULLSTR=`cat ${CONFIG_FILE} | grep "^IBM_SYSTEM_UNATTENDED=" | sed 's/IBM_SYSTEM_UNATTENDED=//'`
		if echo ${UNATTD_FULLSTR} | grep "tftp://" > /dev/null 2>&1
		then
			UNATTD_MODE_TYPE=1
			SVR_DIR_STR=`echo ${UNATTD_FULLSTR} | sed 's/tftp:\/\///'`
			SERVER_STR=`echo ${SVR_DIR_STR} | sed 's/\([^/]*\)\(\/.*\)/\1/' `
			DIR_STR=`echo ${SVR_DIR_STR} | sed 's/\([^/]*\)\(\/.*\)/\2/' `
		elif echo ${UNATTD_FULLSTR} | grep "ftp://" > /dev/null 2>&1
		then
			UNATTD_MODE_TYPE=2
			SVR_DIR_STR=`echo ${UNATTD_FULLSTR} | sed 's/ftp:\/\///'`
			SERVER_STR=`echo ${SVR_DIR_STR} | sed 's/\([^/]*\)\(\/.*\)/\1/' `
			DIR_STR=`echo ${SVR_DIR_STR} | sed 's/\([^/]*\)\(\/.*\)/\2/' `
		elif echo ${UNATTD_FULLSTR} | grep "nfs://" > /dev/null 2>&1
		then
			UNATTD_MODE_TYPE=3
			SVR_DIR_STR=`echo ${UNATTD_FULLSTR} | sed 's/nfs:\/\///'`
			SERVER_STR=`echo ${SVR_DIR_STR} | sed 's/\([^/]*\)\(\/.*\)/\1/' `
			DIR_STR=`echo ${SVR_DIR_STR} | sed 's/\([^/]*\)\(\/.*\)/\2/' `
		elif echo ${UNATTD_FULLSTR} | grep "smb://" > /dev/null 2>&1
		then
			UNATTD_MODE_TYPE=4
			SVR_DIR_STR=`echo ${UNATTD_FULLSTR} | sed 's/smb:\/\///'`
			SERVER_STR=`echo ${SVR_DIR_STR} | sed 's/\([^/]*\)\(\/.*\)/\1/' `
			DIR_STR=`echo ${SVR_DIR_STR} | sed 's/\([^/]*\)\(\/.*\)/\2/' `
		elif echo ${UNATTD_FULLSTR} | grep "usb:/" > /dev/null 2>&1
		then
			UNATTD_MODE_TYPE=5
			DIR_STR=`echo ${UNATTD_FULLSTR} | sed 's/usb:\///'`
		else
			UNATTD_MODE_TYPE=0
		fi
	fi
	echo -e "\nConfiguration for unattended mode:"${UNATTD_FULLSTR} >> ${LOG_FILE}
}

function getMt()
{
	echo "Get machine type from the outputs of \"dmidecode\" command."
	local MT_STR_LENGTH=4
	echo "Parse \"Product Name\" field."
	local product_name=`dmidecode | grep -w -A 10 "DMI type 1" | grep "Product Name"`
	MT_STR=`echo ${product_name} | sed -e 's/.*\[\([0-9a-zA-Z]\{4\}\).*\].*/\1/'`
	if [ ${#MT_STR} -eq ${MT_STR_LENGTH} ]
	then
		return 0
	fi

	echo "Cannot get machine type from \"Product Name\" field."
	echo "Try to parse \"SKU Number\" field."
	local sku_number=`dmidecode | grep -w -A 10 "DMI type 1" | grep "SKU Number"`
	MT_STR=`echo ${sku_number} | sed -e 's/SKU Number: \([0-9a-zA-Z]\{4\}\).*/\1/'`
	if [ ${#MT_STR} -eq ${MT_STR_LENGTH} ]
	then
		return 0
	fi

	echo "Failed to get machine type."
	MT_STR="UNKNOWN"
	return 1
}

function package_log_pkg()
{
  
	echo -e "\nPackaging the log package..." >> ${LOG_FILE}
 # VALID_STR=`echo ${LOG_PKG_DIR} | sed 's/UXSPI_//'| sed 's/\([^_]*_\)\(.*\)/\2/'`
 # MT_STR=`echo ${VALID_STR} |sed 's/\([^_]*\)\(_.*\)/\1/'`
 # VALID_STR=`echo ${VALID_STR} |sed 's/\([^_]*\)\(.*\)/\2/'`
 # SN_STR=`echo ${VALID_STR} |sed 's/\(_[^_]*\)\(.*\)/\1/'` 
 # VALID_STR=`echo ${VALID_STR} |sed 's/\(_[^_]*\)\(.*\)/\2/'` 
 # STAMP_STR=`echo ${VALID_STR} |sed 's/\(_[^_]*\)\(.*\)/\1/'` 
   getMt
   #MT_STR=`dmidecode -s system-product-name|tail -n 1 |sed 's/[^\[]*\[\(....\)[^\]*/\1/g'`
   SN_STR=`dmidecode -s system-serial-number | tail -1`
   STAMP_STR=`date +%Y%m%d%H%M%S` #`echo ${LOG_PKG_DIR} | sed 's/OneCli-//'| sed 's/\([^-]*-\)\(.*\)/\2/'`

	if cat ${CONFIG_FILE} | grep IBM_SYSTEM_NO_TIMESTAMP=YES >/dev/null 2>&1
	then
		#LOG_PKG_DIR="UXSPI_"${MT_STR}${SN_STR}
		LOG_PKG_DIR="UpdateGUI_"${MT_STR}"_"${SN_STR}
	else
		#LOG_PKG_DIR="UXSPI_"${MT_STR}${SN_STR}${STAMP_STR}
		LOG_PKG_DIR="UpdateGUI_"${MT_STR}"_"${SN_STR}"_"${STAMP_STR}
	fi
	mkdir -p ${TMP_PATH}/${LOG_PKG_DIR}
	
	cp -r ${LOG_PATH}/* ${TMP_PATH}/${LOG_PKG_DIR}/ 2>> ${LOG_FILE}
	cp -r ${NEW_LOG_PATH}/* ${TMP_PATH}/${LOG_PKG_DIR}/ 2>> ${LOG_FILE}
	

	cd ${TMP_PATH}/ 2>> ${LOG_FILE}
	
	LOG_PKG_FILE=${LOG_PKG_DIR}.tar.gz	
	if tar -zcvf ${LOG_PKG_FILE} ${LOG_PKG_DIR} >> ${LOG_FILE} 2>${ERROR_FILE}
	then
		echo "Tar the log package successfully:"${LOG_PKG_FILE} >> ${LOG_FILE}
	else
		echo "Failed to tar the log package" >> ${ERROR_FILE}
		show_error
		return
	fi
	cd ${ROOT_PATH}	
}

function upload_log_pkg()
{

	# upload the package
	case "$1" in
	0)
		;;
	1)
		upload_2_tftp ${SERVER_STR} ${DIR_STR};;
	2)
		upload_2_ftp ${SERVER_STR} ${DIR_STR};;
	3)	
		upload_2_nfs ${SERVER_STR} ${DIR_STR};;
	4)	
		upload_2_smb ${SERVER_STR} ${DIR_STR};;
	5)
		upload_2_usb ${DIR_STR};;
	*)
		;;
	esac
}

# main flow

echo "Enter unattended_menu.sh" >> ${LOG_FILE}
if [ $# -ne 1 ]
then
	echo ${USAGE_UNATTD_MENU}
	exit
fi

if [ "$1" = "cli" ]
then
	cd ${UXSPI_TUI_CMD_UNATTD_WORKING_DIR}
	${UXSPI_TUI_CMD_UNATTD}
elif [ "$1" = "gui" ]
then
	# echo ${UXSPI_BINARY_PATH} > ~/.xinitrc
	echo 'fluxbox & /tmp/lxce_ux/start_lxce_ux.sh' > ~/.xinitrc
  	startx
else
	echo ${USAGE_UNATTD_MENU}
	exit
fi


# check if the uxspi tool exit
wait_4_uxspi

# update the unattended mode info based on the IBM_SYSTEM_UNATTENDED string
update_unattd_mode

# tar the log package into a gz package
package_log_pkg


if [ $UNATTENDED_SERURITY_METHOD == 1 ];then
	echo "Upload logs by security method..." >> ${LOG_FILE} 
	echo "Upload logs by security method..."
	ONECLI_BIN="${TMP_PATH}/lxce_ux/command/onecli/OneCli"
	UNATTD_FULLSTR=`cat ${CONFIG_FILE} | grep "^IBM_SYSTEM_UNATTENDED=" | sed 's/IBM_SYSTEM_UNATTENDED=//'`
	echo "$ONECLI_BIN inventory upload --srcdata ${TMP_PATH}/${LOG_PKG_FILE} --upload $UNATTD_FULLSTR --output ${LOG_PATH} --log 5 --unattended" >> ${ERROR_FILE}
	#unattended
	$ONECLI_BIN inventory upload --srcdata ${TMP_PATH}/${LOG_PKG_FILE} --upload $UNATTD_FULLSTR --output ${LOG_PATH} --log 5 --unattended >> ${ERROR_FILE} 2>&1
	if [ $? == 0 ];then
		echo "[Success]: Upload logs."
	else
		echo "[Failure]: Upload logs."
		show_error
	fi
else
	echo "Upload logs by normal method..." >> ${LOG_FILE} 2>${ERROR_FILE}
	echo "Upload logs by normal method..."
# upload the log package to the location specified by user
	upload_log_pkg ${UNATTD_MODE_TYPE}
fi
exit 0
