#!/bin/sh
# Copyright © 2018 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
#
export PATH=$PATH:/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/usr/X11R6/bin:/bin:/usr/games:/usr/lib/mit/bin:/usr/lib/mit/sbin
export HOME=~
chmod +x /toolscenter/menu/* > /dev/null 2>&1

dos2unix /toolscenter/tcexit_noeject.sh > /dev/null 2>&1
cp -f /toolscenter/salie_tcexit_noeject.sh /tmp/salie_tcexit_noeject.sh
chmod +x /tmp/tcexit_noeject.sh

dos2unix /toolscenter/tcexit.sh > /dev/null 2>&1
cp -f /toolscenter/salie_tcexit.sh /tmp/salie_tcexit.sh
chmod +x /tmp/tcexit.sh 

dos2unix /toolscenter/tcexit_noeject.sh > /dev/null 2>&1
cp -f /toolscenter/tcexit_noeject.sh /tmp/tcexit_noeject.sh
chmod +x /tmp/tcexit_noeject.sh

dos2unix /toolscenter/tcexit.sh > /dev/null 2>&1
cp -f /toolscenter/tcexit.sh /tmp/tcexit.sh
chmod +x /tmp/tcexit.sh 

# Assume that one jobd file exist
for file_var in $(ls /toolscenter/); do
	jbod_file_name=$(echo $file_var | grep '^UUT.*rhel8$')
	if [ $jbod_file_name ]; then
		break
	fi
	jbod_file_name=$(echo $file_var | grep '^jbodupdate.*rhel7$')
	if [ $jbod_file_name ]; then
		break
	fi
	jbod_file_name=$(echo $file_var | grep '^lenstor')
	if [ $jbod_file_name ]; then
		break
	fi
done
cp -f /toolscenter/$jbod_file_name /tmp/$jbod_file_name
chmod +x /tmp/$jbod_file_name

if [ -f /etc/elie_version ]; then
	export BOMC_EXIT_CMD="/tmp/elie_tcexit.sh"
else
	export BOMC_EXIT_CMD="/tmp/salie_tcexit.sh"
fi

declare -A Model_SD
Model_SD=(["2U12ENC"]="D1212" \
["2U24ENC"]="D1224" \
["5U84ENC"]="D3284" \
["D32845U"]="D3284" )

MODEL=""
FORMAT_VER=""
LOG_NAME=""
function MapModel()
{
	MODEL=${Model_SD[${1:0:7}]}
	#echo "$MODEL"
}
function CovertVersion()
{
	#sample input FW:[5000014,5000028]
	#       output 5.00.00.14 5.00.00.28
	#echo "input=$1"
	#if [[ ${1} == *.*]]
	input=$1
	if [[ "${jbod_file_name}" =~ "UUT" ]] && [[ "${jbod_file_name}" =~ "rhel8" ]]; then
	#input : input= 5.2.0.1605.2.0.153NotAvailable
		input="["${input:0:9}","${input:9:9}"]"
	fi
	#input : input= [5.2.0.160,5.2.0.153]
	if [[ $1 =~ \. ]]; then
		installed_ver=${input#*[}
		installed_ver=${installed_ver%,*}
		new_ver=${input#*,}
		new_ver=${new_ver%]*}
	else
	installed_ver=${input:4:1}"."$((16#${input:5:2}))"."$((16#${input:7:2}))"."$((16#${input:9:2}))
	new_ver=${input:12:1}"."$((16#${input:13:2}))"."$((16#${input:15:2}))"."$((16#${input:17:2}))
	fi
	FORMAT_VER="$installed_ver""           ""$new_ver"
	#echo "$FORMAT_VER"
}
#fw="FW:[5000014,5000028]"
#CovertVersion "FW:[5000014,5000028]"
#MapModel "D32845U12GESM"
#MapModel "2U12ENCJ12ESM3P"
cd /tmp/
LOG_NAME="$(date +%Y%m%d%H%M%S)""_update.log"
>$LOG_NAME
LOG_NAME="/tmp/""$LOG_NAME"
clear
while [[ 1 ]]; do
	if [[ $jbod_file_name =~ "UUT" ]] && [[ $jbod_file_name =~ "rhel8" ]]; then
		./$jbod_file_name --list >./show.log
		storage_enclosure=`cat show.log |grep -A 9 "                    Enclosure" |grep "WWN: "|sed "s/^.*WWN://g"|sed "s/Vendor.*$//g"|tr -d " "`
		storage_model=`cat show.log |grep -A 9 "                    Enclosure" |grep "Model: "|sed "s/^.*Model://g"|sed "s/WWN.*$//g"|tr -d " "`
		storage_fw=`cat show.log |grep -A 24 "1 of .* from Enclosure"|grep "12g_canister_local"|tr -d " "|sed "s/^.*12g_canister_local//g"`
	elif [[ $jbod_file_name =~ "lenstor" ]]; then
		./$jbod_file_name --help
		break
	else
		./$jbod_file_name --show >./show.log
		storage_enclosure=`cat show.log |grep -A 34 "Showing Enclosure with WWN -" |grep "Showing Enclosure with WWN - "|sed "s/.*-//g"|tr -d " "`
		storage_model=`cat show.log |grep -A 34 "Showing Enclosure with WWN -" |grep "Model    :"|sed "s/.*: //g"|tr -d " "`
		storage_fw=`cat show.log |grep -A 34 "Showing Enclosure with WWN -" |grep "FW                   :"|tr -d " "` 
	fi
    storage_enclosure_arr=($storage_enclosure)
	storage_model_arr=($storage_model)
	storage_fw_arr=($storage_fw)
	num=${#storage_model_arr[@]}

	echo "====================Lenovo Storage D-series Firmware Update===================="
	echo ""
	echo "Supported Model:     D1212/D1224 (MT 4587)"
	echo "                     D3284       (MT 6413)"
	echo ""
	echo "Model       Installed Version    New Version"
	for((i=0;i<$num;i++));do
		MapModel ${storage_model_arr[$i]}
		CovertVersion ${storage_fw_arr[$i]}
		echo "$MODEL""           ""$FORMAT_VER"
	done
	echo ""
	echo "Prerequisites:   All ESMs are connected to the host adapters via SAS cables"
	echo ""
	echo "Please read the firmware release note (readme file) before the update."
	echo "==============================================================================="
	echo ""
	echo "The connected D-series enclosures:"
	for((i=0;i<$num;i++));do
		MapModel ${storage_model_arr[$i]}
		echo "$MODEL"" WWN - ""${storage_enclosure_arr[$i]}"
	done
	echo ""
	echo "Do you want to perform the firmware update to the enclosures? (Y/N):"
	read input
	if [ "x$input" == 'xY' ] || [ "x$input" == 'xy' ] || [ "x$input" == 'xyes' ]; then
		if [[ $jbod_file_name =~ "UUT" ]] && [[ $jbod_file_name =~ "rhel8" ]]; then
			./$jbod_file_name -y | tee -a $LOG_NAME
		else
			echo ./$jbod_file_name --enc=all
			./$jbod_file_name --enc=all | tee -a $LOG_NAME
		fi
		echo "The update log has been saved to: ""$LOG_NAME" ". You can check or copy the log to your portable storage."
		echo "And the server can be shutdown or reboot after as needed."
		break
	elif [ "x$input" == 'xN' ] || [ "x$input" == 'xn' ]; then
  		break
	else
		echo "Invalid Input! Please input Y/N......"
	fi
done
echo -e "\"exit\" can quit the command line."
/bin/sh
${BOMC_EXIT_CMD} shutdown
exit 0