#!/bin/sh
# Copyright © 2021 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
# This script prepares the current Linux environment for ToolsCenter.
export PATH=$PATH:/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/usr/X11R6/bin:/bin:/usr/games:/usr/lib/mit/bin:/usr/lib/mit/sbin
export HOME=~

export RUN_DIR="/tmp"
JSON_TOOL="${RUN_DIR}/jq"
export XML_TOOL="xmllint"
MENU_FILE="${RUN_DIR}/fmenu.json"
Cur_point=""
Last_point=""
Cur_function=""
Cur_menu=()
Title="BOMC TITLE"
Cur_script=""
export UXSPI_BOOTABLE=/toolscenter
export BOMC_DATA_DIR="/var/log/apple"
export BOMC_COMMAND_DIR="${RUN_DIR}/lxce_ux/command"
export ONECLI_BIN="${BOMC_COMMAND_DIR}/onecli/OneCli"
export ASU_BIN="${BOMC_COMMAND_DIR}/asu/asu64"
export DSA_DIR="${BOMC_COMMAND_DIR}/dsa"
export DSA_BIN="${DSA_DIR}/dsa"
export BOMC_LOG_DIR="${RUN_DIR}/bomc_logs"
export MOUNT_DIR="/toolscenter"
export USB_MOUNT_DIR="/toolscenter1"

export LOCAL_STORAGE_DIR="${RUN_DIR}/storage"
export BOOTABLE_STORAGE_DIR="${MOUNT_DIR}/storage"
export USB_STORAGE_DIR="${USB_MOUNT_DIR}/storage"

export ONECLI_CONSOLE_FILE="${RUN_DIR}/onecli_output"
export TMP_DIR="${RUN_DIR}/tmp"
export Run="${RUN_DIR}/frun.sh"
export RunPrintResult="${RUN_DIR}/frunCommandBack.sh"
export EXSTORAGE="${RUN_DIR}/fexternalStorage.sh"
export CHOOSE_FILE="/${RUN_DIR}/choose"

export BOMC_LOG_FILE=/tmp/bomc.log
BOMC_CONFIG="${RUN_DIR}/bomc.config"

#---------------------------------------
export ONECLI_ADD_OPTION=""
export ASU_ADD_OPTION=""
export GET_CMD=""
export SET_CMD=""
#-------------------------------------
Clear_screen=1

trap "" 2 20
#-----------------------------------------------
# get machine information
export CUR_MACHINE_TYPE="NONE"
function getMt() {
    echo "Get machine type from the outputs of \"dmidecode\" command."
    local MT_STR_LENGTH=4
    echo "Parse \"Product Name\" field."
    local product_name=$(dmidecode | grep -w -A 10 "DMI type 1" | grep "Product Name")
    CUR_MACHINE_TYPE=$(echo ${product_name} | sed -e 's/.*\[\([0-9a-zA-Z]\{4\}\).*\].*/\1/')
    if [ ${#CUR_MACHINE_TYPE} -eq ${MT_STR_LENGTH} ]; then
        return 0
    fi

    echo "Cannot get machine type from \"Product Name\" field."
    echo "Try to parse \"SKU Number\" field."
    local sku_number=$(dmidecode | grep -w -A 10 "DMI type 1" | grep "SKU Number")
    CUR_MACHINE_TYPE=$(echo ${sku_number} | sed -e 's/SKU Number: \([0-9a-zA-Z]\{4\}\).*/\1/')
    if [ ${#CUR_MACHINE_TYPE} -eq ${MT_STR_LENGTH} ]; then
        return 0
    fi

    echo "Failed to get machine type."
    CUR_MACHINE_TYPE="NONE"
    return 1
}
getMt

export CUR_SN=$(dmidecode -s system-serial-number | tail -n 1 | tr -d '[ \t]')
echo "Machine type=$CUR_MACHINE_TYPE, Serial number=$CUR_SN."
systemx_list="$MOUNT_DIR/menu/systemx_support_list.txt"
dos2unix $systemx_list >/dev/null 2>&1
if cat $systemx_list | grep "$CUR_MACHINE_TYPE" 1>/dev/null 2>&1; then
    echo "This is SystemX."
    export IS_PURLEY=0
else
    echo "This is ThinkSystem."
    export IS_PURLEY=1
fi

amd_list="$MOUNT_DIR/menu/amd_support_list.txt"
dos2unix $amd_list >/dev/null 2>&1
if cat $amd_list | grep "$CUR_MACHINE_TYPE" 1>/dev/null 2>&1; then
    echo "This is AMD."
    export IS_AMD=1
else
    export IS_AMD=0
fi

cfc_list="$MOUNT_DIR/menu/cfc_support_list.txt"
dos2unix $cfc_list >/dev/null 2>&1
if cat $cfc_list | grep "$CUR_MACHINE_TYPE" 1>/dev/null 2>&1; then
    echo "This is CFC System."
    export IS_CFC=1
else
    export IS_CFC=0
fi
#-----------------------------------------------

function prepareFiles() {
    dos2unix ${MOUNT_DIR}/*.sh >/dev/null 2>&1
    cp -f ${MOUNT_DIR}/*.sh ${RUN_DIR}/ >/dev/null 2>&1
    cp -f ${MOUNT_DIR}/fullmenu/* ${RUN_DIR}/ >/dev/null 2>&1
    cp -f ${MOUNT_DIR}/menu/updatecli_start.sh ${RUN_DIR}/updatecli_start.sh >/dev/null 2>&1
    cp -f ${MOUNT_DIR}/menu/updatecli_start_salie.sh ${RUN_DIR}/updatecli_start_salie.sh >/dev/null 2>&1
    cp -fra ${MOUNT_DIR}/menu ${RUN_DIR}/ >/dev/null 2>&1
    cp -fra ${MOUNT_DIR}/dsa ${RUN_DIR}/ >/dev/null 2>&1
    cp -fra ${MOUNT_DIR}/uxspi ${RUN_DIR}/ >/dev/null 2>&1
    cp -fra ${MOUNT_DIR}/miniunz ${RUN_DIR}/ >/dev/null 2>&1
    cp -fra ${MOUNT_DIR}/configfiles ${RUN_DIR}/ >/dev/null 2>&1
    #--------------------this is just for same as original script. but i think it is unuseful.
    dos2unix ${MOUNT_DIR}/*.sh >/dev/null 2>&1
    dos2unix ${MOUNT_DIR}/menu/*.sh >/dev/null 2>&1
    #-----------------------
    dos2unix ${RUN_DIR}/*.sh >/dev/null 2>&1
    dos2unix ${RUN_DIR}/menu/*.sh >/dev/null 2>&1
    dos2unix ${RUN_DIR}/configfiles/* >/dev/null 2>&1

    chmod +x ${RUN_DIR}/*.sh >/dev/null 2>&1
    chmod +x $JSON_TOOL >/dev/null 2>&1

    chmod +x ${RUN_DIR}/menu/*.sh >/dev/null 2>&1

    cp -f ${MOUNT_DIR}/bomc.config ${RUN_DIR}/bomc.config >/dev/null 2>&1
    dos2unix ${RUN_DIR}/bomc.config >/dev/null 2>&1

    cd ${RUN_DIR}/
    chmod -R +x ${RUN_DIR}/* >/dev/null 2>/dev/null
    mkdir -p $BOMC_DATA_DIR >/dev/null 2>/dev/null
    exttoolname="BoMC_3rdPartyTool"
    exttoolpath="${MOUNT_DIR}/$exttoolname"
    [ -d "$exttoolpath" ] && cp -rf $exttoolpath ${RUN_DIR}/ 1>/dev/null 2>&1 && chmod +x ${RUN_DIR}/$exttoolname/*

}

function parseConfig() {
    mkdir -p $BOMC_LOG_DIR

    if cat ${BOMC_CONFIG} | grep "IBM_SYSTEM_COPY_TO_RAMDISK=YES" >/dev/null 2>&1; then
        export COPY_TO_RAMDISK=1
    fi

    # Export the UXSPI_TIMEOUT environment to uxspi
    TIMEOUT=60
    if cat ${BOMC_CONFIG} | grep IBM_SYSTEM_TIMEOUT >/dev/null 2>&1; then
        TIMEOUT=$(cat ${BOMC_CONFIG} | grep IBM_SYSTEM_TIMEOUT | sed 's/IBM_SYSTEM_TIMEOUT=//')
    fi
    export UXSPI_TIMEOUT=${TIMEOUT}

    #Export environment for UXSPI UXSP's/latest
    if cat ${BOMC_CONFIG} | grep "IBM_SYSTEM_LATEST=YES" >/dev/null 2>&1; then
        export UXSPI_LATEST=1
    fi

    #Export environment for UXSPI UXSP's/latest
    if cat ${BOMC_CONFIG} | grep "IBM_SYSTEM_UPDATE_HBACNA=YES" >/dev/null 2>&1; then
        export UXSPI_NEW=1
    fi

    # Export environment for exit script command
    if cat ${BOMC_CONFIG} | grep "IBM_SYSTEM_MEDIA_EJECT=NO" >/dev/null 2>&1; then
        if [ "x$BOOT_OS_ENV_TYPE" == "xMCP" ]; then
            export BOMC_EXIT_CMD="${RUN_DIR}/tcexit_noeject.sh"
        else
            if [ -f /etc/elie_version ]; then
                export BOMC_EXIT_CMD="/tmp/elie_tcexit_noeject.sh"
            else
                export BOMC_EXIT_CMD="/tmp/salie_tcexit_noeject.sh"
            fi
        fi
    else
        if [ "x$BOOT_OS_ENV_TYPE" == "xMCP" ]; then
            export BOMC_EXIT_CMD="${RUN_DIR}/tcexit.sh"
        else
            if [ -f /etc/elie_version ]; then
                export BOMC_EXIT_CMD="/tmp/elie_tcexit.sh"
            else
                export BOMC_EXIT_CMD="/tmp/salie_tcexit.sh"
            fi
        fi
    fi

    # Export environment for UXSPI autorun command
    if cat ${BOMC_CONFIG} | grep "IBM_SYSTEM_AUTORUN=update" >/dev/null 2>&1; then
        export UXSPI_AUTORUN=1
    fi

    if ! cat ${BOMC_CONFIG} | grep "IBM_SYSTEM_ISO_FILE=NULL" >/dev/null 2>&1; then
        export BOOTTYPE="iso"
    elif ! cat ${BOMC_CONFIG} | grep "IBM_SYSTEM_PXE_FILE=NULL" >/dev/null 2>&1; then
        export BOOTTYPE="pxe"
    elif ! cat ${BOMC_CONFIG} | grep "IBM_SYSTEM_CD=NULL" >/dev/null 2>&1; then
        export BOOTTYPE="cd"
    elif ! cat ${BOMC_CONFIG} | grep "IBM_SYSTEM_USB_KEY=NULL" >/dev/null 2>&1; then
        export BOOTTYPE="usb"
    else
        export BOOTTYPE="unkown"
    fi
    echo "BOOTTYPE=$BOOTTYPE"

    # DSA environment variable
    export DSA_PATH=/tmp/embed:/tmp/embed/qlogic:/usr/X11R6/lib64:/usr/X11R6/lib
    export DSA_GUI_CMD="xterm -geometry 170x61 +sb -e /tmp/dsa/start.sh --gui"
    export DSA_CMD_CMD="xterm -geometry 170x61 +sb -e /tmp/dsa/start.sh --cmd"

}

os_version() {
    _version=$(cat /etc/os-release | grep "VERSION_ID=" | cut -d "=" -f2)
    _version=${_version%%\"}
    _version=${_version##\"}
    echo $_version
}

function handleByMtType() {
    if [ "x$BOOT_OS_ENV_TYPE" == x"MCP" ]; then
        #uxspi -------------------------
        # if [ -d /tmp/lxce_ux/command/uxspi/ ];then
        #     export UXSPI_BINARY_PATH="/tmp/lxce_ux/command/uxspi/"`ls /tmp/lxce_ux/command/uxspi/ |sort|grep 'lnvgy_utl_uxspi_.*_anyos_x86-64.bin'|tail -n 1`
        #     echo "Got uxspi binary named $UXSPI_BINARY_PATH."
        # else
        #     export UXSPI_BINARY_PATH=""
        #     echo "Unknown uxspi binary."
        # fi
        ##asu ---------------------------
        compressed_asu=$(ls -t ${MOUNT_DIR}/asu/ | grep lnvgy_utl_.*_linux_x86-64.tgz)

        echo "Got asu binary named $compressed_asu."
        asu_dir="${BOMC_COMMAND_DIR}/asu/"
        mkdir -p $asu_dir >/dev/null 2>/dev/null
        tar xf ${MOUNT_DIR}/asu/$compressed_asu -C ${asu_dir}
        #sed -i -e 's/^ASU_PATH=.*/ASU_PATH=\/tmp\/asu\/asu64/g' ${RUN_DIR}/lxce_ux/command/onecli/global.config
    elif [ -e /etc/elie_version ]; then
        echo "running in elie"
    else
        OS_VERSION=$(os_version)
        if [ "x$OS_VERSION" == "x8" ]; then
            ln -s /usr/lib64/libudev.so.1.6.11 /usr/lib64/libudev.so.0 2>/dev/null
            ln -s /usr/lib64/libnsl.so.2.0.0 /usr/lib64/libnsl.so.1 2>/dev/null
            ln -s /usr/lib64/libcrypto.so.1.1.1g /usr/lib64/libcrypto.so.4 2>/dev/null
            ln -s /usr/lib64/libssl.so.1.1.1g /usr/lib64/libssl.so.4 2>/dev/null
            ln -s /usr/lib64/libcrypto.so.1.1.1g /lib64/libcrypto.so.4 2>/dev/null
            ln -s /usr/lib64/libssl.so.1.1.1g /lib64/libssl.so.4 2>/dev/null
        else
            ln -s /usr/lib64/libudev.so.1.6.2 /usr/lib64/libudev.so.0 2>/dev/null
        fi
    fi

    mkdir -p $STORAGE_DIR 1>/dev/null 2>&1

    if [ $IS_PURLEY == 0 ]; then
        n=$(grep -n "\"SMART data\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+7))d' $MENU_FILE
    fi
    #if this is purley machine, we could not do diagnostics,so we should remove the menu from fmenu.json
    if [ $IS_PURLEY == 1 ]; then
        n=$(grep -n "\"Diagnostics\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+3))d' $MENU_FILE
    fi
    #if this is mcp os, we could not support raid config & secure erase & smartdata
    if [ "x$BOOT_OS_ENV_TYPE" == x"MCP" ]; then
        n=$(grep -n "\"RAID Configuration\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+59))d' $MENU_FILE

        n=$(grep -n "\"Secure Erase\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+6))d' $MENU_FILE

        n=$(grep -n "\"SMART data\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+7))d' $MENU_FILE
    fi
    #if this is AMD server, we should remove the collect FFDC function
    if [ $IS_AMD == 1 ]; then
        #locat the section in fmenu.json
        n=$(grep -n "\"Collect FFDC Logs and Inventory Information\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        #modify title
        sed -i "${n}s/Collect FFDC Logs and Inventory Information/Inventory Information/" "$MENU_FILE"
        #relocate to the description and modify it
        let n=${n}+1
        sed -i "${n}s/Inventory system Log  and FFDC Log/Inventory system Log/" "$MENU_FILE"
        #relocate to the command and modify it
        let n=${n}+3
        sed -i "${n}s/--ffdc//" "$MENU_FILE"
    fi

    #if this is CFC machine, we could not support update vpd & manage fod keys & secure erase & some commands of Advanced System Configuration
    if [ $IS_CFC == 1 ]; then
        n=$(grep -n "\"Update VPD\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+12))d' $MENU_FILE

        n=$(grep -n "\"Restore System Settings (with VPD)\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+10))d' $MENU_FILE

        n=$(grep -n "\"Restore System Settings (without VPD)\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+10))d' $MENU_FILE

        n=$(grep -n "\"Change Asset Tag Number\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+12))d' $MENU_FILE

        n=$(grep -n "\"Change UUID Number\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+12))d' $MENU_FILE

        n=$(grep -n "\"Generate New Random UUID Number\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+10))d' $MENU_FILE

        n=$(grep -n "\"Load UEFI/BMC To Default\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+31))d' $MENU_FILE

        n=$(grep -n "\"Change BMC Settings\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+67))d' $MENU_FILE

        n=$(grep -n "\"Set Hardware System Planar Clock DateTime\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+7))d' $MENU_FILE

        n=$(grep -n "\"Manage FoD Keys\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+53))d' $MENU_FILE

        n=$(grep -n "\"Secure Erase\"" $MENU_FILE | tail -n 1 | cut -d ":" -f 1)
        eval sed -i '$((n-1)),$((n+6))d' $MENU_FILE
    fi
}

function init() {
    #------------------------
    #get memory size
    #if size <4GB, we wil remove some decompress directory for launch updatexpress
    msize=$(free -g | tr -s ' ' | sed -n '2p' | awk '{print $2}' 2>/dev/null)
    if [ $msize -lt 4 ] 2>/dev/null; then
        export ThristyMemory=1
        echo "The memory is ${msize}GB, it's so little."
    else
        export ThristyMemory=0
        echo "The memory is ${msize}GB."
    fi
    #----------------------------
    prepareFiles

    if [ -f /etc/mcp.manifest ]; then
        echo "This is MCP, will auto call the script for MCP..."
        #stty erase ^h
        ${RUN_DIR}/updatecli_start.sh
    else
        echo "This is SALIE, will auto call the script for SALIE..."
        ${RUN_DIR}/updatecli_start_salie.sh
    fi
    while read LINE; do
        export BOOT_OS_ENV_TYPE=$LINE
    done <${RUN_DIR}/boot_type.txt

    parseConfig

    echo "Pre-copy payloads if it is selected..."
    if [ ${COPY_TO_RAMDISK} -eq 1 ]; then
        mkdir -p /run/initramfs/live
        mount /dev/sr0 /run/initramfs/live 1>/dev/null 2>&1
        cp -nv /run/initramfs/live/* /toolscenter/
        cp -nrv /run/initramfs/live/payloads /toolscenter/
        umount /run/initramfs/live 1>/dev/null 2>&1
        rm -rf /toolscenter/lnvgy_utl_lxce_bomc-*.xml 1>/dev/null 2>&1
    fi

    ${RUN_DIR}/menu/check_remote.sh /toolscenter
    if [ $? -eq 0 ]; then
        echo "Remote mounting via remote IMM/network" >>${BOMC_LOG_FILE}
    else
        echo "NOT mounted via remote IMM/network" >>${BOMC_LOG_FILE}
        export UXSPI_REDUCE_COPY=1
    fi

    handleByMtType

    # change the console log level from 7 to 4 to hidden redundant logs
    echo "4 4 1 7" >/proc/sys/kernel/printk
}

function extractDsa() {
    if [ ! -d ${DSA_DIR} ]; then
        if [ $IS_PURLEY == 0 ]; then
            ##dsa ------------------------------
            #echo "Extract dsa..."
            chmod +x ${RUN_DIR}/miniunz
            mkdir -p ${DSA_DIR} >/dev/null 2>&1
            ${RUN_DIR}/miniunz $MOUNT_DIR/dsa/preboot/sfx-mcp74 -d ${DSA_DIR}/ 1>/dev/null 2>&1
        fi
    fi
}

function removeDsa() {
    rm -fr ${DSA_DIR} >/dev/null 2>&1
}

function exit_action() {
    sync
    # Shut down the system when it's unattended image
    ${BOMC_EXIT_CMD} shutdown
}

Diags_result_file="/tmp/onecli_output"
function showDiagsResult() {
    rm -fr $Diags_result_file >/dev/null 2>&1
    name=""
    result=""
    found=0
    count=0
    declare -A info

    while read mline; do
        if echo "$mline" | grep "command not found" >/dev/null 2>&1; then
            continue
        fi

        if echo "$mline" | grep ":" | grep -E -v "Percent|\." >/dev/null 2>&1; then
            name=$mline
            found=0
        elif echo "$mline" | grep -E "Percent Complete : 100%|Percent Complete: 100%" >/dev/null 2>&1; then
            found=1
        elif [ -n "$name" ] && [ $found == 1 ]; then
            result=$mline
            [ "x$result" == "xNo Results." ] && result=""
            if echo "$result" >/dev/null 2>&1; then
                let count+=1
                #                       info+=(["$name"]=$result)
                #                       echo -e "$count $name\t\t$result"
                printf "%-3s  %-50s %-8s\n" $count "$name" $result >>$Diags_result_file
            fi
            found=0
            name=""
        fi
    done <$ONECLI_CONSOLE_FILE

    if [ -f $Diags_result_file ]; then
        more $Diags_result_file
    else
        echo "No valid result."
    fi
}

function Diagnostics() {
    if [ $ThristyMemory == 1 ]; then
        echo "Could not run diagnostics due to memory size less than 4GB."
        return
    fi

    extractDsa
    save_path=$(pwd)
    cd ${DSA_DIR}
    curtime=$(date +%Y%m%d%H%M%S)

    logfile="log_diagnostics_$curtime.txt"
    export DATA_DIR_NAME="Diagnostics"
    #log
    LOG_DIR=${BOMC_LOG_DIR}/$DATA_DIR_NAME
    mkdir -p $LOG_DIR >/dev/null 2>&1
    export DSA_LOGFILE=${LOG_DIR}/$logfile
    #data
    DATA_DIR="${LOCAL_STORAGE_DIR}/$DATA_DIR_NAME"
    mkdir -p $DATA_DIR 1>/dev/null 2>&1

    Diags_result_file=$DATA_DIR/"result_$curtime.txt"
    ${RunPrintResult} "./dsacli -diags -b -d $DATA_DIR" "nocycle"
    if [ $? == 0 ]; then
        showDiagsResult
        if lspci | grep -i ethernet | grep -i intel 1>/dev/null 2>&1; then
            dhclient -r 1>/dev/null 2>&1
            dhclient -4 1>/dev/null 2>&1
        fi

        while [ true ]; do
            read -p "* Do you want to save it?(Y|N)" ans
            [ -z "$ans" ] && continue
            if [ "x$ans" == "xY" ] || [ "x$ans" == "xy" ]; then
                name="diagnostics_${curtime}.tar.gz"
                cd $DATA_DIR
                tar zcf $RUN_DIR/$name * 1>/dev/null 2>&1
                [ $? != 0 ] && echo "[Failure] Failed to compress diagnostics result." && return

                # saved_dir=`echo "$INVENTORY_DIR"|sed 's/\/toolscenter/<USB>/'`
                # echo "FFDC logs and inventory information have been saved in $saved_dir/."
                #$EXPORTDATA $saved_dir
                $EXSTORAGE "save" $RUN_DIR/$name
                # [ $? == 0 ]&& rm -fr $INVENTORY_DIR/* 1>/dev/null 2>&1
                break
            elif [ "x$ans" == "xN" ] || [ "x$ans" == "xn" ]; then
                break
            else
                echo "Invalid input."
            fi
        done

        # [ $? == 0 ]&& rm -fr $DATA_DIR/* 1>/dev/null 2>&1
    fi
    cd ${save_path}
}

function SecureErase() {
    local ResutlFile="result_file"
    read -p "Enter the REST port (empty for no change): " rest_port
    read -p "Enter the CIM port (empty for no change): " cim_port
    # ${Run} "${GET_CMD}" "-" "$cim_port" "$rest_port" "$BOMC_LOG_DIR/serase"
    Command="serase --bmc-cim-port $cim_port --bmc-rest-port $rest_port --log 5 --output $BOMC_LOG_DIR/serase"
    if [ -z "$cim_port" ]; then
        Command=$(echo ${Command/ --bmc-cim-port/})
    fi
    if [ -z "$rest_port" ]; then
        Command=$(echo ${Command/ --bmc-rest-port/})
    fi
    ${ONECLI_BIN} ${Command}
    return
}

function EnableDebugMethod() {
    [ "x$DSA_LOGLEVEL" == "x4" ] && return
    ONECLI_ADD_OPTION="--log 5"
    ASU_ADD_OPTION="-l 90"
    #BOMC_LOG_DIR="$STORAGE_DIR/logs/"
    # save_dir=`echo "$BOMC_LOG_DIR"|sed 's/\/toolscenter/<USB>/'`
    # read -p "* Enter the save path($save_dir):" logspath
    # [ -n "$logspath" ] && BOMC_LOG_DIR="$logspath"
    export DSA_LOGLEVEL=4
    # mkdir -p $BOMC_LOG_DIR 1>/dev/null 2>&1
    echo "[Success]"

}

function DisableDebugMethod() {
    [ "x$DSA_LOGLEVEL" == "x0" ] && return
    ONECLI_ADD_OPTION=""
    ASU_ADD_OPTION=""
    #BOMC_LOG_DIR="${RUN_DIR}/bomc_logs/"
    export DSA_LOGLEVEL=0
    echo "[Success]"
}

function SaveBoMCLogs() {
    export DATA_DIR_NAME="bomc_logs"
    files=$(ls $BOMC_LOG_DIR/ 2>/dev/null)
    if [ ! -e $BOMC_LOG_DIR ] || [ "x$files" == "x" ]; then
        echo "[Failure] No log needs to save."
        return
    fi
    name="logs_${CUR_MACHINE_TYPE}_${CUR_SN}_$(date +%Y%m%d%H%M%S).tar.gz"
    cd $BOMC_LOG_DIR
    tar zcf $RUN_DIR/$name * 1>/dev/null 2>&1
    [ $? != 0 ] && echo "[Failure] Failed to compress log directory." && return
    $EXSTORAGE "save" $RUN_DIR/$name
    #after upload, rm the logs
    # [ $? == 0 ]&& rm -fr $BOMC_LOG_DIR/* 1>/dev/null 2>&1
    cd $RUN_DIR
}

function show_menu() {
    if [ "$Clear_screen" == 0 ]; then
        echo -e "\n\n\n"
    else
        clear
        Clear_screen=0
    fi
    title=$1
    description=$2
    #clear
    echo -e "\t\t[${title}]" | tr 'a-z' 'A-Z'
    #echo -e "$description"
    echo ""
    for ((i = 0; i < ${#Cur_menu[*]}; ++i)); do
        #        menu=`echo ${Cur_menu[$i]}|sed 's/__/ \& /g'`
        #    ((tmp=i+1))
        #        menu=`echo ${menu}|sed 's/_/ /g'`
        echo -e "[$((i + 1))]\t${Cur_menu[$i]}"
    done
    echo ""
    if [ -z ${Cur_point} ]; then
        echo -e "[Q]\t Quit Program and Shut Down System"
    else
        echo -e "[P]\t Previous Menu"
        echo -e "[Q]\t Quit Program and Shut Down System"
    fi
    echo ""
}

function get_menu() {
    Title=$($JSON_TOOL $Cur_point.name $MENU_FILE | sed s/\"//g)
    #echo "$JSON_TOOL $Cur_point.name  $MENU_FILE|sed s/\"//g"
    description=$($JSON_TOOL $Cur_point.description $MENU_FILE | sed s/\"//g)
    script=$($JSON_TOOL $Cur_point.script $MENU_FILE | sed s/\"//g)
    #echo "$JSON_TOOL $Cur_point.script  $MENU_FILE|sed s/\"//g"
    if [ -n "${script}" ] && [ "x$script" != "xnull" ]; then
        #    echo "src=$script="
        Cur_script=$script
    fi

    GET_CMD=""
    SET_CMD=""
    if [ "x$BOOT_OS_ENV_TYPE" == x"MCP" ]; then
        cmd=$($JSON_TOOL $Cur_point.blue_command.get $MENU_FILE | sed s/\"//g)
        [ -n "${cmd}" ] && [ "x$cmd" != "xnull" ] && GET_CMD=$cmd
        cmd=$($JSON_TOOL $Cur_point.blue_command.set $MENU_FILE | sed s/\"//g)
        [ -n "${cmd}" ] && [ "x$cmd" != "xnull" ] && SET_CMD=$cmd
    else
        cmd=$($JSON_TOOL $Cur_point.red_command.get $MENU_FILE | sed s/\"//g)
        [ -n "${cmd}" ] && [ "x$cmd" != "xnull" ] && GET_CMD=$cmd
        cmd=$($JSON_TOOL $Cur_point.red_command.set $MENU_FILE | sed s/\"//g)
        [ -n "${cmd}" ] && [ "x$cmd" != "xnull" ] && SET_CMD=$cmd
    fi
    #echo "sp1: $JSON_TOOL $Cur_point.name  $MENU_FILE"
    menu=$($JSON_TOOL [$Cur_point.submenu[].name] $MENU_FILE)
    menu=$(echo $menu | sed 's/\n//g' | sed 's/[\[\"]//g' | sed 's/\]//g')
    if echo "$menu" | grep "Debug Method" 1>/dev/null 2>&1; then
        if [ "x$DSA_LOGLEVEL" == "x4" ]; then
            menu=$(echo "$menu" | sed 's/Debug Method/Disable Debug Method/g')
        else
            menu=$(echo "$menu" | sed 's/Debug Method/Enable Debug Method/g')
        fi
    fi
    #if [ $IS_PURLEY ==  1 ];then
    #    echo "$menu"
    #    menu=`echo "$menu"|sed 's/Diagnostics, //g'`
    #    echo "$menu"
    #fi

    store_ifs=$IFS
    IFS="\,"
    Cur_menu=(${menu})
    IFS=$store_ifs

    if [ "x$DSA_LOGLEVEL" == "x4" ]; then
        Title=$(echo "$Title" | sed 's/Debug Method/Disable Debug Method/g')
    else
        Title=$(echo "$Title" | sed 's/Debug Method/Enable Debug Method/g')
    fi

    #menu_data=(`echo $menu|awk -v RS='' '{gsub("\n"," "); print}'`)
    # //\"})
    count=${#Cur_menu[@]}
    if [ $count == 0 ] || [ $count == 1 ]; then
        return 1
    else
        show_menu "$Title" "$description"
        return 0
    fi

}

function ask() {
    read -p "* Enter your option:" option

    if [ "x$option" == "xQ" ] || [ "x$option" == "xq" ]; then
        read -p "* Are you sure you want to shut down? [Y/N]:" ans
        if [ "x$ans" == "xy" ] || [ "x$ans" == "xY" ]; then
            exit_action
            exit 0
        elif [ "x$ans" == "xn" ] || [ "x$ans" == "xN" ]; then
            return
        else
            echo "Invalid input."
            return
        fi
    elif [ "x$option" == "xP" ] || [ "x$option" == "xp" ]; then
        Cur_point=$(echo ${Cur_point%.*})
    elif [ $option -gt 0 ] 2>/dev/null; then
        #    echo "count=${#Cur_menu[*]}"
        if [ "$option" -gt "${#Cur_menu[*]}" ]; then
            echo "Please input a valid option."
        else
            let option-=1
            #Title=${Cur_menu[$option]}
            echo "Your option is: ${Cur_menu[$option]}"
            Cur_point="${Cur_point}.submenu[$option]"
        fi
    else
        echo "Please input a valid option."
    fi

    Last_point=$(echo ${Cur_point%.*})
    #echo "$Cur_point"
}

#--------------------------------------------
#---- begin main--------------------------
if [ $# -eq 0 ]; then
    echo "Running in non SOL mode" >>${BOMC_LOG_FILE}
    export DSA_TUI_CMD="/tmp/dsa/start.sh --cmd"
else
    if [ "$1" = "serial" ]; then
        echo "Running in SOL mode - Console" >>${BOMC_LOG_FILE}
        export BOMC_SOL_MODE=1
        export DSA_TUI_CMD="/tmp/dsa/start.sh serial --cmd"
    elif [ "$1" = "serial-on" ]; then
        echo "Lenovo XClarity Essentials started on SOL console......type \"reboot\" to reboot the system"

    fi
fi

init
[ ! -e "$JSON_TOOL" ] && echo "Missing the tool for parse json, Please recreate usb drive." && exit
[ ! -e "$MENU_FILE" ] && echo "Missing menu file, Please recreate usb drive." && exit
#rm -fr $FOD_LEY_FILE 1>/dev/null 2>/dev/null
while [ 1 ]; do
    get_menu
    if [ $? == 0 ]; then
        ask
    else
        Cur_function=$(echo $Title | sed 's/[ \(\)\/]//g')

        if [ "x$Cur_function" == "xEnableDebugMethod" ] ||
            [ "x$Cur_function" == "xDisableDebugMethod" ] ||
            [ "x$Cur_function" == "xDiagnostics" ] ||
            [ "x$Cur_function" == "xSaveBoMCLogs" ] ||
            [ "x$Cur_function" == "xSecureErase" ]; then
            echo ""
            $Cur_function
        elif [ -n "$Cur_script" ]; then
            if [ -e "${RUN_DIR}/$Cur_script" ]; then
                if [ $ThristyMemory == 1 ] && [ "$Cur_script" == "finventory.sh" ] && [ "x$BOOT_OS_ENV_TYPE" == x"MCP" ]; then
                    Cur_point=$Last_point
                    echo "Could not run inventory and get ffdc due to memory size less than 4GB."
                    continue
                fi
                [ "$Cur_script" == "finventory.sh" ] && [ "x$BOOT_OS_ENV_TYPE" == x"MCP" ] && extractDsa
                #echo "call func:./$Cur_script $Cur_function"
                chmod +x ${RUN_DIR}/$Cur_script
                curpath=$(pwd)
                echo ""
                ${RUN_DIR}/$Cur_script $Cur_function

                #sync
                cd $curpath
            else
                echo "${RUN_DIR}/$Cur_script is not exit, please check it."
            fi
        else
            echo "e-$Cur_function"
            echo "Unknown script, please check it."
        fi
        Cur_point=$Last_point
    fi

done
