# Copyright © 2019 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
#/bin/sh
# blank: when success, print nothing, but when failed, print error message.
# all_blank: what ever success and failure, print nothing
# 
#

IS_RAID_CONFIG=0

function isFinished()
{
	ps -ef|grep -E "$ONECLI_BIN|$ASU_BIN|dsacli" |grep -v grep > /dev/null 2>&1
	return $?
}

function wait_cmd()
{
	schar=$1
	echo -ne "\rProcessing [$schar]"
 	sleep 1
	isFinished
	#ret=$?
	#[[  $ret -ne 0 ]]  && echo -ne "\rDone.                     "
	return $?
}

function cmd_check()
{
	cmd="$1"
	pattern=".*OneCli raid"

	echo "${cmd}"|grep -Eq "${pattern}"
	if [ $? -eq 0 ];then
		IS_RAID_CONFIG=1
	fi
}

function RunCommandBack()
{	
	cmd="$1"
	filter="$2"
	output=$ONECLI_CONSOLE_FILE 
	#echo "cmd=$cmd"
	#/bin/sh ./fshowprogress.sh  &
	cmd_check "${cmd}"
	eval "${cmd}" 1> "${output}" 2>&1  &
	jobnum=`jobs -p`
	while [ 1 ]
 	do
		wait_cmd "-"
		[ $? -ne 0 ] && break
		wait_cmd "\\"
		[ $? -ne 0 ] && break
		wait_cmd "|"
		[ $? -ne 0 ] && break
		wait_cmd "/"
		[ $? -ne 0 ] && break
	done
	wait $jobnum
	ret=$?
	#echo "ret=$ret"
	if [ $IS_RAID_CONFIG -eq 1 ];then
		more "${output}"
	fi
	[ "x$filter" == "xall_blank" ] && echo -ne "\r                       \r" && return $ret
	if [ $ret == 0 ];then
		if [ "x$filter" == "xblank" ];then
			echo -ne "\r                       \r"
		elif [ "x$filter" != "x-" ];then
			echo -ne "\r                                  " 
			echo -ne "\r" 
			eval "$filter" 
		else
			echo -e "\r[Success]                                  "
		fi
	else
		msg=`tail -n 1 $output`
		echo -e "\r[Failure] $msg"
	fi

	[ -e $output ]&& cp $output "$BOMC_LOG_DIR/screen/output_`date +%Y%m%d%H%M%S`"
	return $ret
}


mkdir -p "$BOMC_LOG_DIR/screen" 1>/dev/null 2>&1

if [ "$#" != 2 ]; then
	RunCommandBack "$1" "-"
else
	option=$2
	if [ "x$option" == "xnocycle" ];then
		eval $1 | tee $ONECLI_CONSOLE_FILE 
		ret=$?
		[ -e $ONECLI_CONSOLE_FILE ]&& cp $ONECLI_CONSOLE_FILE "$BOMC_LOG_DIR/screen/output_`date +%Y%m%d%H%M%S`"
		exit $ret
	else
		RunCommandBack "$1" "$option"
		exit $?
	fi
fi
