# Copyright © 2018 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
export DATA_DIR_NAME="inventory_ffdc"
INVENTORY_DIR="${LOCAL_STORAGE_DIR}/$DATA_DIR_NAME"
export MD_LOG_DIR="${BOMC_LOG_DIR}/$DATA_DIR_NAME"

mkdir -p $INVENTORY_DIR 1>/dev/null 2>/dev/null
mkdir -p $MD_LOG_DIR 1>/dev/null 2>/dev/null

ret=0
if [ "x$BOOT_OS_ENV_TYPE" == x"MCP" ];then
    save_path=`pwd`
    cd ${DSA_DIR}

    logfile="inventory_dsa_`date +%Y%m%d%H%M%S`.txt"
    export DSA_LOGFILE=$MD_LOG_DIR/$logfile

    ${RunPrintResult} "./dsacli  --ffdc -d ${INVENTORY_DIR} -v -b" "nocycle"
    ret=$?
    cd $save_path
else
    while [ true ]
    do
        read -p "* Do you want to collect hard drive logs? (Y/N)"  ans
        [ -z "$ans" ]&&continue
        read -p "Enter the REST port (empty for no change): " rest_port
        read -p "Enter the CIM port (empty for no change): " cim_port
        if [ "x$ans" == "xY" ] || [ "x$ans" == "xy" ];then
            ${Run} "$GET_CMD" "nocycle" "$cim_port" "$rest_port" "$INVENTORY_DIR"
            break
        elif [ "x$ans" == "xN" ] || [ "x$ans" == "xn" ];then
            ${Run} "$GET_CMD" "nocycle" "$cim_port" "$rest_port" "$INVENTORY_DIR"
            break
        else
            echo "Invalid input."
        fi
    done
    ret=$?
    cp -fran $INVENTORY_DIR/*.log $MD_LOG_DIR/ >/dev/null 2>&1
fi

if [ $ret == 0 ];then
    if [ "x$BOOT_OS_ENV_TYPE" == x"MCP" ];then
        if lspci |grep -i ethernet|grep -i intel 1>/dev/null 2>&1
        then
            dhclient -r 1>/dev/null 2>&1
            dhclient -4 1>/dev/null 2>&1
        fi
    fi
    while [ true ]
    do
        read -p "* Do you want to save it? (Y/N)"  ans
        [ -z "$ans" ]&&continue
        if [ "x$ans" == "xY" ] || [ "x$ans" == "xy" ];then
            name="inventory_${CUR_MACHINE_TYPE}_${CUR_SN}_`date +%Y%m%d%H%M%S`.tar.gz"
            cd $INVENTORY_DIR
            tar zcf $RUN_DIR/$name * 1>/dev/null 2>&1
            [ $? != 0 ]&& echo "[Failure] Failed to compress inventory result." && return

            # saved_dir=`echo "$INVENTORY_DIR"|sed 's/\/toolscenter/<USB>/'`
            # echo "FFDC logs and inventory information have been saved in $saved_dir/."
            #$EXPORTDATA $saved_dir 
            $EXSTORAGE "save" $RUN_DIR/$name
            # [ $? == 0 ]&& rm -fr $INVENTORY_DIR/* 1>/dev/null 2>&1
            break
        elif [ "x$ans" == "xN" ] || [ "x$ans" == "xn" ];then
            break
        else
            echo "Invalid input."
        fi
    done
    
    
fi
