#!/bin/sh
# Copyright © 2019 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
SrcFile=""
UsbDevices=()

LOCAL_STORAGE_DATA_DIR=${LOCAL_STORAGE_DIR}/$DATA_DIR_NAME
EXPORT_STORAGE_DATA_DIR=$BOOTABLE_STORAGE_DIR/$DATA_DIR_NAME
#this file will add detail save information
ExportInfoFile=$LOCAL_STORAGE_DATA_DIR/.info
ExportFiles=()
ExportPaths=()

function SaveExportInfo()
{
	files=$1
	todir=`echo $2|sed 's/\/$//g'`
	[ -z "SrcFile" ]&&return 
	#if the file and path has exist,we could not save it.
	if cat $ExportInfoFile 2>/dev/null | grep echo $files","$todir 1>/dev/null 2>&1;then
		return 
	fi
	mkdir -p $LOCAL_STORAGE_DATA_DIR 1>/dev/null 2>&1
	if echo $files|grep "," 1>/dev/null 2>&1;then
		store_ifs=$IFS
		IFS=","
		flist=($files)
		IFS=$store_ifs
		for file in ${flist[@]}
		do
			echo $file","$todir >> $ExportInfoFile
		done
	else
		echo $files","$todir >> $ExportInfoFile
	fi
	
}

function LoadExportInfo()
{
	[ ! -e $ExportInfoFile ]&&return
	ExportFiles=()
	ExportPaths=()
	while read line
	do
		if echo $line |grep "," >/dev/null 2>&1;then
			ExportFiles+=(`echo $line |cut -d , -f1`)
			ExportPaths+=(`echo $line |cut -d , -f2`)
		fi
	done <$ExportInfoFile
}

function detectusb()
{
	labels=`ls /proc/scsi/usb-storage 2>/dev/null`
    if [ "${labels}" == "" ] ; then
        usb_devices="NULL"
    else
        for lb in ${labels} ; do
            usb_device="/dev/"`ls /sys/class/scsi_device/${lb}\:0\:0\:0/device/block/ 2>/dev/null`
			if echo $usb_device|grep "[0-9]$" >/dev/null 2>&1;then
				continue
			fi
			if mount -l|grep $usb_device |grep "toolscenter" 1>/dev/null 2>/dev/null;then
				usb_device=$usb_device"(Bootable)"
			fi
			
	    	UsbDevices+=(${usb_device})
        done
    fi
	
}

Choose_value_from_list=""
function chooseFromList()
{
	flist=($1)
	question=$2
	confirm="y"
	[ $# -ge 3 ] && confirm=$3
	count=0
	for f in ${flist[@]}
	do
		[ -z "f" ] && continue
		let count=count+1
		echo -e "$count\t$f"
	done
	[ "$count" == 0 ]&&echo "[Failure] Could not find in list." &&return 1

	Choose_value_from_list=${flist[0]}
	if [ "$count" == 1 ];then
		if [ $confirm == "y" ];then
			while [ true ]
			do
				read -p "*Are you sure select $Choose_value_from_list? [Y/N]" ans
				[ -z "$ans" ]&&continue
				if [ "x$ans" == "xY" ] || [ "x$ans" == "xy" ];then
					return 0
				elif [ "x$ans" == "xN" ] || [ "x$ans" == "xn" ];then
					return 1
				else
					echo "Invalid input."
				fi
			done
		fi
	else
		echo ""
		while [ true ]
		do
			read -p "$question" option
			if [ -z "$option" ];then
				continue
			elif [ "x$option" == "xq" ]||[ "x$option" == "xQ" ]; then
				return  1
			elif [ $option -gt 0 ] 2>/dev/null && [ $option -le ${count} ]; then
				Choose_value_from_list=${flist[$(($option-1))]}
				break
			else
				echo "Invalid option."	
			fi
		done	
	fi
	return 0
}


UsbPoint=""
function findUsbPoint()
{
        usbdriver=$1
        UsbPoint=""
        files=(`ls $usbdriver*`)

        [ ${#files[@]} -le 1 ]  &&return 1
        for file in ${files[*]}
        do
                UsbPoint=`echo $file|sed 's/[a-z\/]//g'`
                [ -n "$UsbPoint" ] &&return 0
        done
        return 1
}


Usb_mount_dir="$BOOTABLE_STORAGE_DIR"
Usb_choosed=""
function chooseUSB()
{
	ret=${#UsbDevices[@]}
	
	if [ $ret == 0 ];then
		echo "[Failure] Could not find USB."
		return 1
	fi

	echo -e "No.\tDriver-name"
	chooseFromList "${UsbDevices[*]}" "* More than one usb, Enter your option ('q' to quit):" "n"
	[ $? != 0 ]&&return 1
	choose_usb=$Choose_value_from_list
	

	[ -z "$choose_usb" ]&&echo "[Failure] unknown usb."&&return 1
	if echo $choose_usb|grep "(Bootable)" 1>/dev/null 2>&1;then
			Usb_mount_dir="$MOUNT_DIR"
			Usb_choosed="(Bootable)"
	else
			findUsbPoint $choose_usb
			[ $? != 0 ]&&echo "[Failure] Could not find USB driver."&&return 1

			Usb_choosed="($choose_usb)"
			Usb_mount_dir="/usbmount/"
			mkdir -p $Usb_mount_dir 1>/dev/null 2>/dev/null
			umount $Usb_mount_dir 1>/dev/null 2>&1
			eval "mount ${choose_usb}${UsbPoint} $Usb_mount_dir"
			ret=$?
			if [ $ret != 0 ];then
				echo "[Failure] mount USB failed."
				return 1
			fi
	fi
	return 0


}

function SaveToUSB()
{
	chooseUSB
	[ $? != 0 ]&&return 1
	datadir=$Usb_mount_dir"/storage/"$DATA_DIR_NAME
	mkdir -p $datadir 1>/dev/null 2>/dev/null
	eval "cp -fra $SrcFile ${datadir}/"
	ret=$?
	if echo $SrcFile|grep "," 1>/dev/null 2>&1 ;then
		filename=`echo ${SrcFile}|sed -e 's/.*{\(.*\)}/\1/g'`
	else
		filename=`echo ${SrcFile##*/}`
	fi

	if [ $ret == 0 ];then
		
		SaveExportInfo "${filename}" "$Usb_choosed/storage/$DATA_DIR_NAME"
		
		echo -e "[Success] "${filename}" saved in $Usb_choosed/storage/$DATA_DIR_NAME."
		return 0
	else	
		echo -e "[Failure] ${filename} failed to save."
		return 1
	fi
	return $ret
	
}

#load from usb，we should list them, and then choice
#set Choosefile
function LoadFromUSB()
{
	chooseUSB
	[ $? != 0 ]&&return 1
	datadir=$Usb_mount_dir"/storage/"$DATA_DIR_NAME
	files=`ls $datadir 2>/dev/null`
	
	if [ ! -d "$datadir" ]||[ -z "$files" ];then	
		echo "[Failure] Could not find any file in USB."
		return 1
	fi

	files=($files)
	echo ""
	echo -e "No.\tFilename"
	chooseFromList "${files[*]}" "* More than one file be found, Enter your option ('q' to quit):" 
	[ $? != 0 ]&&return 1

	choose_usb=$Choose_value_from_list
	echo "$datadir"/${Choose_value_from_list} >$CHOOSE_FILE
	return 0
}

function IsValidIP()
{
	ip=$1
	if echo $ip|grep "\." >/dev/null 2>&1;then
		if [[ ! $(echo "$ip" | grep -P  '^([01]?\d\d?|2[0-4]\d|25[0-5])\.([01]?\d\d?|2[0-4]\d|25[0-5])\.([01]?\d\d?|2[0-4]\d|25[0-5])\.([01]?\d\d?|2[0-4]\d|25[0-5])$') ]] >/dev/null;then
			return 1
		else
			return 0
		fi
	elif echo $ip|grep ":" >/dev/null 2>&1;then
		return 0
	else
		return 1
	fi
}

function IsIpv6()
{
	ip=$1
	if echo $ip|grep ":" >/dev/null 2>&1;then
		return 0
	else
		return 1
	fi
}
#
function SaveToSFTP()
{
	tdir="$$LOCAL_STORAGE_DATA_DIR"
	tmpfile="${RUN_DIR}/sftpip"
	oldip=`cat $tmpfile 2>/dev/null|grep "ip="|sed -e 's/ip=//g'`
	oldpath=`cat $tmpfile 2>/dev/null|grep "spath="|sed -e 's/spath=//g'`
	loldpath=`cat $tmpfile 2>/dev/null|grep "lpath="|sed -e 's/lpath=//g'`

	if [ -n "$oldip" ];then
		while [ true ]
		do
			read -p "* Enter SFTP IP($oldip):" ip
		
			[ -z "$ip" ]&& ip=$oldip && break
			IsValidIP "$ip"
			[ $? == 0 ]&& break
			echo "Invalid IP address." 
		done
	else
		while [ true ]
		do
			read -p "* Enter SFTP IP:" ip
			[ -z "$ip" ] &&  continue
			IsValidIP "$ip"
			[ $? == 0 ]&& break
			echo "Invalid IP address."
		done
	fi
	echo "ip=$ip" >$tmpfile
	IsIpv6 $ip
	[ $? == 0 ] && ip="\["$ip"\]" 

	
	if [ -n "$oldpath" ];then
		read -p "* Enter SFTP path($oldpath):" path
		[ -z "$path" ]&& path=$oldpath
	else
		while [ true ]
		do
			read -p "* Enter SFTP path:" path
			[ -n "$path" ] && break
		done
	fi

	echo "spath=$path" >>$tmpfile
	echo "lpath=$loldpath" >>$tmpfile
	

	while [ true ]
	do
		read -p "* Enter SFTP username:" username
		[ -n "$username" ] && break
	done
	
	while [ true ]
	do
		read -s -p "* Enter SFTP password:" password
		[ -n "$password" ] && break
	done

	echo

	# echo "scp -o StrictHostKeyChecking=no -q $SrcFile $username@${ip}:${path}/" 2>/dev/null
	eval "sshpass -p $password scp -o StrictHostKeyChecking=no -o HostKeyAlgorithms=+ssh-dss -q $SrcFile $username@${ip}:${path}/" 2>/dev/null
	ret=$?

	if echo $SrcFile|grep "," 1>/dev/null 2>&1 ;then
		filename=`echo "${SrcFile}"|sed -e 's/.*{\(.*\)}/\1/g'`
	else
		filename=`echo ${SrcFile##*/}`
	fi
	if [ $ret == 0 ];then
		SaveExportInfo ${filename} "${ip}:${path}"
		echo "[Success] ${filename} uploaded successfully."
		return 0
	else	
		echo "[Failure] ${filename} failed to upload."
		return 1
	fi

}
#load from sftp, we should specify the full path,and filename
#download it.
#set Choosefile
function LoadFromSFTP()
{
	tdir="$TMP_DIR"
	[ ! -e $tdir ] && mkdir -p $tdir 1>/dev/null 2>&1
	tmpfile="${RUN_DIR}/sftpip"
	oldip=`cat $tmpfile 2>/dev/null|grep "ip="|sed -e 's/ip=//g'`
	soldpath=`cat $tmpfile 2>/dev/null|grep "spath="|sed -e 's/spath=//g'`
	oldpath=`cat $tmpfile 2>/dev/null|grep "lpath="|sed -e 's/lpath=//g'`

	if [ -n "$oldip" ];then
		while [ true ]
		do
			read -p "* Enter SFTP IP($oldip):" ip
		
			[ -z "$ip" ]&& ip=$oldip && break
			IsValidIP "$ip"
			[ $? == 0 ]&& break
			echo "Invalid IP address." 
		done
	else
		while [ true ]
		do
			read -p "* Enter SFTP IP:" ip
			[ -z "$ip" ] &&  continue
			IsValidIP "$ip"
			[ $? == 0 ]&& break
			echo "Invalid IP address."
		done
	fi
	echo "ip=$ip" >$tmpfile
	IsIpv6 $ip
	[ $? == 0 ] && ip="\["$ip"\]" 
	
	askinfo="* Enter SFTP path with filename"
	
	echo "[Warnning] Do not support that SFTP path is a directory."
	if [ -n "$oldpath" ];then
		read -p "$askinfo($oldpath):" path
		[ -z "$path" ]&& path=$oldpath
	else
		while [ true ]
		do
			read -p "$askinfo:" path
			[ -n "$path" ] && break
		done
	fi
	echo "spath=$soldpath" >>$tmpfile
	echo "lpath=$path" >>$tmpfile
	

	while [ true ]
	do
		read -p "* Enter SFTP username:" username
		[ -n "$username" ] && break
	done
	
	filename=`echo ${path##*/}`
	downloadpath="$tdir/$filename"
	[ -e $downloadpath ] && rm -f $downloadpath 1>/dev/null 2>&1
#	echo "scp -o \"StrictHostKeyChecking no\" -rq $username@${ip}:${path} $tdir/ "
	eval "scp -o 'StrictHostKeyChecking no' -q $username@${ip}:${path} $tdir/" 2>/dev/null
	
	[ $? != 0 ]&& echo "[Failure] Fail to download $path." && return 1

	# if [ -d "$downloadpath" ];then
	# 	echo "You select a directory."
	# 	flist=`ls $downloadpath 2>/dev/null`
	# 	[ -z "$flist" ] && echo "No file could be find in the directory."&&rm -fr $downloadpath 1>/dev/null 2>&1 && return 1
	# 	chooseFromList "${flist[*]}" "* More than one file be found, Enter your option ('q' to quit):"
	# 	[ $? != 0 ] && return 1
	# 	cp -f $downloadpath/$Choose_value_from_list $tdir/ 1>/dev/null 2>&1
	# 	echo "$tdir/$Choose_value_from_list" >$CHOOSE_FILE	

	# 	rm -fr $downloadpath 1>/dev/null 2>&1
		
		
	# else	
	echo "$downloadpath" > $CHOOSE_FILE
	# fi
	return 0

}

function chooseMethod()
{
	dofunc=$1
	echo ""
	echo "Target location"
	echo -e "1\tUSB"
	echo -e "2\tSFTP"
	while [ true ]
	do
		read -p "* Enter your choice('Q' to QUIT):" ans
		[ -z "$ans" ]&&continue
		if [ "x$ans" == "x1" ];then
			echo ""
			${dofunc}"USB"
			return $?
		elif [ "x$ans" == "x2" ];then
			echo ""
			${dofunc}"SFTP"
			return $?
		elif [ "x$ans" == "xq" ]||[ "x$ans" == "xQ" ]; then
			return 10
		else
			echo "Invalid input."
		fi
	done

}

	

function emptyDir()
{
	sdir=$1
	[ ! -d $sdir ] && return 0
	emp=0
	for f in `ls $sdir`
	do
		emp=1
		break
	done
	return $emp
}



function chooseFromLocal()
{
	echo ""
	echo -e "No.\tSaved to"
	for ((i=0;i<${#ExportFiles[@]};i++))
	do
		echo -e "$(($i+1))\t${ExportPaths[$i]}/${ExportFiles[$i]}"
	done
	let i=i+1
	echo -e "${i}\t<external>"
	echo ""
	while [ true ]
	do
		read -p "* Enter your option ('q' to quit):" option
		if [ -z "$option" ];then
			continue
		elif [ "x$option" == "xq" ]||[ "x$option" == "xQ" ]; then
			return  1
		elif [ $option -eq ${i} ]; then
			return 2
		elif [ $option -gt 0 ] 2>/dev/null && [ $option -lt ${i} ]; then
			Choose_value_from_list=${ExportFiles[$(($option-1))]}
			echo "$LOCAL_STORAGE_DATA_DIR/$Choose_value_from_list">$CHOOSE_FILE
			return 0
		else
			echo "Invalid option."	
		fi
	done	
	

	return 0
} 

detectusb
if [ "x$1" == "xsave" ];then
	dofunc="SaveTo"
	SrcFile=$2
	ret=0
	while [ true ]
	do
		chooseMethod $dofunc
		ret=$?
		if [ $ret == 10 ] || [ $ret == 0 ];then
			break
		fi
	done
	exit $ret
else
	dofunc="LoadFrom"
	LoadExportInfo
	if [ ! -e  $ExportInfoFile ] || [ "${#ExportFiles[*]}" == 0 ];then
		chooseMethod $dofunc
	else
		chooseFromLocal
		case $? in
		0):
			exit 0 
			;;
		1):
			exit 1
			;;
		2):
			chooseMethod $dofunc
			exit $?
		
		esac
	fi
fi
exit $?
