// Copyright © 2019 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
var UpdateSelection = function() {
	var ac_content_index = 0;
	var ac_isNew_content = true;
	var ac_current_content_count = 0;
	var ac_content_count = 0;
	var ac_canceled = false;
	var ac_moving_contentIndex;
	var ac_beginCount = 0;
	var ac_timeout = 0;
	var strDate;

	var errCode = 0;

	//record the error occured in one package
	var wrong = 0;
	var isContinue = false;

	var ibmMtArr = new Array();
	var lenovoMtArr = new Array();

	//buffer the html element frequently refered
	var _doc = document;
	var _details = _doc.getElementById("details_selection");
	header = ["", "Component", "Update ID", "Release Date"];

	// if any system has been selected
	// var sysSelected = false;

	var in_process_index = "";
	var in_process_rows_index = [];

	var table_names = new Array();

	Array.prototype.indexOf = function(e) {
		for (var i = 0; i < this.length; i++) {
			if (this[i] == e)
				return i;
		}
		return -1; 
	};
	
	Array.prototype.add = function(val) {
		var index = this.indexOf(val);
		if (index == -1) {
			this.push(val); 
		}
	};

	Array.prototype.remove = function(val) {
		var index = this.indexOf(val);
		if (index > -1) {
			this.splice(index, 1); 
		}
	};

	function gui_log(text) {
	    top.writeTextFile(top.guilogInfo, "\n\t" + text + "\n\t", true);
	}

	function mtArrSort() {
		ibmMtArr = [];
		lenovoMtArr = [];
		for (var i = 0; i < top.mtArray.length; i++) {
			lenovoMtArr.push(top.mtArray[i]);
		}
		top.mtArray = ibmMtArr;
		top.mtArray = top.mtArray.concat(lenovoMtArr);
	}

	function checkOverwrite()
	{
		if(top.isForce == true)
		{
			top.configTag["IBM_SYSTEM_FORCE_OVERWRITE"] == "";  
		}

		if(createISOFile == true)
		{
			if(engineTop.secureFileExists(top.isoFile))
			{
				// ISO file already exists in working directory
				if(confirm("Are you sure you want to overwrite " + top.isoFile + "?"))
				{
					top.isForce = true;
					return true;
				}
				else
				{
					alert("Please go back to \"Media Format\" and assign another name for the ISO file");
					return false;
				}
			}
			else
			{
				return true;
			}
		}
		else if(createPXEFile == true)
		{
			var pxeKeyFile = "";
			if (top.OSTYPE == "windows")
			{
				if(top.pxeFile.lastIndexOf("\\") == top.pxeFile.length-1)
				{
					pxeKeyFile = top.pxeFile + "pxelinux.0";
				}
				else
				{
					pxeKeyFile = top.pxeFile + "\\pxelinux.0";
				}                  
			}
			else
			{
				if(top.pxeFile.lastIndexOf("/") == top.pxeFile.length-1)
				{
					pxeKeyFile = top.pxeFile + "pxelinux.0";
				}
				else
				{
					pxeKeyFile = top.pxeFile + "/pxelinux.0";
				}
			}

			var pxeExisted = engineTop.secureFileExists(pxeKeyFile);
			if (pxeExisted)
			{
				if (confirm("Are you sure you want to overwrite " + top.pxeFile + "?"))
				{
					top.isForce = true;
					return true;
				}
				else
				{
					alert("Please go back to \"Media Format\" and assign another direcotry for pxe creation");
					return false;
				}
			}
			else
			{
				return true;
			}
		}
		else
		{
			//create usb or burn to device
			return true;
		}
	}

	function progressInit() {
		ac_timeout = 20 * 1000;
	    if (!top.isForce) {
			if(!checkOverwrite())
			{
				return;
			}
	    }

		if(top.use_Intel_RSTe_RAID_Configuration)
		{
			top.writeConFiles(
				top.workingdirProgram
				+(top.workingdirProgram.lastIndexOf(FILE_SEPARATOR) == top.workingdirProgram.length-1?"":FILE_SEPARATOR)
				+"configfiles");
		}

		in_process_index = "";
		in_process_rows_index.splice(0,in_process_rows_index.length);

		mtArrSort();

		_doc = document;
		_details = _doc.getElementById("details_selection");
		$("#details_selection").empty().hide();
		$("#comMsg").hide();
		$("#beginBtnCom").hide();
		$("#cplMsgSel").hide();
		$("#warnMsg").hide();
		$("#errorMsg").hide();
		header = ["", "Component", "Update ID", "Release Date"];
		top.toggleNext(false);
		top.isBomcRunning(killBomcConfirm);
	}

	function killBomcConfirm(success) {
		if (success) {
			var confirmKill = confirm("Another running bomc is detected. If you want to continue this program, the running one need to be killed. Are you sure to kill it and continue now? ");
			if (confirmKill) {
				top.killAsync(top.mainAppName, killBomcCB);
			} else {
				$("#beginBtnCom").show();
				return false;
			}
		} else {
			ac_init();
		}
	}

	function killBomcCB(success) {
		if (success) {
			ac_init();
		} else {
			$("#beginBtnCom").show();
			return false;
		}
	}

	function ac_init() {
		ac_reload();
		beginAcq(_doc.getElementById("beginBtnCom"));
	}

	//refresh Aquire_Updates.html
	function ac_reload() {
		$("#details_selection").empty().hide();
		$("#comMsg").hide();
		$("#cplMsgSel").hide();
	    $("#comMsg2").html("Comparing updates. . .");
	    $("#comMsg1").html("...").hide();
		$("#beginBtnCom").show();
		ac_content_index = 0;
		ac_isNew_content = true;
		ac_current_content_count = 0;
		ac_content_count = 0;
		ac_moving_contentIndex;
		strDate;
		ac_beginCount = 0;

		errCode = 0;

		wrong = 0;
		isContinue = false;
		table_names = new Array();
		
		_doc = document;
		_details = _doc.getElementById("details_selection");
		header = ["", "Component", "Update ID", "Release Date"];

		progressMainAppIsRunning = false;

		// sysSelected = false;

	    top.toggleNext(false);
	}

	function store_bomc_command(args) {
		top.bomcCommandArray.length = 0;
		top.bomcCommandArray = args.slice();

		var patt1 = new RegExp("--password=");
		var patt2 = new RegExp("--proxy-password=");
		var patt3 = new RegExp("bomc.exe|bomc.bin");

		// hidden passowrd.
		// hidden absolute path of BoMC
		for (var i=0; i<args.length; i++) {
			if (patt1.test(args[i])) {
				top.bomcCommandArray[i] = "--password=***";
			} else if (patt2.test(args[i])) {
				top.bomcCommandArray[i] = "--proxy-password=***";
			} else if (patt3.test(args[i])) {
				top.bomcCommandArray[i] = "<LXCE BoMC>";
			}
		}

		// remove proxy script
		top.bomcCommandArray.shift()

		// remove '--xml' parameter, it is only for GUI usage
		var index = top.bomcCommandArray.indexOf("--xml");
		if (index > -1) {
			top.bomcCommandArray.splice(index, 1);
		}
	}

	function uxsp_acquire() {
	    var args = new Array();
	    if (top.OSTYPE == "windows") {
	        args.push("..\\proxy.bat");
	        args.push(top.workingdir + "\\" + top.mainAppName);
	    } else {
	        args.push("../proxy.sh");
	        args.push(top.mainAppName);
	    }

	    top.program = top.program.replace("uxspi", "UPDATE");

	    if (top.selectedOSMachineType.indexOf("storage") != -1) {
	    	args.push('--function=jbod');
	    } else {
	    	args.push('--function=' + top.program.toLowerCase());
	    }

		if (top.selectedOSMachineType.indexOf("storage") == -1) {
			if (!top.isRebootBmc)
			{
				args.push('--noreboot');
			}
			if (top.strUnattdCfgFullStr != "" && top.strUnattdCfgFullStr != "NULL" && top.strUnattdCfgFullStr!= undefined) {
				args.push("--unattended=" + top.strUnattdCfgFullStr);
				if (top.after_updating_firmware == "Noaction")
				{
					args.push("--noshutdown");
				}
				else if (top.after_updating_firmware == "Reboot")
				{
					args.push("--rebootos");
				}
				if (top.strUnattdUseUserName)
				{
					if (top.OSTYPE == "windows") {
						args.push("--password=" + "\"\"" + top.strUnattdCfgPassword + "\"\"");
					} else {
						args.push("--password=" + "\"" + top.strUnattdCfgPassword + "\"");
					}
				}
		    }
		}

	    var mt = "";
	    for (var i=0; i<top.mtArray.length; ++i) {
	        if (i==0) {
	            mt = top.mtArray[i];
	        } else {
	            mt = mt + "," + top.mtArray[i];
	        }

	    }

	    if (top.selectedOSMachineType.indexOf("storage") == -1) {
			if (mt != "" && mt != undefined && mt != null) {
				args.push("--machine-type=" + mt);
			}
	    }
		//	args.push("--bootenv=" + top.bootEnv);
		if (top.selectedOSMachineType.indexOf("storage") == -1) {
			if (top.autorun != "NULL") {
				args.push("--autorun");
			}
		}
	    
	    if (top.mediaFormat == 1) {
	        if (top.usbKeyVolume != "" ) {
	            args.push("--usbkey=" + top.usbKeyVolume);
	        }
	    } else if (top.mediaFormat == 2) {
	        if (top.pxeFile != "") {
	            if (top.OSTYPE == "windows") {
	                var lastChar = top.pxeFile.charAt(top.pxeFile.length - 1);
	                if (lastChar == "\\") {
	                    top.pxeFile = top.pxeFile.substring(0, top.pxeFile.length - 1);
	                }
					args.push("--pxe");
					args.push( top.pxeFile );
	            } else {
	                args.push("--pxe=" + top.pxeFile);
	            }
	            if (top.pxeTFTPAddress != "") {
	                args.push("--tftp-pxe-address=" + top.pxeTFTPAddress);
	            }
	        }
	    } else {
	        if (top.isoFile != "") {
	            if (top.OSTYPE == "windows") {
					
					args.push("--iso");
					args.push( top.isoFile );
	            } else {
	                args.push("--iso=" + top.isoFile);
	            }
	        }
	    }
		if (top.copy_ram_disk) {
			args.push("--copytoramdisk");
		}

	    if (top.isForce) {
	    	args.push("--force");
		}
		
		if (top.useAdditionalCaCertFile) {
			args.push("--cacert=" + top.additionalCaCertFile);
		}

		if (top.url_custom) {
			if (top.url_insecure) {
				args.push("--insecure");
			} else if (top.url_specify_cert) {
				if (top.urlCustomCaCertFile != "" && top.urlCustomCaCertFile != null) {
					args.push("--cacert");
					args.push(top.urlCustomCaCertFile);
				}
			}
		}

	    if (top.useProxy) {
	    	if (top.proxyAdd != "" && top.proxyAdd != null && top.proxyAdd != undefined && top.proxyPort != "" && top.proxyPort != null && top.proxyPort != undefined) {
				if (top.proxyType == "https" ||
					top.proxyType == "socks4" ||
					top.proxyType == "socks4a" ||
					top.proxyType == "socks5" ||
					top.proxyType == "socks5h") {
					args.push("--proxy-address=" + top.proxyType + "://" + top.proxyAdd);
				} else {
					args.push("--proxy-address=" + top.proxyAdd);
				}
	    		args.push("--proxy-port=" + top.proxyPort);
	    	}
	    	if (top.useProxyAuth) {
	    		if (top.proxyUid != "" && top.proxyUid != null && top.proxyUid != undefined) {
	    			args.push("--proxy-user=" + top.proxyUid);
	    		}
	    		if (top.proxyPwd != "" && top.proxyPwd != null && top.proxyPwd != undefined) {
	    			args.push("--proxy-password=" + top.proxyPwd);
	    		}
			}

			if (top.proxy_insecure) {
				args.push("--proxy-insecure");
			} else {
				if (top.proxy_specify_cert) {
					if (top.proxyCaCertFile != "" && top.proxyCaCertFile != null) {
						args.push("--proxy-cacert");
						args.push(top.proxyCaCertFile); 
					}
				}
			}
	    }
	    
	    if (top.OSTYPE == "windows") {
	        var lastChar = top.workingdirProgram.charAt(top.workingdirProgram.length - 1);
	        if (lastChar == "\\") {
	            top.workingdirProgram = top.workingdirProgram.substring(0, top.workingdirProgram.length - 1);
	        }
	        // args.push("\"" + "--local=" + top.workingdirProgram + "\"");
	        args.push("-l");
	        args.push(top.workingdirProgram );
	    } else {
	        // args.push("--local=" + top.workingdirProgram);
	        args.push("-l");
	        args.push(top.workingdirProgram);
	    }
	    args.push("--xml");
	    if (top.selectedOSMachineType.indexOf("storage") != -1) {
	    	if (!top.acquireToolOnly) {
	    		args.push('--no-acquire');
	    	}
	    } else {
			if (top.latest) {
				args.push("--latest");
			}
	    }

	    if (top.OSTYPE == "windows") {
	        if (top.mediaLabel == "") {
				args.push("--description=" + "\"" + " " + "\"");
	        } else {
				args.push("--description");
				args.push( top.mediaLabel );
	        }
	    } else {
	        if (top.mediaLabel == "") {
	            args.push("--description=" + " ");
	        } else {
	            args.push("--description=" + top.mediaLabel);
	        }
	    }

	    // Add for preview 
            setPreviewParams(args);
            store_bomc_command(args);

	    progressMainAppIsRunning = true;
	    secureRunProgram(null, args, BACKGROUND, HIDDEN, null, progessCallback);
	}

	function progessCallback() {
		progressMainAppIsRunning = false;
	}

	function beginAcq(ref) {
	    top.togglePrevious(false);
		$("#comMsg").show();
		ref.style.display = "none";
		_details = _doc.getElementById("details_selection");
		_details.innerHTML = "";
		_details.style.display = "block";

	    ac_canceled = false;
	    //Preparation
	    deleteFile(top.gl_ac_result);
	    //deleteFile_ux(top.gl_common_result);
	    deleteFile(top.guilogInfo);
	    deleteFile(top.cliErrorMsg);
		uxsp_acquire();
		
		createAllContents();
		setTimeout(showStatus_ac,1000);
	}

	function ac_cancel() {
	    ac_canceled = true;
	    killApp_ux(top.mainAppName);
		ac_reload();
	    top.togglePrevious(true);
	}


	function killApp_ux(appName) {
	    var args = new Array();
	    args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
	    args.push("--kill");
	    args.push(appName);
	    args.push("--file");
	    args.push(top.bomc_gui);
	    return secureRunProgram(null, args, FOREGROUND, HIDDEN);
	}

	function confirmContinue(warningMsg) {
	    if (isContinue == false) {
	        var msg = warningMsg + "\nAre you sure you want to continue?";
	        var answer = "STOP";
	        if (confirm(msg)) {
	            isContinue = true;
	            answer = "";
			}
	        top.writeTextFile(top.CONFIRM_CONTINUE_FILE, answer, false);
	    }
	    return isContinue;
	}

	function showStatus_ac() {
	    strDate = Date();
	    gui_log(strDate + " showStatus_ac in");
	    if (ac_canceled == true) {
	        return;
	    }
		
		getCLIErrorCode(); 

		if (errCode >= 100) {
	        complete(0, errMsg);
	        return;
	    }

        if (!top.fileExists(top.gl_ac_result) && progressMainAppIsRunning) {
        	_doc.getElementById("comMsg2").innerHTML = "Connecting . . .";
			setTimeout(showStatus_ac,1000);
			ac_timeout -= 1000;
			if (ac_timeout < 0) {
				confirmContinue("There was no response from server.\nPlease check the network status.");
				ac_cancel();
			}
            return;
        }

    	if (!top.fileExists(top.gl_ac_result) || !progressMainAppIsRunning) {
            if (errCode >= 100 && errCode < 256) {
            	//cli return error
                //clearInterval(ac_progress_timer);
                complete(0);
                return;
			} else {
               	errCode = 0;
                errMsg="bomc process error";
               	complete(errCode);
               	return;
            }
        }

	    var doc = top.readTextFile(top.gl_ac_result);

        var dom = ezJsLib.XmlDom.parse(doc);
        //doc is not null but dom is null
        if (dom == null) {
            setTimeout(showStatus_ac,1000);
            return;
        }
        var content = ezJsLib.XmlDom.getNodeByTagAndIndex("CONTENT", dom, ac_content_index);
        if (content == null) {
            //refresh the progress bar
            _updateProgress(content);
            if (!progressMainAppIsRunning) {
                //clearInterval(ac_progress_timer); 
                //stop the timer
                complete(0);
                return;
            }
            setTimeout(showStatus_ac,1000);
            return;
        }
		
        var mt = ezJsLib.XmlDom.getValueByTagFromNode("MT", content);
        var needErrorConfirm = false;
        if (mt.toLowerCase() != "tool") {
        	needErrorConfirm = true;
        }
        var os = ezJsLib.XmlDom.getValueByTagFromNode("OS", content);
        var total = parseInt(ezJsLib.XmlDom.getValueByTagFromNode("TOTAL", content));
		var index = "";
		if(os == "RHEL 7 x64"){
			index = (mt + unifyOS("RHEL 7")).toLowerCase();
		} else if (os == "platform"){
			index = (mt + unifyOS("platform")).toLowerCase();
		} else {
			index = (mt + unifyOS(os)).toLowerCase();
		}
		in_process_index = index;
        //update content coming...

        if (mt == "all" || (mt == "undefined" && os == "NONE")) { //get fixIds list or invalid mt and os
            setTimeout(showStatus_ac,1000);
            return;
        }

        _doc.getElementById("comMsg1").style.display = "block";
        _doc.getElementById('cancelBtn').style.marginLeft = (top.BROWSER == "IExplore") ? "44" : "36" + "px";
        
        
        if (ac_isNew_content) {	
            wrong = 0;
            
			updateTotal(index, total);
			ac_beginCount = 0;
			ac_current_content_count = total;
            
            if (total > 0) {						
                showPlusIcon(index);
                updateTitle(index, "Acquiring");
                var table = null;
                if(ac_beginCount==0) {
					var cb = "<input type='checkbox' name='checkbox' value='" + index + "' id='content_checkbox" + index + "' onclick='UpdateSelection.selectContent(this)' checked>";
					header[0] = cb;
					table = createTable(index, false);
					table_names.push(index);
                } else {
                	table = _doc.getElementById("table" + index);
                }
                
                for (var i = 0; i < total; i++) {
                    //default consider that its a full xml file, including all nodes
                    var component = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("COMPONENT", content, i);
					var updateId = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("UPDATEID", content, i);
					var description = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("DESCRIPTION", content, i);
					var releaseDate = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("RELEASEDATE", content, i);

                    //add a new row
					var newRow = table.insertRow(-1);
					
					var newCell0 = newRow.insertCell(-1);
					newCell0.innerHTML = "<input type=\"checkbox\" name=\"checkbox\" value=\"" + updateId + "\" id=\"su_checkbox" + ac_content_index + '_' + i + "\"checked>";
					newCell0.className = "EntityTableCell";
					newCell0.align = "center";

					var newCell1 = newRow.insertCell(-1);
                    if (component == "Undefined" || component == "null")
                        component = "UXSP";
                    newCell1.innerHTML = component;
                    newCell1.title = component;
                    newCell1.className = "EntityTableCell";

                    var newCell2 = newRow.insertCell(-1);
                    newCell2.innerHTML = updateId;
                    newCell2.title = description.replace(/ \(InstallXML\)/g, "");
                    newCell2.className = "EntityTableCell";

		    var newCell3 = newRow.insertCell(-1);
		    newCell3.innerHTML = releaseDate;
		    newCell3.title = releaseDate;
	            newCell3.className = "EntityTableCell";

                    ac_isNew_content = false;
                }
            } else {
                updateTitle(index, "None");
                ac_isNew_content = true;
                //start parsing new content
                ac_content_index++;
            }
        } else {
            var package_finished_count = ac_beginCount;
            console.log("PACKAGE_FINISHED_COUNT="+package_finished_count);
            for (var i = 0; i < total; i++) {
                var statusValue = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("STATUS", content, i);
                if (statusValue.toLowerCase().indexOf('already download') != -1) {
					package_finished_count++;
					in_process_rows_index.remove(1 + ac_beginCount + i);
                } else if (statusValue.toLowerCase().indexOf('acquiring') != -1) {
					in_process_rows_index.add(1 + ac_beginCount + i);
					/*
                    * If the cli exits abnormally when downloading, the status of the UXSP will be always "acquiring",
                    * and the status on the xml won't be changed.
                    * In this case, what we need to do is to just traverse the xml file.
                    */
                    if (!progressMainAppIsRunning) {
                        wrong++;
						package_finished_count++;
						in_process_rows_index.remove(1 + ac_beginCount + i);
                    }
                } else if (statusValue.toLowerCase().indexOf('done') != -1) {
					package_finished_count++;
					in_process_rows_index.remove(1 + ac_beginCount + i);
                } else if (statusValue.toLowerCase().indexOf('error') != -1) {
                    wrong++;
					package_finished_count++;
					in_process_rows_index.remove(1 + ac_beginCount + i);

                    if(needErrorConfirm && wrong > 0){
                        if(confirmContinue("some update files are missed  ")){
							$('#su_checkbox' + ac_content_index + '_' + i).attr('disabled', true);
							$('#su_checkbox' + ac_content_index + '_' + i).attr('checked', false);
                        } else {
                            ac_cancel();
                        }
                    }
                } else {
                    if (!progressMainAppIsRunning) {
                    	package_finished_count++;
                    }
                }
        	}
        
	        //finished downloading one package
	        if (package_finished_count == ac_current_content_count) {
	            if(wrong==ac_current_content_count){
	                updateTitle(index, "Error");
	                if(top.program.indexOf("UPDATE") != -1&&ac_content_index==1){
	                    complete(0);
	                }
	            }
	            else if(wrong==0){
					updateTitle(index, "Done");
					in_process_index = "";
	            }
	            else {
					updateTitle(index, "Warning");
					in_process_index = "";
	            }
	            ac_isNew_content = true;
	            //start parsing new content
	            ac_content_index++;
	        }
	    }
	    _updateProgress(content);

	    //Even when uxspi300_cli.exe has quited, the page will still remain incomplete because of the I/O delay for writing/reading xml file
        if (ac_content_index == ac_content_count) { //all statuses in ac_result.xml are "Done" or "Already Downloaded	
            //It's a little hard to handle all kinds of errors here.
            if ((errCode >= 100 && errCode < 256) || !progressMainAppIsRunning) {
                //exit abnormally
                //cli errors occurred
                complete(0);
                return;
            } else {
                complete(1);
                return;
            }
        }
	    
	    setTimeout(showStatus_ac,1000);
	}


	function _updateProgress(content) {
	    //gui_log("_updateProgress in");
	    if (content == null) {
	        //if content is null, restore the package downloading progress bar to zero
	        _doc.getElementById("meterValue").style.marginRight = "100%";
	        _doc.getElementById("comMsg2").innerHTML = "Comparing now, please wait...";
	        return;
	    }

	    var packages = content.getElementsByTagName("PACKAGE");
	    var machineType= ezJsLib.XmlDom.getValueByTagFromNode("MT", content);
	    var total = ezJsLib.XmlDom.getValueByTagFromNode("TOTAL", content);
	    var currentUpdateId = ezJsLib.XmlDom.getValueByTagFromNode("CURRENTUPDATEID", content);
	    var currentUpdateIdIndex = -1;
	    for (var i = 0; i < total; i++) {
	        var updateId = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("UPDATEID", content, i);
	        if (updateId == currentUpdateId)
	            currentUpdateIdIndex = i;
	    }
	    if (currentUpdateIdIndex == -1)
	        return;

	    if (packages.length == 0) {
	        _doc.getElementById("comMsg2").innerHTML = "Comparing now, please wait...";
	        _doc.getElementById("comMsg1").innerHTML = formatData(ac_content_index / ac_content_count * 100) + "% completed";
	        if (machineType == "Tool" || machineType== "VMWARE ESXi Updates" || machineType == "Requisite Package") {
	            _doc.getElementById("comMsg1").innerHTML = formatData(ac_content_index / ac_content_count * 100) + "% completed";
	        } else {
	            if (confirmContinue("No applicable updates available") == false) {
	                ac_cancel();
	            } else {
	                _doc.getElementById("comMsg1").innerHTML = formatData(ac_content_index / ac_content_count * 100) + "% completed";
	            }
	        }
	        return;
	    }

	    //progress of contents...
	    if (ac_content_index < ac_content_count) {
	        _doc.getElementById("comMsg1").innerHTML = formatData(ac_content_index / ac_content_count * 100) + "% completed";
	    }

	}

	function formatData(input) {
	    var per = input.toString();
	    if (parseFloat(input) < 0) {
	        per = 0;
	    } else if (per.indexOf(".") > 0) {
	        per = per.substring(0, per.indexOf(".") + 3);
	    }
	    return per;
	}

	function selectContent(ref) {
		var index = ref.id.substring("content_checkbox".length);
		var checkboxes = _doc.getElementById(TABLE_PRE + index).getElementsByTagName("input");
		for (var i = 1; i < checkboxes.length; i++) {
			if (!checkboxes[i].disabled) {
				checkboxes[i].checked = ref.checked;
			}
		}
	}

	//if downloads finished, execute this
	function complete(c) {
		$("#comMsg").hide();
	    switch (c) {
	    case 0:			//error when acquiring
			$("#errorMsg").show();
		    _doc.getElementById("errorMsg2").innerHTML = "Error(s) occur while downloading xml files!";
	        //stop the cli process if it's still running
	        if (progressMainAppIsRunning) {
	            killApp_ux(top.mainAppName);
			}
			else if(in_process_index != "") {
				updateTitle(in_process_index, "Error");
			}
	        top.togglePrevious(true);
	        break;
	    case 1:
			$("#cplMsgSel").show();
			updateReleaseDate(); // before display success, update releaseDate
			_doc.getElementById("cplMsgSel2").innerHTML = "Success.";
			top.togglePrevious(true);
			top.toggleNext(true);
	        break;
		}
	}

	function getCLIErrorCode() {
	    var cliErrorMsgFile;
		var errDom;
		if (!top.fileExists(top.cliErrorMsg)) {
			return;
		}

		cliErrorMsgFile = top.readTextFile(top.cliErrorMsg);

		if (cliErrorMsgFile) {
			errCode = 0;
			errDom = ezJsLib.XmlDom.parse(cliErrorMsgFile);
			errMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", errDom.documentElement);
			errCode = ezJsLib.XmlDom.getValueByTagFromNode("CODE", errDom.documentElement);
			stepSN = ezJsLib.XmlDom.getValueByTagFromNode("STEPSERIAL", errDom.documentElement);
		}
	}

	function open_no_uxsp_url() {
		var  sWidth  = 500;
	    var  sHeight = 200;
	    var  l = ( screen.availWidth - sWidth ) / 2;
	    var  t = ( screen.availHeight- sHeight) / 2;
	    var  style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
	    var  loc   = ',left='+l+',top='+t+',width='+sWidth+',height='+sHeight;
	    // window.open(findFile(null, 'noUpdates.html'),  '', style+loc);
	    window.open("../bomc/content/no_uxsp_updates.html",  '', style+loc);
	}

	function open_no_indiv_url() {
		var  sWidth  = 500;
	    var  sHeight = 200;
	    var  l = ( screen.availWidth - sWidth ) / 2;
	    var  t = ( screen.availHeight- sHeight) / 2;
	    var  style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
	    var  loc   = ',left='+l+',top='+t+',width='+sWidth+',height='+sHeight;
	    // window.open(findFile(null, 'noUpdates.html'),  '', style+loc);
	    window.open("../bomc/content/no_indiv_updates.html",  '', style+loc);
	}

	function openNoRequisiteURL() {
	    var  sWidth  = 500;
	    var  sHeight = 200;
	    var  l = ( screen.availWidth - sWidth ) / 2;
	    var  t = ( screen.availHeight- sHeight) / 2;
	    var  style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
	    var  loc   = ',left='+l+',top='+t+',width='+sWidth+',height='+sHeight;
	    // window.open(findFile(null, 'noRequisite.html'),  '', style+loc);
	    window.open("../bomc/content/noRequisite.html",  '', style+loc);
	}

	function openNoSEPsURL() {
	    var  sWidth  = 500;
	    var  sHeight = 200;
	    var  l = ( screen.availWidth - sWidth ) / 2;
	    var  t = ( screen.availHeight- sHeight) / 2;
	    var  style = 'resizable=no,toolbar=no,status=no,menubar=no,personalbar=no,location=no,directories=no,titlebar=no,scrollbars=no,close=yes,show=true';
	    var  loc   = ',left='+l+',top='+t+',width='+sWidth+',height='+sHeight;
	    // window.open(findFile(null, 'noSEPpkgAvailable.html'),  '', style+loc);
	    window.open("../bomc/content/noSEPpkgAvailable.html",  '', style+loc);
	}

	/**
	 * update 'total' parameter in content title
	 */
	/*Style: 'resizable,toolbar,status,menubar,personalbar,location,directories,titlebar,close,scrollbars'*/
	function updateTotal(index, total) {
	    var  spans = _doc.getElementById(TITLE_PRE + index).getElementsByTagName("span");

	    if (total == 0) {
	        if ((index.indexOf("vmware esxi updates") != -1)) {
	            spans[0].innerHTML = "(No packages available)";
	        } else if (index.indexOf("tool") != -1) {
	            spans[0].innerHTML = "(No update packages required. <a href=\"javascript:void 0\" onclick=UpdateSelection.openNoSEPsURL()> Details...</a>)"
	        } else if (index.indexOf("requisite package") != -1) {
	            spans[0].innerHTML = "(No additional requisite required <a href=\"javascript:void 0\" onclick=UpdateSelection.openNoRequisiteURL()> Details...</a>)"
	        } else {
	            if (top.latest) {
	                spans[0].innerHTML = "(No applicable Individual Updates for this system! <a href=\"javascript:void 0\" onclick=UpdateSelection.open_no_indiv_url()> Details...</a>)";
	            } else {
	                spans[0].innerHTML = "(No applicable UXSP for this system! <a href=\"javascript:void 0\" onclick=UpdateSelection.open_no_uxsp_url()> Details...</a>)";
	            }
	        }
	    } else
	        spans[0].innerHTML = total + " update(s)";
	}



	/**
	 * before any download begins, show all the waiting contents first.
	 */
	function createAllContents() {
		for (var i = 0; i < ibmMtArr.length; i++) {
			var mt = ibmMtArr[i];
			var os = "RHEL 6 x64";
			var type = "Updates";
			var index = (mt + os).toLowerCase();
			createContentSel("", mt, type, index);
			++ac_content_count;
		}
		for (var i = 0; i < lenovoMtArr.length; i++) {
			var mt = lenovoMtArr[i];
			var os = "platform";
			var type = "Updates";
			var index = (mt + os).toLowerCase();
			createContentSel("", mt, type, index);
			++ac_content_count;
		}
	}




	/*
	 * 1234.56 -> 1,234.56
	 */
	function formatNumberWithComma(input) {
	    var str = "", value = input.toString();
	    var dotPos = value.indexOf(".");
	    var integer = dotPos > -1 ? value.substring(0, dotPos) : value;
	    var dicemal = dotPos > -1 ? value.substring(dotPos) : "";
	    var chars = top.trim(integer).split("");
	    for (var i = chars.length - 1; i > -1; i--) {
	        str = chars[i] + str;
	        if ( (chars.length - i) % 3 == 0 && i != 0) {
	            str = "," + str;
	        }
	    }
	    return str + dicemal;
	}

	function progressPreviousAction() {
		ac_cancel();
		top.toggleNext(true);
	}

	function su_collect() {
		top.gl_selected_list = new Map();
		top.ibm_requisite = false;
		top.lenovo_requisite = false;
		for(var table_index = 0; table_index < table_names.length; ++table_index)
		{
			var checkboxes = _doc.getElementById(TABLE_PRE + table_names[table_index]).getElementsByTagName("input");
			var gl_selected_list_child = new Array();
			for (var i = 1; i < checkboxes.length; ++i) {
				if(checkboxes[i].checked) {
					gl_selected_list_child.push(checkboxes[i].value);
				}
			}
			if(gl_selected_list_child.length > 0)
			{
				top.gl_selected_list.set(table_names[table_index],gl_selected_list_child);
				if(table_names[table_index].indexOf("platform") == -1 && table_names[table_index].indexOf("lenovo") == -1)
				{
					top.ibm_requisite = true;
				}
				else
				{
					top.lenovo_requisite = true;
				}
			}
		}
		if (top.gl_selected_list.size < 1){
			alert("Select one or more package(s)!");
			return false;
		}
		return true;
	}

	function updateReleaseDate() {
	
		if (!top.fileExists(top.gl_ac_result)) {
           	return;    
        }

	    var doc = top.readTextFile(top.gl_ac_result);
		var dom = ezJsLib.XmlDom.parse(doc);
		var contents = dom.documentElement.getElementsByTagName("CONTENT");

		for (var i = 0; i < contents.length; i++) {
			var content = contents[i];
			var mt = ezJsLib.XmlDom.getValueByTagFromNode("MT", content);
			var os = ezJsLib.XmlDom.getValueByTagFromNode("OS", content);
			var total = parseInt(ezJsLib.XmlDom.getValueByTagFromNode("TOTAL", content));
			var index = "";
			if(os == "RHEL 7 x64"){
				index = (mt + unifyOS("RHEL 7")).toLowerCase();
			} else if (os == "platform"){
				index = (mt + unifyOS("platform")).toLowerCase();
			} else {
				index = (mt + unifyOS(os)).toLowerCase();
			}
			var table = _doc.getElementById(TABLE_PRE + index);

			for (var r = 0; r < total; ++r) {
				var releaseDate = ezJsLib.XmlDom.getValueByTagAndIndexFromNode("RELEASEDATE", content, r);
				table.rows[1 + r].cells[3].innerHTML = releaseDate;
				table.rows[1 + r].cells[3].title = releaseDate;
			}
		}
	}


	function setAcResultComplete() {
		top.comResultCompleted = true;
	}

	function nextAction() {
		if(!su_collect())
			return false;
		top.rewrite_compare_result(setAcResultComplete, top.gl_ac_result_rewrite, top.gl_ac_result, top.gl_selected_list);
		$("#details_selection").empty().hide();
		return true;
	}

	return{
		name: "UpdateSelection",
        index: 0,
        header: header,
		openNoRequisiteURL: openNoRequisiteURL,
		ac_cancel: ac_cancel,
		openNoSEPsURL: openNoSEPsURL,
		open_no_uxsp_url: open_no_uxsp_url,
		open_no_indiv_url: open_no_indiv_url,
		beginAcq: beginAcq,
		selectContent: selectContent,
		init: progressInit, 
        nextAction: nextAction,
		previousAction: progressPreviousAction,
        importId: '#import_updateSelection',
        selectorId: '.updateSelection',
        title: "Update Selection" 
	}
}();
