// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
var SupportedSystems=function(){
	var currentFuncSet = "";
	var SUPPORTLIST_OPERATION_RESULT;
	var timer;
	var needUpdateList = false;
	var isInited = false;
	var total_sys_count = 0;
	// if user selects a system in storage table, selectedTable is "storage"
	// if user selects a system in Lenovo Platform or IBM Platform table, selectedTable is "platform"
	var selectedTable = "";

	function config_storage_step() {
		if (top.selectedTable == 'storage') {
			if (top.gl_steps_current.indexOf(MediaPurpose) != -1) {
				top.gl_steps_current.splice(top.gl_steps_current.indexOf(MediaPurpose), 1);
			}
			if (top.gl_steps_current.indexOf(UnattendedConfiguration) != -1) {
				top.gl_steps_current.splice(top.gl_steps_current.indexOf(UnattendedConfiguration), 1);
			}
		} else {
			if (top.gl_steps_current.indexOf(MediaPurpose) == -1) {
				if (top.gl_steps_current.indexOf(SupportedSystems) != -1) {
					top.gl_steps_current.splice(top.gl_steps_current.indexOf(SupportedSystems) + 1, 0, MediaPurpose);
				}
			}
			if (top.gl_steps_current.indexOf(UnattendedConfiguration) == -1) {
				if (top.gl_steps_current.indexOf(SaveConfiguration) != -1) {
					top.gl_steps_current.splice(top.gl_steps_current.indexOf(SaveConfiguration), 0, UnattendedConfiguration);
				}
			}
		}
		// configSteps(top.gl_steps_current);
	}

	function setCurrentFuncSet(funcSet) {
	    currentFuncSet = funcSet;
	}
	/*function isCurrentFuncSetChanged() {
	    var changed = false;
	    if (top.program != currentFuncSet) {
	        changed = true;
	    }
	    return changed;
	}*/
	function select_all(ele) {
		var tbId = $(ele).attr("value");
		var status = $(ele).prop("checked");
	    var t = document.getElementById(tbId).childNodes.item(1);
	    for (var i=0; i<t.childNodes.length; i++) {
	        if (t.childNodes[i].firstChild.firstChild.disabled != true) {
	            t.childNodes[i].firstChild.firstChild.checked = status;
	            if (status) {
	                t.childNodes[i].className = "RowSelected";
	            } else {
	                t.childNodes[i].className = "RowUnselected";
	            }
	        }
	    }
	    updateRemoveBtn(tbId);
		checkTableShouldDisabled();
		saveTableInfo();
	}
	function checkNewItem(newFamily, newMT) {
	    var mtExisted = false;
		var table = document.getElementById("salieOsTable").childNodes.item(1);
		for (var i =0; i < table.childNodes.length; i++) {
			var mt_cnt = table.childNodes[i].childNodes[2].firstChild.nodeValue;
			if (newMT.trim().toLowerCase() == mt_cnt.toLowerCase()) {
				mtExisted = true;
				break;
			}
		}
	    return mtExisted;
	}

	/**
	  * A valid machine type should be a 4-digit text
	  */

	function isMTValid(mt,type) {
	    var valid = true;
	    mt = $.trim(mt);
		var regExp =  /^[\d]{4}$/gi;
		if("salieOsTable" == type){
			regExp = /^[a-zA-Z\d]{4}$/gi;
		}
	    if (!mt.match(regExp))
	    {
	        valid = false;
	    }
	    
	    return valid;
	}

	function addsystemitem(ele) {
		var osTableId = $(ele).attr("name");
	    var newFamily = document.getElementById("txtProductFamily").value;
	    var newMT = document.getElementById("txtMachineType").value;
	    if (isMTValid(newMT, osTableId) == false) {
	        top.showWarningInformation("supportOSModalTipsDiv" ,"supportOSModalTips" ,"Invalid machine-type(s) specified");
	    } else if ((newFamily != "") && (newMT != "")) {
	        if (checkNewItem(newFamily, newMT) == true) {
	            top.showWarningInformation("supportOSModalTipsDiv" ,"supportOSModalTips" ,"The server already exists in the list!");
	        } else {
	            var t = document.getElementById(osTableId).childNodes.item(1);
	            var i = t.childNodes.length + 1;
	            if ((i == 1) && (top.BROWSER != "IExplore")) {
	                var newHTML = "<tr id='sysRow" + i + "'>";
	                document.getElementById("ostable_body").innerHTML = newHTML;
	                document.getElementById(osTableId).rows[i].insertCell(-1).innerHTML = "<input onclick=\"SupportedSystems.toggleRowSelect('sysRow" + i + "', this,'"+osTableId+"');\" type='checkbox' name='sys' id='sys" + i + "'><span id='sysRow" + i + "Flag'" + " style='display:none'>n</span>";
	                document.getElementById(osTableId).rows[i].insertCell(-1).innerHTML = newFamily;
	                document.getElementById(osTableId).rows[i].insertCell(-1).innerHTML = newMT;
	                // Set supportability of current tools as Unknown
	                var toolSelectedNum = top.program.split(",").length;
	                for (var tIndex = 0; tIndex < toolSelectedNum; ++tIndex) {
	                    document.getElementById(osTableId).rows[i].insertCell(-1).innerHTML = "<img src='" + "images/statusUnknown_obj16.gif'><span style='display:none'>unknown</span></img>";
	                }
	            } else {
	                var x=document.getElementById(osTableId).insertRow(-1);
	                x.id="sysRow" + i;

	                x.insertCell(-1).innerHTML="<input onclick=\"SupportedSystems.toggleRowSelect('sysRow" + i + "', this,'"+osTableId+"');\" type='checkbox' name='sys' id='sys" + i + "'><span id='sysRow" + i + "Flag'" + " style='display:none'>n</span>";
	                x.insertCell(-1).innerHTML= newFamily ;
	                x.insertCell(-1).innerHTML= newMT ;
	                // Set supportability of current tools as Unknown
	                var toolSelectedNum = top.program.split(",").length;
	                for (var tIndex = 0; tIndex < toolSelectedNum; ++tIndex) {
	                    x.insertCell(-1).innerHTML = "<img src='" + "images/statusUnknown_obj16.gif'><span style='display:none'>unknown</span></img>";
	                }
	            }
	            if (top.allList.indexOf(newMT) == -1) {
	            	top.allList.push(newMT);
	            }
				if (top.isPurley(newMT) && top.purleyList.indexOf(newMT) == -1) {
					top.purleyList.push(newMT);
				} else {
					if (top.lenovoSystemxList.indexOf(newMT) == -1) {
						top.lenovoSystemxList.push(newMT);
					}
				}
	            saveTableInfo();
	            // clearNewSystemInfo();
				top.hideSupportOSModal();
	            checkTableShouldDisabled();
	        }
	    } else {
	        top.showWarningInformation("supportOSModalTipsDiv" ,"supportOSModalTips" ,"Product family and machine type info could not be empty!");
	    }
	}

	/*function clearNewSystemInfo() {
	    document.getElementById("txtProductFamily").value = "";
	    document.getElementById("txtMachineType").value = "";
	}*/

	/* check if any item selected and enable or disable removeBtn */
	function updateRemoveBtn(ostableid) {
	    var t = document.getElementById(ostableid).childNodes.item(1);
	    var itemSelected = false;
	    for (var i=0; i<t.childNodes.length; i++) {
	        if (t.childNodes[i].firstChild.firstChild.checked) {
	            itemSelected = true;
	            break;
	        }
	    }
	    if (itemSelected == false) {
	        $("#"+ostableid+"_delete").prop("disabled",true);
	    } else {
	        $("#"+ostableid+"_delete").prop("disabled",false);
	    }
	}
	function deleteitem(ele) {
		var ostableid =$(ele).attr("name");
	    var t = document.getElementById(ostableid).childNodes.item(1);

	    if (window.confirm("All selected systems will be removed from the list. Do you wish to proceed?")) {
	        for (var i=0; i<t.childNodes.length; i++) {
	            if (t.childNodes[i].firstChild.firstChild.checked) {
	                //t.childNodes[i].removeNode(true);
	                document.getElementById(ostableid).deleteRow(i+1);
	                i--;
	            }
	        }
	        saveTableInfo();
	    } else {
	        //do nothing
	    }
	    updateRemoveBtn(ostableid);
		checkTableShouldDisabled();		
	}
	function saveTableInfo() {
	    top.mtArray.length = 0
		$(["storageOsTable", "salieOsTable"]).each(function(h,n){
			var j = top.mtArray.length;
			var t = document.getElementById(n).childNodes.item(1);
			for (var i=0; i<t.childNodes.length; i++) {
				if (t.childNodes[i].firstChild.firstChild.checked) {
					try {
						var tmpMT = t.childNodes[i].childNodes[2].firstChild.nodeValue.split(",");
						for ( var m = 0; m < tmpMT.length; m ++) {
							if ( top.mtArray.length == 0)
								top.mtArray[j++] = tmpMT[m];
							else {
								var hasSameMT = false;
								for ( var l = 0; l < top.mtArray.length; l ++)
									if ( tmpMT[m] == top.mtArray[l])
										hasSameMT = true;

								if ( hasSameMT == false)
									top.mtArray[j++] = tmpMT[m];
							}
						}
					} catch (e) {
						;
					}
				}
			}
			top.mtArray.length = j;
		});
	}
	
	/* array[index] isn't in the support list and inquire the customer
		@return value means whether the specified machine type is added*/
	/*function handleMTNotInList(array, index, osTableId) {
	    var ret;
	    var newMT = array[index];
	    if (window.confirm("Machine Type " + array[index] + " isn't in the support list. Do you want to add it  to the machine type list?")) {
	        var t = document.getElementById(osTableId).childNodes.item(1);
	        var i = t.childNodes.length + 1;
	        if ((i == 1) && (top.BROWSER != "IExplore")) {
	            var newHTML = "<tr id='sysRow" + i + "'>";
	            document.getElementById(osTableId+"_body").innerHTML = newHTML;

	            document.getElementById(osTableId).rows[i].insertCell(-1).innerHTML = "<input onclick=\"SupportedSystems.toggleRowSelect('sysRow" + i +"', this,'"+osTableId+"');\" type='checkbox' name='sys' id='sys" + i + "' checked>";
	            document.getElementById(osTableId).rows[i].insertCell(-1).innerHTML = "Unknown Family";
	            document.getElementById(osTableId).rows[i].insertCell(-1).innerHTML = newMT;
	            // Set supportability of current tools as Unknown
	            var toolSelectedNum = top.program.split(",").length;
	            for (var tIndex = 0; tIndex < toolSelectedNum; ++tIndex) {
	                document.getElementById(osTableId).rows[i].insertCell(-1).innerHTML = "<img src='" + "images/statusUnknown_obj16.gif'><span style='display:none'>unknown</span></img>";
	            }

	            x.className = "RowSelected";
	        } else {
	            var x=document.getElementById(osTableId).insertRow(-1);
	            x.id="sysRow" + i;

	            x.insertCell(-1).innerHTML="<input onclick=\"SupportedSystems.toggleRowSelect('sysRow" + i +"', this,'"+osTableId+"');\" type='checkbox' name='sys' id='sys" + i + "' checked >";
	            x.insertCell(-1).innerHTML= "Unknown Family" ;
	            x.insertCell(-1).innerHTML= newMT;
	            // Set supportability of current tools as Unknown
	            var toolSelectedNum = top.program.split(",").length;
	            for (var tIndex = 0; tIndex < toolSelectedNum; ++tIndex) {
	                x.insertCell(-1).innerHTML = "<img src='" + "images/statusUnknown_obj16.gif'><span style='display:none'>unknown</span></img>";
	            }
	            x.className = "RowSelected";
	        }

	        ret = true;
	    } else {
	        var temp = new Array();
	        for (var i = 0 ; i < array.length; ++i) {
	            temp[i] = array[i];
	        }
	        for (var j = 0, n = 0; j < array.length; ++j) {
	            if (j != index) array[n++] = temp[j];
	        }
	        array.length = temp.length -1;
	        ret = false;
	    }
	    return ret;
	}*/

	/**
	  * Check if none of the machine types is supported by any single tool
	  * @param
	  *       mt:Array - containing machine types to be checked
	  *       tools:String - tools currently selected, comma seperated string, e.g.,"dsa,uxspi"
	  * @return
	  *       Array containing the tool name which is not supported by all tools specified
	  *       if all tools support at least on system specified, an empty array is returned
	  */
	/*function getNonSupportingToolsForMT(mt, tools) {
		var nonSupportTools = new Array();
		if(tools == "NULL") {
			return nonSupportTools;
		}
	    var root = systemSupportListDom.documentElement;
	    var allSystems = root.getElementsByTagName("system");
	    var sysCount = allSystems.length;
	    var targetTools = tools.split(",");
	    var toolCount = targetTools.length;
	    var mtCount = mt.length;
	    for (var ti = 0; ti < toolCount; ++ti) {
	        var curTool = targetTools[ti];
	        var isToolSupport = false;
	        for (var mi = 0; mi < mtCount; ++mi) {
	            var curMT = mt[mi];
	            var mtFound = false;
	            for (var si = 0; si < sysCount; ++si) {
	                var curSys = allSystems.item(si);
	                if (curSys.getElementsByTagName("machineType")[0].firstChild.nodeValue == curMT) {
	                    mtFound = true;
	                    if (curSys.getElementsByTagName(curTool)[0].firstChild.nodeValue == "yes") {
	                        isToolSupport = true;
	                        break;
	                    }
	                }
	            }
	            if (isToolSupport == true) {
	                break;
	            } else if (mtFound == false) {
	                isToolSupport = true;
	                break;
	            } else {
	                // next loop
	            }
	        }
	        if (isToolSupport == false) {
	            nonSupportTools.push(curTool);
	        }
	    }
	    return nonSupportTools;
	}*/
	
	/*function checkVmwareUpdate(tool) {
	    var root = systemSupportListDom.documentElement;
	    var allSystems = root.getElementsByTagName("system");
	    var sysCount = allSystems.length;
	    var mtCount = top.mtArray.length;
	    var ret = false;

	    for (var mi = 0; mi < mtCount; ++mi) {
	        var curMT = top.mtArray[mi];
	        var mtFound = false;
	        for (var si = 0; si < sysCount; ++si) {
	            var curSys = allSystems.item(si);
	            if (curSys.getElementsByTagName("machineType")[0].firstChild.nodeValue == curMT) {
	                mtFound = true;
				   	var obj = curSys.getElementsByTagName(tool);
				   	if(obj.length != "0"){
		                if (obj[0].firstChild.nodeValue == "yes") {
		                    ret = true;
		                    break;
		                }
				   	}
	            }
	        }
	    }
	    return ret;
	}*/

	function checkSelectedSystems() {
		top.selectedOSMachineType = [];
		saveTableInfo();
		if (top.mtArray.length == 0) {
			alert("You have not selected any system! ");
			return false;
		} else {
			for (var i = 0; i < top.mtArray.length; i++) {
				var type = top.returnMtCategory(top.mtArray[i]);
				if (type != "" && type != undefined && type != null) {
					if (top.selectedOSMachineType.indexOf(type) == -1) {
						top.selectedOSMachineType.push(type);
					}
				}
			}
			if (top.selectedOSMachineType.indexOf("storage") != -1) {
				top.program = "UPDATE";
				top.autorun = "NULL";
			}
			// if (top.selectedOSMachineType.indexOf("storage") != -1) {
			// 	top.program = "storage";
			// 	$('#acquire_mode_section').hide();
			// 	$("#remotely").attr("disabled", true);
			// } else {
			// 	top.program = "update";
			// 	$('#acquire_mode_section').show();
			// 	$("#remotely").removeAttr("disabled");
			// 	if (top.selectedOSMachineType.indexOf("ibm") != -1 && (top.selectedOSMachineType.indexOf("x") != -1 || top.selectedOSMachineType.indexOf("purley") != -1)) {
			// 		$("#updateDiv").hide();
			// 		$("#full").click();
			// 	} else {
			// 		$("#updateDiv").show();
			// 		$("#update").click();
			// 	}
			// }
			return true;
		}
	}

	/*function checkSelectedSystems() {
	    saveTableInfo();
	    if (top.program.indexOf("serverguide") == -1 && top.program.indexOf("uxspi") != -1) 
	    {
	    	// what is this 'if' for?
	    }

	    if (top.mtArray.length == 0) 
	    {
	        alert('You have not selected any system!');
	    } 
	    else 
	    {
	    	// Bug 91027 - [BoMC_10.4] While switch the targeted System platform,the options should be reset.
	    	if (top.selectedOSMachineType == 'salie') 
    		{
    			top.program = "uxspi";
    		}
	        var nonSupportingTools = getNonSupportingToolsForMT(top.mtArray, top.program);
	        if (nonSupportingTools.length > 0) 
	        {
	            var errMsg = "None of the systems selected is supported by the following tools:\n";
	            for (var i = 0; i < nonSupportingTools.length; ++i) 
	            {
	                if (nonSupportingTools[i] == "dsa") 
	                {
	                    errMsg += "\"Diagnostics\"\n";
	                } 
	                else if (nonSupportingTools[i] == "uxspi") 
	                {
	                    errMsg += "\"Updates\"\n";
	                } 
	                else if (nonSupportingTools[i] == "serverguide") 
	                {
	                    errMsg += "\"Deployment\"\n";
	                } 
	                else 
	                {
	                    // dummy
	                }
	            }
	            errMsg += "\nWould you like to update the system support list now?";
	            if (confirm(errMsg) == true) 
	            {
	                updateList();
				}
				checkTableShouldDisabled();
	        } 
	        else 
	        {
	            return true;
	        }
	    }
	}*/

	function changeStep(){
		console.log("changeStep");
		if (selectedTable == 'platform') {
			if (top.gl_steps_current.indexOf(MediaPurpose) == -1) {
				if (top.gl_steps_current.indexOf(SupportedSystems) != -1) {
					top.gl_steps_current.splice(top.gl_steps_current.indexOf(SupportedSystems) + 1, 0, MediaPurpose);
				}
			}
			if (top.gl_steps_current.indexOf(UnattendedConfiguration) == -1) {
				if (top.gl_steps_current.indexOf(SaveConfiguration) != -1) {
					top.gl_steps_current.splice(top.gl_steps_current.indexOf(SaveConfiguration), 0, UnattendedConfiguration);
				}
			}
		} else if (selectedTable == 'storage') {
			if (top.gl_steps_current.indexOf(MediaPurpose) != -1) {
				top.gl_steps_current.splice(top.gl_steps_current.indexOf(MediaPurpose), 1);
			}
			if (top.gl_steps_current.indexOf(UnattendedConfiguration) != -1) {
				top.gl_steps_current.splice(top.gl_steps_current.indexOf(UnattendedConfiguration), 1);
			}
			//config_storage_step();
		}
		configSteps(top.gl_steps_current);
	}

	function toggleRowSelect(id, ref,ostableid) {
	    updateRemoveBtn(ostableid);
		checkTableShouldDisabled();	
		saveTableInfo();
	    var checkFlag = document.getElementById(id + "Flag");
	    if (ref.checked) {
	        ref.parentNode.parentNode.className= "RowSelected";
	        checkFlag.innerHTML = "y";
	    } else {
	        ref.parentNode.parentNode.className= "RowUnselected";
	        checkFlag.innerHTML = "n";
	    }
	}

	function checkTableShouldDisabled() {
		selectedTable = "";
		var table_arr = ['salieOsTable', 'storageOsTable'];
		for (var i = 0; i < table_arr.length; i++) {
			var t = document.getElementById(table_arr[i]).childNodes.item(1);
			for (var j = 0; j < t.childNodes.length; j++) {
				if (t.childNodes[j].firstChild.firstChild.disabled != true && t.childNodes[j].firstChild.firstChild.checked == true) {
					if (table_arr[i].indexOf('salie') != -1) {
						selectedTable = 'platform'
					} else {
						selectedTable = 'storage';
					}
					break;
				}
			}
			if (selectedTable != '') {
				break;
			}
		}
		if (selectedTable == 'platform') {
			setUnSelectedTableDisabled('storageOsTable', true);
		} else if (selectedTable == 'storage') {
			setUnSelectedTableDisabled('salieOsTable', true);
		} else if (selectedTable == '') {
			$(["storageOsTable", "salieOsTable"]).each(function(i, n) {
				setUnSelectedTableDisabled(n, false);
			});
		}

		changeStep();
	}

	function setUnSelectedTableDisabled(tableid,status) {
		var t = document.getElementById(tableid).childNodes.item(1);
		for (var i =0; i < t.childNodes.length; i++) {
			if (top.existInArray(forbidSystemList, "sys" + i) == false) {
				t.childNodes[i].firstChild.firstChild.disabled = status;
			}
		}
		$("#"+tableid+"_all").prop("disabled",status);
	}

	function loadSystemsList() {
		try {
			var machineListFile = top.findFile(null, top.SYSTEM_SUPPORT_LIST);
			top.gl_salie_machine_list = JSON.parse(readTextFile(SALIE_SUPPORT_LIST));
			if(top.gl_salie_machine_list == null) throw new Error();
			top.getXML(machineListFile, populateSysList, "sysListID");
		} catch (error) {
			if(top.OSTYPE == "windows"){
				var salie_support_list_temp = top.workingdir + "\\SALIE_SYSTEM_SUPPORT_LIST_13.1.0.json";
				top.gl_salie_machine_list = JSON.parse(readTextFile(salie_support_list_temp));
	
				var supportListFile_temp = top.workingdir + "\\SYSTEM_SUPPORT_LIST_13.1.0.xml";
				var machineListFile = top.findFile(null, supportListFile_temp);
				top.getXML(machineListFile, populateSysList, "sysListID");
			}else{
				var salie_support_list_temp = top.workingdir + "/SALIE_SYSTEM_SUPPORT_LIST_13.1.0.json";
				top.gl_salie_machine_list = JSON.parse(readTextFile(salie_support_list_temp));
	
				var supportListFile_temp = top.workingdir + "/SYSTEM_SUPPORT_LIST_13.1.0.xml";
				var machineListFile = top.findFile(null, supportListFile_temp);
				top.getXML(machineListFile, populateSysList, "sysListID");
			}
		}
	}

	
	function checkMTisSalie(mt){
		if(top.gl_salie_machine_list && top.gl_salie_machine_list.indexOf(mt)>-1)
			return true;
		else
			return false;
	}

	function init() {
		SUPPORTLIST_OPERATION_RESULT = top.gl_ibm_support + top.getOSCommand("SUPPORTLIST_OPERATION_RESULT");
	    setCurrentFuncSet( top.program);
	    loadSystemsList();
	    isInited = true;
	}
	var salieTableBodyStr = "";

	function create_table_body_storage() {
		var resultStr = '';
		var storage_system = ['D1212/D1224', 'D3284'];
		var storage_mt = ['4587', '6413'];
		var storage_start_index = total_sys_count + 1;
		for (var i = 0; i < storage_mt.length; i++) {
			var index = storage_start_index + i;
			resultStr += "<tr><td style='width:16px;'><input onclick=\"SupportedSystems.toggleRowSelect('sysRow" + index + "', this,'storageOsTable');\" type='checkbox' name='sys' id='sys" + index + "'><span id='sysRow" + storage_start_index + i + "Flag'" + " style='display:none'>n</span></td>";
			resultStr += "<td style='width:550px;'>" + storage_system[i] + "</td>";
			resultStr += "<td style='width:109px;'>" + storage_mt[i] + "</td>";
			total_sys_count = index;
		}
		resultStr += '</tr>';
		$('#storageOsTable_body').html(resultStr);
	}

	function createTableBody(allSystems) {
	    var sysCount = allSystems.length;
		
		for (i = 0; i < sysCount; i++) {
	        var tmpResult = "";
			var resultStr = "";
	        // var isSgSupported = false;
	        // var noToolSupported = true;
			var curMT = "";
			var xname = allSystems.item(i).firstChild.firstChild.nodeValue.toLowerCase();
			if (xname == "legacy option" || xname == "storage") {
				continue;
			}
	        for (j = 0; j < allSystems.item(i).childNodes.length; j++) {
				var sysItem = allSystems.item(i).childNodes[j];
	            if (j > 1) {
	                // var supportToolElement = sysItem;
	                // var supportToolName = supportToolElement.nodeName;
	                // var supportValue = supportToolElement.firstChild.nodeValue;
	                // if ("yes" == supportValue && top.program.indexOf(supportToolName) != -1) {
	                //     noToolSupported = false;
	                //     if (supportToolName == "serverguide") {
	                //         isSgSupported = true;
	                //     }
	                //     //tmpResult += "<td style='width:30px;'><img src='" + "images/statusSuccess_obj16.gif'><span style='display:none'>yes</span></img>" + "</td>";
	                // } else if ("no" == supportValue && top.program.indexOf(supportToolName) != -1) {
	                //     //tmpResult += "<td style='width:30px;'><img src='" + "images/statusCritical_obj16.gif'><span style='display:none'>no</span></img>" + "</td>";
	                // } else if (top.program.indexOf(supportToolName) != -1) {
	                //     //tmpResult += "<td style='width:30px;'><img src='" + "images/statusUnknown_obj16.gif'><span style='display:none'>unknown</span></img>" + "</td>";
	                // }
	            } else if (sysItem.firstChild) {
					if(j==1){
						curMT = sysItem.firstChild.nodeValue
	                	tmpResult += "<td style='width:109px;'>" + sysItem.firstChild.nodeValue + "</td>";
					}else{
						tmpResult += "<td style='width:550px;'>" + sysItem.firstChild.nodeValue + "</td>";
					}
	            }
	        }
	   //      if (top.program.indexOf("serverguide") != -1 && isSgSupported == false) {
	   //          if (top.BROWSER != "IExplore") {
	   //              forbidSystemList.push("sys"+i);
	   //          }
	   //          resultStr += "<tr id='sysRow" + i + "' title='The system is not selectable UNLESS it is supported by Deployment tool'>";
	   //          resultStr += "<td style='width:16px;'><input type='checkbox' name='sys' id='sys" + i + "' disabled='true'><span id='sysRow" + i + "Flag'" + " style='display:none'>n</span></td>";
	   //      } else if (noToolSupported == true) {
	   //          if (top.BROWSER != "IExplore") {
	   //              forbidSystemList.push("sys"+i);
	   //          }
	   //          resultStr += "<tr id='sysRow" + i + "' title='The system is not selectable UNLESS it is supported by at least 1 tool selected'>";
	   //          resultStr += "<td style='width:16px;'><input type='checkbox' name='sys' id='sys" + i + "' disabled='true'><span id='sysRow" + i + "Flag'" + " style='display:none'>n</span></td>";
	   //      } else {
	   //          resultStr += "<tr id='sysRow" + i + "'>";
				// resultStr += "<td style='width:16px;'><input onclick=\"SupportedSystems.toggleRowSelect('sysRow" + i + "', this,'"+getOSTableId(curMT)+"');\" type='checkbox' name='sys' id='sys" + i + "'><span id='sysRow" + i + "Flag'" + " style='display:none'>n</span></td>";
	   //      }
	        resultStr += "<tr id='sysRow" + i + "'>";
			resultStr += "<td style='width:16px;'><input onclick=\"SupportedSystems.toggleRowSelect('sysRow" + i + "', this,'"+getOSTableId(curMT)+"');\" type='checkbox' name='sys' id='sys" + i + "'><span id='sysRow" + i + "Flag'" + " style='display:none'>n</span></td>";
	        resultStr += tmpResult;
	        resultStr += "</tr>";

	        total_sys_count = i;

			if(checkMTisSalie(curMT))
				salieTableBodyStr += resultStr;
	    }
	}

	function getOSTableId(mt) {
		// if(top.gl_salie_machine_list && top.gl_salie_machine_list.indexOf(mt)>-1)
			return "salieOsTable";
		// else
		// 	return "mcpOsTable";
	}

	function createTableHeader(pId, osTableId) {
		var resultStr = "<table id='"+osTableId+"' cellpadding=\"2\" cellspacing=\"0\" border=\"1\" style=\"width:100%;\" summary=\"Supported System\">";
	    resultStr += "<thead><tr><td style='width:16px;' id=\"checkedTitle\"><input type='checkbox' id='"+osTableId+"_all' value='"+osTableId+"' onclick='SupportedSystems.select_all(this)' > </td>"
	                 + "<td style='width:550px;' type=\"String\" onclick=\"SupportedSystems.sortColumn(event)\" >Product Family</td>"
	                 + "<td style='width:109px;' type=\"string\" onclick=\"SupportedSystems.sortColumn(event)\" >Machine Type</td>";

	    resultStr += "</thead><tbody id='"+osTableId+"_body'>";
		
	    resultStr += "</tbody>";
	    resultStr += "</table>";
		document.getElementById(pId).innerHTML = resultStr;
	}

	// Array of systems not allowed for selection
	// Element: id of checkbox for each system
	var forbidSystemList;
	// Dom object for contents of system support list
	var systemSupportListDom;
	function populateSysList(dom) {
	    systemSupportListDom = dom;
	    var root = dom.documentElement;
	    var allSystems = root.getElementsByTagName("system");
		if (top.BROWSER != "IExplore") 
	        forbidSystemList = new Array();
	    
		$("#systemsList_salie").html("");
		salieTableBodyStr = "";
		createTableHeader("systemsList_salie", "salieOsTable");
		createTableHeader('systemsList_storage', 'storageOsTable');
		createTableBody(allSystems);
		create_table_body_storage();

		if(salieTableBodyStr == ""){
			$("#salieOSPanel").hide();
		}else{
			$("#salieOSPanel").show();
			$("#salieOsTable_body").html(salieTableBodyStr);
		}
		// always show storage panel
		$('#storage_panel').show();

	}

	function updateSupportedSystems() {
		initSalieListFile();
		top.printLog("INFO", "initSalieListFile done.");

		// refresh salie_support_list
	    initAllList();
		top.printLog("INFO", "initAllList done.");

	    initLenovoSystemxList();
		top.printLog("INFO", "initLenovoSystemxList done.");

	    initPurleyList();
		top.printLog("INFO", "initPurleyList done.");

	    initStorageList();
		top.printLog("INFO", "initStorageList done.");

	    init();
		top.printLog("INFO", "init done.");

	    setCurrentFuncSet(top.program);

	    var isAllSelected = false;
	    for (var i = 0 ; i < top.mtArray.length; ++i) {
	        if (top.mtArray[i].indexOf("all") != -1 || top.mtArray[i].indexOf("ALL") != -1) {
	            isAllSelected = true;
	            break;
	        }
	    }
	    if (!isAllSelected) {
			setNodeChecked();
	    } else {
	        // '-m all' provided
	        select_all(true);
	    }
		updateRemoveBtn("salieOsTable");
		checkTableShouldDisabled();
	    initGlobalStatusPanel();
	}

	function setNodeChecked() {
		$(["storageOsTable", "salieOsTable"]).each(function(_num, _value){
			var t = document.getElementById(_value).childNodes.item(1);
			for (var i=0; i<t.childNodes.length; i++) {
				t.childNodes[i].firstChild.firstChild.checked = false;
				t.childNodes[i].className = "RowUnselected";
			}
		});
		
		for (var k=0; k<top.mtArray.length; ++k) {
			//var findOne = false;
			$(["storageOsTable", "salieOsTable"]).each(function(_num, _value){
				var t = document.getElementById(_value).childNodes.item(1);
				for (var i=0; i<t.childNodes.length; i++) {
					if ( t.childNodes[i].childNodes[2].firstChild.nodeValue == top.mtArray[k]) {
						//findOne = true;
						if ((top.BROWSER != "IExplore" && top.existInArray(forbidSystemList, "sys" + i) == false)
								|| (top.BROWSER == "IExplore" && t.childNodes[i].firstChild.firstChild.disabled != true)) {

							t.childNodes[i].firstChild.firstChild.checked = true;
							t.childNodes[i].className = "RowSelected";
							break;
						}
					}
				}
			});
			/*
			if (!findOne) {
				// if (handleMTNotInList(top.mtArray, k, osTableId))
					k ++;
			} else {
				k ++;
			}
			*/

		}
	}

	var dom = (document.getElementsByTagName) ? true : false;
	var ie5 = (document.getElementsByTagName && document.all) ? true : false;
	var arrowUp, arrowDown;

	if (ie5 || dom)
	    initSortTable();

	function initSortTable() {
	    arrowUp = document.createElement("SPAN");
	    //var tn = document.createTextNode("5");
	    var tn = document.createTextNode("↑");
	    arrowUp.appendChild(tn);
	    arrowUp.className = "arrow";

	    arrowDown = document.createElement("SPAN");
	    //var tn = document.createTextNode("6");
	    var tn = document.createTextNode("↓");
	    arrowDown.appendChild(tn);
	    arrowDown.className = "arrow";
	}

	function mergeRows(orig, dest, nCol) {
	    var trl = orig.length;
	    var col = 1;//(nCol == 1)? 2:1;
	    var pre ;
	    var pre_content;
	    var cur;
	    var cur_content;

	    var j = 0;
	    for (var i = 0; i < trl; ++i) {
	        cur = orig[i].childNodes[nCol].firstChild.nodeValue;
	        var selected = orig[i].firstChild.firstChild.checked;
	        cur_content = orig[i].childNodes[col].firstChild.nodeValue;
	        if (pre == cur) {
	            pre_content = pre_content + ',' + cur_content;
	            dest[j-1].childNodes[col].firstChild.nodeValue = pre_content;
	            if (selected) {
	                dest[j-1].firstChild.firstChild.checked = selected;
	                dest[j-1].className = "RowSelected";
	            }
	        } else {
	            pre = cur;
	            pre_content = cur_content;
	            dest[j++] = orig[i];
	        }
	        //alert(dest[j].childNodes[col].firstChild.nodeValue);
	    }
	    //alert(orig.length);
	    //alert(dest.length);
	}
	function sortRows(tableNode, nCol, bDesc, sType) {
	    var tBody = tableNode.tBodies[0];
	    var trs = tBody.rows;
	    var trl = trs.length;
	    var a = new Array();

	    for (var i = 0; i < trl; i++) {
	        a[i] = trs[i];
	    }

	    //var start = new Date;
	    //window.status = "Sorting data...";
	    a.sort(compareByColumn(nCol, bDesc, sType));
	    //window.status = "Sorting data done";

	    /*
	    	var b = new Array();
	    	mergeRows(a, b, nCol);
	    	trl = b.length;
	    */
	    var b = a;
	    // append(replace) rows into table
	    for (var i = 0; i < trl; i++) {
	        //alert(b[i].childNodes[nCol].firstChild.nodeValue);
	        var ifChecked = b[i].firstChild.firstChild.checked;
	        tBody.appendChild(b[i]);
	        tBody.lastChild.firstChild.firstChild.checked = ifChecked;
	        //window.status = "Updating row " + (i + 1) + " of " + trl +
	        //			" (Time spent: " + (new Date - start) + "ms)";
	    }
	    return b.length;
	}
	function deleteRows(tableNode, trl, ntrl) {
	    // delete useless rows.
	    var tBody = tableNode.tBodies[0];
	    var count = trl - ntrl;
	    for (var i = 0; i < count; ++i ) {
	        //alert(i); alert(delete_row);
	        tBody.deleteRow(0);
	    }

	}

	function sortTable(tableNode, nCol, bDesc, sType) {
	    // first:  break rows.
	    var trl = tableNode.tBodies[0].rows.length;
	    //alert(trl);
	    var nColOther = 1;//(nCol == 1)? 2:1;
		//	breakRows(tableNode, nCol, nColOther);

	    // second: sort rows
	    trl = tableNode.tBodies[0].rows.length;
	    //alert(trl);
	    var ntrl = sortRows(tableNode, nCol, bDesc, sType);
	    //alert(ntrl);

	    // third : delete rows
	    deleteRows(tableNode, trl, ntrl);
	    trl = tableNode.tBodies[0].rows.length;
	    //alert(trl);

	    // fourth: check for onsort
	    if (typeof tableNode.onsort == "string")
	        tableNode.onsort = new Function("", tableNode.onsort);
	    if (typeof tableNode.onsort == "function")
	        tableNode.onsort();
	}


	function CaseInsensitiveString(s) {
	    return String(s).toUpperCase();
	}

	function parseDate(s) {
	    return Date.parse(s.replace(/\-/g, '/'));
	}

	/* alternative to number function
	 * This one is slower but can handle non numerical characters in
	 * the string allow strings like the follow (as well as a lot more)
	 * to be used:
	 *    "1,000,000"
	 *    "1 000 000"
	 *    "100cm"
	 */

	function toNumber(s) {
	    return Number(s.replace(/[^0-9\.]/g, ""));
	}

	function compareByColumn(nCol, bDescending, sType) {
	    var c = nCol;
	    var d = bDescending;

	    var fTypeCast = String;

	    if (sType == "Number")
	        fTypeCast = Number;
	    else if (sType == "Date")
	        fTypeCast = parseDate;
	    else if (sType == "CaseInsensitiveString")
	        fTypeCast = CaseInsensitiveString;

	    return function (n1, n2) {
	        if (fTypeCast(getInnerText(n1.cells[c])) < fTypeCast(getInnerText(n2.cells[c])))
	            return d ? -1 : +1;
	        if (fTypeCast(getInnerText(n1.cells[c])) > fTypeCast(getInnerText(n2.cells[c])))
	            return d ? +1 : -1;
	        return 0;
	    };
	}

	function sortColumnWithHold(e) {
	    // find table element
	    var el = ie5 ? e.srcElement : e.target;
	    var table = getParent(el, "TABLE");

	    // backup old cursor and onclick
	    var oldCursor = table.style.cursor;
	    var oldClick = table.onclick;

	    // change cursor and onclick
	    table.style.cursor = "wait";
	    table.onclick = null;

	    // the event object is destroyed after this thread but we only need
	    // the srcElement and/or the target
		var fakeEvent = {srcElement :
	                 e.srcElement, target :
	                     e.target
	                    };

	    // call sortColumn in a new thread to allow the ui thread to be updated
	    // with the cursor/onclick
	    window.setTimeout(function () {
	        sortColumn(fakeEvent);
	        // once done resore cursor and onclick
	        table.style.cursor = oldCursor;
	        table.onclick = oldClick;
	    }, 100);
	}

	function sortColumn(e) {
	    var tmp = e.target ? e.target : e.srcElement;
	    var tHeadParent = getParent(tmp, "THEAD");
	    var el = getParent(tmp, "TD");

	    if (tHeadParent == null)
	        return;

	    if (el != null) {
	        var p = el.parentNode;
	        var i;


	        // get the index of the td
	        var cells = p.cells;
	        var l = cells.length;
	        for (i = 0; i < l; i++) {
	            if (cells[i] == el) break;
	        }
	        /*
	        // do not sort if click first column [include checkedBox]
	        if (i == 0)
	        	return;
	        */
	        // typecast to Boolean
	        el._descending = !Boolean(el._descending);

	        if (tHeadParent.arrow != null) {
	            if (tHeadParent.arrow.parentNode != el) {
	                tHeadParent.arrow.parentNode._descending = null;	//reset sort order
	            }
	            tHeadParent.arrow.parentNode.removeChild(tHeadParent.arrow);
	        }

	        if (el._descending)
	            tHeadParent.arrow = arrowUp.cloneNode(true);
	        else
	            tHeadParent.arrow = arrowDown.cloneNode(true);

	        el.appendChild(tHeadParent.arrow);


	        var table = getParent(el, "TABLE");
	        // can't fail

	        sortTable(table,i,el._descending, el.getAttribute("type"));

	        // update the radio button status
	        switch (i) {
	        case 1:
	            document.getElementById("sortByFamily").checked = true;
	            break;
	        case 2:
	            document.getElementById("sortByMachineType").checked = true;
	            break;
	        }
	    }
	}

	function testsort() {
	    sortTable(table,1,el._descending, el.getAttribute("type"));
	}
	function getInnerText(el) {
	    if (ie5) return el.innerText;	//Not needed but it is faster

	    var str = "";

	    var cs = el.childNodes;
	    var l = cs.length;
	    for (var i = 0; i < l; i++) {
	        switch (cs[i].nodeType) {
	        case 1: //ELEMENT_NODE
	            str += getInnerText(cs[i]);
	            break;
	        case 3:	//TEXT_NODE
	            str += cs[i].nodeValue;
	            break;
	        }

	    }

	    return str;
	}

	function getParent(el, pTagName) {
	    if (el == null) return null;
	    else if (el.nodeType == 1 && el.tagName.toLowerCase() == pTagName.toLowerCase())	// Gecko bug, supposed to be uppercase
	        return el;
	    else
	        return getParent(el.parentNode, pTagName);
	}


	function sortByFamily() {
	    sort(1);
	}

	function sortByMachineType() {
	    sort(2);
	}

	function sort(colIndex) {
	    var tmp = document.getElementById("ostable");
	    var tHeadParent = tmp.childNodes[0];
	    var el;
	    switch (colIndex) {
	    case 1:
	        el = tmp.childNodes[0].childNodes[0].firstChild.nextSibling;
	        break;
	    case 2:
	        el = tmp.childNodes[0].childNodes[0].firstChild.nextSibling.nextSibling;
	        break;
	    }

	    if (tHeadParent == null) {
	        return;
	    }
	    if (el != null) {
	        var p = el.parentNode;
	        var i = colIndex;

	        // typecast to Boolean
	        el._descending = !Boolean(el._descending);

	        if (tHeadParent.arrow != null) {
	            if (tHeadParent.arrow.parentNode != el) {
	                tHeadParent.arrow.parentNode._descending = null;	//reset sort order
	            }
	            tHeadParent.arrow.parentNode.removeChild(tHeadParent.arrow);
	        }

	        if (el._descending)
	            tHeadParent.arrow = arrowUp.cloneNode(true);
	        else
	            tHeadParent.arrow = arrowDown.cloneNode(true);

	        el.appendChild(tHeadParent.arrow);

	        var table = getParent(el, "TABLE");
	        // can't fail

	        sortTable(table,i,el._descending, el.getAttribute("type"));
	    }

	}

	/**
	  * Perform necessary updates when suppport list operation is finished
	  */
	function postUpdate(dom) {
	    if (dom != null) {
	        var root = dom.documentElement;
	        var result = root.getElementsByTagName("result");
	        var resultStr = result.item(0).childNodes[0].nodeValue;
	        var dispMsg;
	        if (resultStr == "SUCCESS") {
	            //top.showGlobalStatus("Request succeeded", null, top.STATUS.SUCCESS);
	            // init();
	            updateSupportedSystems();
		     	top.getVMWareSupportList(); //update vmware update support list
	            dispMsg = "Request succeeded";
	        } else {
	            if (resultStr == "NOCHANGE") {
	                //top.showGlobalStatus("No change found, request succeeded");
	                dispMsg = "No change found, request succeeded";
	            } else if (resultStr == "FAIL") {
	                //top.showGlobalStatus("Request failed", null, top.STATUS.FAIL);
	                dispMsg = "Request failed";
	            } else {
	                // dummy
	                dispMsg = "Unknown error occured...";
	            }
	        }
			// setTimeout(top.hideGlobalStatus, 3000);
	        top.hideGlobalStatus();
	        alert(dispMsg);
	        toggleElementsStatus(false);
	    }
	}

	function toggleElementsStatus(disable) {
	    var buttons = document.getElementsByTagName("input");
	    for (var i = 0; i < buttons.length; ++i) {
	        if (buttons[i].type == "button") {
	            buttons[i].disabled = disable;
	        }
	    }
		$(["storageOsTable", "salieOsTable"]).each(function(i, osTableId) {
			var table = document.getElementById(osTableId);
			table.disabled = disable;
			if (top.BROWSER != "IExplore") {
				var selects = table.getElementsByTagName("input");
				for (var i = 0; i < selects.length; ++i) {
					if (selects[i].type == "checkbox"
						&& selects[i].id != ""
						&& top.existInArray(forbidSystemList, selects[i].id) == false) {
						selects[i].disabled = disable;
					}
				}
			}
		});
	    
	    togglePrevious(!disable);
	    toggleNext(!disable);
	}
	/**
	  * Check the result of operation on system support list
	  */
	function checkOperationResult() {
	    var file = top.findFile(null, SUPPORTLIST_OPERATION_RESULT);
	    if (timer > 90000) {
	        var args = new Array();
	        args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
	        args.push("--kill");
	        if (top.OSTYPE == "windows") {
	            args.push(top.workingdir + "\\" + top.mainAppName);
	        } else {
	            args.push(top.mainAppName);
	        }
	        args.push("--file");
	        args.push(top.bomc_gui);
	        //top.showGlobalStatus("No response for a long time, please retry...", null, top.STATUS.WARNING);
	        secureRunProgram(null, args, BACKGROUND, HIDDEN);
			//setTimeout(top.hideGlobalStatus, 3000);
	        top.hideGlobalStatus();
	        toggleElementsStatus(false);
	        alert("No response for a long time, please retry...");
	    } else if (file != null) {
	        top.getXML(file, postUpdate, "sysListOPResultID");
	    } else {
	        timer += 2000;
	        setTimeout(checkOperationResult, 2000);
	    }
	}

	function maskRunProgram(cmd, msg) {
	    timer = 0;
	    toggleElementsStatus(true);
	    top.showGlobalStatus(msg);
	    top.deleteFile(SUPPORTLIST_OPERATION_RESULT);
	    if (top.proxyAdd && top.proxyPort) {
	        if (top.proxyAdd != "NULL") {
				if (top.proxyType == "https" ||
					top.proxyType == "socks4" ||
					top.proxyType == "socks4a" ||
					top.proxyType == "socks5" ||
					top.proxyType == "socks5h") {
					cmd.push("--proxy-address=" + top.proxyType + "://" + top.proxyAdd);
				} else {
					cmd.push("--proxy-address=" + top.proxyAdd);
				}
	        }
	        if (top.proxyPort != "NULL") {
	            cmd.push("--proxy-port=" + top.proxyPort);
	        }
	        if (top.proxyUid != "NULL") {
	            cmd.push("--proxy-user=" + top.proxyUid);
	        }
	        if (top.proxyPwd != "NULL") {
	            cmd.push("--proxy-password=" + top.proxyPwd);
	        }
	    }
	    top.secureRunProgram(null, cmd, top.BACKGROUND, top.HIDDEN);
	    setTimeout(checkOperationResult, 2000);
	}

	function cancelOperation() {
	    var args = new Array();
	    args.push(getStartingTopDir() + getNativeFileSeparator() + top.guiHelper);
	    args.push("--kill");
	    if (top.OSTYPE == "windows") {
	        args.push(top.workingdir + "\\" + top.mainAppName);
	    } else {
	        args.push(top.workingdir + "/" + top.mainAppName);
	    }
	    args.push("--file");
	    args.push(top.bomc_gui);
	    var ret = secureRunProgram(null, args, FOREGROUND, HIDDEN);
	    toggleElementsStatus(false);
	    return ret;
	}
	/**
	  * Update Target System page with latest system support list acquired from server
	  */
	function updateList() {
	    var cmd = new Array();
	    if (top.OSTYPE == "windows") {
	        cmd.push(top.workingdir + "\\" + top.mainAppName);
	    } else {
	        cmd.push("../proxy.sh");
	        cmd.push(top.mainAppName);
	    }
	    cmd.push("--update-supportlist");
	    cmd.push("--xml");
	    setPreviewParams(cmd);
	    var msg = "Updating system support list now, please wait...";
	    maskRunProgram(cmd, msg);
	}

	/**
	  * Update Target System page with the list bundled in BoMC
	  */
	function rollbackList() {
	    var cmd = new Array();
	    if (top.OSTYPE == "windows") {
	        cmd.push(top.workingdir + "\\" + top.mainAppName);
	    } else {
	        cmd.push("../proxy.sh");
	        cmd.push(top.mainAppName);
	    }
	    cmd.push("--rollback-supportlist");
	    cmd.push("--xml");
	    setPreviewParams(cmd);
	    var msg = "Rolling back system support list now, please wait...";
	    maskRunProgram(cmd, msg);
	}


	return{
		name: "SupportedSystems",
        index: 0,
        init: updateSupportedSystems,
        // select_storage_all: select_storage_all,
        // toggle_jbod: toggle_jbod,
        needReInit: false, 
        nextAction: checkSelectedSystems,
        sortByFamily: sortByFamily,
        sortByMachineType: sortByMachineType,
        // addNewMt: addNewMt,
        addsystemitem: addsystemitem,
        select_all: select_all,
        deleteitem: deleteitem,
        updateList: updateList,
        rollbackList: rollbackList,
        toggleRowSelect: toggleRowSelect,
		sortColumn: sortColumn,
        importId: '#import_supportedSystems',
        selectorId: '.supportedSystems',
        title: "Targeted Systems"   
	}
}();