// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.

var gl_wizard = null;
var gl_wizard_steps = null;
var Welcome = null;
var Acquire_Location = null;
var HttpProxy=null;
var HttpProxy1=null;
var MediaPurpose=null;
var Load_Configuration=null;
var SupportedSystems=null;
var SaveConfiguration=null;
var ObtainLatestVersion=null;
var TargetDirectory=null;
var CreateMedia=null;
var UnattendedConfiguration=null;
var UpdateSelection=null;
var Progress=null;
var Finish = null;
var gl_steps_current=[];

function appendHtml(filename, containerId) {
    var htmlContent = top.readTextFile(top.pathJoin(window.bomc.utils("appBasePath"), filename), "utf-8");
    console.log("filepath: " , top.pathJoin(window.bomc.utils("appBasePath"), filename));
    document.getElementById(containerId).innerHTML += htmlContent;
}

// importHtml to a specific location, function enhanced to support templates.
// options: object - two types of options, 1. contains importId, selectorId and hookId, this is to 
//insert the html content under hookId. 2. contains importId, selectorId, index and title, this is 
//to dynamically instert a jQuery step.
// returns: no returns
function importHtml(options) {
    if (typeof(options) == "undefined" || options == null) {
        console.log("importHtml doesn't define options");
        return doc;
    }
    var doc = document.querySelector(options.selectorId);
    if (doc == null)
    {
        appendHtml(options.pageFilename, options.containerId);
        doc = document.querySelector(options.selectorId);
    }
    var template = Hogan.compile(doc.innerHTML);
    var renderedDoc = template.render(lang);
    if (options.title) {
        gl_wizard.steps("insert", options.index, {
            title: options.title,
            content: renderedDoc
        });
    } else {
        document.querySelector(options.hookId).innerHTML = renderedDoc;
        // var parser = new DOMParser();
        // var domNode = parser.parseFromString(renderedDoc, "text/xml");
        // document.querySelector(options.hookId).appendChild(domNode.documentElement); 
    }
    /*
        if (options.title) {
            gl_wizard.steps("insert", options.index, {
                title : options.title,
                content : doc.innerHTML
            });
        } else {
            document.querySelector(options.hookId).appendChild(doc.cloneNode(true)); 
        }
        */
}

function enableButton(button_id, enable)
{
  //top.logEnter("enableButton", arguments);
  enable = isStringTrue(enable);
  var button = top.root.footer.document.getElementById(button_id);
  button.disabled = !enable;
}

function isStringTrue(string)
{
    if(string == true) return true;
    if(string == false) return false;
    if(typeof string == "string" && string.toUpperCase() == "TRUE") return true;
    return false;
}

function configSteps(newSteps){
    if ( gl_wizard_steps == null)
    {
        //set default steps the same as html defined.
        gl_wizard_steps = [Welcome, SupportedSystems, MediaPurpose, Acquire_Location, HttpProxy, TargetDirectory, CreateMedia, UnattendedConfiguration, SaveConfiguration, UpdateSelection, Progress, Finish, Load_Configuration, ObtainLatestVersion];
    }
    console.log("configSteps");
    for (var i=0; i<newSteps.length; i++) {
        if (!newSteps[i]) {
            alert("Some steps are null: " + i);
            return;
        }
        newSteps[i].index = i;
        var stepFound = false;
        for (var j=i; j< gl_wizard_steps.length; j++){
            if (gl_wizard_steps[j].name == newSteps[i].name) {
                stepFound = true;
                if (j > i) {
                    for (var x = i; x < j; x++) {
                        gl_wizard.steps('remove', i);
                    }
                    gl_wizard_steps.splice(i,(j-i));
                } //else j==i
                break;
            }
        }
        if (!stepFound) {
            importHtml({
                importId: newSteps[i].importId,
                selectorId: newSteps[i].selectorId,
                index: i,
                title: newSteps[i].title
            });
            gl_wizard_steps.splice(i, 0, newSteps[i]);
        }
    }
    if (gl_wizard_steps.length > newSteps.length){
        for (i=newSteps.length; i<gl_wizard_steps.length; i++) {
            gl_wizard.steps('remove', newSteps.length);
        }
    }
    gl_wizard_steps = newSteps.concat();
    gl_steps_current = gl_wizard_steps.concat();
    removeDoneStepClass();
}

function removeDoneStepClass(cIndex){
    if(!cIndex){
        var cIndex = -1;
        $("#navigationbar-vertical").find("li").each(function(i, n){
            var $this = $(this);
            if($this.hasClass("current")){
                cIndex = i;
                return true;
            }
            if(cIndex>-1 && i>cIndex && $this.hasClass("done"))
                $this.removeClass("done").addClass("disabled");
        });
    }else{
        $("#navigationbar-vertical").find("li").each(function(i, n){
            var $this = $(this);
            if(i>cIndex && $this.hasClass("done"))
                $this.removeClass("done").addClass("disabled");
        });
    }
    
}

function goNextStep() {
  $("#navigationbar-vertical").steps("next");
}



$(window).on('load', function() {
    var post = null;
    var doc = null;

    // kill bomc.exe when exit the application in electron
    // 20170208 by yqw
    window.onbeforeunload = function(e) {
        killApp_ux(top.mainAppName);
    };
    
    importHtml({
        importId: '#import_banner',
        selectorId: '.banner',
        hookId: '#banner',
        pageFilename: 'content/banner.html',
        containerId: 'subPageContainer'
    });

    importHtml({
        importId: '#import_welcome',
        selectorId: '.welcome',
        hookId: '#welcome',
        pageFilename: 'content/menu_Welcome.html',
        containerId: 'subPageContainer'
    });

    importHtml({
        importId: '#import_mediaPurpose',
        selectorId: '.mediaPurpose',
        hookId: '#mediaPurpose',
        pageFilename: 'content/menu_MediaPurpose.html',
        containerId: 'subPageContainer'
    });
    
    importHtml({
        importId: '#import_acquire_location',
        selectorId: '.acquire_location',
        hookId: '#acquire_location',
        pageFilename: 'content/menu_AcquireLocation.html',
        containerId: 'subPageContainer'
    });
    
    importHtml({
        importId: '#import_proxy',
        selectorId: '.proxy',
        hookId: '#proxy',
        pageFilename: 'content/menu_Proxy.html',
        containerId: 'subPageContainer'
    });
    

    importHtml({
        importId: '#import_supportedSystems',
        selectorId: '.supportedSystems',
        hookId: '#supportedSystems',
        pageFilename: 'content/menu_SupportedSystems.html',
        containerId: 'subPageContainer'
    });


    importHtml({
        importId: '#import_targetDirectory',
        selectorId: '.targetDirectory',
        hookId: '#targetDirectory',
        pageFilename: 'content/menu_TargetDirectory.html',
        containerId: 'subPageContainer'
    });
    
    importHtml({
        importId: '#import_createMedia',
        selectorId: '.createMedia',
        hookId: '#createMedia',
        pageFilename: 'content/menu_CreateMedia.html',
        containerId: 'subPageContainer'
    });
    
    importHtml({
        importId: '#import_unattendedConfiguration',
        selectorId: '.unattendedConfiguration',
        hookId: '#unattendedConfiguration',
        pageFilename: 'content/menu_UnattendedConfiguration.html',
        containerId: 'subPageContainer'
    });
    
    importHtml({
        importId: '#import_saveConfiguration',
        selectorId: '.saveConfiguration',
        hookId: '#saveConfiguration',
        pageFilename: 'content/menu_SaveConfiguration.html',
        containerId: 'subPageContainer'
    });

    importHtml({
        importId: '#import_updateSelection',
        selectorId: '.updateSelection',
        hookId: '#updateSelection',
        pageFilename: 'content/menu_UpdateSelection.html',
        containerId: 'subPageContainer'
    });

    importHtml({
        importId: '#import_progress',
        selectorId: '.progress',
        hookId: '#progress',
        pageFilename: 'content/menu_Progress.html',
        containerId: 'subPageContainer'
    });
    
    importHtml({
        importId: '#import_finish',
        selectorId: '.finish',
        hookId: '#finish',
        pageFilename: 'content/menu_Finish.html',
        containerId: 'subPageContainer'
    });
    
    importHtml({
        importId: '#import_loadconfig',
        selectorId: '.loadconfig',
        hookId: '#loadconfig',
        pageFilename: 'content/menu_LoadConfiguration.html',
        containerId: 'subPageContainer'
    });
    
    importHtml({
        importId: '#import_obtainLatestVersion',
        selectorId: '.obtainLatestVersion',
        hookId: '#obtainLatestVersion',
        pageFilename: 'content/menu_ObtainLatestVersion.html',
        containerId: 'subPageContainer'
    });
    console.log("success import html.");
    gl_wizard = $("#navigationbar-vertical").steps({
        headerTag: "h3",
        bodyTag: "section",
        transitionEffect: "slideLeft",
        stepsOrientation: "vertical", 
        onInit: function(event, currentIndex) 
        {
            console.log("common_init.");
            common_init();
            console.log("success on init.");
        },
        onStepChanging: function(event, currentIndex, newIndex) {
            // Always allow going backward even if the current step contains invalid fields!
            if (currentIndex > newIndex) {
                if (gl_wizard_steps[currentIndex].previousAction){
                    gl_wizard_steps[currentIndex].previousAction();
                }
                return true;
            }

            if (currentIndex < newIndex) {
                var act_next = gl_wizard_steps[currentIndex].nextAction();
                if(act_next == true
                    && gl_wizard_steps[newIndex] != Finish)
                {
                    togglePrevious(false);
                    toggleNext(false);
                }
                return act_next;
            }
        },
        onContentLoaded: function(event, currentIndex) {
            console.log("step "+ currentIndex + " loaded" + event);
        },
        onStepChanged: function(event, currentIndex, priorIndex) {
            console.log("step changed");
            //Refresh the step page if needRefresh
            removeDoneStepClass(currentIndex);
            if(gl_wizard_steps[currentIndex] != UpdateSelection
                && gl_wizard_steps[currentIndex] != Progress
                && gl_wizard_steps[currentIndex] != Finish) {
                togglePrevious(true);
                toggleNext(true);
            }
            if (currentIndex > priorIndex) {
                if (gl_wizard_steps[currentIndex].needRefresh){
                    importHtml({
                        importId: gl_wizard_steps[currentIndex].importId,
                        selectorId: gl_wizard_steps[currentIndex].selectorId,
                        hookId: '#navigationbar-vertical-p-' + currentIndex
                    });
                }
                gl_wizard_steps[currentIndex].init();
            } else if (gl_wizard_steps[currentIndex].needReInit){
                gl_wizard_steps[currentIndex].init();
            } else if (gl_wizard_steps[currentIndex].backEntry) {
                gl_wizard_steps[currentIndex].backEntry();
            }
            disableAllTab();
        },
        onFinishing: function(event, currentIndex) {
            var form = $(this);

            // Disable validation on fields that are disabled.
            // At this point it's recommended to do an overall check (mean ignoring only disabled fields)
            form.validate().settings.ignore = ":disabled";

            // Start validation; Prevent form submission if false
            // return form.valid();
            return true;
        },
        onFinished: function(event, currentIndex) {
            Exit();
        } 
    });

    configSteps([Welcome, SupportedSystems, MediaPurpose, Acquire_Location, HttpProxy, TargetDirectory, CreateMedia, UnattendedConfiguration, SaveConfiguration, UpdateSelection, Progress, Finish]);

});