// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Update_Execution = function() {
    var up_progress_timer;
    var up_table_visibility;
    var up_total;
    var up_package_index;
    var up_package_index_last;
    var up_running;
    var startUploadFFDCLog;
    var up_isUnattended;
    // var up_isPurley;
    var up_isGrantly;
    var up_args;

    // for bmu case
    // for the case that user need to flash both oob and bmu packages
    // first step, flash oob packages, up_stage = 0
    // second step, flash bmu packages, up_stage = 1
    var up_stage;
    // value: "oob", "bmu" and "both"
    var up_type;
    var oobResultMsg, oobResultError;

    // current index of payload that is copying
    var copyIndex = 0;
    // total number of payloads that need copy
    var copyTotal = 0;
    // if a payload is failed to copy, will push into this array
    // if copyError.length > 0, will warn user
    // if copyError.length = copyTotal, will let user retry
    var copyError = new Array();

    var waitForComplete = 0;

    // for salie, after comparing updates and user select packages to update, will copy payloads from /run/initramfs/live to /toolscenter
    // after copying, start normal process
    function up_init() {
        printLog("INFO","Update Execution page init.");
        // fix problem that when it is bootable, unattended mode in usb, Update_Execution will be inited when Update Comparison is not finished. 
        // do not init Update Execution when Update Comparison is not finished. 
        if (top.gl_uxlite_bootable) {
            if (top.gl_isOnecli == undefined) {
                return;
            }
        }
        if (top.gl_uxlite_bootable && top.fileExists('/etc/redhat-release')) {
            var osRelease = '';
            try {
                osRelease = top.readTextFile('/etc/redhat-release');
            } catch(e) {
                osRelease = ''; 
            }
            // only need copy payloads when it is salie and it is not boot by usb key or pxe
            // for salie, in /etc/redhat-release, it is CentOS
            if (osRelease.indexOf('CentOS') != -1 && top.need_copy()) {
                startCopy();
            } else {
                up_init_normal();
            }
        } else {
            up_init_normal();
        }
    }

    function startCopy() {
        top.togglePrevious(false);
        top.toggleNext(false);
        copyTotal = top.gl_co_list.length;
        copyIndex = 0;
        copyError = new Array();
        $('#copyMsg').html('');
        $('#errMsgExec2').html('');
        $('#errMsgExec').hide();
        $('#warnMsgExec').hide();
        $('#warnMsgExec2').html('');
        $('#copy_success').hide();
        $('#copyBeginSection').hide();
        $('#updateBeginSection').hide();
        document.getElementById('copyProgress').style.marginRight = '100%';
        $('#copy_status').show();
        if (in_ramdisk()) {
            var mountArgs = new Array();
            mountArgs.push("mount");
            mountArgs.push("/dev/sr0");
            mountArgs.push("/run/initramfs/live");
            runProgram(mountArgs, null, copyPayload);
        }
        else {
            copyPayload(true);
        }
    }

    function copyPayload(success) {
        if (!success) {
            copyError.push(top.gl_co_list[copyIndex - 1]);
        }
        if (copyIndex > copyTotal - 1) {
            if (in_ramdisk()) {
                var umountArgs = new Array();
                umountArgs.push("umount");
                umountArgs.push("/run/initramfs/live");
                runProgram(umountArgs, null, completeCopy);
            }
            else {
                completeCopy();
            }
        } else {
            var copyArgs = new Array();
            copyArgs.push(top.getSystemFile('copyPayload'));
            copyArgs.push(top.gl_co_list[copyIndex]);
            copyIndex++;
            // show progress
            document.getElementById("copyMsg").innerHTML = $.i18n.prop("UpdateExec.Copying") + " " + copyIndex + " of " + copyTotal;
            var percentage = formatData((1 - copyIndex / copyTotal) * 100) + "%";
            document.getElementById("copyProgress").style.marginRight = percentage;
            printLog("INFO","run commend:" + getRunProgramCommend(copyArgs));
            runProgram(copyArgs, null, copyPayload);
        }
    }

    function completeCopy() {
        $('#copy_status').hide();
        top.togglePrevious(true);
        if (copyError.length == copyTotal) {
            $('#errMsgExec').show();
            $('#errMsgExec2').html($.i18n.prop('UpdateExec.FailCopyAll'));
            $('#copyBeginSection').show();
            top.toggleNext(false);
        } else if (copyError.length > 0) {
            $('#warnMsgExec').show();
            var warnMsg = $.i18n.prop('UpdateExec.FailCopySome');
            for (var i = 0; i < copyError.length; i++) {
                warnMsg += '<br>' + copyError[i];
            }
            $('#warnMsgExec2').html(warnMsg);
            $('#copyBeginSection').show();
            $('#updateBeginSection').show();
            top.toggleNext(true);
        } else {
            $('#copy_success').show();
            $('#copyBeginSection').hide();
            up_init_normal();
        }
    }

    function up_init_normal() {
        // init
        // if execution page is inited, View Log at Finish page should show flash log instead of acquiring log.
        // clean the previous value of top.gl_logfile
        // if flash is success, it will assign a new value to this variable, else, it will remain an empty string.
        top.gl_logfile = "";
        up_table_visibility = false;
        up_total = -1;
        up_package_index = 0;
        up_package_index_last = -1;
        up_running = false;
        startUploadFFDCLog = false;
        up_stage = null;
        up_type = null;
        up_args = new Array();
        top.togglePrevious(true);

        if (top.gl_oobPackList.length > 0 && top.gl_bmuPackList.length == 0) up_type = "oob";
        else if (top.gl_oobPackList.length == 0 && top.gl_bmuPackList.length > 0) up_type = "bmu";
        else if (top.gl_oobPackList.length > 0 && top.gl_bmuPackList.length > 0) {
            up_type = "both";
            // up_stage = 0;
        }

        $("#up_status").hide();
        $("#updateBeginSection").show();
        up_isUnattended = top.getEnv("BOMC_UNATTENDED_MODE");
        toggleNext(false);
        // fix problem that flash is not started automatically when autorun is enabled
        if (top.gl_uxlite_bootable == '1') {
            if (top.is_unattend() || top.is_autorun()) {
                $("#updateBeginBtn").click();
            }
        }
        // if (top.gl_uxlite_bootable == "1" && up_isUnattended) {
        //     $("#updateBeginBtn").click();
        // }
        // up_isPurley = top.isPurley();
        up_isGrantly = top.isGrantly();
        /*
        if (top.gl_OOB_Params.MT.startsWith("7x") || top.gl_OOB_Params.MT.startsWith("7X") || top.gl_current_mt_d.startsWith("7x") || top.gl_current_mt_d.startsWith("7X")) {
            up_isPurley = true;
        }
        */
    }

    function rewrite_cp_result(callback) {
        // gl_selected_list, gl_forceid_list
        var cpResult = top.getSupportFile('compareResult', 'rewrite');
        // var selectList = top.gl_co_list;
        if (top.fileExists(cpResult)) {
            top.deleteFile(cpResult);
        }
        var cp_content = '';
        try {
            cp_content = top.readTextFile(top.getSupportFile('compareResult', 'oneCli'));
        } catch(e) {
            cp_content = '';
        }

        var cp_dom = ezJsLib.XmlDom.parse(cp_content)
        var cp_total = ezJsLib.XmlDom.getValueByTag('TOTAL', cp_dom)

        var tag_sel = 0;
        var tag_force = 0;
        
        var instream = fs.createReadStream(top.getSupportFile('compareResult', 'oneCli'));
        var outstream = new (require('stream'))();
        var rl = readline.createInterface(instream, outstream);
        rl.on('line', function(line) {
            if (line.indexOf('UPDATEID') != -1) {
                for (var i = 0; i < top.gl_selected_list.length; i++) {
                    if (line.indexOf(top.gl_selected_list[i]) != -1) {
                        tag_sel = 1;
                        break;
                    }
                    tag_sel = 0;
                }
                for (var i = 0; i < top.gl_forceid_list.length; i++) {
                    if (line.indexOf(top.gl_forceid_list[i]) != -1) {
                        tag_force = 1;
                        break;
                    }
                    tag_force = 0;
                }
                /*if (tag_sel == 1) {
                    var current_updateid = '';
                    current_updateid = line.replace('<UPDATEID>', '').replace('</UPDATEID>', '').trim();
                    var cp_pack = '';
                    var cp_updateid = '';
                    var cp_selected = '';
                    for (var i = 0; i < cp_total; i++) {
                        cp_pack = ezJsLib.XmlDom.getNodeByTagAndIndex('PACKAGE', cp_dom, i);
                        cp_updateid = ezJsLib.XmlDom.getValueByTagFromNode('UPDATEID', cp_pack);
                        cp_selected = ezJsLib.XmlDom.getValueByTagFromNode('SELECTED', cp_pack);
                        if (cp_updateid == current_updateid) {
                            if (cp_selected.toString() == '0') {
                                tag_force = 1;
                                break;
                            }
                            tag_force = 0;
                        }
                    }
                }*/
            }
            // if (line.indexOf('<CHILDUPDATES>') != -1) {
            //     tag_child = true;
            // }
            // if (line.indexOf('</CHILDUPDATES>') != -1) {
            //     tag_child = false;
            // }
            // if (line.indexOf('SELECTED') != -1 && line.indexOf('UNSELECTEDREASON') == -1 && !tag_child) {
            if (line.indexOf('<SELECTED>') != -1) {
                if (line.indexOf('0') != -1) {
                    line = line.replace('0', tag_sel);
                } else if (line.indexOf('1') != -1) {
                    line = line.replace('1', tag_sel);
                }
            }
            if (line.indexOf('<CSELECTED>') != -1) {
                if (line.indexOf('0') != -1) {
                    line = line.replace('0', tag_sel);
                } else if (line.indexOf('1') != -1) {
                    line = line.replace('1', tag_sel);
                }
            }
            if (line.indexOf('FORCEID') != -1) {
                if (line.indexOf('0') != -1) {
                    line = line.replace('0', tag_force);
                } else if (line.indexOf('1') != -1) {
                    line = line.replace('1', tag_force);
                }
            }
            if (line.indexOf('</PACKAGE>') != -1) {
                tag_sel = 0;
                tag_force = 0;
            }
            line = line + '\n';
            top.writeTextFile(cpResult, line, true);
        });
        rl.on('close', function(line) {
            if (callback) callback();
        });
    }

    function confirmUpdate() { 
        printLog("INFO","button 'Begin Update' was clicked.");
        $('#copy_status').hide();
        $('#errMsgExec').hide();
        $('#warnMsgExec').hide();
        $('#copy_success').hide(); 
        $('#copyBeginSection').hide();
        if (top.gl_uxlite_bootable == "1" && (top.is_unattend() || top.is_autorun())) {
            beginExecute();
        } else {
            // if (top.gl_OOB_Params.Enabled && (up_type == "bmu" ||up_type == "both")) {
            if (top.gl_OOB_Params.Enabled) {
                if (confirm($.i18n.prop("UpdateExec.RebootConfirm"))) {
                    beginExecute();
                }
            } else {
                if (confirm($.i18n.prop("UpdateExec.UpdateConfirm"))) {
                    beginExecute();
                }
            }
        }
    }

    function beginExecute() {
        // show status bar and hide begin button
        $("#updateBeginSection").hide();
        $("#up_status").show();
        beginUpdate();
    }

    function updateCB() {
        up_args.push("--comparexml");
        // if (!top.gl_OOB_Params.Enabled) {
        //     up_args.push(top.getSupportFile('compareResult', 'inband'));
        // } else {
        //     if (up_type == "oob" || (up_type == "both" && up_stage == 0)) {
        //         up_args.push(top.getSupportFile('compareResult', 'oob'));
        //     } else if (up_type == 'bmu' || (up_type == 'both' && up_stage == 1)) {
        //         up_args.push(top.getSupportFile('compareResult', 'bmu'));
        //     }
        // }
        up_args.push(top.getSupportFile('compareResult', 'rewrite'));
        togglePrevious(false);
        toggleNext(false);
        up_running = true;
        top.store_onecli_command(up_args);
        printLog("INFO","run commend:" + getRunProgramCommend(up_args));
        runProgram(up_args, null, markComplete);
        up_progress_timer = setInterval(showStatus_up, 1000);
    }

    function RemoteServerConnInfo() {
        if (top.gl_OOB_Params.Remote_UserName != "" || top.gl_OOB_Params.Remote_Password != "") {
            if (top.gl_OOB_Params.Remote_Port == "") {
                if (top.gl_OOB_Params.Remote_Address.indexOf(":") != -1) {
                    return (top.gl_OOB_Params.Remote_UserName + ":" + top.gl_OOB_Params.Remote_Password + "@[" + top.gl_OOB_Params.Remote_Address + "]" + top.gl_OOB_Params.Remote_Location);
                } else {
                    return (top.gl_OOB_Params.Remote_UserName + ":" + top.gl_OOB_Params.Remote_Password + "@" + top.gl_OOB_Params.Remote_Address + top.gl_OOB_Params.Remote_Location);
                }
            } else {
                if (top.gl_OOB_Params.Remote_Address.indexOf(":") != -1) {
                    return (top.gl_OOB_Params.Remote_UserName + ":" + top.gl_OOB_Params.Remote_Password + "@[" + top.gl_OOB_Params.Remote_Address + "]:" + top.gl_OOB_Params.Remote_Port + top.gl_OOB_Params.Remote_Location);
                } else {
                    return (top.gl_OOB_Params.Remote_UserName + ":" + top.gl_OOB_Params.Remote_Password + "@" + top.gl_OOB_Params.Remote_Address + ":" + top.gl_OOB_Params.Remote_Port + top.gl_OOB_Params.Remote_Location);
                }
            }
        } else {
            if (top.gl_OOB_Params.Remote_Port == "") {
                if (top.gl_OOB_Params.Remote_Address.indexOf(":") != -1) {
                    return ("[" + top.gl_OOB_Params.Remote_Address + "]" + top.gl_OOB_Params.Remote_Location);
                } else {
                    return (top.gl_OOB_Params.Remote_Address + top.gl_OOB_Params.Remote_Location);
                }
            } else {
                if (top.gl_OOB_Params.Remote_Address.indexOf(":") != -1) {
                    return ("[" + top.gl_OOB_Params.Remote_Address + "]:" + top.gl_OOB_Params.Remote_Port + top.gl_OOB_Params.Remote_Location);
                } else {
                    return (top.gl_OOB_Params.Remote_Address + ":" + top.gl_OOB_Params.Remote_Port + top.gl_OOB_Params.Remote_Location);
                }
            }
        }
    }

    function beginUpdate() {
        //Preparation
        waitForComplete = 0;
        deleteFile(top.getVarLogFile("updateResult", "uxspi"));
        deleteFile(top.getSupportFile("updateResult", "oneCli"));
        deleteFile(top.getSupportFile("commonResult"));
        up_args = new Array();
        up_args.push(top.getSystemFile("oneCli"));
        up_args.push("update");
        up_args.push("flash");
        // if(top.gl_isOnecli) {
        //     up_args.push("--nocompare");
        // }
        if (top.gl_OOB_Params.Enabled) {
            up_args.push("--uselocalimg");
            up_args.push("--imm");
            up_args.push(SplitFullConnInfo());
            
            if (top.gl_OOB_Params.Use_Sep_Remote) {
                // One and only one protocol has been selected in OOBSetting
                if (top.gl_OOB_Params.Use_Sep_SFTP) {
                    up_args.push("--sftp");
                } else if (top.gl_OOB_Params.Use_Sep_HTTPS) {
                    up_args.push("--https");
                } else if (top.gl_OOB_Params.Use_Sep_FTP) {
                    up_args.push("--ftp");
                } else if (top.gl_OOB_Params.Use_Sep_HTTP) {
                    up_args.push("--http");
                }
                up_args.push(RemoteServerConnInfo());
            }
            up_args.push("--never-check-trust");
        } else {
            // inband CFC also use external server
            if (top.isCFC()) {
                if (top.gl_OOB_Params.Use_Sep_HTTPS) {
                    up_args.push("--https");
                } else if (top.gl_OOB_Params.Use_Sep_FTP) {
                    up_args.push("--ftp");
                }
                up_args.push(RemoteServerConnInfo());
                up_args.push("--never-check-trust");
            }
        }

        // inband parameters
        // add by chenhao at 20170606
        if (top.gl_Inband_Params.Enabled && top.gl_Inband_Params.UserInput) {
            if (top.gl_Inband_Params.IMM_UserName != "" && top.gl_Inband_Params.IMM_UserName != null && top.gl_Inband_Params.IMM_UserName != undefined
             && top.gl_Inband_Params.IMM_Password != "" && top.gl_Inband_Params.IMM_Password != null && top.gl_Inband_Params.IMM_Password != undefined) {
                up_args.push("--bmc-username");
                up_args.push(top.gl_Inband_Params.IMM_UserName);
                up_args.push("--bmc-password");
                up_args.push(top.gl_Inband_Params.IMM_Password);
            }
            //  TODO: --bmc-cimport
            if (top.gl_Inband_Params.IMM_Port != "" && top.gl_Inband_Params.IMM_Port != null && top.gl_Inband_Params.IMM_Port != undefined) {
                up_args.push("--bmc-cim-port");
                up_args.push(top.gl_Inband_Params.IMM_Port);
            }

            if (top.gl_Inband_Params.REST_Port != "" && top.gl_Inband_Params.REST_Port != null && top.gl_Inband_Params.REST_Port != undefined) {
                up_args.push("--bmc-rest-port");
                up_args.push(top.gl_Inband_Params.REST_Port);
            }
        }

        up_args.push("--dir");
        up_args.push(top.gl_workingDir);
        up_args.push(...add_output_log5());
        var updateIds = "";
        var forceIds = "";

        if (top.gl_optionBackup == true) {
            up_args.push("--backup");
        }

        // grantley bmu function
        // red systems have bmu function always
        // no need to determine whether the system is purley or grantley
        // if (top.gl_OOB_Params.Enabled && up_isPurley) {  
        if (!top.gl_OOB_Params.Enabled && !top.gl_isOnecli) {   // UXSPI case
            for (var i = 0; i < top.gl_selected_list.length; i++) {
                if (i == 0) updateIds += top.gl_selected_list[i]; 
                else updateIds += "," + top.gl_selected_list[i];
            }
            up_args.push("--includeid");
            up_args.push(updateIds);

            if (top.gl_forceid_list.length > 0) {
                for (var i = 0; i < top.gl_forceid_list.length; i++) {
                    if (i == 0) forceIds += top.gl_forceid_list[i]; 
                    else forceIds += "," + top.gl_forceid_list[i];
                }
                up_args.push("--forceid");
                up_args.push(forceIds);
            }
            
            togglePrevious(false);
            toggleNext(false);
            up_running = true;
            // defect-160364: BOMC boot from USBkey, when update fail, then click "previous" return to "update conparison" page, can't click “next” button
            var co_file_path = top.getVarLogFile("compareResult", "uxspi");
            var co_file_bak_path = top.getVarLogFile("compareResult", "uxspi_bak");
            if (co_file_path) {
                fs.renameSync(co_file_path, co_file_bak_path);
            }
            printLog("INFO","run commend:" + getRunProgramCommend(up_args));
            runProgram(up_args, null, markComplete);
            up_progress_timer = setInterval(showStatus_up, 1000);
        // } else if (top.gl_OOB_Params.Enabled) {     // OOB case
        //     if (up_type == "oob" || (up_type == "both" && up_stage == 0)) {
        //         rewriteCpResult('oob', updateCB);
        //     } else if (up_type == "bmu" || (up_type == "both" && up_stage == 1)) {
        //         up_args.push("--bmu");
        //         rewriteCpResult('bmu', updateCB);
        //     }
        } else {    // inband case and oob case
            if (top.gl_OOB_Params.Enabled && !top.isAmd()) {
                up_args.push('--platform');
            }
            if (top.is_reboot_bmc() == false) {
                up_args.push('--noreboot');
            }
            // rewriteCpResult('inband', updateCB);
            rewrite_cp_result(updateCB);
        }
    }

    function markComplete(rc, error) {
        up_running = false;
    }

    function up_backEntry() {
        // do nothing when back from the next page
    }

    function showStatus_up() {
        var up_running_cache = up_running;
        var content;        
        if(top.fileExists(top.getSupportFile("updateResult", "oneCli"))) {
            content = top.readTextFile(top.getSupportFile("updateResult", "oneCli"));    
        } else if(top.fileExists(top.getVarLogFile("updateResult", "uxspi"))) {
            content = top.readTextFile(top.getVarLogFile("updateResult", "uxspi"));
        }
        if (content != null) {
            var dom = ezJsLib.XmlDom.parse(content);
            if (!up_table_visibility)  {
                createDetailTable(dom);
                up_table_visibility = true;
            }
            updateDetailTable(dom, up_running_cache);
            updateProgressBar(up_running_cache);
        }
        // } else if (up_type == "both" && up_stage == 1) {
        //     // flash xml is not generated yet, mock the status as "Ready"
        //     document.getElementById('up_progress_table').rows[2 + top.gl_oobPackList.length].cells[2].innerHTML = "<img src='images/progress_anim2_small.gif'>" + "Preparing environment";
        //     document.getElementById('up_progress_table').rows[2 + top.gl_oobPackList.length].cells[2].title = "Preparing environment";
        // }
        //if (!up_running_cache && (up_total == up_package_index)) 
        // Bug 117321 - xClarity Essential tool BoMC v11.0 window hung and fail to exit after system update completed.
        // for bootable mode, will detect whether common_result.xml is completed writing
        // if it is completed writing, will set up_running_cache to false
        // added by chenhao: 2017.11.1
        if (top.gl_uxlite_bootable) {
            if (top.fileExists(top.getSupportFile('commonResult'))) {
                var resultFile = top.readTextFile(top.getSupportFile('commonResult'));
                var resultDom;
                var resultRC;
                if (resultFile != null) {
                    try {
                        resultDom = ezJsLib.XmlDom.parse(resultFile);
                        resultRC = ezJsLib.XmlDom.getValueByTagFromNode("RETURNCODE", resultDom.documentElement);
                    } catch(e) {
                        // do nothing
                    }
                    console.log('resultRC is: ' + resultRC);
                    if (resultRC != null || resultRC != undefined) {
                        up_running_cache = false;
                    }
                }
            }
        }
        if (!up_running_cache) {
            clearInterval(up_progress_timer);
            getCommonResult();
            if (needPrereqWarn()) {
                top.gl_needPrereqWarn = true;
            }
            // up_isPurley is no need
            // if (top.gl_OOB_Params.Enabled && up_isPurley && up_type == "both" && (up_stage == 0 || up_stage == 1)) {
            // if (top.gl_OOB_Params.Enabled && up_type == "both" && (up_stage == 0 || up_stage == 1)) {
            //     togglePrevious(false);
            //     toggleNext(false);
            // } else {
            //     togglePrevious(true);
            //     toggleNext(true);
            // }
            togglePrevious(true);
            toggleNext(true);
        }
    }

    function needPrereqWarn() {
        var content = null;
        var res = false;

        if(top.fileExists(top.getSupportFile("updateResult", "oneCli"))) {
            content = top.readTextFile(top.getSupportFile("updateResult", "oneCli"));
            if (content != null) {
                var dom = ezJsLib.XmlDom.parse(content);
                var total = ezJsLib.XmlDom.getValueByTag("TOTAL", dom);
                var res_code;
                var prereq_code = "1703";
                for (var i = 0; i < total; i++) {
                    res_code = ezJsLib.XmlDom.getValueByTagAndIndex("RESCODE", dom, i);
                    if (res_code === prereq_code) {
                        res = true;
                        break;
                    } else {
                        res = false;
                    }
                }
            }
        }

        return res;
    }

    function createDetailTable(dom) {
        var table = document.getElementById('up_progress_table');
        var mt, os, total;
        if (top.gl_isOnecli) {   
            mt = top.gl_current_mt_d;
            os = top.gl_current_os_d;
            // arch = top.gl_current_arch_d;
        } else {
            mt = ezJsLib.XmlDom.getValueByTag("MT", dom);
            os = ezJsLib.XmlDom.getValueByTag("OS", dom);
            // arch = ezJsLib.XmlDom.getValueByTag("ARCH", dom);
        }
        // for OOB case, need to get MT from remote machine
        if (top.gl_OOB_Params.Enabled) mt = top.gl_OOB_Params.MT;

        total = ezJsLib.XmlDom.getValueByTag("TOTAL", dom);

        document.getElementById("up_progress").style.display = "";
        table.style.visibility = "visible";
        /************ Why the following method does not work on IE? Include <td> in the <tr>?*************/
        /*var con = "<td colspan=\"2\" class='EntityTableCell2'>Machine-Type=\""
                    + mt + "\", OS="
                    + os + "</td>";
        alert(con);
        table.insertRow(-1).innerHTML = con;*/

        var newCell = table.insertRow(-1).insertCell(-1);
        newCell.colSpan = 4;
        newCell.className = "EntityTableCell2";
        if (top.gl_uxlite_bootable == "1") {
            newCell.innerHTML = "Machine-Type=\"" + mt + "\"";
        } else if (top.gl_OOB_Params.Enabled) {
            newCell.innerHTML = "Remote Machine-Type=\"" + mt + "\"";
        } else {
            // newCell.innerHTML = "Machine-Type=\"" + mt + "\", OS=" + os + " (" + arch + ")";
            newCell.innerHTML = "Machine-Type=\"" + mt + "\", OS=" + os;
        }
        up_total = parseInt(total);
        // if (top.gl_OOB_Params.Enabled && up_isPurley && up_type == "both") up_total += top.gl_bmuPackList.length;
        // if (top.gl_OOB_Params.Enabled && up_type == "both") up_total += top.gl_bmuPackList.length;
        for (var i = 0; i < total; i++) {
            //default consider that its a full xml file, including all nodes
            var nameValue, reboot, statusValue, errorMsg, updateId, CompValue, resultValue;
            nameValue = ezJsLib.XmlDom.getValueByTagAndIndex("NAME", dom, i);
            reboot = ezJsLib.XmlDom.getValueByTagAndIndex("REBOOT", dom, i);
            errorMsg = ezJsLib.XmlDom.getValueByTagAndIndex("ERRORMESSAGE", dom, i);
            updateId = ezJsLib.XmlDom.getValueByTagAndIndex("UPDATEID", dom, i);
            CompValue = ezJsLib.XmlDom.getValueByTagAndIndex("COMPONENT", dom, i);
            resultValue = ezJsLib.XmlDom.getValueByTagAndIndex("RESULT", dom, i);
            statusValue = ezJsLib.XmlDom.getValueByTagAndIndex("STATUS", dom, i);
            if (top.gl_isOnecli)
            {
                statusValue = ezJsLib.XmlDom.getStatus(statusValue);
            }
            // Check whether uEFI update succeed.
            var pos = CompValue.indexOf("UEFI")
            if (pos != -1) {
                top.gl_isValidUefiUpdate = true;//fix coverity issue 46956
            }

            //add a new row
            var newRow = table.insertRow(-1);

            var newCell1 = newRow.insertCell(-1);
            newCell1.innerHTML = nameValue;
            newCell1.title = nameValue;
            newCell1.className = "EntityTableCell";

            /*
            var newCell4 = newRow.insertCell(-1);
            newCell4.innerHTML = newVersion;
            newCell4.title = newVersion;
            newCell4.className = "EntityTableCell";
            */

            var newCell6 = newRow.insertCell(-1);
            if (reboot.indexOf("No") != -1) {
                newCell6.innerHTML = reboot;
            } else {
                newCell6.innerHTML = "Required";
            }
            newCell6.title = reboot;
            newCell6.className = "EntityTableCell";

            var newCell7 = newRow.insertCell(-1);
            newCell7.title = statusValue;
            newCell7.className = "EntityTableCell";
            if (statusValue == "Successfully Installed") {
                newCell7.innerHTML = "<img src='images/statusSuccess_obj16.gif'>" + statusValue;
            } else if (statusValue == "Running") {
                newCell7.innerHTML = "<img src='images/progress_anim2_small.gif'>" + statusValue;
            } else if (statusValue == "Not Started") {
                newCell7.innerHTML = "<img src='images/statusStopped_obj16.gif'>" + statusValue;
            } else {
                var values = new Array();
                filterStatusValue(values, statusValue);
                if (values.length == 3) {
                    newCell7.title = values[2];
                    if (values[0] == "Not Applicable") {
                        newCell7.innerHTML = "<img src='images/statusInformation_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + values[2] + "');\">" + $.i18n.prop("UpdateExec.HardwareNotPresent") + "</a>";
                    } else {
                        newCell7.innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + values[2] + "');\">" + $.i18n.prop("UpdateExec.More") + "</a>";
                    }
                } else if (values.length == 1) {
                    if (errorMsg == "") {
                        table.rows[up_package_index + 2].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0];
                    } else {
                        newCell7.title = errorMsg;
                        newCell7.innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + errorMsg + "');\">" + $.i18n.prop("UpdateExec.FailMsg") + "</a>";
                    }
                } else {
                    newCell7.innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                }
            }
            // add new column "Result"
            // 20161115 by chenhao
            var newCell8 = newRow.insertCell(-1);
            if (!resultValue || resultValue == "") {
                // do nothing
            } else {
                newCell8.innerHTML = resultValue;
                newCell8.title = resultValue;
            }
            newCell8.className = "EntityTableCell";
        }
        // if (top.gl_OOB_Params.Enabled && up_isPurley && up_type == "both") {
        // if (top.gl_OOB_Params.Enabled && up_type == "both") {
        //     for (var i = 0; i < top.gl_bmuPackList.length; i++) {
        //         var newRow = table.insertRow(-1);
        //         var newCell1 = newRow.insertCell(-1);
        //         newCell1.innerHTML = top.gl_bmuPackList[i];
        //         newCell1.title = top.gl_bmuPackList[i];
        //         newCell1.className = "EntityTableCell";

        //         var newCell6 = newRow.insertCell(-1);
        //         newCell6.innerHTML = "";
        //         newCell6.title = "";
        //         newCell6.className = "EntityTableCell";

        //         var newCell7 = newRow.insertCell(-1);
        //         newCell7.innerHTML = "<img src='images/statusStopped_obj16.gif'>" + "Not Started";
        //         newCell7.title = "Not Started";
        //         newCell7.className = "EntityTableCell";

        //         var newCell8 = newRow.insertCell(-1);
        //         newCell8.innerHTML = "";
        //         newCell8.title = "";
        //         newCell8.className = "EntityTableCell";
        //     }
        // }
    }

    function updateDetailTable(dom, up_running_cache) {
        var table = document.getElementById('up_progress_table');
        var root = dom.documentElement;
        var nodes = root.getElementsByTagName("PACKAGE");
        var finishCount = 0;
        for(var nodeIndex = 0; nodeIndex < nodes.length; nodeIndex++) {
            if(!top.gl_OOB_Params.Enabled && up_isGrantly) {
                var statusNodes = nodes[nodeIndex].getElementsByTagName("STATUS");
                var msgNodes = nodes[nodeIndex].getElementsByTagName("ERRORMESSAGE");
                var errorMsg = "";
                var resultNodes = nodes[nodeIndex].getElementsByTagName("RESULT");
                var resultMsg = "";
                if (msgNodes[0]) {
                    if (msgNodes[0].childNodes[0]) {
                        errorMsg = msgNodes[0].childNodes[0].nodeValue;
                    }
                }
                if (resultNodes[0]) {
                    if (resultNodes[0].childNodes[0]) {
                        resultMsg = resultNodes[0].childNodes[0].nodeValue;
                    }
                    if (!resultMsg || resultMsg == "") {
                        // do nothing
                    } else {
                        table.rows[nodeIndex + 2].cells[3].title = resultMsg;
                        table.rows[nodeIndex + 2].cells[3].innerHTML = resultMsg;
                    }
                }
                if (statusNodes[0]) {
                    if (statusNodes[0].childNodes[0]) {
                        var statusValue = ezJsLib.XmlDom.getStatus(statusNodes[0].childNodes[0].nodeValue);
                        table.rows[nodeIndex + 2].cells[2].title = statusValue;
                        if (statusValue == "Not Started") {
                            //do nothing, keep original table
                            if (!up_running_cache) 
                                finishCount++;
                        } else if (statusValue == "Running") {
                            if (!up_running_cache) {
                                table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + $.i18n.prop("UpdateExec.NotFinish");
                                finishCount++;
                            } else {
                                table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/progress_anim2_small.gif'>" + statusValue;
                            }
                        } else if (statusValue == "Successfully Installed") {
                            table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusSuccess_obj16.gif'>" + statusValue;
                            finishCount++;
                        } else {
                            //table.rows[nodeIndex + 2].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                            var updateId = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", nodes[nodeIndex]);
                            var values = new Array();
                            filterStatusValue(values, statusValue);
                            if (values.length == 3) {
                                table.rows[nodeIndex + 2].cells[2].title = values[2];
                                if (values[0] == "Not Applicable") {
                                    table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusInformation_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + values[2] + "');\">" + $.i18n.prop("UpdateExec.HardwareNotPresent") + "</a>";
                                } else {
                                    table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + values[2] + "');\">" + $.i18n.prop("UpdateExec.More") + "</a>";
                                }
                            } else if (values.length == 1) {
                                if (errorMsg == "") {
                                    table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0];
                                } else {
                                    table.rows[nodeIndex + 2].cells[2].title = errorMsg;
                                    table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + errorMsg + "');\">" + $.i18n.prop("UpdateExec.FailMsg") + "</a>";
                                }
                            } else {
                                table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                            }
                            finishCount++;
                        }
                    }
                }
            } else {    // for OOB and Purley case: add by chenhao: 20161101
                var statusNodes = nodes[nodeIndex].getElementsByTagName("STATUS");
                var resultNodes = nodes[nodeIndex].getElementsByTagName("RESULT");
                var rcNodes = nodes[nodeIndex].getElementsByTagName("RCODE");
                var rebootNodes = nodes[nodeIndex].getElementsByTagName("REBOOT");
                var statusValue, resultValue, rcValue, rebootValue;
                try {
                    statusValue = statusNodes[0].childNodes[0].nodeValue;
                } catch(e) {
                    statusValue = "";
                }
                try {
                    resultValue = resultNodes[0].childNodes[0].nodeValue;
                } catch(e) {
                    resultValue = "";
                }
                try {
                    rebootValue = rebootNodes[0].childNodes[0].nodeValue;
                } catch (e) {
                    rebootValue = "";
                }
                rebootValue = top.reboot_decode(rebootValue.toString());
                try {
                    rcValue = rcNodes[0].childNodes[0].nodeValue;
                } catch(e) {
                    rcValue = 0;
                }
                /*
                if (statusValue) {
                    table.rows[nodeIndex + 2].cells[2].title = statusValue;
                    table.rows[nodeIndex + 2].cells[2].innerHTML = statusValue;
                }
                if (rebootValue) {
                    table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                    table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                }
                */
                if (!resultValue || resultValue == "") {         // no result value ==> the update of the package is not finished
                    if (rcValue == 0) {
                        if (!up_running_cache) {
                            // if (up_type == "both" && up_stage == 1) {
                            //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                            //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[2].title = statusValue;
                            //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[1].innerHTML = rebootValue;
                            //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[1].title = rebootValue;
                            // } else {
                            //     table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                            //     table.rows[nodeIndex + 2].cells[2].title = statusValue;
                            //     table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                            //     table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                            // }
                            table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                            table.rows[nodeIndex + 2].cells[2].title = statusValue;
                            table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                            table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                            finishCount++;
                        } else {
                            // For those packages that are not the one being installed, if its status is "Ready", change it to "Not Started"
                            // show stopped icon
                            if (statusValue == "Ready" && nodeIndex != finishCount) {
                                statusValue = "Not Started";
                                // if (up_type == "both" && up_stage == 1) {
                                //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[2].innerHTML = "<img src='images/statusStopped_obj16.gif'>" + statusValue;
                                //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[2].title = statusValue;
                                //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[1].innerHTML = rebootValue;
                                //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[1].title = rebootValue;
                                // } else {
                                //     table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusStopped_obj16.gif'>" + statusValue;
                                //     table.rows[nodeIndex + 2].cells[2].title = statusValue;
                                //     table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                                //     table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                                // }
                                table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusStopped_obj16.gif'>" + statusValue;
                                table.rows[nodeIndex + 2].cells[2].title = statusValue;
                                table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                                table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                            } else {
                                // if (up_type == "both" && up_stage == 1) {
                                //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[2].innerHTML = "<img src='images/progress_anim2_small.gif'>" + statusValue;
                                //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[2].title = statusValue;
                                //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[1].innerHTML = rebootValue;
                                //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[1].title = rebootValue;
                                // } else {
                                //     table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/progress_anim2_small.gif'>" + statusValue;
                                //     table.rows[nodeIndex + 2].cells[2].title = statusValue;
                                //     table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                                //     table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                                // }
                                table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/progress_anim2_small.gif'>" + statusValue;
                                table.rows[nodeIndex + 2].cells[2].title = statusValue;
                                table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                                table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                            }
                        }
                    } else {
                        // if (up_type == "both" && up_stage == 1) {
                        //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                        //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[2].title = statusValue;
                        //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[1].title = rebootValue;
                        //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[1].innerHTML = rebootValue;
                        // } else {
                        //     table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                        //     table.rows[nodeIndex + 2].cells[2].title = statusValue;
                        //     table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                        //     table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                        // }
                        table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                        table.rows[nodeIndex + 2].cells[2].title = statusValue;
                        table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                        table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                    } 
                } else {
                    // if (up_type == "both" && up_stage == 1) {
                    //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[3].innerHTML = resultValue;
                    //     table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[3].title = resultValue;
                    //     if (rcValue == 0) {
                    //         table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[2].innerHTML = "<img src='images/statusSuccess_obj16.gif'>" + statusValue;
                    //         table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[2].title = statusValue;
                    //         table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[1].title = rebootValue;
                    //         table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[1].innerHTML = rebootValue;
                    //     } else {
                    //         table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                    //         table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[2].title = statusValue;
                    //         table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[1].title = rebootValue;
                    //         table.rows[nodeIndex + 2 + top.gl_oobPackList.length].cells[1].innerHTML = rebootValue;
                    //     }
                    // } else {
                    //     table.rows[nodeIndex + 2].cells[3].innerHTML = resultValue;
                    //     table.rows[nodeIndex + 2].cells[3].title = resultValue;
                    //     if (rcValue == 0) {
                    //         table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusSuccess_obj16.gif'>" + statusValue;
                    //         table.rows[nodeIndex + 2].cells[2].title = statusValue;
                    //         table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                    //         table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                    //     } else {
                    //         table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                    //         table.rows[nodeIndex + 2].cells[2].title = statusValue;
                    //         table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                    //         table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                    //     }
                    // }
                    table.rows[nodeIndex + 2].cells[3].innerHTML = resultValue;
                    table.rows[nodeIndex + 2].cells[3].title = resultValue;
                    if (rcValue == 0) {
                        table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusSuccess_obj16.gif'>" + statusValue;
                        table.rows[nodeIndex + 2].cells[2].title = statusValue;
                        table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                        table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                    } else {
                        table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                        table.rows[nodeIndex + 2].cells[2].title = statusValue;
                        table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                        table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                    }
                    finishCount++;
                }
            }
        }
        up_package_index = finishCount;
        // if (top.gl_OOB_Params.Enabled && up_isPurley && up_type == "both" && up_stage == 1) up_package_index += top.gl_oobPackList.length;
        // if (top.gl_OOB_Params.Enabled && up_type == "both" && up_stage == 1) up_package_index += top.gl_oobPackList.length;
    }

    /*
     * Filter status value and sort "Install did not succeed" and other detail message.
     */
    function filterStatusValue(values, statusValue) {
        var criterion = "Install did not succeed";
        var pos = statusValue.indexOf(criterion);
        if (pos != -1) {
            values.push(criterion);
            if (statusValue.length > criterion.length) {
                values.push("Error Message");
                values.push(statusValue.substring(pos + criterion.length + 1, statusValue.length + 1));
            }
        } else {
            var criterion2 = "Not Applicable";
            var pos2 = statusValue.indexOf(criterion2);
            if (pos2 != -1) {
                values.push(criterion2);
                if (statusValue.length > criterion2.length) {
                    values.push("Update Message");
                    values.push(statusValue.substring(pos2 + criterion2.length + 1, statusValue.length + 1));
                }
            }
        }
    }

    function updateProgressBar(running) {
        if ((up_package_index + 1) > up_total) {
            if (!running) {
                return;
            } else {
                if (waitForComplete < 6) {
                    waitForComplete++;
                    return;
                } else {
                    document.getElementById("upMsg").innerHTML = $.i18n.prop("UpdateExec.CollectData");
                    document.getElementById("progressSectionExec").style.display = "none";
                    document.getElementById("progressImageExec").style.marginTop = "-10px";
                }
            }
        } else {
            document.getElementById("upMsg").innerHTML = $.i18n.prop("UpdateExec.Updating") + (up_package_index + 1) + " of " + up_total;
            var percentage = formatData((1 - (up_package_index + 1) / up_total) * 100) + "%";
            document.getElementById("installProgress").style.marginRight = percentage;
        }
    }

    /*function updateProgressBar() {
        if (top.gl_OOB_Params.Enabled) {
            if ((up_package_index + 1) > up_total) {
                document.getElementById("upMsg").innerHTML = $.i18n.prop("UpdateExec.UploadFFDCLog");
                document.getElementById("progressSectionExec").style.display = "none";
                document.getElementById("progressImageExec").style.marginTop = "-10px";
            } else {
                document.getElementById("upMsg").innerHTML = $.i18n.prop("UpdateExec.Updating") + " " + (up_package_index + 1) + " of " + up_total;
                var percentage = formatData((1 - (up_package_index + 1) / up_total) * 100) + "%";
                document.getElementById("installProgress").style.marginRight = percentage;
            }
        } else {
            if ((up_package_index + 1) > up_total) return;
            document.getElementById("upMsg").innerHTML = $.i18n.prop("UpdateExec.Updating") + (up_package_index + 1) + " of " + up_total;
            var percentage = formatData((1 - (up_package_index + 1) / up_total) * 100) + "%";
            document.getElementById("installProgress").style.marginRight = percentage;
        }
    }*/

    //display messages from common_result.xml
    function getCommonResult() {
        var resultFile = top.readTextFile(top.getSupportFile("commonResult"));
        var resultDom, resultMsg, resultError;
        if (resultFile != null) {
            resultDom = ezJsLib.XmlDom.parse(resultFile);
            resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
            resultError = false;
            if (resultDom.documentElement.getElementsByTagName("ERROR").length > 0) {
                resultError = true;
                var errorContent = ezJsLib.XmlDom.getValueByTagFromNode("ERROR", resultDom.documentElement);
                if (errorContent=="No") {
                    resultError = false;
                }
            }
            // if (top.gl_OOB_Params.Enabled && up_isPurley && up_type == "both" && up_stage == 0) {
            // if (top.gl_OOB_Params.Enabled && up_type == "both" && up_stage == 0) {
            //     oobResultError = resultError;
            //     oobResultMsg = resultMsg;
            //     up_stage++;
            //     top.gl_ooblogfile = ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom);
            //     // top.gl_logfile = ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom);
            //     beginUpdate();
            // // } else if (top.gl_OOB_Params.Enabled && up_isPurley && up_type == "both" && up_stage == 1) {
            // } else if (top.gl_OOB_Params.Enabled && up_type == "both" && up_stage == 1) {
            //     if (resultError) complete(0, resultMsg);
            //     else if (oobResultError) complete(0, oobResultMsg);
            //     else if (resultMsg.indexOf("failed") != -1) complete(2, resultMsg);
            //     else if (oobResultMsg.indexOf("failed") != -1) complete(2, oobResultMsg);
            //     else complete(1, resultMsg);
            //     top.gl_bmulogfile = ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom);
            //     // top.gl_logfile = ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom);
            //     up_stage++;
            // } else {
            //     if (resultError)
            //         complete(0, resultMsg);
            //     else if (resultMsg.indexOf("failed") != -1)
            //         complete(2, resultMsg);
            //     else
            //         complete(1, resultMsg);
            //     top.gl_logfile = ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom);
            // }
            if (resultError) {
                complete(0, resultMsg);
            } else if (resultMsg.indexOf("failed") != -1) {
                complete(2, resultMsg);
            } else {
                complete(1, resultMsg);
            }
            top.gl_logfile = ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom);
        } else {
            // if (top.gl_OOB_Params.Enabled && up_isPurley && up_type == "both" && up_stage == 0) {
            // if (top.gl_OOB_Params.Enabled && up_type == "both" && up_stage == 0) {
            //     oobResultError = true;
            //     oobResultMsg = top.getComErrMsg();
            //     up_stage++;
            //     beginUpdate();
            // // } else if (top.gl_OOB_Params.Enabled && up_isPurley && up_type == "both" && up_stage == 1) {
            // } else if (top.gl_OOB_Params.Enabled && up_type == "both" && up_stage == 1) {
            //     complete(0, oobResultMsg);
            // } else {
            //     complete(0, top.getComErrMsg());
            // }
            complete(0, top.getComErrMsg());
        }
    }

    function complete(c, msg) {
        switch (c) {
            case 0: //error
                $("#up_status").hide();
                $("#errMsgExec").show();
                $("#errMsgExec2").html($.i18n.prop("UpdateExec.ErrorInstall") + "<br>" + $.i18n.prop("UpdateExec.ErrorMsg", msg) + "<br>" + $.i18n.prop("UpdateExec.MoreInfo", top.getSupportDir()));
                // document.getElementById("up_status").style.display = "none";
                // document.getElementById("errMsgExec").style.display = "block";
                // document.getElementById("errMsgExec2").innerHTML = "Error(s) occured while installing! <br>Error message: " + msg;
                break;
            case 1:
                var pos = msg.indexOf("\n");
                //         document.getElementById("up_status").innerHTML = "case 1";
                var msg1 = "";
                if (pos != -1) {
                    msg1 = "<h3>";
                    msg1 += msg.substring(0, pos);
                    msg1 += "</h3>";
                    //document.getElementById("up_status").innerHTML = msg1;
                    if (pos < msg.length) {
                        msg1 += "<br>";
                        msg1 += "<p>";
                        msg1 += msg.substring(pos + 1);
                        msg1 += "</p>";
                        document.getElementById("up_status").innerHTML = msg1;
                    }
                    msg = "<img src=\"images/statusSuccess.gif\" style=\"float:left;\"> <class=\"MessageDescription\" style=\"margin-left:36px;\" id=\"upMsg\">" + msg1;
                    document.getElementById("up_status").innerHTML = msg;
                } else {
                    document.getElementById("up_status").innerHTML = "<img src=\"images/statusSuccess.gif\" style=\"float:left;\"> <class=\"MessageDescription\" style=\"margin-left:36px;\" id=\"upMsg\">" + msg + "</p>";
                }
                break;
            case 2: //warning
                $("#up_status").hide();
                $("#warnMsgExec").show();
                $("#warnMsgExec2").html(msg);
                // document.getElementById("up_status").style.display = "none";
                // document.getElementById("warnMsgExec").style.display = "block";
                // document.getElementById("warnMsgExec").childNodes[0].src = "images/statusWarning.png";
                // document.getElementById("warnMsgExec2").innerHTML = msg;
                break;
            default:
                break;
        }
        clearInterval(up_progress_timer);
        waitForComplete = 0;
        //We consider the user has completed his behavior, so they can't go previous page.
        //top.enableButton("nextButton", true);
        //top.enableButton("previousButton", true);
        if (top.getEnv("BOMC_UNATTENDED_MODE")) {
            top.Exit(false);
            return;
        }
    }

    return {
        init: up_init,
        backEntry: up_backEntry,
        index: 0,
        name: "Update_Execution",
        nextAction: function() { 
            printLog("INFO","Next was clicked.");
            clearInterval(up_progress_timer);
            return true;
        },
        previousAction: function() {
            printLog("INFO","Previous was clicked.");
            // defect-160364: BOMC boot from USBkey, when update fail, then click "previous" return to "update conparison" page, can't click “next” button
            if (!top.gl_OOB_Params.Enabled && !top.gl_isOnecli) {
                var co_file_path = top.getVarLogFile("compareResult", "uxspi");
                var co_file_bak_path = top.getVarLogFile("compareResult", "uxspi_bak");
                if (top.fileExists(co_file_bak_path)) {
                    fs.renameSync(co_file_bak_path, co_file_path);
                }
            }
            clearInterval(up_progress_timer);
            toggleNext(true);
            return true;
        },     
        beginExecute: beginExecute,
        confirmUpdate: confirmUpdate, 
        startCopy: startCopy,
        importId: '#import_update_execution',
        selectorId: '.update_execution',
        title: "Navi.UpdateExecution",
        needRefresh: true
    }

}();