// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
function appendHtml(filename, containerId) {
    var htmlContent = fs.readFileSync(__dirname + "/" + filename, "utf-8");
    document.getElementById(containerId).innerHTML += htmlContent;
}

// importHtml to a specific location, function enhanced to support templates.
// options: object - two types of options, 1. contains importId, selectorId and hookId, this is to 
//  insert the html content under hookId. 2. contains importId, selectorId, index and title, this is 
//  to dynamically instert a jQuery step.
// returns: no returns
function importHtml(options) {
    if (typeof(options) == "undefined" || options == null) {
        console.log("importHtml doesn't define options");
        return doc;
    }
    var doc = document.querySelector(options.selectorId);
    if (doc == null)
    {
        appendHtml(options.pageFilename, options.containerId);
        doc = document.querySelector(options.selectorId);
    }
    if (options.title) {
        gl_wizard.steps("insert", options.index, {
            title: options.title,
            content: doc.innerHTML
        });
    } else {
        document.querySelector(options.hookId).innerHTML = doc.innerHTML;
    }
}

function goNextStep() {
  $("#navigationbar-vertical").steps("next");
}

function configSteps(newSteps) {
    if (gl_wizard_steps == null) {
        // gl_wizard_steps = [Welcome, Obtain_Latest_Version, Update_Task, Update_Location, Update_Type, Proxy_Setting, Update_Selection, Acquire_Updates, Update_Comparison, Update_Options, Update_Execution, Finish, Machine_Types, Target_Operating_Systems, Target_Directory, OOB_Setting];
        gl_wizard_steps = [Welcome, Obtain_Latest_Version, Update_Task, Update_Location, Update_Type, Proxy_Setting, Update_Selection, Acquire_Updates, Update_Comparison, Update_Execution, Finish, Machine_Types, Target_Operating_Systems, Target_Directory, OOB_Setting, Raid_Config];
    }

    for (var i=0; i<newSteps.length; i++) {
        if (!newSteps[i]) {
            alert($.i18n.prop("Common.StepNull",i));
            return;
        }
        newSteps[i].index = i;
        var stepFound = false;
        for (var j=i; j< gl_wizard_steps.length; j++){
            if (gl_wizard_steps[j].name == newSteps[i].name) {
                stepFound = true;
                if (j > i) {
                    for (var x = i; x < j; x++) {
                        gl_wizard.steps('remove', i);
                    }
                    gl_wizard_steps.splice(i,(j-i));
                }
                break;
            }
        }
        if (!stepFound) {
            importHtml({
                importId: newSteps[i].importId,
                selectorId: newSteps[i].selectorId,
                index: i,
                title: $.i18n.prop(newSteps[i].title)
            });
            gl_wizard_steps.splice(i, 0, newSteps[i]);
        }
    }
    if (gl_wizard_steps.length > newSteps.length){
        for (i=newSteps.length; i<gl_wizard_steps.length; i++) {
            gl_wizard.steps('remove', newSteps.length);
        }
    }
    gl_wizard_steps = newSteps.concat();
    gl_steps_current = gl_wizard_steps.concat();
    initLocale();
    removeDoneStepClass();
}

function removeDoneStepClass(cIndex){
    if(!cIndex){
        var cIndex = -1;
        $("#navigationbar-vertical").find("li").each(function(i, n){
            var $this = $(this);
            if($this.hasClass("current")){
                cIndex = i;
                return true;
            }
            if(cIndex>-1 && i>cIndex && $this.hasClass("done"))
                $this.removeClass("done").addClass("disabled");
        });
    }else{
        $("#navigationbar-vertical").find("li").each(function(i, n){
            var $this = $(this);
            if(i>cIndex && $this.hasClass("done"))
                $this.removeClass("done").addClass("disabled");
        });
    }
    
}

function togglePrevious(enable) { 
    toggleActionButton("previous", enable); 
}

function toggleNext(enable) { 
    toggleActionButton("next", enable); 
}

function toggleActionButton(buttonId, enable) {
    if (enable)
    {
        // Enable disabled button
        var button = $("#navigationbar-vertical").find('a[href="#' + buttonId + '-disabled"]');
            button.attr("href", '#' + buttonId);
            button.parent().removeClass();
    }
    else
    {
        // Disable enabled button
        var button = $("#navigationbar-vertical").find('a[href="#' + buttonId + '"]');
            button.attr("href", '#' + buttonId + '-disabled');
            button.parent().addClass("disabled");
    }
}

function disableAllTab() {
    $("[role='tab']").addClass("disabled");
}
