// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
$(window).load(function() {
    initMain();
});

function initMain() {
    
    window.onbeforeunload = function(e) {
        top.del_knowhostskey();
        top.killOneCli();
    }
   
//    initUxspiSupportFiles();
    initBlacklist();
    initAMDlist();
    initCFClist();
    initGrantlylist();
    top.querySystemInfo(onQuerySystemInfoFinished);
}

function onQuerySystemInfoFinished(success) {
    if(success) {
        initOSInfo();
        initMTInfo();
        initSteps();
        initBomcConfig();
        initLocale(initLocaleToMainWindow);
    } else {
        initLocale();
        require('@electron/remote').getGlobal("sharedObject").messageConfirmExit = $.i18n.prop("Common.ConfirmExit");
        require('@electron/remote').getGlobal("sharedObject").messageShowTitle = $.i18n.prop("Common.ShowTitle");
        alert($.i18n.prop("Common.NoBasicInfo"));
        quit();
    }
}

function initBomcConfig() {
    top.get_bomc_config_content();
}

function initSteps() {
    var steps = require("./settings/steps.json");
    for(var i=0; i<steps.length; i++) {
        importHtml(steps[i]);
    }
}

function initLocale(callback) {
    jQuery.i18n.properties({
        name: 'lang',
        path: './locale/',
        mode: 'map',
        language: top.BUILD_LANGUAGE,
        callback: function() {
            $("[data-localize]").each(function() {
                var elem = $(this),
                    localizedValue = jQuery.i18n.prop(elem.data("localize"));
                if (elem.is("input[type=text]") || elem.is("input[type=password]") || elem.is("input[type=email]")) {
                    elem.attr("placeholder", localizedValue);
                } else if (elem.is("input[type=button]") || elem.is("input[type=submit]")) {
                    elem.attr("value", localizedValue);
                } else {
                    elem.text(localizedValue);
                }
            });
            if(callback)
            {
                callback();
            }

        }
    });
}

function initLocaleToMainWindow() {
    require('@electron/remote').getGlobal("sharedObject").messageConfirmExit = $.i18n.prop("Common.ConfirmExit");
    require('@electron/remote').getGlobal("sharedObject").messageShowTitle = $.i18n.prop("Common.ShowTitle");
    initWizard();
}

function initWizard() {
    gl_wizard = $("#navigationbar-vertical").steps({
        headerTag: "h3",
        bodyTag: "section",
        transitionEffect: "slideLeft",
        stepsOrientation: "vertical", 
        suppressPaginationOnFocus: false,
        enableKeyNavigation: false,
        onInit: function(event, currentIndex) {
            Banner.init();
            Welcome.init();
            console.log("Init" + currentIndex);
        },
        onStepChanging: function(event, currentIndex, newIndex) {
            // Always allow going backward even if the current step contains invalid fields!
            if (currentIndex > newIndex) {
                printLog("INFO","Previous was clicked, goto " + gl_wizard_steps[newIndex].name);
                if (gl_wizard_steps[currentIndex].previousAction){
                    gl_wizard_steps[currentIndex].previousAction();
                }
                return true;
            }
            if (currentIndex < newIndex) {
                printLog("INFO","Next was clicked, want goto " + gl_wizard_steps[newIndex].name);
                return gl_wizard_steps[currentIndex].nextAction();
            }
        },
        onContentLoaded: function(event, currentIndex) {
            console.log("Step "+ currentIndex + " loaded" + event);
        },
        onStepChanged: function(event, currentIndex, priorIndex) {
            console.log("Step changed");
            //Refresh the step page if needRefresh
            removeDoneStepClass(currentIndex);
            if (top.getEnv("UXSPI_BOOTABLE")) {
                if (priorIndex == 0 && gl_wizard_steps[priorIndex].name == "Welcome") {
                    configSteps([OOB_Setting, Update_Comparison, Update_Execution, Finish]);
                    --currentIndex;
                    --priorIndex;
                }
            }
            if (currentIndex > priorIndex) {
                if (gl_wizard_steps[currentIndex].needRefresh){
                    importHtml({
                      importId: gl_wizard_steps[currentIndex].importId,
                      selectorId: gl_wizard_steps[currentIndex].selectorId,
                      hookId: '#navigationbar-vertical-p-' + currentIndex
                    });
                    initLocale();
                }
                gl_wizard_steps[currentIndex].init();
            } else if (gl_wizard_steps[currentIndex].needReInit){
                gl_wizard_steps[currentIndex].init();
            }  else if (gl_wizard_steps[currentIndex].backEntry) {
                gl_wizard_steps[currentIndex].backEntry();
            } 
            disableAllTab();
        },
        onFinishing: function(event, currentIndex) {
            printLog("INFO","Finish was clicked.");
            var form = $(this);
            // Disable validation on fields that are disabled.
            // At this point it's recommended to do an overall check (mean ignoring only disabled fields)
            form.validate().settings.ignore = ":disabled";
            // Start validation; Prevent form submission if false
            //return form.valid();
            return true;
        },
        onFinished: function(event, currentIndex) {
            Exit(true);
        },
        labels: {
            finish: $.i18n.prop("Common.Finish"),
            previous: $.i18n.prop("Common.Previous"),
            next: $.i18n.prop("Common.Next")
        } 
    });
    initProxy();
    initBootable();
}

function initUxspiSupportFiles() {
    // edit UXSPI_PATH for OneCli in global.property
    // added by chenhao 20161114
    // removed: updateGui will not call uxspi anymore
    var onecliGlobalPropertyPath = getSystemFile("oneCliConfig");
    var uxspiProxyPath = top.getSystemFile("uxspiProxy");
    var uxspiLineAddedConfig = "UXSPI_PATH=" + uxspiProxyPath;
    var dataString = top.readTextFile(onecliGlobalPropertyPath);
    var dataArray = dataString.split("\n");
    for (var i = 0; i < dataArray.length; i++) {
        if (dataArray[i].match("UXSPI_PATH=")) {
            delete dataArray[i];
        }
    }
    dataArray.push(uxspiLineAddedConfig);
    dataString = dataArray.join("\n");
    top.writeTextFile(onecliGlobalPropertyPath, dataString);

    // edit uxspi_proxy with real uxspi path 
    // added by chenhao 20161114
    // removed: updateGui will not call uxspi anymore
    var uxspiBinName = null;
    var uxspiFolderPath = top.getSystemFile("uxspiFolder");
    var uxspiFolderList = fs.readdirSync(uxspiFolderPath);
    for (var i = 0; i < uxspiFolderList.length; i++) {
        if ((top.OSTYPE=="windows" && uxspiFolderList[i].match(".exe")) 
            || (top.OSTYPE!="windows" && uxspiFolderList[i].match(".bin"))) {
            uxspiBinName = uxspiFolderList[i];
            break;
        }
    }
    if(uxspiBinName)
    {
        var uxspiBinPath = path.join(uxspiFolderPath, uxspiBinName.toString());
        var cmdInScript = "";
        if (top.OSTYPE == "windows") {
            cmdInScript = uxspiBinPath + " %* --xml";
        } else {
            cmdInScript = uxspiBinPath + " $* --xml";
        }
        top.writeTextFile(uxspiProxyPath, cmdInScript);
        fs.chmodSync(uxspiBinPath, 777);
        fs.chmodSync(uxspiProxyPath, 777);
    }
    
}

function initProxy() {
    top.gl_url_custom = false;
    top.gl_url_insecure = true;
    top.gl_url_specify_cert = false;
    top.gl_url_cert = "";
    top.gl_isProxy = false;
    top.gl_proxy_address = "";
    top.gl_proxy_port = "";
    top.gl_proxy_username = "";
    top.gl_proxy_password = "";
    top.gl_proxy_custom = false;
    top.gl_proxy_insecure = true;
    top.gl_proxy_specify_cert = false;
    top.gl_proxy_cert = "";
}

function initBlacklist() {
    top.gl_bl_mt_list.length = 0;
    var IBMSysFile = top.getSystemFile("IBMSysList");
    if (!top.fileExists(IBMSysFile)) {
        top.gl_bl_mt_list = [];
        console.log("There is no blacklist. ");
    } else {
        var IBMSysContent = top.readTextFile(IBMSysFile);
        console.log("Init blacklist. ");
        var sysListArr = IBMSysContent.split(")");
        for (var i = 0; i < sysListArr.length; i++) {
            if (sysListArr[i] != "") {
                var mtStr = sysListArr[i].substring(sysListArr[i].indexOf("(") + 1);
                var mtListArr = mtStr.split(",");
                for (var j = 0; j < mtListArr.length; j++) {
                    top.gl_bl_mt_list.push($.trim(mtListArr[j]));
                }
            }
        }
    }
}

/*
function initBlacklist() {
    try {
        var p_file = getSystemFile("blacklist");
        var bl_mt = top.readTextFile(p_file);
        top.gl_bl_mt_list = bl_mt.split(",");
    } catch (e) {
        //avoid throwing exception if there is no blacklist file
        console.log("There is no balcklist.");
    }
}
*/

function initAMDlist() {
    top.gl_amd_mt_list.length = 0;
    var AMDSysFile = top.getSystemFile("AMDSysList");
    if (!top.fileExists(AMDSysFile)) {
        top.gl_amd_mt_list = [];
        console.log("There is no AMD mt list. ");
    } else {
        var AMDSysContent = top.readTextFile(AMDSysFile);
        console.log("Init AMD mt list. ");
        var sysListArr = AMDSysContent.split(")");
        for (var i = 0; i < sysListArr.length; i++) {
            if (sysListArr[i] != "") {
                var mtStr = sysListArr[i].substring(sysListArr[i].indexOf("(") + 1);
                var mtListArr = mtStr.split(",");
                for (var j = 0; j < mtListArr.length; j++) {
                    top.gl_amd_mt_list.push($.trim(mtListArr[j]));
                }
            }
        }
    }
}

function initCFClist() {
    top.gl_cfc_mt_list.length = 0;
    var CFCSysFile = top.getSystemFile("CFCSysList");
    if (!top.fileExists(CFCSysFile)) {
        top.gl_cfc_mt_list = [];
        console.log("There is no CFC mt list. ");
    } else {
        var CFCSysContent = top.readTextFile(CFCSysFile);
        console.log("Init CFC mt list. ");
        var sysListArr = CFCSysContent.split(")");
        for (var i = 0; i < sysListArr.length; i++) {
            if (sysListArr[i] != "") {
                var mtStr = sysListArr[i].substring(sysListArr[i].indexOf("(") + 1);
                var mtListArr = mtStr.split(",");
                for (var j = 0; j < mtListArr.length; j++) {
                    top.gl_cfc_mt_list.push($.trim(mtListArr[j]));
                }
            }
        }
    }
}

function initGrantlylist() {
    top.gl_grantly_mt_list.length = 0;
    var GrantlySysFile = top.getSystemFile("GrantlySysList");
    if (!top.fileExists(GrantlySysFile)) {
        top.gl_grantly_mt_list = [];
        console.log("There is no Grantly mt list. ");
    } else {
        var GrantlySysContent = top.readTextFile(GrantlySysFile);
        console.log("Init Grantly mt list. ");
        var sysListArr = GrantlySysContent.split(")");
        for (var i = 0; i < sysListArr.length; i++) {
            if (sysListArr[i] != "") {
                var mtStr = sysListArr[i].substring(sysListArr[i].indexOf("(") + 1);
                var mtListArr = mtStr.split(",");
                for (var j = 0; j < mtListArr.length; j++) {
                    top.gl_grantly_mt_list.push($.trim(mtListArr[j]));
                }
            }
        }
    }
}

function initBootable() {
    if (top.getEnv("UXSPI_BOOTABLE")) {
        top.gl_uxlite_bootable = "1";
        top.gl_workingDir = top.getEnv("UXSPI_BOOTABLE");
        top.gl_portable_dir = top.gl_properties_info["IBM_SYSTEM_DIR"];
        top.gl_portable_dir += "/../../";
        require('@electron/remote').getCurrentWindow().maximize();
        configSteps([Welcome, OOB_Setting, Update_Comparison, Update_Execution, Finish]);
        
        gl_wizard.steps("next");
    } else {
        // configSteps([Welcome, Update_Task, Update_Location, Update_Type, Proxy_Setting, Update_Comparison, Update_Options, Update_Execution, Finish]);
        configSteps([Welcome, Update_Task, Update_Location, Update_Type, Update_Comparison, Update_Execution, Finish]);
    }
}

function initOSInfo() {
    var arch = top.gl_properties_info["IBM_SYSTEM_ARCH"];
    if (arch == "64") {
        top.gl_current_arch_d = "64 bit";
    } else if (arch == "32") {
        top.gl_current_arch_d = "32 bit";
    } else {
        top.gl_current_arch_d = $.i18n.prop("Common.NoArch");
    }

    var os = top.gl_properties_info["IBM_SYSTEM_OS"];
    var current_os_d = "NONE";
    var current_os = "NONE";
    var osDefineList = require("./settings/os_defines.json");
    for(var i=0; i<osDefineList.length; i++) {
        var osId = osDefineList[i].id;
        var osDesc = osDefineList[i].desc;
        var osCode = osDefineList[i].code;
        if(osId.length == os.length) {
            var equal = true;
            for(var c=0; c<osId.length; c++) {
                if(osId[c]=='-' || osId[c]==os[c])
                {
                    continue;
                }
                equal = false;
                break;
            }
            if(equal) {
                if(osDesc)
                    current_os_d = osDesc;
                if(osCode)
                    current_os = osCode;
            }
        }
    }
    top.gl_current_os_d = current_os_d;
    top.gl_current_os = current_os;

    // Patch for Win10, need to look for another way to identify the Win10 and Win8
    if(top.gl_current_os_d == "Windows 8")
    {
        if(require("os").release().startsWith("10."))
        {
            top.gl_current_os_d = "Windows 10";
        }
    }
}

function initMTInfo() {
    top.gl_current_mt = top.gl_properties_info["IBM_SYSTEM_MT"];
    top.gl_current_mt_d = top.gl_current_mt;
    if (top.gl_current_mt == "NONE") {
        top.gl_current_mt_d = "NONE";
    }
}

function initForceCompare() {
    var mtMatch = false;
    var mtFromImageArr = top.getMTFromImage();
    for (var i = 0; i < mtFromImageArr.length; i++) {
        if (mtFromImageArr[i].toLowerCase() == top.gl_current_mt.toLowerCase()) {
            mtMatch = true;
            break;
        }
    }
    if (!mtMatch && !top.gl_forceCompare) {
        if (confirm($.i18n.prop('UpdateComparison.Not.Suitable'))) {
            top.gl_forceCompare = true;
        } else {
            quit();
        }
    }
}