// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
/*
 * 1234.56 -> 1,234.56
 * input may already have commas, so just return
 */
function formatNumberWithComma(input) {
    var str = "",
        value = input.toString();
    var dotPos = value.indexOf(".");
    var commaPos = value.indexOf(",");
    if (commaPos > -1) {
        return input;
    }
    var integer = dotPos > -1 ? value.substring(0, dotPos) : value;
    var dicemal = dotPos > -1 ? value.substring(dotPos) : "";
    var chars = $.trim(integer).split("");
    for (var i = chars.length - 1; i > -1; i--) {
        str = chars[i] + str;
        if ((chars.length - i) % 3 == 0 && i != 0) {
            str = "," + str;
        }
    }
    return str + dicemal;
}

/*
 * for decimal
 */
function formatData(input) {
    var per = input.toString();
    if (per.indexOf(".") > 0)
        per = per.substring(0, per.indexOf(".") + 3);
    return per;
}

/*
 * for index
 */
function formatNo(input) {
    var result = input.toString();
    switch (input) {
        case 1:
            result += "st";
            break;
        case 2:
            result += "nd";
            break;
        case 3:
            result += "rd";
            break;
        default:
            result += "th";
    }
    return result;
}