// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Welcome = function() {

    function wl_init() {
        $("#versionInfo").html("Version "+top.PACKAGE_VERSION);
        initLogPath();
        initLanguageOption();
        Banner.set_active_status("", "");
    }

    function initLogPath(){
        if(!require("../../logPath.json").isChangeLan)
        {
            var date = new Date();
            var month = date.getMonth() + 1<10? "0"+(date.getMonth() + 1):date.getMonth() + 1;
            var strDate = date.getDate()<10? "0" + date.getDate():date.getDate();
            var strHour = date.getHours()<10? "0" + date.getHours():date.getHours();
            var strMinute = date.getMinutes()<10? "0" + date.getMinutes():date.getMinutes();
            var strSecond = date.getSeconds()<10? "0" + date.getSeconds():date.getSeconds();
            var currentdate = "" + date.getFullYear() + month + strDate + strHour + strMinute + strSecond;
            var logPath = path.join(gl_base_path, "Lenovo_Support");
            LOG_PATH = path.join(logPath, "updateXpress" + currentdate + ".log");
            logFile = fs.createWriteStream(LOG_PATH, { flags: 'a' });

            var log = require("../../logPath.json");
            log.logPath = LOG_PATH;
            var callback = function(err) {
                if (err) {
                    throw err;
                }
            }
            fs.writeFile(getSystemFile("logPathJson"), new Buffer(JSON.stringify(log)), null, callback);
        }
        else
        {
            var log = require("../../logPath.json");
            log.isChangeLan = 0;
            var callback = function(err) {
                if (err) {
                    throw err;
                }
            }
            fs.writeFile(getSystemFile("logPathJson"), new Buffer(JSON.stringify(log)), null, callback);
        }
        printLog("DEBUG","updateXpress log module has been initialized.");
    }

    function doCheckForLatest(ref) {
        printLog("INFO","check box 'Check for the latest version of this installer'  "+($(ref).prop("checked")?"checked.":"unchecked."));
        var post = null;
        var doc = null;
        if ($(ref).prop("checked")) {
            if(gl_steps_current.indexOf(Proxy_Setting)>0){
                gl_steps_current.splice(gl_steps_current.indexOf(Proxy_Setting),1);
            }
            if(gl_steps_current.indexOf(Obtain_Latest_Version)>0){
                gl_steps_current.splice(gl_steps_current.indexOf(Obtain_Latest_Version),1);
            }
            gl_steps_current.splice(1, 0, Proxy_Setting, Obtain_Latest_Version);
            // configSteps([Welcome, Proxy_Setting, Obtain_Latest_Version, Update_Task, Update_Location, Update_Type, Update_Comparison, Update_Options, Update_Execution, Finish]);
            configSteps(gl_steps_current);
            top.bProxyShow = false;
            top.bCheckForLatest = true;
        } else {
            gl_steps_current.splice(1,2);
            // configSteps([Welcome, Update_Task, Update_Location, Update_Type, Proxy_Setting, Update_Comparison, Update_Options, Update_Execution, Finish]);
            configSteps(gl_steps_current);
            top.bProxyShow = true;
            top.bCheckForLatest = false;
        }
        printLog("DEBUG","function doCheckForLatest end.");
    }

    function initLanguageOption(){
        printLog("DEBUG","function initLanguageOption start.");
        let languageOpt = require("../../languages.json").languageOpt;
        if(languageOpt){
            let str = "";
            languageOpt.forEach(function(opt){
                str += "<option value='"+opt.value+"'>"+opt.name+"</option>";
            });
            $("#languageSelect").html(str);
            $("#languageSelect").val(top.BUILD_LANGUAGE);
        }
        printLog("DEBUG","function initLanguageOption end.");
    }

    function languageChanged(ele){
        printLog("INFO","Language option changed.");
        let remote = require('@electron/remote');
        let lan = require("../../languages.json");
        lan.language = $(ele).val();
        // fix bug that language change does not work
        // in new node.js, fs.writeFile requires the fourth parameter callback, otherwise it will throw exception
        var callback = function(err) {
            if (err) {
                throw err;
            }
        }
        fs.writeFileSync(getSystemFile("languagesJson"), new Buffer(JSON.stringify(lan)), null, callback);
        // require('@electron/remote').getGlobal("sharedObject").language = $(ele).val();

        var log = require("../../logPath.json");
        log.isChangeLan = 1;
        fs.writeFileSync(getSystemFile("logPathJson"), new Buffer(JSON.stringify(log)), null, callback);

        remote.getCurrentWindow().reload();
    }

    return {
        name: "Welcome",
        index: 0,
        init: wl_init, 
        doCheckForLatest: doCheckForLatest,
        languageChanged: languageChanged,
        nextAction: function() { printLog("INFO","Next was clicked."); return true;},
        importId: '#import_welcome',
        selectorId: '.welcome',
        title: "Navi.Welcome"        
    };
}();