// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Target_Operating_Systems = function() {
	var i = 0;
	var targetOS = new Array();
	var cur_os_list = new Array();
	var isOSFirstShow = "1";

	targetOS[0] = "OS independent update";
	targetOS[1] = "Windows 2008";
	targetOS[2] = "Windows 2012";
	targetOS[3] = "Windows 2016";
	targetOS[4] = "Windows Server version 1709";
	targetOS[5] = "Windows Server version 1803";
	targetOS[6] = 'Windows Server 2019';
	targetOS[7] = "Windows Server version 1904";
	targetOS[8] = 'Windows Server 2022';
	targetOS[9] = "Red Hat Enterprise Linux (RHEL) 7";
	targetOS[10] = "Red Hat Enterprise Linux (RHEL) 8";
	targetOS[11] = "Red Hat Enterprise Linux (RHEL) 9";
	targetOS[12] = "SLES 12";
	targetOS[13] = "SLES 15";
 
	function toggleRowSelectOS(id, ref)
	{
	  printLog("INFO", id + " " + (ref.checked?" checked.":" unchecked."));
	  if (ref.checked) {
	    document.getElementById(id).className = "RowSelected";
	    /*
	    var i;
		if(top.gl_isUXSP)
			i = 1;
		else
			i = 0;
		*/
		for(var i = 0; i < targetOS.length; i++) {
			if(!document.getElementById("sysOS" + i).checked)
				return;
		}
		document.getElementById("checkAll_operating").checked = true;
	  }
	  else {
	    document.getElementById(id).className = "RowUnselected";
	    document.getElementById("checkAll_operating").checked = false;
	  }
	}

	function populateOSList(dom){
		cur_os_list = new Array();
		var allOSes = dom.documentElement.getElementsByTagName("OS");
		for(var i = 0; i < allOSes.length; i++){
			cur_os_list.push(allOSes[i].childNodes[0].nodeValue);	
		}
	}

	

	function os_init() {
		printLog("INFO","Operating Systems page init.");
	  	var configFile;
	  	top.gl_isNoneSelected = false;
	  	configFile = top.readTextFile(top.getSupportFile("configList"));
        if (configFile != null)
        {
            var cfDom = ezJsLib.XmlDom.parse(configFile);
        	top.gl_configlist_time_stamp = ezJsLib.XmlDom.getValueByTag("timestamp", cfDom);
        	populateOSList(cfDom);
        }
        
		//If reading config file fails, it will select current os by default
		if(cur_os_list.length == 0)
	  		cur_os_list.push(top.gl_current_os_d);

    	//record user's operation
		var sa = true;

		// remove the previous code
		// now, when creating local repository, user can always select platform
		// code by chenhao at 20170808
		/*
		var i;
		if((hasPurleyOrOther(top.gl_mt_list) == "purley" && top.gl_isUXSP) 
		|| (!top.gl_isUXSP && hasPurleyOrOther(top.gl_mt_list) == "prepurley")) {
			document.getElementById("sysRowOS0").style.display = "";
			i = 0;
		}else{
			document.getElementById("sysRowOS0").style.display = "none";
			document.getElementById("sysOS0").checked = false;
			document.getElementById("sysRowOS0").className = "RowUnselected";
			i = 1;
		}
		*/
		for (var i = 0; i < targetOS.length; i++) {
			//initialization
			//keep every item being unchecked by default
			document.getElementById("sysOS" + i).checked = false;
			document.getElementById("sysRowOS" + i).className = "RowUnselected";
			var osName = document.getElementById("sysOS" + i).value;
			var inOSList = false;
			for(var j = 0; j < cur_os_list.length; j++) {
				if(osName == cur_os_list[j]) {
					document.getElementById("sysOS" + i).checked = true;
					document.getElementById("sysRowOS" + i).className = "RowSelected";
					inOSList = true;
					break;
				}
			}
			if(!inOSList)
				sa = false;
		}
		if(sa)
			document.getElementById("checkAll_operating").checked = true;
		else 
			document.getElementById("checkAll_operating").checked = false;
	}

	function os_collect() {
		printLog("INFO","Next was clicked.");
		top.gl_os_list = new Array();
		top.gl_selectPlatform = false;
		for(var i = 0; i < targetOS.length; i++) {
			if(document.getElementById("sysOS" + i).checked == true) {
				var os = document.getElementById("sysOS" + i).value
				// grantley bmu function
				// for red systems, os independency => ostype=platform
				// if (os == "none") {
				if(os == "platform") {
					top.gl_isNoneSelected = true;
					if(hasPurleyOrOther(top.gl_mt_list) == "purley" && top.gl_isUXSP){
						top.gl_selectPlatform = true;
						os = "platform";
					}
				}
				top.gl_os_list.push(os);
			}
		}

		top.gl_store_os = true;
		if(top.gl_os_list.length < 1) {
			alert($.i18n.prop("TargetOperatingSystems.NoOS"));
			return false;
		}
		else {
			//for OS agnostic update support
			// Now we use OneCli, it will not download OS Indepent SUP when you speicalize a MT
			if(!top.gl_isUXSP && !top.gl_isNoneSelected) {
				// top.gl_os_list.push("none");
			}
		//	nextDefinedByUX();
		}
	  	//fix defect 466508
	    writeConfigFile();
	    return true;
	}

	function checkAll(ref) {
		printLog("INFO","check box 'select/deselect all' "+(ref.checked?"checked.":"unchecked."));
		for (var i = 0; i < targetOS.length; i++) {
			if ($("#sysRowOS" + i).attr("display") == "none") {
				continue;
			} else {
				if(ref.checked){
					document.getElementById("sysRowOS" + i).className = "RowSelected";
					document.getElementById("sysOS" + i).checked = true;
				}else{
					document.getElementById("sysRowOS" + i).className = "RowUnselected";
					document.getElementById("sysOS" + i).checked = false;
				}
			}
		}
	}

	return {
		init: os_init,
		index: 0,
		name: "Target_Operating_Systems",
		nextAction: os_collect,
		checkAll: checkAll,
		toggleRowSelectOS: toggleRowSelectOS,
		needReInit: false,
		importId: '#import_target_operating_systems',
        selectorId: '.target_operating_systems',
        title: "Navi.TargetOperatingSystems"
	}
}();