// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
function getOSDisplayName(osKey) {
    if(osKey=="none") {
        return "OS Independent";
    } else if (osKey=="win2008") {
        return "Windows Server 2008";
    } else if (osKey=="win2012") {
        return "Windows Server 2012";
    } else if (osKey=="win2012r2") {
        return "Windows Server 2012 R2";
    } else if (osKey=="win2016") {
        return "Windows Server 2016";
    } else if (osKey=="windows") {
        return "Windows";
    } else if (osKey == 'win2019') {
        return 'Windows Server 2019';
    } else if (osKey == 'win2022') {
        return 'Windows Server 2022';
    } else if (osKey == 'win1709') {
        return 'Windows Server version 1709';
    } else if (osKey == 'win1803') {
        return 'Windows Server version 1803';
    } else if (osKey == 'win1904') {
        return 'Windows Server version 1904';
    } else {
        return osKey;
    }
}

function getOSKey(osDisplayName, windowsInsensitive) {
    if(windowsInsensitive) {
        if(osDisplayName.toLowerCase().indexOf('win')>=0) {
            return "windows";
        } else {
            return osDisplayName.replace(" ", "").toLowerCase();
        }
    }
    if(osDisplayName.toLowerCase()=="windows 2008") {
        return "win2008";
    } else if (osDisplayName.toLowerCase()=="windows 2012") {
        return "win2012";
    } else if (osDisplayName.toLowerCase()=="windows 2012 r2") {
        return "win2012r2";
    } else if (osDisplayName.toLowerCase()=="windows 2016") {
        return "win2016";
    } else if (osDisplayName.toLowerCase() == 'windows 2019') {
        return 'win2019';
    } else if (osDisplayName.toLowerCase() == 'windows 2022') {
        return 'win2022';
    } else if (osDisplayName.toLowerCase() == 'windows server version 1709') {
        return 'win1709';
    } else if (osDisplayName.toLowerCase() == 'windows server version 1803') {
        return 'win1803';
    } else if (osDisplayName.toLowerCase() == 'windows server version 1904') {
        return 'win1904';
    } else {
        return osDisplayName.replace(" ", "").toLowerCase();
    }
}